//---------------------------------------------------------------------------
//
// center
//
// Syntax: center(string,screen_width)
//
//  Same as printf("%s",string), but with the string centered on the screen.
//
//  If screen_width is given as an input argument, the string is centered
//  for a screen of the given width.  Otherwise, screen_width is 80. 
//
// Originally written for MATLAB by Lee P. Peterson
// Modified by Jeff Layton and ported to RLaB by Jeff Layton
//---------------------------------------------------------------------------

center = function(string,screen_width)
{
   local(i,j,str1,strout,sw)

   if (!exist (screen_width)) { sw = 80; else sw = screen_width; }
   i=(sw-(length(string)))/2;
   str1="";

   for (j in 1:i) {
        str1=str1+" ";
   }
   strout="";
   strout=str1+string+"\n";
   printf("%s",strout);

};
