//
// curve_fit.r
//

// Use a minimization scheme to fit a model to a set of data
// points.

// Create the data...

x = (0:10:.1)';
y = 3.2.*1.5.^x;

ptitle ("Original Contrived Data");
plot ([x,y]);
pause ();

// Now add some random-ness

rand ("uniform", -max(abs(y))/5, max(abs(y))/5);
y_orig = y;
y = y + rand (size (y));

ptitle ("Original Data with some Random-ness Added");
plot ([x,y]);
pause ();

// Now make up a model function

fmodel = function (a, b, x) { return a.*b.^x; }

// Now make up a cost function

fcost = function ( A ) 
{
  global (x, y)
  return -sum ( abs ((y - fmodel (A[1], A[2], x))).*x); 
}

// Now load the min/max - imizer

rfile mdsmax
rfile nmsmax

#fit = nmsmax (fcost, [1, 1]);
fit = mdsmax (fcost, [1, 1]);

// Plot the result

ptitle ("Original+Random-ness and Fitted Model");
plot ([ x, y, fmodel (fit.x[1], fit.x[2], x) ]);
pause ();

ptitle ("Original and Fitted Model");
plot ([ x, y_orig, fmodel (fit.x[1], fit.x[2], x) ]);

"\tNow compare original model coefficients and fitted"

original = [3.2, 1.5]
fitted = fit.x

difference = [3.2, 1.5] - fit.x
