/*
 * finger.c
 */
#include "finger.h"

char *laston(), buf[200];
#define shodat() printf("'%s' '%d' '%d' '%s' '%c' '%s' '%s'\n"\
	, info.name, info.uid, info.gid\
	, info.rname, info.phone.unlisted, info.phone.no, info.company)


main(argc, argv)
	 int argc;
	 char **argv;
{
	FILE *f;
	struct passwd *pwe;
	int i;
	char *cp;

	if (argc != 2)
	{	fprintf(stderr, "Usage: %s user\n", argv[0]);
		exit(EXIT_SUCCESS);
	}
	if(!strcmp(argv[1], "--version"))
	{	fprintf(stderr, "%s: version %s\n", argv[0], Version);
		exit(EXIT_SUCCESS);
	}
	setpwent();
	if ((pwe = getpwnam(argv[1])) != NULL)
	{	strcpy(info.name, pwe->pw_name);
		strcpy(info.rname, pwe->pw_comment);
		strcpy(info.dir, pwe->pw_dir);
		strcpy(info.shell, pwe->pw_shell);
	}
	else
	{	fprintf(stderr, "%s: user %s not known\n", argv[0], argv[1]);
		exit(EXIT_FAILURE);
	}
	if ((f = fopen(FData, "r")) == NULL)
	{	perror(FData);
		exit(EXIT_FAILURE);
	}
	i = strlen(argv[1]);
	while (fgets(buf, sizeof(buf), f) != NULL)
		if (buf[i] == ':' && !strncmp(buf, argv[1], i))
			break;
	if (feof(f))
	{	strcpy(info.phone.no, "-unknown-");
		strcpy(info.company, "-unknown-");
	}
	else
		sscanf(buf, "%*[^:]:%*[^:]:%*[^:]:%*[^:]:%[^:]:%c%[^:]:%[^:]:"
			   ,info.rname, &info.phone.unlisted, info.phone.no, info.company);
	fclose(f);
	if (info.phone.unlisted == 'U')
		strcpy(info.phone.no, "-unlisted-");

	printf("\nLogin Name: %-*s\tIn real life: %-*s\n"
		, sizeof(info.name), info.name, sizeof(info.rname), info.rname);
	printf("Organization: %s\nPhone: %s\n", info.company, info.phone.no);
	printf("Directory: %s\t\tShell: %s\n", info.dir, info.shell);
	printf("Checking for last logon, wait.. ");
	fflush(stdout);
	printf(laston());
	printf("Project: ");
	sprintf(buf, "%s/.project", info.dir);
	if ((f = fopen(buf, "r")) == NULL)
		printf("No project.\n");
	else
	{	i = 1;
		while(fgets(buf, sizeof(buf), f) != NULL)
		{	if(*buf == '[' && (cp = strchr(buf, ']')) != NULL)
			{	*cp = '\n';
				i = atoi(&buf[1]);
				fputs(cp, stdout);
			}
			else
				fputs(buf, stdout);
			if(--i <= 0) break;
		}
		fclose(f);
	}
	printf("Plan: ");
	sprintf(buf, "%s/.plan", info.dir);
	if ((f = fopen(buf, "r")) == NULL)
		printf("No plan.\n");
	else
	{	putchar('\n');
		while (fgets(buf, sizeof(buf), f))
			fputs(buf, stdout);
		fclose(f);
	}
	exit(EXIT_SUCCESS);
}

/*
* routine to determine the last time the user was (is) on.
* Four possibilities in order:
*  1.  user logged in (entry in /etc/utmp)
*	2.	user not logged in and has ~/.lastlogin file
*  3.  user not logged in (entry in /usr/adm/wtmp)
*  4.  user has not logged on since first entry in /usr/adm/wtmp
*/
char *
laston()
{
static char p[81], *spinner = "\\|/-";
struct utmp ut;
struct stat st;
FILE *f;

if ((f = fopen(UTmp, "r")) != NULL)
{	while (fread(&ut, sizeof(ut), 1, f) == 1)
	{	if (!strcmp(info.name, ut.ut_name))
		{	sprintf(p, "\rOn since %s", asctime(localtime(&ut.ut_time)));
			fclose(f);
			return (p);
		}
	}
	fclose(f);
}
sprintf(buf, "%s%s%s"
	, info.dir
	, info.dir[strlen(info.dir) - 1] == '/' ? "" : "/"
	, LastLogin);
if (!stat(buf, &st))
{	sprintf(p, "\rLast on %.24s (%s)\n"
		, asctime(localtime(&st.st_ctime)), buf);
	return(p);
}
if ((f = fopen(WTmp, "r")) != NULL)
{	int lastentry = 0, sc = 0, lsc, count = 0;

	fseek(f, -sizeof(struct utmp), SEEK_END);
	lsc = strlen(spinner);
	while (fread(&ut, sizeof(ut), 1, f) == 1)
	{	if(!(++count % 100))
		{	printf("\b%c", spinner[sc++]);
			fflush(stdout);
		}
		if(sc == lsc) sc = 0;
		if (!(strcmp(info.name, ut.ut_name)))
		{	sprintf(p, "\rLast on %s", asctime(localtime(&ut.ut_time)));
			break;
		}
		if (!lastentry)
		{	fseek(f, -(2 * sizeof(ut)), SEEK_CUR);
			if (ftell(f) == 0)
				lastentry = 1;
		}
		else
		{	sprintf(p, "\rNot on since begining of log (%.24s)\n"
						, asctime(localtime(&ut.ut_time)));
				break;
			}
		}
		fclose(f);
	}
	else
		printf("\rNo %s!                                \r", WTmp);
	return (p);
}
