/*
 * chfn.c
 */
#include "finger.h"
#include <termio.h>

char *editinfo();

main(argc,argv)
int argc;
char **argv;
{
	FILE *f;
	char buf[200];
	int len;
	struct passwd *pwe;

	if(!strcmp(argv[1], "--version"))
	{	fprintf(stderr, "%s: version %s\n", argv[0], Version);
		exit(EXIT_SUCCESS);
	}
	strcpy(info.name, getenv("USER"));
	if (info.name == NULL)
		strcpy(info.name, getenv("LOGNAME"));
	if (info.name == NULL)
	{	fprintf(stderr
			, "%s: need USER or LOGNAME set in environment\n", argv[0]);
		exit(EXIT_FAILURE);
	}
	if ((pwe = getpwnam(info.name)) != NULL)
	{	info.uid = pwe->pw_uid;
		info.gid = pwe->pw_gid;
		strcpy(info.rname, pwe->pw_comment);
		strcpy(info.dir, pwe->pw_dir);
		strcpy(info.shell, pwe->pw_shell);
	}
	else
	{	fprintf(stderr, "%s: user %s not known\n", argv[0], argv[1]);
		exit(EXIT_FAILURE);
	}
	if ((f = fopen(FData, "r")) == NULL)
	{	perror(FData);
		exit(EXIT_FAILURE);
	}
	len = strlen(info.name);
	while (fgets(buf, sizeof(buf), f) != NULL)
		if (buf[len] == ':' && !strncmp(buf, info.name, len))
			break;
	if (feof(f))
	{	info.phone.unlisted = 'N';
		strcpy(info.phone.no, "-unknown-");
		strcpy(info.company, "-unknown-");
	}
	else
		sscanf(buf, "%*[^:]:%*[^:]:%*[^:]:%*[^:]:%[^:]:%c%[^:]:%[^:]:"
			, info.rname, &info.phone.unlisted, info.phone.no, info.company);
	fclose(f);
	if (readinfo())
		saveinfo();
	exit(EXIT_SUCCESS);
	return argc; /* so the compiler doesn't gripe */
}

/*
 * readinfo()
 */
readinfo()
{
	char	*ret, 
			*rtag = " In real life", 
			*ctag = " Organization",
			*ptag = "        Phone";
	int  	change,	c, rlen, clen, plen;
	struct termio ns, os;

	ioctl(fileno(stdin), TCGETA, &os);
	memcpy(&ns, &os, sizeof(ns));
	ns.c_lflag &= ~(ICANON|ECHO);
	ns.c_cc[VMIN] = 1;
	ns.c_cc[VTIME] = 0;
	ioctl(fileno(stdin), TCSETA, &ns);
	do
	{	rlen = strlen(rtag);
		clen = strlen(ctag);
		plen = strlen(ptag);

		printf("\nEnter new information (or <Enter> to retain current value):\n");
		if(ret = editinfo(rtag, rlen, info.rname, sizeof(info.rname)))
		{	change = TRUE;
			strcpy(info.rname, ret);
		}
		if(ret = editinfo(ctag, clen, info.company, sizeof(info.company)))
		{	change = TRUE;
			strcpy(info.company, ret);
		}
		if(ret = editinfo(ptag, plen, info.phone.no, sizeof(info.phone.no)))
		{	change = TRUE;
			strcpy(info.phone.no, ret);
		}
		printf("\n\nPhone number [L]isted/[U]nlisted? >%c<\b\b", info.phone.unlisted);
		fflush(stdout);
		if((c = getchar()) != '\n')
		{	c = toupper(c) == 'U' ? 'U' : 'L';
			if(c != info.phone.unlisted)
			{	putchar(c);
				info.phone.unlisted = c;
				change = TRUE;
			}
		}
		printf("\n\n	Ok? [y/N] > ");
		fflush(stdout);
	} while (toupper(getchar()) != 'Y');
	ioctl(fileno(stdin), TCSETA, &os);
	putchar('\n');
	return (change);
}

/*
 * editinfo()
 */
char *editinfo(tag, tlen, str, slen)
char *tag, *str;
int	 tlen, slen;
{	int	c, len;
	char *tstr;
	printf("\n%*s >%-*s<", tlen, tag, slen, str);
	printf("\r%*s >", tlen, tag);
	fflush(stdout);
	if((c = getchar()) != '\n')
	{	printf("\r%*s >%-*s<", tlen, tag, slen, " ");
		printf("\r%*s >", tlen, tag);
		fflush(stdout);
		if((tstr = (char*)malloc(slen + 1)) == NULL) tstr = str;
		len = 0;
		do
		{	if(c == 27)
			{	if(tstr != str)
				{	printf("\r%*s >%-*s<", tlen, tag, slen, str);
					free(tstr);
				}
				else
					printf("\n%*s >%-*s<", tlen, tag, slen, "-unchanged-");
				return NULL;
			}
			if(c == '\b')
			{	if(len)
				{	tstr[--len] = '\0';
					putchar(c);
				}
				else *tstr = '\0';
			} 
			else
			{	putchar(c);
				tstr[len++] = c;
				tstr[len] = '\0';
			}
		} while(len < slen && (c = getchar()) != '\n');
		while(isspace(tstr[--len]))
			tstr[len] = '\0';
		if(tstr != str)
		{	free(tstr);
			return(strcpy(str, tstr));
		}
		return str;
	}
	else
		return NULL;
}

/*
 * showinfo()
 */
showinfo()
{	printf("\nCurrent information for `%s'\n\n", info.name);
	printf("In real life: %s\n", info.rname);
	printf("Organization: %s\n", info.company);
	printf("       Phone: %s%s" 
		, info.phone.no
		, info.phone.unlisted == 'Y' ? " (unlisted)\n" : "\n");
}

/*
 * saveinfo()
 */
saveinfo()
{
	FILE *userf, *tfp;
	char buf[MAXLINE], *t_name;
	int len, replaced, rtn = FALSE;

	if ((userf = fopen(FData, "r")) == NULL)
	{	fprintf(stderr, "Cannot open %s for reading\n", FData);
		return (EOF);
	}
	t_name = (char*)tempnam(NULL, "cf_");
	if ((tfp = fopen(t_name, "w")) == NULL)
	{	fprintf(stderr, "Cannot open %s for writing\n", t_name);
		free(t_name);
		fclose(userf);
		return (EOF);
	}
	printf("Writing new info to finger data file...\n");
	len = strlen(info.name);
	replaced = FALSE;
	while (fgets(buf, sizeof(buf), userf) != NULL)
	{	if (replaced == FALSE
			&& !strncmp(buf, info.name, len)
			&& buf[len] == ':')
		{	fprintf(tfp, "%s:%c:%d:%d:%s:%c%s:%s:\n"
				, info.name, 'x', info.uid, info.gid, info.rname
				, info.phone.unlisted, info.phone.no, info.company);
			replaced = TRUE;
		}
		else
			fputs(buf, tfp);
	}
	if (replaced == FALSE)
	{	fprintf(tfp, "%s:%c:%d:%d:%s:%c%s:%s:\n"
			, info.name, 'x', info.uid, info.gid, info.rname
			, info.phone.unlisted, info.phone.no, info.company);
	}
	fclose(userf);
	fclose(tfp);
	unlink(FData);
	sprintf(buf, "cp %s %s", t_name, FData);
	system(buf);
	chmod(FData, 0600);
	unlink(t_name);
	free(t_name);
}
