/ (-lgl
/ 	COHERENT Version 4.2
/ 	Copyright (c) 1994 by Mark Williams Company.
/ 	All rights reserved. May not be copied without permission.
/ -lgl)

/	.unixorder		# Compiled with gas so .unixorder assumed
				# Do not compile it with the MWC as, it
				# does not create the named sections!

	.globl	exit
	.globl	_init
	.globl	_start
	.globl	_exit

/	External functions: Note that volatile void is the gnu way to
/	Define a function which doesn't return to this context.
/
/	volatile void exit(int retcode);
/	void _init(void);
/	volatile void _start(int argc, ...);
/	volatile void _exit(int retcode);

/	Make pointer to environment public accessable

	.globl	environ

///////////////////////////////////////////////////////////////////////////
/	start:	Set up the stack for main then call it.
/
/	The stack coming into the function looks like this:
/
/	Top of stack:
/		+---------------+
/		| environment  	|	
/		+---------------+
/		| argv[argc-1]	|
/		+---------------+
/		| ...   	|	
/		+---------------+
/		| argv[1]	|	
/		+---------------+
/		| argv[0]	|	
/		+---------------+
/	%esp->	| argc   	|	
/		+---------------+
/
///////////////////////////////////////////////////////////////////////////

_start:
	movl	%esp,%ebp		# Create stack frame
	movl	(%ebp),%eax		# %eax = argc;
	leal	0x8(%ebp,%eax,4),%edx	# %edx = envp;
	movl	%edx,environ		# environ = %edx; /* envp */
	pushl	%edx			# push envp for call to main()
	leal	0x4(%ebp),%edx		# %edx = argv;
	pushl	%edx			# push argv for call to main()
	pushl	%eax			# push argc for call to main()
	call	_init			# call the GNU _init in crtbegin
	call	main			# main(argc, argv, envp);
	addl	$0xc,%esp		# Clean up the stack for main
	pushl	%eax			# Save main's return code
	call	exit			# exit(retcode);

///////////////////////////////////////////////////////////////////////////
/
/	_exit(int retcode);
/
/	Force an exit regardless of status of files and ignoring functions
/	registered with atexit. Note that this function is called by the 
/	normal exit function. The normal exit function will fclose all
/	open files and call all registered atexit functions before it
/	comes here.
/
////////////////////////////////////////////////////////////////////////////

_exit:
	movl	$0x1,%eax		# exit system call
	lcall	$0x7,$0x0
	hlt				# Never get here.


////////////////////////////////////////////////////////////////////////////
/
/	Data section with the global environment pointer
/
////////////////////////////////////////////////////////////////////////////
	.section .data
	.align 4
environ:		
	.long	0			# Global pointer for all functions
					# to environment.

////////////////////////////////////////////////////////////////////////////
/
/	Comment section, so that we can identify binaries compiled
/	with the MWC port of GNU C
/
////////////////////////////////////////////////////////////////////////////
	.section .comment
	.align 4
	.ascii	"Mark Williams startup for GNU C 2.5.8"
	.byte	0


////////////////////////////////////////////////////////////////////////////
/
/	Init section:
/	Hook for the GNU C/C++ initialization code in crtbegin and crtend
/
////////////////////////////////////////////////////////////////////////////
	.section .init
	.align 4
_init:
