/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/X.h>
#include <X11/cursorfont.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>


#include "struct.h"
#include "config.h"



/*
 * Globale Variablen
 */

extern	Widget		toplevel;
extern	Cursor		def_cursor;
extern	Widget		dialog;
	Widget		ws_shell;
	Widget		etext1,etext2,etext3,etext4;
	Widget		et1,et2, save_but;

extern	WS_Glyph	*selc_ws;
extern	Dimension	selc_w;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Boolean		GRAB;

extern	Pixmap		icon_pixmap;
extern	Pixmap		Icon_WSE_PM;
extern	Pixmap		Icon_WSD_PM;

extern	xfm_struct	defaults;
extern	Boolean		FILE_CHANGED;

extern	WS_Glyph	workspace;
extern	XtTranslations	but_trans[];

/*
 * Function Prototypes
 */

void		makeWorkspaceWindow (Widget parent, WS_Glyph *ws);
XtActionProc	refreshWS      (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c);
XtActionProc	resetWS        (Widget w, XConfigureEvent *e, 
				String *s, Cardinal *c);
void		addWSEtoWS     (WS_Glyph *ws, char *label,
				char *file, char *icon,
		 		Boolean can_arg, Boolean must_arg);
extern	Widget	makeDialog     (Dimension text,
				char *label1, char *label2,
				char *text1, char *text2,
				char *title, Boolean cancel, Boolean OVERRIDE);

extern	void	drawWSE	       (WS_Glyph *ws, Dimension entry,
				Boolean selected, Boolean back);
extern	void	FATAL_ERROR    (char *mess);
extern	String	getPath	       (Dir_Glyph *dir);
extern	Pixmap	ReadPixmapFromFile(char *filename, int *w, int *h);

void		init_editWSE   (void);
void		init_deleteWSE (void);

void		saveWorkspace  (WS_Glyph *ws);
void		hide_wsshell   (void);
void		reset_wsshell  (void);
void		apply_wsshell  (void);
void		save_wsshell   (void);
void		wse_delete_cb  (void);


/*********************************************************
 * name:	makeWorkspaceWindow
 * description:	Erzeugt das Fenster eines Workspaces, in dem der
 *		Benutzer Programme nach belieben ablegen kann, ohne
 *		das eine Operation im Filesystem dazu ausgefuehrt
 *		werden muesste.
 *		Es ist hauptsaechlich dazu gedacht, ausfuehrbare
 *		Programme dort abzulegen, um dann spaeter Dateien
 *		mittels Drag&Drop darauf ziehen zu koennen.
 * input:	Widget	parent	- Parentwidget, im Falle des
 *				  singleWindow-Modes die Pane
 *		WS_Glyph	- der Workspace
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
void		makeWorkspaceWindow (Widget parent, WS_Glyph *ws)
{
	Arg	args[10];
	Widget	vp;
	Widget	dummy, form,but;

	ws->shell = parent;

	/*
	 * Eine Form erzeugen und darauf den Workspacebereich und einige
	 * Controllelemente anbringen.
	 */
	dummy = XtVaCreateManagedWidget ("workspace_pane", panedWidgetClass,
					  parent,
					  XtNorientation, (defaults.multi_window ? XtorientHorizontal : XtorientVertical),
					  NULL);

	/*
	 * Auf der Pane eine Form fuer das Workspace-Iconmenu erzeugen
	 */
	form = XtVaCreateManagedWidget("workspace_form",formWidgetClass,dummy,
					XtNshowGrip,FALSE,
					NULL);

	/*
	 * Auf der Form 2 Buttons fuer Edit und Delete einrichten
	 */
	XtSetArg(args[0],XtNleft, XawChainLeft);
	XtSetArg(args[1],XtNright, XawChainLeft);
	XtSetArg(args[2],XtNbottom, XawChainTop);
	XtSetArg(args[3],XtNtop, XawChainTop);
	XtSetArg(args[4],XtNwidth,32);
	XtSetArg(args[5],XtNheight,32);
	but = XtCreateManagedWidget("edit_wse",simpleWidgetClass,form,
					args,6);
	XtOverrideTranslations(but, but_trans[7]);

	if (defaults.multi_window)
		XtSetArg(args[6],XtNfromVert,but);
	else {
		XtSetArg(args[6],XtNfromHoriz, but);
		ws->shell = dummy;
	}
	but = XtCreateManagedWidget("delete_wse",simpleWidgetClass,form,
					args,7);
	XtOverrideTranslations(but, but_trans[8]);

	/*
	 * Einen Viewport fuer den Workspace erzeugen
	 */
	if (defaults.multi_window)
		XtSetArg(args[0],XtNwidth, 640);
	else
		XtSetArg(args[0],XtNwidth,250);
	XtSetArg(args[1],XtNheight,100);
	XtSetArg(args[2],XtNallowHoriz, TRUE);
	XtSetArg(args[3],XtNallowVert, TRUE);
	XtSetArg(args[4],XtNforceBars, TRUE);
	XtSetArg(args[5],XtNuseBottom, TRUE);
	XtSetArg(args[6],XtNuseRight, TRUE);
	vp = XtCreateManagedWidget("viewport", viewportWidgetClass,
				   dummy, args,7);

	/*
	 * Auf den Viewport kommt nun das Simple fuer den Workspace
	 */
	ws->window = XtCreateWidget("ws_simple", simpleWidgetClass,
					vp, args, 2);
	XtOverrideTranslations(ws->window, XtParseTranslationTable(
					"<Leave>: leave-window()\n\
					<Enter>: enter-window()\n\
				        <Expose>: refresh-ws() \n\
					<Btn1Down>: clear-multi() start-single()\n\
					<Btn1Motion>: follow-single()\n\
					<Btn1Up>: end-single()"));
	XtOverrideTranslations(ws->shell, XtParseTranslationTable("<Configure>: reset-ws()"));
}


/*********************************************************
 * name:	resetWS
 * description:	Neuanordnen der Icons nach einem Reset
 * input:	Widget w - nur zum checken
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
XtActionProc	resetWS      (Widget w, XConfigureEvent *e, 
				String *s, Cardinal *c)
{
	int		i;
	Dimension	wi,hi;
	Widget		vp;
	Dimension	sw,sh;

	/* Breite vom Viewport abhaengig machen */
	vp = XtParent(workspace.window);
	XtVaGetValues(vp,XtNwidth,&wi,
			 XtNheight,&hi,
			 NULL);

	sw = wi;
	sh = hi;
	wi = (wi - 40)/100;
	if (wi < 1)	wi = 1;
	if (sw < 140)	sw = 140;

	if (wi > 0 && wi != workspace.width) {
		workspace.width = wi;
		for (i = 0; i < workspace.wse_count; i++) {
			workspace.wse[i]->x = i%workspace.width;
			workspace.wse[i]->y = i/workspace.width;
		}
	}
	if (workspace.wse_count) {
		sh = 80 + workspace.wse[workspace.wse_count - 1]->y*40;
		if (sh < hi)	sh = hi;
	}

	XClearWindow(XtDisplay(toplevel),XtWindow(workspace.window));
	refreshWS(workspace.window,NULL,NULL,NULL);

	/*
	 * XtResizeWidget causes trouble on some displays
	 */
	XtVaSetValues(workspace.window, XtNwidth,sw,
					XtNheight,sh,
					NULL);

	/*
	 * Groesse der Shell holen, damit sie beim naechsten Mal
	 * wieder hergestellt werden kann.
	 */
	XtVaGetValues(workspace.shell,  XtNwidth, &wi,
					XtNheight, &hi,
					XtNx, &sw,
					XtNy, &sh,
					NULL);
	workspace.fx = sw; workspace.fx = sh;
	workspace.fw = wi, workspace.fh = hi;
}


/*********************************************************
 * name:	refreshWS
 * description:	Neuzeichnen des Workspaces nach einem
 *		Exposeevent
 * input:	Widget w - nur zum checken
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
XtActionProc	refreshWS      (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c)
{
	if (w == workspace.window && workspace.wse_count > 0) {
		int	i;
		Boolean b;

		/*
		 * Alle notwendigen Icons neuzeichnen
		 */
		for (i = 0; i < workspace.wse_count; i++) {
			b = (i == selc_w ? TRUE : FALSE);
			drawWSE (&workspace,i,b,b);
		}
	}
}


/*********************************************************
 * name:	addWSEtoWS
 * description:	Neuen Eintrag am Workspace anfuegen
 * input:	WS_Glyph *ws	- Workspace
 *		char	*label	- label
 *		char	*file	- filename
 *		char	*path	- pfad
 *		char	*icon	- iconfile
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.1993
 *********************************************************/
void	addWSEtoWS (WS_Glyph *ws, char *label,
		    char *file, char *icon,
		    Boolean can_arg, Boolean must_arg)
{
	WSE_Glyph	*wse;

	/*
	 * Speicher fuer den Workspaceeintrag holen
	 */
	ws->wse_count++;
	if (!(wse = (WSE_Glyph *) malloc(sizeof(WSE_Glyph))))
		FATAL_ERROR("addWSEtoWS: malloc failed");
	if (!ws->wse) {
		if (!(ws->wse = (WSE_Glyph **) malloc(sizeof(WSE_Glyph *))))
			FATAL_ERROR ("addWSEtoWS: malloc failed");
	}
	else {
		if (!(ws->wse = (WSE_Glyph **) realloc((void *) ws->wse,
							sizeof(WSE_Glyph *)*ws->wse_count)))
			FATAL_ERROR ("addWSEtoWS: realloc failed");
	}

	/*
	 * Workspaceeintrag fuellen
	 */
	wse->x = (ws->wse_count - 1)%ws->width;	/* psovisorisches fuellen */
	wse->y = (ws->wse_count - 1)/ws->width;
	wse->label = label;
	wse->file = file;
	wse->pmap = (Pixmap) NULL;
	/*
	 * Nach Pixmap suchen
	 */
	{ 	int	w,h;
		if (icon)
			wse->pmap = ReadPixmapFromFile(icon,&w,&h);
		if (!wse->pmap)
			h = 16;
		wse->w = w; wse->h = h;
	}

	wse->pmap_file = icon;
	wse->can_arg = can_arg;
	wse->must_arg = must_arg;
	ws->wse[ws->wse_count - 1] = wse;
}




/*********************************************************
 * name:	readWorkspace
 * description:	Initialisiert einen Workspace mit den
 *		Settings aus dem angegebenen File
 * input:	WS_Glyph *ws	- Workspace
 *		char	*file	- Settingsfile
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
void	readWorkspace  (WS_Glyph *ws, char *file)
{
	char	filename[255];
	char	*home = getenv("HOME");
	FILE	*fp;

	/*
	 * zunaechst den Filenamen generieren
	 */
	if (strcmp(home,"/"))
		sprintf(filename,"%s/.wsrc",home);
	else
		sprintf(filename,"/.wsrc");

	/*
	 * Workspacefiles oeffnen falls vorhanden
	 */
	if ((fp = fopen(filename,"r")) || (fp = fopen(DEFAULT_WORKSPACE,"r"))) {
		int	width,items;
		int	i;
		char	s[1024];

		s[1023] = '\0';
		if (fgets(s,1023,fp)) {
			sscanf(s,"%d %d %d %d %d %d",&width,&items,&ws->fx,&ws->fy,&ws->fw,&ws->fh);
			ws->width = width;
			ws->wse_count = 0;
			ws->wse = NULL;
			if (!ws->fw)	ws->fw = 600;
			if (!ws->fh)	ws->fh = 80;
		}
		else items = 0;
		/* Einzelnen Eintraege lesen */
		for (i = 0; i < items; i++) {
			char	*sss, *ss;
			char	*label, *file, *pmap_file;
			int	x,y,can_arg,must_arg;

			ss = s;
			fgets(s,1023,fp);
			/*
			 * Label holen
			 */
			if ((sss = strchr(ss,':'))) {
				*sss = '\0';
				if (!(label = (char *) malloc (strlen(ss)+1)))
					FATAL_ERROR("Read WS: Malloc failed");
				sprintf(label,"%s",ss);
				ss = sss + 1;
				/*
				 * Ausfuehrbares Programm holen
				 */
				if ((sss = strchr(ss,':'))) {
					*sss = '\0';
					if (!(file = (char *) malloc (strlen(ss)+1)))
						FATAL_ERROR("Read WS: Malloc failed");
					sprintf(file,"%s",ss);
					ss = sss + 1;
					sscanf(ss,"%d%d",&x,&y);
					ss = strchr(ss,':') + 1;

					/*
					 * Icon-filenamen holen
					 */
					pmap_file = NULL;
					if ((sss = strchr(ss,':'))) {
						*sss = '\0';
						if (strlen(ss)) {
							if (!(pmap_file = (char *) malloc (strlen(ss)+1)))
								FATAL_ERROR("Read WS: Malloc failed");
							sprintf(pmap_file,"%s",ss);
						}
						ss = sss;
					}
					ss++;
					sscanf(ss,"%d %d",&can_arg,&must_arg);
					addWSEtoWS(ws,label,file,pmap_file,can_arg,must_arg);
				}
			}
		}
		fclose(fp);
	}
	else {	/* Default Workspace nehmen */
#ifdef	HAVE_XPM
#ifdef	hpux
		ws->wse_count = 0;
		ws->width = 6;
		ws->wse = NULL;
		ws->fx = 0;
		ws->fy = 0;
		ws->fw = 700;
		ws->fh = 90;
		addWSEtoWS(ws,"File Viewer","xmore","xmore.xpm",TRUE,FALSE);
		addWSEtoWS(ws,"Editor","xedit","xedit.xpm",TRUE,FALSE);
		addWSEtoWS(ws,"News","/users/kalkan/bin/xrnj",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"Mailtool","xmail",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"WaisQ","xwaisq",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"XV","xv","file_pix.xpm",TRUE,TRUE);
		addWSEtoWS(ws,"Compress","gzip","file_z.xpm",TRUE,TRUE);
		addWSEtoWS(ws,"Uncompress","gunzip","file_z.xpm",TRUE,TRUE);
		addWSEtoWS(ws,"XFig","xfig","file_graph.xpm",TRUE,FALSE);
#else
		ws->wse_count = 0;
		ws->width = 6;
		ws->wse = NULL;
		addWSEtoWS(ws,"File Viewer","xmore","file_text.xpm",TRUE,FALSE);
		addWSEtoWS(ws,"Editor","xedit","file_dvi.xpm",TRUE,FALSE);
		addWSEtoWS(ws,"WaisQ","xwaisq",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"XV","xv","file_pix.xpm",TRUE,TRUE);
		addWSEtoWS(ws,"XFig","xfig","file_graph.xpm",TRUE,FALSE);
		addWSEtoWS(ws,"Compress","gzip","file_z.xpm",TRUE,TRUE);
		addWSEtoWS(ws,"Uncompress","gunzip","file_z.xpm",TRUE,TRUE);
#endif
#else
#ifdef	hpux
		ws->wse_count = 0;
		ws->width = 6;
		ws->wse = NULL;
		ws->fx = 0;
		ws->fy = 0;
		ws->fw = 700;
		ws->fh = 90;
		addWSEtoWS(ws,"File Viewer","xmore","text.xbm",TRUE,FALSE);
		addWSEtoWS(ws,"Editor","xedit",NULL,TRUE,FALSE);
		addWSEtoWS(ws,"News","/users/kalkan/bin/xrnj",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"Mailtool","xmail",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"WaisQ","xwaisq",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"XV","xv","file_pix.xbm",TRUE,TRUE);
		addWSEtoWS(ws,"Compress","gzip","file_z.xbm",TRUE,TRUE);
		addWSEtoWS(ws,"Uncompress","gunzip","file_z.xbm",TRUE,TRUE);
		addWSEtoWS(ws,"XFig","xfig","file_graph.xbm",TRUE,FALSE);
#else
		ws->wse_count = 0;
		ws->width = 6;
		ws->wse = NULL;
		addWSEtoWS(ws,"File Viewer","xmore","file_text.xbm",TRUE,FALSE);
		addWSEtoWS(ws,"Editor","xedit","file_dvi.xbm",TRUE,FALSE);
		addWSEtoWS(ws,"WaisQ","xwaisq",NULL,FALSE,FALSE);
		addWSEtoWS(ws,"XV","xv","file_pix.xbm",TRUE,TRUE);
		addWSEtoWS(ws,"XFig","xfig","file_graph.xbm",TRUE,FALSE);
		addWSEtoWS(ws,"Compress","gzip","file_z.xbm",TRUE,TRUE);
		addWSEtoWS(ws,"Uncompress","gunzip","file_z.xbm",TRUE,TRUE);
#endif
#endif
	}

	/*
	 * Groesse und Position des Workspaces setzen
	 */
	if (defaults.multi_window)
		XtConfigureWidget(ws->shell,ws->fx,ws->fy,ws->fw,ws->fh,0);
}



/*********************************************************
 * name:	init_editWSE
 * description:	oeffnet ein Fenster zum Editieren oder Neuerzeugen von
 *		Eintraegen fuer den Workspace
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	init_editWSE(void)
{
	Widget		form;
	WSE_Glyph	*g = NULL;
	Widget		label,icon;

	if (selc_fo && selc_f < 16000 && GRAB) {	/* Executable wurde draufgezogen */
		char	*d = getPath(selc_fo->dir);
		char	s[1024];

		if (strcmp(d,"/"))
			sprintf(s,"%s/%s",d,selc_fo->file[selc_f]->name);
		else
			sprintf(s,"/%s",selc_fo->file[selc_f]->name);
		free(d);
		if (!(d = (char *) malloc (strlen(s)+1)))
			FATAL_ERROR("initEditWS: Malloc failed");
		sprintf(d,"%s",s);
		addWSEtoWS(&workspace,selc_fo->file[selc_f]->name,d,
				NULL,TRUE,FALSE);
		selc_ws = &workspace;
		selc_w = workspace.wse_count - 1;
		refreshWS(workspace.window,NULL,NULL,NULL);
	}
	if (selc_w < 16000 && selc_ws)
		g = selc_ws->wse[selc_w];

	/*
	 * Alte Shell zerstoeren, falls sie noch existiert
	 */
	if (ws_shell)
		XtDestroyWidget(ws_shell);
	ws_shell = XtVaCreatePopupShell("wse_shell",topLevelShellWidgetClass,
					toplevel,
					XtNallowShellResize,TRUE,
					NULL);

	/*
	 * Form darauf erzeugen
	 */
	form = XtVaCreateManagedWidget ("dialog_form", formWidgetClass, ws_shell,
					NULL);
	/*
	 * Den Simple fuer das Icon erstellen
	 */
	icon_pixmap = Icon_WSE_PM;
	icon = XtVaCreateManagedWidget ("dialog_icon", simpleWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNwidth, 32,
					XtNheight, 32,
					XtNborderWidth, 0,
					NULL);
	XtOverrideTranslations(icon,XtParseTranslationTable("<Expose>: refresh-dialog-icon()"));

	/*
	 * den Label darauf erzeugen, der sagt, das es sich hierbei um
	 * eine Verschiebe-Aktion handelt
	 */
	label = XtVaCreateManagedWidget ("info_title", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNfromHoriz, icon,
					XtNlabel,"Workspace Entry Editor",
					NULL);

	/*
	 * Feld fuer Label erzeugen
	 */
	label = XtVaCreateManagedWidget ("label_label", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel,"Label :",
					XtNjustify,XtJustifyRight,
					XtNwidth,100,
					XtNfromVert,icon,
					NULL);
	etext1 = XtVaCreateManagedWidget ("label_label", asciiTextWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainRight,
					XtNleft, XtChainLeft,
					XtNstring,(g ? g->label : NULL),
					XtNresize, XawtextResizeWidth,
					XtNfromVert,icon,
					XtNfromHoriz, label,
					XtNeditType, XawtextEdit,
					NULL);
	XtOverrideTranslations(etext1, XtParseTranslationTable(
					"<Key>Return: no-op()"));

	/*
	 * Feld fuer Label erzeugen
	 */
	label = XtVaCreateManagedWidget ("label_label", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel,"Executable :",
					XtNjustify,XtJustifyRight,
					XtNwidth,100,
					XtNfromVert,label,
					NULL);
	etext2 = XtVaCreateManagedWidget ("label_label", asciiTextWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainRight,
					XtNleft, XtChainLeft,
					XtNstring,(g ? g->file : NULL),
					XtNresize, XawtextResizeWidth,
					XtNfromVert,etext1,
					XtNfromHoriz, label,
					XtNeditType, XawtextEdit,
					NULL);
	XtOverrideTranslations(etext2, XtParseTranslationTable(
					"<Key>Return: no-op()"));

	/*
	 * Feld fuer Label erzeugen
	 */
	label = XtVaCreateManagedWidget ("icon_label", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel,"Iconfile :",
					XtNjustify,XtJustifyRight,
					XtNwidth,100,
					XtNfromVert,label,
					NULL);
	etext3 = XtVaCreateManagedWidget ("label_label", asciiTextWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainRight,
					XtNleft, XtChainLeft,
					XtNstring,(g ? g->pmap_file : NULL),
					XtNresize, XawtextResizeWidth,
					XtNfromVert,etext2,
					XtNfromHoriz, label,
					XtNeditType, XawtextEdit,
					NULL);
	XtOverrideTranslations(etext3, XtParseTranslationTable(
					"<Key>Return: no-op()"));

	/*
	 * Feld fuer CanArgLabel erzeugen
	 */
	label = XtVaCreateManagedWidget ("icon_label", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel,"Can be Droptarget :",
					XtNjustify,XtJustifyRight,
					XtNwidth,150,
					XtNfromVert,label,
					XtNvertDistance, 12,
					NULL);
	et1 = XtVaCreateManagedWidget ("toggle", toggleWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNwidth,20,
					XtNfromVert,etext3,
					XtNfromHoriz, label,
					XtNstate,(g ? g->can_arg : TRUE),
					XtNvertDistance, 10,
					XtNlabel," ",
					NULL);

	/*
	 * Feld fuer MustArgLabel erzeugen
	 */
	label = XtVaCreateManagedWidget ("icon_label", labelWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNborderWidth, 0,
					XtNlabel,"Must be Droptarget :",
					XtNjustify,XtJustifyRight,
					XtNwidth,150,
					XtNfromVert,et1,
					NULL);
	et2 = XtVaCreateManagedWidget ("toggle", toggleWidgetClass, form,
					XtNtop, XtChainTop,
					XtNbottom, XtChainTop,
					XtNright, XtChainLeft,
					XtNleft, XtChainLeft,
					XtNwidth,20,
					XtNfromVert,et1,
					XtNfromHoriz, label,
					XtNstate,(g ? g->must_arg : FALSE),
					XtNlabel," ",
					NULL);

	/*
	 * Zum Schluss noch eine Form fuer die Buttons erzeugen
	 */
	form = XtVaCreateManagedWidget("wse_form", formWidgetClass, form,
					XtNleft,XawChainLeft,
					XtNright,XawChainRight,
					XtNbottom,XawChainBottom,
					XtNtop,XawChainBottom,
					XtNfromVert,label,
					XtNvertDistance,20,
					XtNborderWidth,0,
					NULL);
	/*
	 * Darauf jetzt noch einige Buttons erzeugen
	 */
	label = XtVaCreateManagedWidget("wse_hide", commandWidgetClass, form,
					XtNleft, XawChainLeft,
					XtNright, XawChainLeft,
					XtNlabel, "  Hide  ",
					NULL);
	XtAddCallback (label,XtNcallback,(XtCallbackProc) hide_wsshell,NULL);

	label = XtVaCreateManagedWidget("wse_reset", commandWidgetClass, form,
					XtNleft, XawChainRight,
					XtNright, XawChainRight,
					XtNlabel, " Reset ",
					XtNfromHoriz, label,
					XtNhorizDistance, 50,
					NULL);
	XtAddCallback (label,XtNcallback,(XtCallbackProc) reset_wsshell,NULL);

	save_but = XtVaCreateManagedWidget("wse_save", commandWidgetClass, form,
					XtNleft, XawChainRight,
					XtNright, XawChainRight,
					XtNlabel, "  Save  ",
					XtNfromHoriz, label,
					NULL);
	XtAddCallback (save_but,XtNcallback,(XtCallbackProc) save_wsshell,NULL);

	label = XtVaCreateManagedWidget("wse_apply", commandWidgetClass, form,
					XtNleft, XawChainRight,
					XtNright, XawChainRight,
					XtNlabel, " Apply  ",
					XtNfromHoriz, save_but,
					NULL);
	XtAddCallback (label,XtNcallback,(XtCallbackProc) apply_wsshell,NULL);


	XtManageChild(ws_shell);
}

/*********************************************************
 * name:	init_deleteWSE
 * description:	oeffnet ein Fenster zum Loeschen von
 *		Eintraegen des Workspace
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	init_deleteWSE(void)
{
	Widget	but;

	/*
	 * Dialog-Fenster erzeugen
	 */
	icon_pixmap = Icon_WSD_PM;
	but = makeDialog(0,"","",NULL,NULL,"Remove Workspace Entry?",TRUE,TRUE);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) wse_delete_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);
}


/*********************************************************
 * name:	saveWorkspace
 * description:	Sichern eines Workspaces um ihn spaeter wieder
 *		verwenden zu koennen.
 * input:	WS_Glyph *ws	- Der Workspace
 * output:	none
 * author:	Ove Kalkan
 * date:	21.7.1993
 *********************************************************/
void	saveWorkspace (WS_Glyph *ws)
{
	FILE	*fp;
	char	*home = getenv("HOME");
	char	filename[255];

	/*
	 * zunaechst den Filenamen generieren
	 */
	if (strcmp(home,"/"))
		sprintf(filename,"%s/.wsrc",home);
	else
		sprintf(filename,"/.wsrc");

	/*
	 * Versuchen, das File zu oeffnen
	 */
	if ((fp = fopen(filename,"w"))) {
		int	i;
		/*
		 * Workspace rausschreiben
		 */
		fprintf(fp,"%d %d %d %d %d %d\n",ws->width,ws->wse_count,ws->fx,ws->fy,
						 ws->fw,ws->fh);
		for (i = 0; i < ws->wse_count; i++) {
			WSE_Glyph *g = ws->wse[i];

			fprintf(fp,"%s:%s:%d %d:%s:%d %d\n",
					g->label,g->file,g->x,g->y,
					g->pmap_file,g->can_arg,g->must_arg);
		}
		fclose(fp);
	}
	else
		WARNING("Cannot save Workspace");
}



/*********************************************************
 * name:	hide_wsshell
 * description:	Loeschen der Workspace_Edit-Shell
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	hide_wsshell (void)
{
	XtDestroyWidget (ws_shell);
	ws_shell = NULL;
}



/*********************************************************
 * name:	reset_wsshell
 * description:	Ruecksetzen der Eintraege im Workspace Editor
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	reset_wsshell (void)
{
	if (selc_ws && selc_w < 16000) {
		WSE_Glyph	*g = selc_ws->wse[selc_w];

		XtVaSetValues(etext1,XtNstring,g->label,NULL);
		XtVaSetValues(etext2,XtNstring,g->file,NULL);
		XtVaSetValues(etext3,XtNstring,g->pmap_file,NULL);
		XtVaSetValues(et1,XtNstate,g->can_arg,NULL);
		XtVaSetValues(et2,XtNstate,g->must_arg,NULL);
	}
	else {
		XtVaSetValues(etext1,XtNstring,NULL,NULL);
		XtVaSetValues(etext2,XtNstring,NULL,NULL);
		XtVaSetValues(etext3,XtNstring,NULL,NULL);
		XtVaSetValues(et1,XtNstate,TRUE,NULL);
		XtVaSetValues(et2,XtNstate,FALSE,NULL);
	}
}


/*********************************************************
 * name:	save_wsshell
 * description:	sichern des Workspaces
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	save_wsshell (void)
{
	saveWorkspace(&workspace);
}


/*********************************************************
 * name:	apply_wsshell
 * description:	Aufnehmen oder Aendern eines Eintrages
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	22.7.1993
 *********************************************************/
void	apply_wsshell (void)
{
	char	*a1,*a2,*a3;
	Boolean	b1,b2;

	/*
	 * Werte und Strings von den Widgets holen
	 */
	XtVaGetValues(etext1,XtNstring,&a1,NULL);
	XtVaGetValues(etext2,XtNstring,&a2,NULL);
	XtVaGetValues(etext3,XtNstring,&a3,NULL);
	XtVaGetValues(et1,XtNstate,&b1,NULL);
	XtVaGetValues(et2,XtNstate,&b2,NULL);

	/*
	 * Label und Executable muessen vorhanden sein
	 */
	if (!strlen(a1)) {
		WARNING("Error: Missing Label");
		return;
	}
	if (!strlen(a2)) {
		WARNING("Error: Missing Executable");
		return;
	}

	if (selc_ws && selc_w < 16000) {	/* Alten Eintrag modifizieren */
		WSE_Glyph	*g = selc_ws->wse[selc_w];

		/*
		 * Speicher neu beschaffen und Werte sichern
		 */
		if (!(g->label = (char *) realloc((void *) g->label,
						  strlen(a1)+1)))
			FATAL_ERROR("apply_shell: realloc1 failed.");
		if (!(g->file = (char *) realloc((void *) g->file,
						  strlen(a2)+1)))
			FATAL_ERROR("apply_shell: realloc2 failed.");
		sprintf(g->label,"%s",a1);
		sprintf(g->file,"%s",a2);
		if (strlen(a3)) {
			if (!g->pmap) {
				if (!(g->pmap_file = (char *) malloc(strlen(a3)+1)))
					FATAL_ERROR("apply_shell: nmalloc3 failed.");
			}
			else {
				if (!(g->pmap_file = (char *) realloc((void *) g->pmap_file,
								  strlen(a3)+1)))
					FATAL_ERROR("apply_shell: realloc3 failed.");
			}
			sprintf(g->pmap_file,"%s",a3);
		}
		else {
			if (g->pmap_file)
				free(g->pmap_file);
			g->pmap_file = NULL;
		}
		g->can_arg = b1;
		g->must_arg = b2;

		/*
		 * Pixmap neu laden und darstellen
		 */
		if (g->pmap)
			XFreePixmap(XtDisplay(toplevel),g->pmap);
		g->pmap = (Pixmap) NULL;
		{ 	int	w,h;

			if (g->pmap_file)
				g->pmap = ReadPixmapFromFile(g->pmap_file,&w,&h);
			if (!g->pmap)
				h = 16;
			g->w = w; g->h = h;
		}
		refreshWS(workspace.window,NULL,NULL,NULL);
	}
	else {	/* Neuen Eintrag erstellen */
		char	*label,*file,*pmap_file;

		if (!(label = (char *) malloc(strlen(a1)+1)))
			FATAL_ERROR("apply_shell: malloc1 failed.");
		if (!(file = (char *) malloc(strlen(a2)+1)))
			FATAL_ERROR("apply_shell: malloc2 failed.");
		sprintf(label,"%s",a1);
		sprintf(file,"%s",a2);
		if (strlen(a3)) {
			if (!(pmap_file = (char *) malloc(strlen(a3)+1)))
				FATAL_ERROR("apply_shell: malloc3 failed.");
			sprintf(pmap_file,"%s",a3);
		}
		else
			pmap_file = NULL;
		addWSEtoWS(&workspace,label,file,pmap_file,b1,b2);
		selc_ws = &workspace;
		selc_w = workspace.wse_count - 1;
		refreshWS(workspace.window,NULL,NULL,NULL);
	}
}



/*********************************************************
 * name:	wse_delete_cb
 * description:	loeschen eines Eintrags aus dem Workspace
 * input:	None
 * output:	None
 * author:	Ove Kalkan
 * date:	28.7.1993
 *********************************************************/
void	wse_delete_cb(void)
{
	int	i;

	XUngrabPointer(XtDisplay(toplevel),CurrentTime);
	XtDestroyWidget (dialog);
	dialog = NULL;
	workspace.wse_count--;

	for (i = selc_w; i < workspace.wse_count; i++)
		workspace.wse[i] = workspace.wse[i+1];

	XClearWindow(XtDisplay(workspace.window),XtWindow(workspace.window));
	refreshWS(workspace.window,NULL,NULL,NULL);
}
