/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

/*
 * This file contains all important global structure defines
 */

#ifndef	STRUCT_H
#define	STRUCT_H

#ifdef COHERENT
typedef unsigned int u_int;
#endif

typedef struct dir_glyph{
	Dimension		x, y;		/* Position des Glyphs im Icondirectory */
	String			name;		/* Wenn Null, dann Root-Directory */
	Boolean			open;		/* Ob die Unterdirectoires gezeigt werden */
	unsigned char		flags;		/* Dir-Flags */

	struct dir_glyph	*parent;	/* Das Parentdir */
	Dimension		dir_count;	/* Anzahl der Unterdirectories in diesem
						   Verzeichnis */
	struct dir_glyph	**dir;		/* Feld mit Zeigern auf die
						   Unterdirectories */
} Dir_Glyph;

/*
 * Dir-Flags
 */
#define	DIR_READABLE	1
#define	DIR_WRITEABLE	2
#define	DIR_LINK	4
#define	DIR_HIDDEN	8

/*
 * Hier die File-Struktur fuer das neben dem Dir-Fenster gezeigte 
 * FileFenster
 */
typedef struct {
	unsigned char	prog_type;		/* Programm-Type */
	unsigned int	size;			/* Groesse des Files */
	ushort		mode;			/* File Mode */
	uid_t		uid;			/* Id des Owners */
	gid_t		gid;			/* Id der Gruppe */
	char		*name;			/* Name of File */
} File_Glyph;

typedef struct {
	Dimension	max_length;		/* Laengster Filename */
	Dimension	total_count;		/* Anzahl der Files im Dir gesamt */
	unsigned int	size;			/* Bytes der Files in diesem Folder */

	Widget		window;			/* Das Fenster der Fileliste */
	Widget		label;			/* der Label */
	Widget		vp;			/* der Viewport */
	Widget		shell;			/* Das Shellfenster */
	Widget		info;			/* File-Count info */

	Dir_Glyph	*dir;			/* Das Directory */

	char		*filter;		/* String or NULL */
	Dimension	file_count;		/* Anzahl der Files */
	File_Glyph	**file;			/* Die Files */
} Folder_Glyph;


/*
 * File-Flags
 */
#define	FILE_PLAIN	100
#define	FILE_LOCK	101
#define	FILE_LINK	102
#define	FILE_EXEC	103

#define	FILE_LDIR	198
#define	FILE_DIR	199
#define	FILE_ROOT	200

typedef	struct {
	char		*cmd;			/* Programm das ausgefuerht werden soll */
	char		*suffix;		/* Alle moeglichen Suffixe des Dateityps */
	unsigned char	type;			/* prog_type */
	char		*pmap_file;		/* File mit dem Icon */
	Pixmap		*pmap;			/* Icon des Files */
	char		*description;		/* Beschreibung */
} Suffix_Glyph;

typedef	struct {
	char		type;			/* Filetype fuer den pmap */
	Pixmap		*pmap;			/* als Icon verwendet wird */
} Pixmap_Glyph;

/*
 * Structure mit den Defaultsettings
 */
typedef struct	{
	/* Das Rootdir mit dem angefangen wird, z.B. "/" oder "/users" */
	char		*root_dir;		/* Das Root-Directory */

	/* Graphic resources */
	Pixel		select_color;		/* Farbe selektierter Items */
	XFontStruct	*icon_font;		/* Font fuer die Icons */
	char		*icon_dir;		/* Wo die Icons zu finden sind */

	/* Einige Resources fuer das Handling */
	Boolean		multi_window;		/* Folder oeffnet neues Fenster */
	Dimension	click_interval;		/* Doppelclick Zeitinterval */
	Boolean		drag_copy;		/* Wenn True wird nicht gefragt beim Copy-Drag */
	Boolean		drag_move;		/* Wenn True wird nicht gefragt beim Move-Drag */
	Boolean		drag_exec;		/* Wie Oben */
	Boolean		drag_delete;		/* Wie oben */
	Boolean		save_ws_on_exit;	/* Sichern des Workspaces beim Verlassen */
} xfm_struct;


/*
 * Info_struktur, gibt auskunft darueber, wo sich der Mauszeiger befindet
 * und welches Item selectiert, etc. wurde
 */
typedef	struct	{
	Widget		window;			/* Fenster */
	Folder_Glyph	*folder;		/* Wenn nicht folder, dann NULL */
	Dimension	selc_v;			/* Das gerade selectierte Item */

	Dir_Glyph	*selc_g;		/* Wenn im Dir-Path selectiert */
} Info_Glyph;


/*
 * Die Workspace Struct
 */
typedef struct	{
	char		*label;			/* Label eines WS-Entries */
	char		*file;			/* Name des Files, das ausgefuehrt wird*/
	Dimension	x,y;			/* Iconposition */
	Dimension	w,h;			/* Icongroesse */
	char		*pmap_file;		/* Iconfile */
	Pixmap		pmap;			/* Das Icon */
	Boolean		can_arg;		/* Ob Dropable */
	Boolean		must_arg;		/* Ob ohne Argument */
} WSE_Glyph;

typedef	struct	{
	Widget		window;			/* Das Icon */
	Widget		shell;			/* Das Shellwindow */

	int		fx,fy;			/* Position des Fensters auf dem Screen */
	int		fw,fh;			/* Fenstergroesse */
	Dimension	width;
	Dimension	wse_count;		/* Zahl der Eintraege im Workspace */
	WSE_Glyph	**wse;			/* Icons im Workspace */
} WS_Glyph;

#ifndef S_ISLNK
#define	S_ISLNK(_M) ((_M & S_IFMT)==S_IFLNK)   /* test for symbolic link */
#endif
#endif

