/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#ifndef ICONS_H
#define ICONS_H

/*
 * In diesem File befinden sich die Xpm Icons
 */

/*
 * Closed dir
 */
#define	BACKGROUND	". c grey90   m white g4 grey90"

static char *dir_closed[] = {
	"16 16 3 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"y c yellow m white g4 grey80",
	"................",
	"................",
	"................",
	"..bbbb..........",
	".byyyyb.........",
	"bbbbbbbbbbbbbb..",
	"byyyyyyyyyyyyb..",
	"byyyyyyyyyyyyb..",
	"byyyyyyyyyyyyb..",
	"byyyyyyyyyyyyb..",
	"byyyyyyyyyyyyb..",
	"byyyyyyyyyyyyb..",
	"bbbbbbbbbbbbbb..",
	"................",
	"................",
	"................",
};	

static char *file_dlink[] = {
	"16 16 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"r c red   m white g4 grey70",
	"y c yellow m white g4 grey80",
	"................",
	"................",
	"................",
	"..bbbbb.........",
	".brrrrrb........",
	"bbrrrrrrbbbbbb..",
	"bybbbrrrbyyybb..",
	"byyyybrrrbbbbrb.",
	"byyyybrrrrrrrrrb",
	"byyyyybrrrrrrrrb",
	"byyyyyybbbbbbrb.",
	"byyyyyyyyyyybb..",
	"bbbbbbbbbbbbbb..",
	"................",
	"................",
	"................",
};	


static char *dir_locked[] = {
	"16 16 4 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"y c yellow m white g4 grey80",
	"r c red    m black g4 red",
	"................",
	"................",
	"rr..........rr..",
	".rrbbb.....rr...",
	".brryyb...rr....",
	"bbbrrbbbbrrbbb..",
	"byyyrryyrryyyb..",
	"byyyyrrrryyyyb..",
	"byyyyyrryyyyyb..",
	"byyyyrrrryyyyb..",
	"byyyrryyrryyyb..",
	"byyrryyyyrryyb..",
	"bbrrbbbbbbrrbb..",
	".rr........rr...",
	"rr..........rr..",
	"................",
};	


static char *dir_opened[] = {
	"16 16 4 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"y c yellow m white g4 grey80",
	"g c grey70 m white g4 grey70",
	"................",
	"................",
	"................",
	"..bbbb..........",
	".bggggb.........",
	"bggggggbbbbbbb..",
	"bggggggggggggb..",
	"bgbbbbbbbbbbbbbb",
	"bgbyyyyyyyyyyybb",
	"bbyyyyyyyyyyyyb.",
	"bbyyyyyyyyyyybb.",
	"byyyyyyyyyyyyb..",
	"bbbbbbbbbbbbbb..",
	"................",
	"................",
	"................",
};	


static char *file_root[] = {
	"16 16 3 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"y c blue m white g4 grey70",
	"................",
	"................",
	"................",
	"...bb...........",
	"..byyb..........",
	".byyyyb.........",
	"bbbyybbb........",
	"..byyb..........",
	"..byyb..........",
	"..byyb...b....b.",
	"..byyb..byb..byb",
	"...bb....b....b.",
	"................",
	"................",
	"................",
	"................",
};	

static char *file_plain[] = {
	"16 16 3 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"g c white m white g4 white",
	"................",
	"................",
	"..bbbbbbbbbb....",
	"..bgggggggbgb...",
	"..bgggggggbggb..",
	"..bgggggggbbbbb..",
	"..bgggggggggggb.",
	"..bgggggggggggb.",
	"..bgggggggggggb.",
	"..bgggggggggggb.",
	"..bgggggggggggb.",
	"..bgggggggggggb.",
	"..bbbbbbbbbbbbb..",
	"................",
	"................",
	"................",
};



static char *file_exec[] = {
	"16 16 4 1",
	BACKGROUND,
	"b c black  m black g4 black",
	"g c lightblue m white g4 grey80",
	"w c white m white g4 white",
	"................",
	"................",
	"................",
	"..bbbbbbbbbbbb..",
	"..bggggggggggb..",
	"..bggggggggggb..",
	"..bbbbbbbbbbbb..",
	"..bwwwwwwwwwwb..",
	"..bwwwwwwwwwwb..",
	"..bwwwwwwwwwwb..",
	"..bwwwwwwwwwwb..",
	"..bwwwwwwwwwwb..",
	"..bbbbbbbbbbbb..",
	"................",
	"................",
	"................",
};	


static char *file_link[] = {
	"16 16 3 1",
	BACKGROUND,
	"b c black m black g4 black",
	"r c red   m white g4 grey70",
	"................",
	"................",
	"................",
	"..bbbbb.........",
	".brrrrrb........",
	".brrrrrrb...b...",
	"..bbbrrrb...bb..",
	".....brrrbbbbrb.",
	".....brrrrrrrrrb",
	"......brrrrrrrrb",
	".......bbbbbbrb.",
	"............bb..",
	"............b...",
	"................",
	"................",
	"................",
};	


static char *file_lock[] = {
	"16 16 3 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c red m white g4 grey50",
	"................",
	".............g..",
	".....gggggg.ggg.",
	"....gggggggggg..",
	"...gg.....ggg...",
	"..gg.....ggggg..",
	"..gg....ggg.gg..",
	"..gg...ggg..gg..",
	"..gg..ggg...gg..",
	"..gg.ggg....gg..",
	"..ggggg.....gg..",
	"...ggg.....gg...",
	"..gggggggggg....",
	".ggg.gggggg.....",
	"..g.............",
	"................",
};	


/*
 * Hier stehen die Daten fuer die verschiedenen Pictogramme
 */

static char *icon_move[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"................................",
	".bbbbbbbbbb.....................",
	".bggggggggbb....................",
	".bggggggggbgb...................",
	".bggggggggbbbb..................",
	".bgggggggggggb..................",
	".bggbbbbbbbggb..................",
	".bggbbbggggggb..................",
	".bggbbbbbggggb..................",
	".bggbbbggggggb..................",
	".bggbbbggggggb..................",
	".bggggggglllgb..................",
	".bbbbbbblllllb..................",
	".........lllll....l.............",
	"..........lllll..ll.............",
	"...........llllllll.............",
	"............lllllll.............",
	".............llllll.............",
	".............llllll.............",
	"............lllllllbbbbbbbbb....",
	"...........llllllllggggggggbb...",
	"..................bggggggggbgb..",
	"..................bggggggggbbbb.",
	"..................bgggggggggggb.",
	"..................bggbbbbbbbggb.",
	"..................bggggbbbggggb.",
	"..................bggggbbbggggb.",
	"..................bggggbbbggggb.",
	"..................bggggbbbggggb.",
	"..................bgggggggggggb.",
	"..................bbbbbbbbbbbbb.",
	"................................",
	"................................",
};	


static char *icon_copy[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"................................",
	"..................bbbbbbbbbb....",
	"..................bggggggggbb...",
	"..................bggggggggbgb..",
	"..................bggggggggbbbb.",
	"..................bgggggggggggb.",
	"..................bggggbbbbgggb.",
	"..............lllllllgbbggbbggb.",
	"...............llllllggggbbgggb.",
	"...............llllllgggbbggggb.",
	".bbbbbbbbbb...lllllllgbbbbbbggb.",
	".bggggggggbb.lllllbllgggggggggb.",
	".bggggggggbglllll.bblbbbbbbbbbb.",
	".bggggggggblllll................",
	".bgggggggggglll.................",
	".bgggggggggggl..................",
	".bgggggggggggl..................",
	".bgggggggggglll.................",
	".bggggggggglllll................",
	".bgggggggggglllll.bbbbbbbbbb....",
	".bggggggggggglllllbglggggggbb...",
	".bbbbbbbbbbbbblllllllggggggbgb..",
	"...............llllllggggggbbbb.",
	"................lllllgggggggggb.",
	"................lllllgggbbggggb.",
	"...............llllllgbbbbggggb.",
	"..................bgggggbbggggb.",
	"..................bgggggbbggggb.",
	"..................bgggbbbbbbggb.",
	"..................bgggggggggggb.",
	"..................bbbbbbbbbbbbb.",
	"................................",
	"................................",
};	



static char *icon_exec[] = {
	"32 32 5 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"s c steelblue m black g4 grey40",
	"................................",
	"..........bbbbbbbbbb............",
	"..........bggggggggbb...........",
	"..........bggggggggbgb..........",
	"..........bggggggggbbbb.........",
	"..........bgggggggggggb.........",
	"..........bgggggggggggb.........",
	"..........bgggggggggggb.........",
	"..........bggglllllgggb.........",
	"..........bggglllllgggb.........",
	"..........bggglllllgggb.........",
	"..........bbbblllllbbbb.........",
	"..............lllll.............",
	"............lllllllll...........",
	".............lllllll............",
	"..............lllll.............",
	"...............lll..............",
	"................l...............",
	"..............ssss..............",
	"..............ssss..............",
	"..............sss...............",
	"..............sssss.............",
	"............ssssssss..ss........",
	"...........ss.sssssssss.........",
	"..........ss..sssss.s...........",
	"...........ss.sssss.............",
	"............ssssssss............",
	"...........sssss.ssss...........",
	"........sssssss....sss..........",
	"........ssss........ss..........",
	"........s...........ss..........",
	"....................sss.........",
	"................................",
};	


static char *icon_delete[] = {
	"32 32 8 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"s c steelblue m black g4 grey40",
	"f c brown m black g4 grey40",
	"r c red m black g4 grey50",
	"y c yellow m white g4 grey90",
	"................................",
	"..........bbbbbbbbbb............",
	"..........bggggggggbb...........",
	"..........bggggggggbgb..........",
	"..........bggggggggbbbb.........",
	"..........bgggggggggggb.........",
	"..........bgggggggggggb.........",
	"..........bgggggggggggb.........",
	"..........bggglllllgggb.........",
	"..........bggglllllgggb.........",
	"..........bggglllllgggb.........",
	"..........bbbblllllbbbb.........",
	"..............lllll.............",
	"............lllllllll...........",
	".............lllllll............",
	"..............lllll.............",
	"...............lll..............",
	"................l...............",
	"................................",
	"...............r................",
	"..............ry................",
	".........r....ryr.r.............",
	".........r...ryyr.rr............",
	"........ryr..ryyyryyr...........",
	"........ryyrryyryrygyr..........",
	".......rygyryyrygyryyr..........",
	".......rygyryyrygyrygyr.........",
	".......rygyryyrygyrygyr.........",
	"........rygyryyyyryyyr..........",
	".....bbb.ryybbyybbbbbbbbb.......",
	"....bfffff.bffff.fffffffff......",
	"....bfffff.bffff.fffffffff......",
	"................................",
};	



static char *icon_warning[] = {
	"32 32 3 1",
	BACKGROUND,
	"b c black m black g4 black",
	"r c red m white g4 grey70",
	"................................",
	"............bbbbbbbbbb..........",
	"..........bbbrrrrrrrrbbb........",
	".........bbrrrrrrrrrrrrbb.......",
	".........brrrrrrrrrrrrrrb.......",
	".........brrrrrrrrrrrrrrb.......",
	".........bbrrrrrrrrrrrrbb.......",
	"..........brrrrrrrrrrrrb........",
	"..........bbrrrrrrrrrrbb........",
	"...........brrrrrrrrrrb.........",
	"...........brrrrrrrrrrb.........",
	"...........bbrrrrrrrrbb.........",
	"............brrrrrrrrb..........",
	"............brrrrrrrrb..........",
	"............bbrrrrrrbb..........",
	".............brrrrrrb...........",
	".............brrrrrrb...........",
	".............bbrrrrbb...........",
	"..............brrrrb............",
	"..............brrrrb............",
	"..............bbrrbb............",
	"...............bbbb.............",
	"................................",
	"...............bbbb.............",
	"..............brrrrb............",
	".............brrrrrrb...........",
	".............brrrrrrb...........",
	".............brrrrrrb...........",
	"..............brrrrb............",
	"...............bbbb.............",
	"................................",
	"................................",
};	


static char *icon_help[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"r c blue m white g4 grey60",	/* This has been previously forest green */
	"g c white m white g4 white",
	"................................",
	"................................",
	".........bbbbbbbbbbbbbb.........",
	".....bbbbrrrrrrrrrrrrrrbbbb.....",
	"....brrrrrrrrrrrrrrrrrrrrrrb....",
	"....brrrrrbbbbbbbbbbbbrrrrrb....",
	"...brrrrrb............brrrrrb...",
	".bbbrrrrbbbbbbbb.......brrrrb...",
	".bgbrrrrbgggggbgb......brrrrb...",
	".bggbbbbggggggbggb.....brrrrb...",
	".bggggggggggggbbbbb..bbrrrrb....",
	".bggggggggggggggggbbbrrrrrrb....",
	".bggggggggggggggbbrrrrrrbbb.....",
	".bggggggggggggbbrrrrrbbb........",
	".bggggggggggggbrrrrrb...........",
	".bgggggggggggbrrrrrb............",
	".bgggggggggggbrrrrb.............",
	".bgggggggggggbrrrrb.............",
	".bgggggggggggbrrrrb.............",
	".bbbbbbbbbbbbbrrrrb.............",
	"..............bbbb..............",
	"................................",
	"................................",
	"..............bbbb..............",
	".............brrrrb.............",
	"............brrrrrrb............",
	"............brrrrrrb............",
	"............brrrrrrb............",
	".............brrrrb.............",
	"..............bbbb..............",
	"................................",
	"................................",
};

static char *icon_filter[] = {
	"32 32 6 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"r c blue m white g4 grey60",
	"l c lightblue m black g4 grey95",
	"h c blue m black g4 grey20",
	"................................",
	"................................",
	"................................",
	"................................",
	"...................rr...........",
	"...................rr...........",
	"...................rr...........",
	"....bbbbbbbbbbbb..rr............",
	"....bgggggggggbgb.rr............",
	"....bgggggggggbggbrr............",
	"....bgggggggggbbbrr.............",
	"....bgggggglhggggrrb............",
	"....bggggggllhgggrrb............",
	"....bgggggglhlhgrrgb..lhhhh.....",
	"....bggggglhgglhrrgblhh...lhh...",
	"....bggggglhggggrrlhh.......lhh.",
	"...lhggggglhgggrrggb............",
	"...lhgggglhggggrrggb............",
	"..lhlhgglhgggggrrggb............",
	"..lhblhblhbbbbrrbbbb............",
	".lh...lhlh....rr................",
	".lh....lh.....rr................",
	".h...........rr.................",
	".h...........rr.................",
	".............rr.................",
	"............rr..................",
	"............rr..................",
	"............rr..................",
	"................................",
	"................................",
	"................................",
	"................................",
};	

static char *icon_info[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"r c yellow m white g4 grey80",
	"g c white m white g4 white",
	"................................",
	"................................",
	"...............bbbb.............",
	"..............brrrrb............",
	".............brrrrrrb...........",
	"..bbbbbbbbbb.brrrrrrb...........",
	"..bgggggggbgbbrrrrrrb...........",
	"..bgggggggbggbbrrrrb............",
	"..bgggggggbbbbbbbbb.............",
	"..bgggggggggggb.................",
	"..bgggggggggggb.................",
	"..bggggggggggbbbbbbbbb..........",
	"..bggggggggggbrrrrrrrb..........",
	"..bggggggggggbrrrrrrrb..........",
	"..bggggggggggbrrrrrrrb..........",
	"..bggggggggggbrrrrrrrb..........",
	"..bbbbbbbbbbbbrrrrrrrb..........",
	".............brrrrrrrb..........",
	".............brrrrrrrb..........",
	".............brrrrrrrb..........",
	".............brrrrrrrb..........",
	".............brrrrrrrb..........",
	".............brrrrrrrb..........",
	"............brrrrrrrrb..........",
	"............brrrrrrrrrb.........",
	"...........brrrrrrrrrrrbbb......",
	"..........brrrrrrrrrrrrrrrb.....",
	".......bbbrrrrrrrrrrrrrrrrb.....",
	"......brrrrrrrrrrrrrrrrrrrb.....",
	".......bbbbbbbbbbbbbbbbbbb......",
	"................................",
	"................................",
};	

static char *icon_hide[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c blue m white g4 grey50",
	"w c white m white g4 white",
	"................................",
	"................................",
	"..................g.............",
	".............g....g....g........",
	"..............g...g...g.........",
	"...............g..g..g..........",
	"................................",
	"............gggg..g..gggg.......",
	"................................",
	"................g...g...........",
	"...............g..g..g..........",
	"..............g...g...g.........",
	"..................g.............",
	"..................g.............",
	".........gggggg.................",
	".......ggwwwwwwgg...............",
	"......gwwwwwwwwwwg..............",
	".....gwwwwwwwwwwwwg.............",
	".....gwwwwwwwwwwwwg.............",
	"....gwwwwwwwwwwwwwwg............",
	"....gwwwwwwwwwwwwwwg............",
	"....gwwwwwgwwwwwwwwg............",
	"....gwwgwwggwwwwwwwg............",
	"....gwwggggwwwwwwwwg............",
	"....gwggwwwggwwwwwwg............",
	".....gwwgwgggwwwwwg.............",
	".....gwgggwwwgwwwwg.............",
	"......gwwwggwwwwwg..............",
	".......ggwwwwwwgg...............",
	".........gggggg.................",
	"................................",
	"................................",
};	


static char *icon_newdir[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"y c yellow m white g4 grey80",
	"l c blue m black g4 grey60",
	"................................",
	"................................",
	"................................",
	"..................b.............",
	"..................b......bb.....",
	"..................b.....byyb....",
	"..................b....bbbbbbbb.",
	"..................b....byyyyyyb.",
	"..................bbbb.byyyyyyb.",
	"...............l..b....byyyyyyb.",
	"...bb..........ll.b....bbbbbbbb.",
	"..byyb.....lllllllb.............",
	".bbbbbbbb..llllllll.............",
	".byyyyyyb..lllllllll............",
	".byyyyyyb..llllllll.............",
	".byyyyyyb..lllllllb.............",
	".bbbbbbbb......ll.b.............",
	"...............l..b.............",
	"..................b......bb.....",
	"..................b.....byyb....",
	"..................b....bbbbbbbb.",
	"..................b....byyyyyyb.",
	"..................bbbb.byyyyyyb.",
	".......................byyyyyyb.",
	".......................bbbbbbbb.",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
};	


static char *icon_wsedit[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	".....bbbbbbbbbbbbbbbbbbbbbbb....",
	".....bgggggggggggggggggggggb....",
	".....bgbbbbbbbgggggggggggggb....",
	".....bgblllllbgggbbbbbbbbggb....",
	".....bgblggglbgggggggggggggb....",
	".....bgblggllbgggbbbbbgggggb....",
	".....bgblglllbgggggggggggggb....",
	".....bgblllllbgggbbbbbbbgggb....",
	".....bgbbbbbbbgggggggggggggb....",
	".....bgggggggggggggggggggggb....",
	".....bgggggggggggggggggggggb....",
	".....bgggggggggggggggggggggb....",
	".....bggggggbbbbbbggbbbbbbgb....",
	".....bggggggbggggbggbggggbgb....",
	".....bggggggbbbbbbggbbbbbbgb....",
	".....bgggggggggggggggggggggb....",
	".....bbbbbbbbbbbbbbbbbbbbbbb....",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
};


static char *icon_wsdelete[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	".bbbbbbbbb.........bbbbbbbbbbbb.",
	".bggggggggb........bggggggggggb.",
	".bgbbbbbbbgb......bggggggggggb..",
	"..bgblllllbgb.....bbbbbbbbbggb..",
	"..bgblggglbgb.....bggggggggggb..",
	"..bgblggllbgb....bbbbbbgggggb...",
	"..bgblglllbggb...bgggggggggb....",
	"..bgblllllbggb...bbbbbbbgggb....",
	"..bgbbbbbbbgb...bggggggggggb....",
	"..bgggggggggb...bggggggggggb....",
	"...bgggggggggb..bggggggggggb....",
	"...bggggggggb..bggggggggggb.....",
	"...bggggggbbb.bbbggbbbbbbgb.....",
	"...bggggggbgb.bgbggbggggbgb.....",
	"...bggggggbbb.bbbggbbbbbbgb.....",
	"...bgggggggggbgggggggggggb......",
	"...bbbbbbbbbbbbbbbbbbbbbbb......",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
};



static char *icon_floppy3[] = {
	"32 32 4 1",
	BACKGROUND,
	"b c black m black g4 black",
	"g c white m white g4 white",
	"l c blue m black g4 grey60",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	".....llllggggggggggggggllll.....",
	".....l..lgggggggggggggglbbl.....",
	".....l..lgggggggggggggglbbl.....",
	".....llllggggggggggggggllll.....",
	".....llllggggggggggggggllll.....",
	".....llllggggggggggggggllll.....",
	".....llllllllllllllllllllll.....",
	".....llllllggggggggggllllll.....",
	".....llllllglllggggggllllll.....",
	".....llllllglllggggggllllll.....",
	".....llllllglllggggggllllll.....",
	"......lllllggggggggggllllll.....",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
	"................................",
};

#endif