/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "struct.h"
#include "config.h"
#include "filetypes.h"

/*
 * Globals
 */
extern	xfm_struct	defaults;
extern	Widget		toplevel;


Pixmap		pmaps[100];			/* Hier sind alle Pixmaps fuer die Files gespeichert */
int		pcount = 0;			/* Anzahl der Pixmaps die geladen ist */

Dimension	typelength = 10;		/* Laenge des Filetype.description strings */
Suffix_Glyph	*filetypes;			/* Die Filetypestrukturen */
Dimension	max_filetypes = 0;

/*
 * Function prototypes
 */
Boolean	readCustomSettings(void);
void	loadTypeIcons(void);

extern	void	FATAL_ERROR (char *message);
extern	Pixmap	ReadPixmapFromFile(char *filename, int *w, int *h);



/*********************************************************
 * name:	readCustomSettings
 * description:	Liest das Defaultfile fuer die Filetype
 *		zuordnungen. Falls es nicht existierte,
 *		so wird es erzeugt und der Returnvalue ist
 *		TRUE. Es wird dann ein Defaultsetting
 *		verwendet.
 * input:	none
 * output:	FALSE wenn das File schon existierte,
 *		sonnst TRUE, damit die Introsequenz
 *		abgespielt werden kann
 * author:	Ove Kalkan
 * date:	24.6.93
 *********************************************************/
Boolean	readCustomSettings(void)
{
	char	*home = getenv("HOME");
	char	filename[200];
	FILE	*fp;

	/*
	 * zunaechst den Filenamen generieren
	 */
	if (strcmp(home,"/"))
		sprintf(filename,"%s/.xfmrc",home);
	else
		sprintf(filename,"/.xfmrc");

	/*
	 * Versuchen, das File zu oeffnen
	 */
	if ((fp = fopen(filename,"r")) || (fp = fopen(DEFAULT_FILETYPES,"r"))) {
		char	s[1024];
		int	count = 0;

		/*
		 * Defaults aus dem File lesen
		 */
		s[1023] = '\0';
		while ((fgets(s,1023,fp))) {
			int	lcount = -1;

			if (s[0] != '!') {	/* Kommentar nicht parsen */
				char	*b;
				int	i;
				char	*a = s;
				/*
				 * Liste der Filetypen erweitern
				 */
				if (lcount != count) {
					if (!filetypes) {
						if (!(filetypes = (Suffix_Glyph *) malloc(sizeof(Suffix_Glyph)*1)))
							FATAL_ERROR ("readCustomSettings: Malloc failed");
					}
					else {
						if (!(filetypes = (Suffix_Glyph *) realloc((void *) filetypes,
										   sizeof(Suffix_Glyph)*(count+2))))
							FATAL_ERROR ("readCustomSettings: Reallocation failed");
					}
					lcount = count;
				}

				/*
				 * Commando lesen
				 */
				if (b = strchr(a,':')){		/* Auf Syntax achten */
					i = b - a;
					if (!(filetypes[count].cmd = (char *) malloc(i+1)))
						FATAL_ERROR("readCustomSettings: Malloc1 failed");
					strncpy(filetypes[count].cmd,a,i);
					filetypes[count].cmd[i] = '\0';
					a += (i + 1);

					/*
					 * Suffixes lesen
					 */
					if (b = strchr(a,':')){		/* Auf Syntax achten */
						i = b - a;
						if (!(filetypes[count].suffix = (char *) malloc(i+1)))
							FATAL_ERROR("readCustomSettings: Malloc1 failed");
						strncpy(filetypes[count].suffix,a,i);
						filetypes[count].suffix[i] = '\0';
						a += (i + 1);

						/*
						 * Iconfilenamen lesen
						 */
						if (b = strchr(a,':')){		/* Auf Syntax achten */
							i = b - a;
							if (!(filetypes[count].pmap_file = (char *) malloc(i+1)))
								FATAL_ERROR("readCustomSettings: Malloc1 failed");
							strncpy(filetypes[count].pmap_file,a,i);
							filetypes[count].pmap_file[i] = '\0';
							a += (i + 1);

							/*
							 * Iconfilenamen lesen
							 */
							i = strlen(a);
							if (!(filetypes[count].description = (char *) malloc(i + 1)))
								FATAL_ERROR("readCustomSettings: Malloc1 failed");
							strncpy(filetypes[count].description,a,i - 1);
							filetypes[count].description[i - 1] = '\0';
							filetypes[count].type = count;
							filetypes[count].pmap = NULL;
							typelength = 200;
							count++;
							max_filetypes++;
						}
					}
				}
			}
		}
		if (count)
			filetypes[count].cmd = NULL;
		else
			filetypes = default_filetypes;
		fclose(fp);
	}
	/*
	 * Defaults in das File schreiben
	 */
	else {
		int	i;

		filetypes = default_filetypes;
/*
		if (!(fp = fopen(filename,"w")))
			return(TRUE);
		for (i = 0; i < max_filetypes; i++) {
			fprintf(fp,"%s:%s:%s:%s\n",filetypes[i].cmd,
						   filetypes[i].suffix,
						   filetypes[i].pmap_file,
						   filetypes[i].description);
			max_filetypes++;
		}
		fclose(fp);
*/	}

}

/*********************************************************
 * name:	loadTypeIcons
 * description:	Die Icons fuer die Widgets laden
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	25.6.93
 *********************************************************/
void	loadTypeIcons(void)
{
	/*
	 * Die Settings sind geladen, nun die dazugehoerigen Icons laden
	 */
	String	filename[100];
	int	scount = 0;
	int	i;

	/*
	 * Alle Filetypes durchsuchen und dafuer Icons laden
	 */
	for (scount = 0; filetypes[scount].cmd; scount++) {
		i = 0;
		while (i < pcount && !filetypes[scount].pmap) {
			if (!(strcmp(filetypes[scount].pmap_file,filename[i])))
				filetypes[scount].pmap = &pmaps[i];
			i++;
		}
		if (!filetypes[scount].pmap && filetypes[scount].pmap_file) {
			/*
			 * Nach Pixmap suchen
			 */
			{ 	int	w,h;

				pmaps[pcount] = ReadPixmapFromFile(filetypes[scount].pmap_file,&w,&h);
			}
			if (pmaps[pcount]) {
				filename[pcount] = filetypes[scount].pmap_file;
				filetypes[scount].pmap = &pmaps[pcount];
				pcount++;
			}

		}
	}
}

