/****************************************************************************
 * This module is all original code 
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 * Copyright 1993, Robert Nation
 *     You may use this code for any purpose, as long as the original
 *     copyright remains in the source code and all documentation
 ****************************************************************************/

/***********************************************************************
 *
 * code for moving windows
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

extern XEvent Event;
extern int menuFromFrameOrWindowOrTitlebar;
/****************************************************************************
 *
 * Start a window move operation
 *
 ****************************************************************************/
#ifdef __STDC__
void move_window(XEvent *eventp,Window w,FvwmWindow *tmp_win,int context)
#else
void move_window(eventp, w, tmp_win, context)
XEvent *eventp;
Window w;
FvwmWindow *tmp_win;
int context;
#endif
{
  extern int Stashed_X, Stashed_Y;
  int origDragX,origDragY,DragX, DragY, DragWidth, DragHeight;
  int XOffset, YOffset,FinalX,FinalY;
  XEvent d;

  /* gotta have a window */
  if(w == None)
    return;

  InstallRootColormap();
  if (menuFromFrameOrWindowOrTitlebar) 
    {
      /* warp the pointer to the cursor position from before menu appeared*/
      XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, Stashed_X,Stashed_Y);
      XFlush(dpy);
    }


  DragX = eventp->xbutton.x_root;
  DragY = eventp->xbutton.y_root;
  /* If this is left commented out, then the move starts from the button press 
   * location instead of the current location, which seems to be an
   * improvement */
  /*  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
      &DragX, &DragY,	&JunkX, &JunkY, &JunkMask);*/

  if(!GrabEm(MOVE))
    {
      XBell(dpy,0);
      return;
    }
  XGrabServer(dpy);
  

  if(tmp_win->flags & ICON)
    w = tmp_win->icon_w;
  else if (w != tmp_win->icon_w)
    w = tmp_win->lead_w;
  
  XGetGeometry(dpy, w, &JunkRoot, &origDragX, &origDragY,
	       (unsigned int *)&DragWidth, (unsigned int *)&DragHeight, 
	       &JunkBW,  &JunkDepth);

  
  if (tmp_win->flags & ICON)
    {
      if(tmp_win->icon_pixmap_w != None)
	{
	  XGetGeometry(dpy, tmp_win->icon_pixmap_w, &JunkRoot, &origDragX, &origDragY,
		       (unsigned int *)&DragWidth, (unsigned int *)&DragHeight, 
		       &JunkBW,  &JunkDepth);
	  DragHeight += tmp_win->icon_w_height;
	}
    }

  DragWidth += JunkBW;
  DragHeight+= JunkBW;
  XOffset = origDragX - DragX;
  YOffset = origDragY - DragY;
  moveLoop(tmp_win, XOffset,YOffset,DragWidth,DragHeight, &FinalX,&FinalY);
  if (w == tmp_win->lead_w)
    SetupFrame (tmp_win, FinalX, FinalY,
		tmp_win->frame_width, tmp_win->frame_height,FALSE);
  else /* icon window */
    {
      tmp_win->icon_x_loc = FinalX ;
      tmp_win->icon_xl_loc = FinalX -
	(tmp_win->icon_w_width - tmp_win->icon_p_width)/2;
      tmp_win->icon_y_loc = FinalY; 
      XMoveWindow (dpy, w, tmp_win->icon_xl_loc, FinalY+tmp_win->icon_p_height);
      if(tmp_win->icon_pixmap_w != None)
	XMoveWindow (dpy, tmp_win->icon_pixmap_w, tmp_win->icon_x_loc,FinalY);
      
    }
  
  UninstallRootColormap();
  XUngrabServer(dpy);
  UngrabEm();
#ifndef NO_PAGER
  RedrawPager();
#endif
  return;
}



/****************************************************************************
 *
 * Move the rubberband around, return with the new window location
 *
 ****************************************************************************/
#ifdef __STDC__
void moveLoop(FvwmWindow *tmp_win, int XOffset, int YOffset, int Width,
	      int Height, int *FinalX, int *FinalY)
#else
void moveLoop(tmp_win, XOffset, YOffset, Width, Height, FinalX, FinalY)
FvwmWindow *tmp_win;
int XOffset, YOffset, Width, Height;
int *FinalX, *FinalY;
#endif
{
  Bool finished = False;
  Bool done;
  int xl,yt,delta_x,delta_y;

  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
		&JunkX, &JunkY, &JunkMask);
  xl += XOffset;
  yt += YOffset;
  MoveOutline(Scr.Root, xl, yt, Width,Height);
  while (!finished)
    {
      /* block until there is an interesting event */
      XMaskEvent(dpy, ButtonPressMask | ButtonReleaseMask | KeyPressMask |
		 PointerMotionMask | ButtonMotionMask, &Event);
      if (Event.type == MotionNotify) 
	/* discard any extra motion events before a logical release */
	while(XCheckMaskEvent(dpy, PointerMotionMask | ButtonMotionMask |
			      ButtonRelease, &Event))
	  if(Event.type == ButtonRelease) break;

      done = FALSE;
      /* Handle a limited number of key press events to allow mouseless
       * operation */
      if(Event.type == KeyPress)
	Keyboard_shortcuts(&Event,ButtonRelease);
      switch(Event.type)
	{
	case ButtonPress:
	case KeyPress:
	  /* throw away enter and leave events until release */
	  done = TRUE;
	  break;
	case ButtonRelease:
	  MoveOutline(Scr.Root, 0, 0, 0, 0);
	  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
			&JunkX, &JunkY, &JunkMask);
	  *FinalX = xl + XOffset;
	  *FinalY = yt + YOffset;
	  done = TRUE;
	  finished = TRUE;
	  break;

	case MotionNotify:
	  XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,&xl, &yt,
			&JunkX, &JunkY, &JunkMask);
#ifndef NON_VIRTUAL	  
	  /* need to move the viewport */
	  if((xl <2)||(xl >= Scr.MyDisplayWidth-2)||
	     (yt <2)||(yt >= Scr.MyDisplayHeight-2))
	    {
	      /* Turn off the rubberband */
	      MoveOutline(Scr.Root,0,0,0,0);
	      /* Move the viewport */
	      if(xl<2)
		delta_x = - Scr.MyDisplayWidth;
	      else if (xl >= Scr.MyDisplayWidth-2)
		delta_x = Scr.MyDisplayWidth;
	      else
		delta_x = 0;
	      if(yt<2)
		delta_y = - Scr.MyDisplayHeight;
	      else if (yt >= Scr.MyDisplayHeight-2)
		delta_y = Scr.MyDisplayHeight;
	      else
		delta_y = 0;
	      if(Scr.Vx + delta_x < 0)
		delta_x = -Scr.Vx;
	      if(Scr.Vy + delta_y < 0)
		delta_y = -Scr.Vy;
	      if(Scr.Vx + delta_x > Scr.VxMax)
		delta_x = Scr.VxMax - Scr.Vx;
	      if(Scr.Vy + delta_y > Scr.VyMax)
		delta_y = Scr.VyMax - Scr.Vy;
	      /* move the cursor back to the approximate correct location */
	      /* that is, the same place on the virtual desktop that it */
	      /* started at */
	      xl -= delta_x;
	      yt -= delta_y;
	      if(xl < 2)xl = 2;
	      if(yt < 2)yt = 2;
	      if(xl >= Scr.MyDisplayWidth-2)xl = Scr.MyDisplayWidth-3;
	      if(yt >= Scr.MyDisplayHeight-2)yt = Scr.MyDisplayHeight-3;

	      XWarpPointer(dpy,None,Scr.Root,0,0,0,0,xl,yt);
	      MoveViewport(Scr.Vx + delta_x,Scr.Vy + delta_y,False);
	      XSync(dpy,0);
	      XQueryPointer(dpy, Scr.Root, &JunkRoot, &JunkChild,
			    &xl, &yt,
			    &JunkX, &JunkY, &JunkMask);
	    }
#endif
	  /* redraw the rubberband */
	  xl += XOffset;
	  yt += YOffset;
	  MoveOutline(Scr.Root, xl, yt, Width,Height);

	  done = TRUE;
	  break;

	default:
	  break;
	}
      if(!done)
	{
	  MoveOutline(Scr.Root,0,0,0,0);
   	  DispatchEvent();
	  MoveOutline(Scr.Root, xl, yt, Width, Height);
	}
    }
}

/****************************************************************************
 *
 * For menus, move, and resize operations, we can effect keyboard 
 * shortcuts by warping the pointer.
 *
 ****************************************************************************/
#ifdef __STDC__
void Keyboard_shortcuts(XEvent *Event, int ReturnEvent)  
#else
void Keyboard_shortcuts(Event, ReturnEvent)  
XEvent *Event;
int ReturnEvent;
#endif
{
  int x,y,x_root,y_root;
  int move_size,x_move,y_move;
  KeySym keysym;

  /* Pick the size of the cursor movement */
  move_size = Scr.EntryHeight;
  if(Event->xkey.state & ControlMask)
    move_size = 1;
  if(Event->xkey.state & ShiftMask)
    move_size = 100;

  keysym = XLookupKeysym(&Event->xkey,0);

  x_move = 0;
  y_move = 0;
  switch(keysym)
    {
    case XK_Up:
    case XK_k:
    case XK_p:
      y_move = -move_size;
      break;
    case XK_Down:
    case XK_n:
    case XK_j:
      y_move = move_size;
      break;
    case XK_Left:
    case XK_b:
    case XK_h:
      x_move = -move_size;
      break;
    case XK_Right:
    case XK_f:
    case XK_l:
      x_move = move_size;
      break;
    case XK_Return:
      /* beat up the event */
      Event->type = ReturnEvent;
      break;
    default:
      break;
    }
  XQueryPointer( dpy, Scr.Root, &JunkRoot, &Event->xany.window,
		&x_root, &y_root, &x, &y, &JunkMask);

  if((x_move != 0)||(y_move != 0))
    {
      /* beat up the event */
      XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, x_root+x_move,
		   y_root+y_move);

      /* beat up the event */
      Event->type = MotionNotify;
      Event->xkey.x += x_move;
      Event->xkey.y += y_move;
    }
}

