/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified 
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 ****************************************************************************/
/*****************************************************************************/
/**       Copyright 1988 by Evans & Sutherland Computer Corporation,        **/
/**                          Salt Lake City, Utah                           **/
/**  Portions Copyright 1989 by the Massachusetts Institute of Technology   **/
/**                        Cambridge, Massachusetts                         **/
/**                                                                         **/
/**                           All Rights Reserved                           **/
/**                                                                         **/
/**    Permission to use, copy, modify, and distribute this software and    **/
/**    its documentation  for  any  purpose  and  without  fee is hereby    **/
/**    granted, provided that the above copyright notice appear  in  all    **/
/**    copies and that both  that  copyright  notice  and  this  permis-    **/
/**    sion  notice appear in supporting  documentation,  and  that  the    **/
/**    names of Evans & Sutherland and M.I.T. not be used in advertising    **/
/**    in publicity pertaining to distribution of the  software  without    **/
/**    specific, written prior permission.                                  **/
/**                                                                         **/
/**    EVANS & SUTHERLAND AND M.I.T. DISCLAIM ALL WARRANTIES WITH REGARD    **/
/**    TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-    **/
/**    ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR    **/
/**    M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-    **/
/**    AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA    **/
/**    OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER    **/
/**    TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE    **/
/**    OR PERFORMANCE OF THIS SOFTWARE.                                     **/
/*****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

extern XEvent Event;
extern int menuFromFrameOrWindowOrTitlebar;

extern FvwmWindow *Tmp_win;
int resize_on=0, move_on=0;

#ifndef NO_PAGER
extern Window Pager_w;
#endif

void FocusOn(FvwmWindow *t);
extern char **g_argv;
void executeFunction(Window w, FvwmWindow *tmp_win, XEvent *eventp, int context,
		     MenuRoot *menu);
/***********************************************************************
 *
 *  Procedure:
 *	ExecuteFunction - execute a fvwm built in function
 *
 *  Inputs:
 *	func	- the function to execute
 *	action	- the menu action to execute 
 *	w	- the window to execute this function on
 *	tmp_win	- the fvwm window structure
 *	event	- the event that caused the function
 *	context - the context in which the button was pressed
 *      val1,val2 - the distances to move in a scroll operation 
 *
 ***********************************************************************/
void ExecuteFunction(int func,char *action, Window w, FvwmWindow *tmp_win, 
		     XEvent *eventp, int context,int val1, int val2,
		     MenuRoot *menu)
{
  FvwmWindow *t;
  Bool found;
  char *junk;
  int x,y,delta_x,delta_y,warp_x,warp_y;
  
  switch (func)
    {
    case F_NOP:
    case F_TITLE:
      break;
      
    case F_BEEP:
      XBell(dpy, 0);
      break;
      
    case F_RESIZE:
      if (DeferExecution(eventp,&w,&tmp_win,&context, MOVE, ButtonPress))
	break;

      tmp_win->flags &= ~MAXIMIZED;
      resize_on = 1;
      resize_window(eventp,w,tmp_win);
      resize_on = 0;
      break;
      
    case F_MOVE:
      if (DeferExecution(eventp,&w,&tmp_win,&context, MOVE,ButtonPress))
	break;
      move_on = 1;
      move_window(eventp,w,tmp_win,context);
      move_on = 0;
      break;

#ifndef NON_VIRTUAL      
    case F_SCROLL:
      if((val1 > -100000)&&(val1 < 100000))
	x=Scr.Vx + val1*Scr.MyDisplayWidth/100;
      else
	x = Scr.Vx + (val1/1000)*Scr.MyDisplayWidth/100;
	  
      if((val2 > -100000)&&(val2 < 100000))
	y=Scr.Vy + val2*Scr.MyDisplayHeight/100;
      else
	y = Scr.Vy + (val2/1000)*Scr.MyDisplayHeight/100;
      
      if(((val1 <= -100000)||(val1 >= 100000))&&(x>Scr.VxMax))
	{
	  x = 0;
	  y += Scr.MyDisplayHeight;
	  if(y > Scr.VxMax)
	    y=0;
	}
      if(((val1 <= -100000)||(val1 >= 100000))&&(x<0))
	{
	  x = Scr.VxMax;
	  y -= Scr.MyDisplayHeight;
	  if(y < 0)
	    y=Scr.VyMax;
	}
      if(((val2 <= -100000)||(val2>= 100000))&&(x>Scr.VyMax))
	{
	  y = 0;
	  x += Scr.MyDisplayWidth;
	  if(x > Scr.VxMax)
	    x=0;
	}
      if(((val2 <= -100000)||(val2>= 100000))&&(y<0))
	{
	  y = Scr.VyMax;
	  x -= Scr.MyDisplayWidth;
	  if(x < 0)
	    x=Scr.VxMax;
	}
      MoveViewport(x,y,True);
      break;
#endif
    case F_MOVECURSOR:
      XQueryPointer( dpy, Scr.Root, &JunkRoot, &JunkChild,
		    &x,&y,&JunkX, &JunkY, &JunkMask);
#ifndef NON_VIRTUAL
      delta_x = 0;
      delta_y = 0;
      warp_x = 0;
      warp_y = 0;
      if(x >= Scr.MyDisplayWidth -2)
	{
	  delta_x = Scr.EdgeScrollX;
	  warp_x = Scr.EdgeScrollX - 4;
	}
      if(y>= Scr.MyDisplayHeight -2)
	{
	  delta_y = Scr.EdgeScrollY;
	  warp_y = Scr.EdgeScrollY - 4;      
	}
      if(x < 2)
	{
	  delta_x = -Scr.EdgeScrollX;
	  warp_x =  -Scr.EdgeScrollX + 4;
	}
      if(y < 2)
	{
	  delta_y = -Scr.EdgeScrollY;
	  warp_y =  -Scr.EdgeScrollY + 4;
	}
      if(Scr.Vx + delta_x < 0)
	delta_x = -Scr.Vx;
      if(Scr.Vy + delta_y < 0)
	delta_y = -Scr.Vy;
      if(Scr.Vx + delta_x > Scr.VxMax)
	delta_x = Scr.VxMax - Scr.Vx;
      if(Scr.Vy + delta_y > Scr.VyMax)
	delta_y = Scr.VyMax - Scr.Vy;
      if((delta_x!=0)||(delta_y!=0))
	{
	  MoveViewport(Scr.Vx + delta_x,Scr.Vy+delta_y,True);
	  XWarpPointer(dpy, Scr.Root, Scr.Root, 0, 0, Scr.MyDisplayWidth, 
		       Scr.MyDisplayHeight, 
		       x - warp_x,
		       y - warp_y);
	}
#endif
      XWarpPointer(dpy, Scr.Root, Scr.Root, 0, 0, Scr.MyDisplayWidth, 
		   Scr.MyDisplayHeight, x + val1*Scr.MyDisplayWidth/100-warp_x,
		   y+val2*Scr.MyDisplayHeight/100 - warp_y);
      
      break;
    case F_ICONIFY:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT, ButtonRelease))
	break;
      if (tmp_win->flags & ICON)
	DeIconify(tmp_win);
      else
	Iconify(tmp_win, eventp->xbutton.x_root-5,eventp->xbutton.y_root-5);
      break;
      
    case F_RAISE:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT,ButtonRelease))
	break;
      
      RaiseWindow(tmp_win);

      if (LookInList(Scr.OnTop,tmp_win->name, &tmp_win->class, &junk))
	tmp_win->flags |= ONTOP;
      KeepOnTop();
      break;
      
    case F_LOWER:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT, ButtonRelease))
	break;
      
      LowerWindow(tmp_win);

      tmp_win->flags &= ~ONTOP;
      break;
      
    case F_DESTROY:
      if (DeferExecution(eventp,&w,&tmp_win,&context, DESTROY, ButtonRelease))
	break;

#ifndef NO_PAGER
      /* Dont delete the pager - it crashes the program! */
      if(tmp_win->w == Pager_w)      
	break;
#endif

      if (XGetGeometry(dpy, tmp_win->w, &JunkRoot, &JunkX, &JunkY,
		       &JunkWidth, &JunkHeight, &JunkBW, &JunkDepth) == 0)
	Destroy(tmp_win);
      else
	XKillClient(dpy, tmp_win->w);
      XSync(dpy,0);
      break;
      
    case F_DELETE:
      if (DeferExecution(eventp,&w,&tmp_win,&context, DESTROY,ButtonRelease))
	break;

#ifndef NO_PAGER
      /* Dont delete the pager - it crashes the program! */
      if(tmp_win->w == Pager_w)      
	break;
#endif
      if (tmp_win->protocols & DoesWmDeleteWindow)
	send_clientmessage (tmp_win->w, _XA_WM_DELETE_WINDOW, CurrentTime);
      else
	XBell (dpy, 0);
      XSync(dpy,0);
      break;
      
    case F_RESTART:
      Done(1, action);
      fprintf(stderr,"Fvwm: Restart of %s failed\n",action);
      XBell(dpy,0);
      XSync(dpy,0);
      sleep_a_little(1000000);
      /* Backup plan - do a conventional restart */
      execvp(g_argv[0],g_argv);      
      XBell(dpy,0);
      break;

    case F_EXEC:
      XGrabPointer(dpy, Scr.Root, True,
		   ButtonPressMask | ButtonReleaseMask,
		   GrabModeAsync, GrabModeAsync,
		   Scr.Root, Scr.FvwmCursors[WAIT], CurrentTime);
      XSync (dpy, 0);
      system(action);
      XUngrabPointer(dpy,CurrentTime);
      break;
      
    case F_REFRESH:
      {
	XSetWindowAttributes attributes;
	unsigned long valuemask;
	
	valuemask = (CWBackPixel);
	attributes.background_pixel = Scr.StdColors.fore;
	attributes.backing_store = NotUseful;
	w = XCreateWindow (dpy, Scr.Root, 0, 0,
			   (unsigned int) Scr.MyDisplayWidth,
			   (unsigned int) Scr.MyDisplayHeight,
			   (unsigned int) 0,
			   CopyFromParent, (unsigned int) CopyFromParent,
			   (Visual *) CopyFromParent, valuemask,
			   &attributes);
	XMapWindow (dpy, w);
	XDestroyWindow (dpy, w);
	XFlush (dpy);
      }
      break;

    case F_STICK:
      /* stick/unstick a window */
      if (DeferExecution(eventp,&w,&tmp_win,&context,SELECT,ButtonRelease))
	break;
      if(tmp_win->flags & STICKY)
	tmp_win->flags &= ~STICKY;
      else
	tmp_win->flags |=STICKY;
      RedrawPager();
      break;

#ifndef NON_VIRTUAL
    case F_GOTO_PAGE:
      /* back up 1 virtual desktop page */
      x=val1*Scr.MyDisplayWidth;
      y=val2*Scr.MyDisplayHeight;
      MoveViewport(x,y,True);
      break;
#endif

    case F_CIRCULATE_UP:
      /* move focus to the previous window */
      found = FALSE;
      t = Scr.Focus;
      while(!found)
	{
	  if ((t == (FvwmWindow *)0)||(t == &Scr.FvwmRoot)||
	      (t->prev == &Scr.FvwmRoot)||(t->prev == (FvwmWindow *)NULL))
	    for(t=Scr.FvwmRoot.next;t->next != (FvwmWindow *)NULL;t=t->next);
	  else
	    t=t->prev;
	  found = TRUE;
	  if (LookInList(Scr.CirculateSkip,t->name, &t->class,&junk))
	    found = FALSE;
	  if (LookInList(Scr.CirculateSkip,t->icon_name, &t->class,&junk))
	    found = FALSE;
	}
      FocusOn(t);
	  
      break;

    case F_CIRCULATE_DOWN:
      /* move focus to the next window */
      found = FALSE;
      t  = Scr.Focus;
      while(!found)
	{
	  if((t == (FvwmWindow *)0)||(t->next == NULL))
	    t = Scr.FvwmRoot.next;
	  else
	    t =t->next;
	  found = TRUE;
	  if (LookInList(Scr.CirculateSkip,t->name, &t->class,&junk))
	    found = FALSE;
	  if (LookInList(Scr.CirculateSkip,t->icon_name, &t->class,&junk))
	    found = FALSE;
	}
      FocusOn(t);
	  
      break;

    case F_RAISELOWER:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT,ButtonRelease))
	break;

      if((tmp_win == Scr.LastWindowRaised)||
	 (tmp_win->flags & VISIBLE))
	{
	  LowerWindow(tmp_win);
	  tmp_win->flags &= ~ONTOP;
	}
      else
	{
	  RaiseWindow(tmp_win);
	  if (LookInList(Scr.OnTop,tmp_win->name, &tmp_win->class,&junk))
	    tmp_win->flags |= ONTOP;	    
	    KeepOnTop();

	}
      break;

    case F_POPUP:
      ActiveItem = NULL;
      ActiveMenu = NULL;
      menuFromFrameOrWindowOrTitlebar = FALSE;
      do_menu(menu);
      break;

     case F_MAXIMIZE:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT,ButtonRelease))
	break;
      Maximize(tmp_win,val1,val2);
      break; 

    case F_QUIT:
      Done(0);
      break;

    case F_WINDOWLIST:
      do_windowList();
      break;

    case F_RAISE_IT:
      RaiseThisWindow(val1);
      break;

    case F_FUNCTION:
      if (DeferExecution(eventp,&w,&tmp_win,&context, SELECT,ButtonPress))
	break;
      executeFunction(w, tmp_win, eventp, context,menu);

    }

  WaitForButtonsUp();

  return;
}


/***********************************************************************
 *
 *  Procedure:
 *	DeferExecution - defer the execution of a function to the
 *	    next button press if the context is C_ROOT
 *
 *  Inputs:
 *      eventp  - pointer to XEvent to patch up
 *      w       - pointer to Window to patch up
 *      tmp_win - pointer to FvwmWindow Structure to patch up
 *	context	- the context in which the mouse button was pressed
 *	func	- the function to defer
 *	cursor	- the cursor to display while waiting
 *      finishEvent - ButtonRelease or ButtonPress; tells what kind of event to
 *                    terminate on.
 *
 ***********************************************************************/
int DeferExecution(XEvent *eventp, Window *w,FvwmWindow **tmp_win,
		   int *context, int cursor, int FinishEvent)

{
  int done;
  int finished = 0;

  if(*context != C_ROOT)
    {
      if((FinishEvent == ButtonPress)||((FinishEvent == ButtonRelease) &&
					(eventp->type != ButtonPress)))
	return FALSE;
    }
  if(!GrabEm(cursor))
    {
      XBell(dpy,0);
      return False;
    }
  
  while (!finished)
    {
      done = 0;
      /* block until there is an event */
      XMaskEvent(dpy,
		 ButtonPressMask | ButtonReleaseMask |
		 ExposureMask |KeyPressMask |
		 VisibilityChangeMask |
		 ButtonMotionMask, eventp);
      if(eventp->type == KeyPress)
	Keyboard_shortcuts(eventp,FinishEvent);	
      if(eventp->type == FinishEvent)
	finished = 1;
      if(eventp->type == ButtonPress)
	done = 1;
      if(eventp->type == ButtonRelease)
	done = 1;
      if(eventp->type == EnterNotify)
	done = 1;
      if(eventp->type == LeaveNotify)
	done = 1;
      if(!done)DispatchEvent();
      
    }

  *w = eventp->xany.window;
  if(((*w == Scr.Root)||(*w == Scr.NoFocusWin))
      && (eventp->xbutton.subwindow != (Window)0))
    {
      *w = eventp->xbutton.subwindow;
    }
  if (*w == Scr.Root)
    {
      *context = C_ROOT;
      XBell(dpy,0);
      UngrabEm();
      return TRUE;
    }
  if (XFindContext (dpy, *w, FvwmContext, (caddr_t *)tmp_win) == XCNOENT)
    {
      *tmp_win = NULL;
      XBell(dpy,0);
      UngrabEm();

      return (TRUE);
    }
  *context = GetContext(tmp_win,eventp);

  UngrabEm();
  return FALSE;
}


/***********************************************************************
 *
 *  Procedure:
 *	DeIconify a window
 *
 ***********************************************************************/
void DeIconify(FvwmWindow *tmp_win)
{
  FvwmWindow *t;
  
  /* now de-iconify transients */
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if ((t == tmp_win)|| 
	  ((t->flags & TRANSIENT) &&(t->transientfor == tmp_win->w)))
	{
	  t->flags |= MAPPED;
	  if(Scr.Focus == t)
	    SetBorder (t, False,True,True);
	  if((t->flags & TITLE)||(t->flags & BORDER))
	    XMapWindow(dpy, t->w);
	  RaiseWindow(t);
	  XMapWindow(dpy, t->lead_w);
	  SetMapStateProp(t, NormalState);
	  
	  if (t->icon_w) 
	    XUnmapWindow(dpy, t->icon_w);
	  if (t->icon_pixmap_w) 
	    XUnmapWindow(dpy, t->icon_pixmap_w);
	  t->flags &= ~ICON;
	}
    }
  if (Scr.ClickToFocus) FocusOn(tmp_win);
  KeepOnTop();

#ifndef NO_PAGER
  RedrawPager();
#endif

  XSync (dpy, 0);
  return;
}


/****************************************************************************
 *
 * Iconifies the selected window
 *
 ****************************************************************************/
void Iconify(FvwmWindow *tmp_win, int def_x, int def_y)
{
  FvwmWindow *t;
  XWindowAttributes winattrs;
  unsigned long eventMask;
  
  XGetWindowAttributes(dpy, tmp_win->w, &winattrs);
  eventMask = winattrs.your_event_mask;
  
  /* iconify transients first */
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if ((t==tmp_win)||
	  ((t->flags & TRANSIENT) && (t->transientfor == tmp_win->w)))
	{
	  /*
	   * Prevent the receipt of an UnmapNotify, since that would
	   * cause a transition to the Withdrawn state.
	   */
	  t->flags &= ~MAPPED;
	  XSelectInput(dpy, t->w, eventMask & ~StructureNotifyMask);
	  XUnmapWindow(dpy, t->w);
	  XSelectInput(dpy, t->w, eventMask);
	  if((t->flags & TITLE)||(t->flags & BORDER))
	    XUnmapWindow(dpy, t->frame);
	  if (t->icon_w)
	    XUnmapWindow(dpy, t->icon_w);
	  SetMapStateProp(t, IconicState);
	  SetBorder (t, False,False,False);
	  t->flags |= ICON;
	}
    } 
  if (tmp_win->icon_w == (int)NULL)
    CreateIconWindow(tmp_win, def_x, def_y);
  RaiseWindow(tmp_win);
  XMapWindow(dpy, tmp_win->icon_w);
  if(tmp_win->icon_pixmap_w != None)
    XMapWindow(dpy, tmp_win->icon_pixmap_w);

#ifndef NO_PAGER
  RedrawPager();
#endif

  KeepOnTop();
  XSync (dpy, 0);
  return;
}


/****************************************************************************
 *
 *  ??????????????????????Got this from twm?????????????????????????
 *
 ****************************************************************************/
void SetMapStateProp(FvwmWindow *tmp_win, int state)
{
  unsigned long data[2];		/* "suggested" by ICCCM version 1 */
  
  data[0] = (unsigned long) state;
  data[1] = (unsigned long) tmp_win->icon_w;
  
  XChangeProperty (dpy, tmp_win->w, _XA_WM_STATE, _XA_WM_STATE, 32, 
		   PropModeReplace, (unsigned char *) data, 2);
  return;
}


/****************************************************************************
 *
 * Keeps the "StaysOnTop" windows on the top of the pile.
 * This is achieved by clearing a flag for OnTop windows here, and waiting
 * for a visibility notify on the windows. Eception: OnTop windows which are
 * obscured by other OnTop windows, which need to be raised here.
 *
 ****************************************************************************/
void KeepOnTop()
{
  FvwmWindow *t;

  /* flag that on-top windows should be re-raised */
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if((t->flags & ONTOP)&&!(t->flags & VISIBLE))
	{
	  RaiseWindow(t);
	  t->flags &= ~RAISED;
	}
      else
	t->flags |= RAISED;
    }
}


/***************************************************************************
 *
 *  Moves the viewport within thwe virtual desktop
 *
 ***************************************************************************/
#ifndef NON_VIRTUAL
void MoveViewport(int newx, int newy, Bool grab)
{
  FvwmWindow *t;
  int deltax,deltay;

  if(grab)
    {
      XGrabServer(dpy);
    }


  if(newx > Scr.VxMax)
    newx = Scr.VxMax;
  if(newy > Scr.VyMax)
    newy = Scr.VyMax;
  if(newx <0)
    newx = 0;
  if(newy <0)
    newy = 0;

  deltay = Scr.Vy - newy;
  deltax = Scr.Vx - newx;
  ShowCurrentPort();

  Scr.Vx = newx;
  Scr.Vy = newy;
  if((deltax!=0)||(deltay!=0))
    {
      for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
	{
	  if(!(t->flags & STICKY))
	    {
	      if(t->icon_w)
		{
		  t->icon_x_loc += deltax;
		  t->icon_y_loc += deltay;
		  if(t->icon_pixmap_w != None)
		    XMoveWindow(dpy,t->icon_pixmap_w,t->icon_x_loc,
				t->icon_y_loc);
		  XMoveWindow(dpy,t->icon_w,t->icon_x_loc,
			      t->icon_y_loc+t->icon_p_height);

		  
		}
	      SetupFrame (t, t->frame_x+ deltax, t->frame_y + deltay,
			  t->frame_width, t->frame_height,FALSE);
	    }
	}
    }
  ShowCurrentPort();
  while(XCheckTypedEvent(dpy,MotionNotify,&Event));
  if(grab)
    {
      XUngrabServer(dpy);
    }
}
#endif


/**************************************************************************
 *
 * Moves focus to specified window 
 *
 *************************************************************************/
void FocusOn(FvwmWindow *t)
{
  int dx,dy;
  int cx,cy,x,y;
  
  if(t == (FvwmWindow *)0)
    return;

#ifndef NON_VIRTUAL
  if(t->flags & ICON)
    {
      cx = t->icon_x_loc + t->icon_w_width/2;
      cy = t->icon_y_loc + ICON_HEIGHT/2;
    }
  else
    {
      cx = t->frame_x + t->frame_width/2;
      cy = t->frame_y + t->frame_height/2;
    }
  /* Put center of window on the visible screen */
  if(Scr.CenterOnCirculate)
    {
      dx = cx - Scr.MyDisplayWidth/2 + Scr.Vx;
      dy = cy - Scr.MyDisplayHeight/2 + Scr.Vy;
    }
  else
    {
      dx = (cx + Scr.Vx)/Scr.MyDisplayWidth*Scr.MyDisplayWidth;
      dy = (cy +Scr.Vy)/Scr.MyDisplayHeight*Scr.MyDisplayHeight;
    }
  MoveViewport(dx,dy,True);
#endif

  if(t->flags & ICON)
    {
      x =  t->icon_x_loc;
      y = t->icon_y_loc;
    }
  else
    {
      x = t->frame_x;
      y = t->frame_y;
    }
  if(!Scr.ClickToFocus)
    XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, x+2,y+2);
  RaiseWindow(t);
  SetBorder(t,True,False,True);
}


   
/***********************************************************************
 *
 *  Procedure:
 *	(Un)Maximize a window.
 *
 ***********************************************************************/
void Maximize(FvwmWindow *tmp_win,int val1,int val2)
{
  int new_width, new_height,new_x,new_y;

  if (tmp_win->flags & MAXIMIZED)
    {
      
      tmp_win->flags &= ~MAXIMIZED;
      SetupFrame(tmp_win,
		 tmp_win->orig_x,
		 tmp_win->orig_y,
		 tmp_win->orig_wd,
		 tmp_win->orig_ht,TRUE);
    }
  else
    {
      new_width = tmp_win->frame_width;      
      new_height = tmp_win->frame_height;
      new_x = tmp_win->frame_x;
      new_y = tmp_win->frame_y;
      if(val1 >0)
	{
	  new_width = val1*Scr.MyDisplayWidth/100;
	  new_x = 0;
	}
      if(val2 >0)
	{
	  new_height = val2*Scr.MyDisplayHeight/100;
	  new_y = 0;
	}
      if((val1==0)&&(val2==0))
	{
	  new_x = 0;
	  new_y = 0;
	  new_height = Scr.MyDisplayHeight;
	  new_width = Scr.MyDisplayWidth;
	}
			      

      tmp_win->flags |= MAXIMIZED;
      ConstrainSize (tmp_win, &new_width, &new_height);
      SetupFrame(tmp_win,new_x,new_y,new_width,new_height,TRUE);
    }
#ifndef NO_PAGER  
  RedrawPager();
#endif
}

/*****************************************************************************
 *
 * Grab the pointer and keyboard
 *
 ****************************************************************************/
Bool GrabEm(int cursor)
{
  int i=0,val;
  /* move the keyboard focus prior to grabbing the pointer to
   * eliminate the enterNotify and exitNotify events that go
   * to the windows */
  XSetInputFocus(dpy,Scr.NoFocusWin,RevertToParent,CurrentTime);
  while((i<1000)&&(val=XGrabPointer(dpy, Scr.Root, False,ButtonPressMask | 
			       ButtonReleaseMask | ButtonMotionMask |
			       PointerMotionMask|PointerMotionHintMask,
			       GrabModeAsync, GrabModeAsync, Scr.Root,
			       Scr.FvwmCursors[cursor], CurrentTime)!=
		  GrabSuccess))
    {
      i++;
      /* If you go too fast, other windows may not get a change to release
       * any grab that they have. */
      sleep_a_little(1000);
    }
  /* If we fall out of the loop without grabbing the pointer, its
     time to give up */
  if(val!=GrabSuccess)
    return False;

  return True;
}


/*****************************************************************************
 *
 * UnGrab the pointer and keyboard
 *
 ****************************************************************************/
void UngrabEm()
{
  XUngrabPointer(dpy,CurrentTime);
  if(Scr.Focus != NULL)
    {
      if(Scr.Focus->flags & ICON)
	XSetInputFocus (dpy, Scr.Focus->icon_w,RevertToParent, CurrentTime);
      else
	XSetInputFocus (dpy, Scr.Focus->w,RevertToParent, CurrentTime);
    }
}

/*****************************************************************************
 *
 * Builtin which determines if the button press was a click or double click...
 *
 ****************************************************************************/
void executeFunction(Window w, FvwmWindow *tmp_win, XEvent *eventp,int context,
		     MenuRoot *mr)
{
  char type = MOTION;
  XEvent d, *ev;
  char c;
  MenuItem *mi;
  
  if(mr == NULL)
    return;

  /* A window has already been selected */
  ev = eventp;

  /* Wait and see if we have a click, or a move */
  /* wait 100 msec, see if the used releases the button */
  sleep_a_little(Scr.ClickTime*1000);
  if(XCheckMaskEvent (dpy,ButtonReleaseMask, &d))
    {
      type = CLICK;
      ev = &d;
    }

  /* If it was a click, wait to see if its a double click */
  if(type == CLICK)
    {
      sleep_a_little(Scr.ClickTime*1000);
      if(XCheckMaskEvent (dpy,ButtonPressMask, &d))
	{
	  type = ONE_AND_A_HALF_CLICKS;
	  ev = &d;
	}
      if(type == ONE_AND_A_HALF_CLICKS)
	{
	  sleep_a_little(Scr.ClickTime*1000);
	  if(XCheckMaskEvent (dpy,ButtonReleaseMask, &d))
	    {
	      type = DOUBLE_CLICK;      
	      ev = &d;
	    }
	}
    }

  /* For clicks we expect the finish window to be the same as start window */
  if((d.xany.window != eventp->xany.window) &&
     ((type == CLICK)||(type==DOUBLE_CLICK)||(type==ONE_AND_A_HALF_CLICKS)))
    {
      XBell(dpy,0);
      return;
    }

  /* need to free the window list ? */
  mi = mr->first;
  while(mi != NULL)
    {
      /* make lower case */
      c = *(mi->item);
      if(isupper(c))
	c=tolower(c);
      if(c == type)
	ExecuteFunction(mi->func, mi->action,tmp_win->lead_w,
			tmp_win, ev, context,mi->val1,mi->val2,mi->menu);
      mi = mi->next;
    }

}


/* For Ultrix 4.2 */
#include <sys/types.h>

#include <sys/time.h>

/**************************************************************************
 * 
 * Sleep for n microseconds
 *
 *************************************************************************/
void sleep_a_little(int n)
{
        struct timeval value;

        if (n <= 0)
                return;

        value.tv_usec = n % 1000000;
        value.tv_sec = n / 1000000;

#ifdef COHERENT
        (void) soselect(1, 0, 0, 0, &value);
#else
        (void) select(1, 0, 0, 0, &value);
#endif
}
