.TH xv l
.SH NAME
\fBxv\fP \- displays and manipulates images on X11 displays
.SH SYNTAX
\fBxv\fP \fI[options] [filename [filename...]]\fP
.SH DESCRIPTION
\fIxv\fP is an X11 program that displays images in the GIF, PBM, PGM, PPM, 
X11 bitmap, and PM formats on 1-, 4-, 6-, 8-, 24-, and 32-bit X displays.  
.SH OVERVIEW
\fIxv\fP displays one image at a time in an output window.  You can arbitrarily
stretch or compress the window, and the picture will be rescaled to fit.  
You can rotate the picture in 90-degree steps.  You can repeatedly 'crop'
a picture (define a rectangular 'region-of-interest' and 'throw away' the
rest).  You can magnify any portion of the picture by 
any amount, up to the maximum size of your screen.  
.PP
\fIxv\fP allows you click on the picture to determine pixel RGB values and
x,y coordinates.  You can perform arbitrary 'gamma correction' on the picture
both in RGB space and HSV space.  You can specify the maximum number of colors
that \fIxv\fP should use, for some interesting visual effects.  You can have
the program produce a stippled version of the picture using black and white,
or any other pair of colors.  
.PP
\fIxv\fP can write images in a variety of formats, with many of the 
modifications you may have made to the picture saved as well.  You can use
\fIxv\fP to do format conversion.  \fIxv\fP will also automatically 
uncompress \fBcompress\fP\-ed files, as well as read files from stdin.
.PP
It slices, it dices, and it'll balance your checkbook if you aren't careful.
.SH "USING THE PROGRAM"
Start the program up by typing '\fIxv\fP \fIfilename\fP' After a short 
delay, a window 
will appear with the desired image displayed in it.  If you change the size 
of the window, (however your particular window manager lets you do this), the 
picture will rescale to fit the window.
.PP
Clicking (and dragging) the Left mouse button inside the image window will
display pixel information.  The first two numbers are the x and y offset,
in pixels, from the top-left corner of the image.  The first group of three
numbers are the red, green, and blue values of that pixel from the original
data (after any 24-bit to 8-bit conversions...).  The second group of
three numbers are the red, green, and blue values of that pixel AFTER any gamma
correction (and the '\fB\-rv\fP' option).  If you actually want to measure some
pixels, it will probably help to crop to a small region, and expand that 
region quite a bit, to the point where you can see individual pixels.
.PP
If you type 'h', '?' or click the Right mouse button inside this window,
the CONTROL BOX window will appear.  This box will contain a list of 
file names (just one in this example) and many buttons.
.PP
Note:  unless specified otherwise, 'click' means 'click with the Left mouse
button'.
.SH "THE CONTROL BOX"
Most of the buttons in the control box let you adjust the size of the
currently shown picture.  You can either click the button, or type a keyboard
equivalent inside ANY \fIxv\fP window (except the SAVE BOX (see below)).  It
should be noted that the 'resizing' controls do not MODIFY the picture in any
way.  They simply change the way the picture is displayed, by duplicating or
dropping pixels from the original picture to produce an image of the desired
size.  As you expand images, they will get 'chunkier'.
.PP
The 'Max Size' button (or 'm' key) causes the picture to be redrawn so that it
completely fills the screen.  Be warned that this might take a while,
depending on the speed of your machine.  It also may cover all the other
windows on the screen, including the control window.  If this happens, you can
bring the control window back to the top by clicking the Right mouse button 
in the picture window one or two times.
.PP
The 'Normal' button (or 'n' key) returns the picture to it's normal size.
Normal size is defined as a 1 to 1 mapping between pixels in the image and
pixels on the screen.  (i.e., if you have a 320x200 image, the 'Normal' command
will set the 'on-screen' size to 320x200).
.PP
The only exception to this behavior is when the image is larger than your 
screen.  In this case, the picture is 'halved' until it fits.  (For example,
if you were trying to display a 1000x600 image on an 800x600 screen, 
the 'Normal' command would set the 'on-screen' size to 500x300.)
.PP
The 'Dbl Size' button (or '>' key) doubles the width and height of the picture,
under the constrant that the picture may not be larger than the screen.  (ie,
if you have a 900x100 image, and a 1000x800 screen, doubling would result in
a picture size of 1000x200 (the doubling of the '900' was clipped))
.PP
The 'Half Size' button (or '<' key) halves the width and height of the 
picture.
.PP
The '+10%' button (or '.' key) adds 10% to the width and height of the 
picture.  (Under the same constrant as 'Dbl Size'.)
.PP
The '-10%' button (or ',' key) subtracts 10% from the width and height of the
picture.  
.PP
NOTE: The '+10%' and '-10%' buttons are NOT complementary.  If, for example, 
you have a 100x100 picture, '+10%' will make it into a 110x110 picture.  If 
you then do '-10%', you will have a 99x99 picture.  (10% of 110 = 11 ;
110 - 11 = 99)  The '+10%' and '-10%' buttons have no concept of an 'original
size' to use as an increment/decrement basis.  They only expand or shrink
the current picture by 10% of its current size.
.PP
The '4x3' button (or '4' key) attempts to resize the picture so that the ratio
of width to height is equal to 4 to 3.  (eg, 320x240, 400x300, etc.)  This is
quite useful because most images were meant to fill the screen of 
whatever they were generated on, and nearly all video 
screens have an aspect ratio of 4:3.  By issuing this command, the picture
will be stretched so the proportions of things will (possibly) look right on 
your X display.  (Most of which, thank god, have square pixels.)  
This is particularly obvious on pictures that have really
bizarre sizes (such as the 600x200 pictures presumably meant for CGA).
.PP
The 'Aspect' button (or 'a' key) applies the 'default aspect ratio' to the
picture.  (This is done automatically when the image is first loaded.)  
Normally, the default aspect ratio is '1:1', but certain GIF files may have
an aspect ratio encoded in them.  You can also set the default aspect ratio
via a command-line argument or an X Resource.  The idea here is that you'd
stretch the picture manually (via your window manager) to roughly the size 
you'd like, then you'd click on 'Aspect' to fix-up the proportions.
.PP
The 'Maxpect' button (or 'M' key) makes the picture as large as will fit on
the screen, but preserves the aspect ratio.  
.PP
The 'Turn R' button (or 't' key) rotates the picture 90 degrees clockwise.
It should be noted that when you rotate the picture, you are rotating the
ENTIRE image, even if you're only viewing a small section of it (via 
cropping).
.PP
The 'Turn L' button (or 'T' key) rotates the picture 90 degrees counter-
clockwise.
.PP
The 'Gamma' button (or 'g' key) opens up the GAMMA BOX.  (See 'GAMMA BOX',
below.)
.PP
The 'Info' button (or 'i' key) opens up the INFO BOX.  (See 'INFO BOX',
below.)
.PP
The 'Save' button (or 's' key) opens up the SAVE BOX.  (See 'SAVE BOX',
below.)
.SH CROPPING
In addition to being able to resize/rotate the image, you can do the same to
any rectangular region of the image.  By pressing the Middle mouse button in
the picture window, and dragging it, you'll be able to draw a rectangle.
When this rectangle is visible, the 'Crop' button in the CONTROL BOX lights
up, enabling the 'Crop' command.  
.PP
You can 'fine-tune' the cropping rectangle by using the arrow keys on your
workstation.  The arrow keys (unmodified) will move the cropping rectangle in
the requested direction, preserving its current size.  You can change the size
of the cropping rectangle by holding the 'Shift' key down and using the 
arrow keys.  'Shift-Left' makes the rectangle narrower, 'Shift-Up' makes it
shorter, 'Shift-Right' makes it wider, and 'Shift-Down' makes it taller.
For precise cropping, you'll probably want the INFO BOX visible, which will
tell you the position and size of the cropping rectangle, in image coordinates.
.PP
If you press the 'Crop' button (or the 'c'
key), the parts of the picture outside the rectangle will disappear, and the
window will shrink to the size of the rectangle.  Also, the 'Crop' button 
will 'dim', and the 'UnCrop' button will light up.
.PP
You can manipulate this portion of the image exactly as if it were the
entire image.  You can even draw another 'cropping rectangle' on it and do
the 'Crop' command again.
.PP
Pressing the 'UnCrop' button (or the 'u' key) (when lit) will return to
manipulating the entire image.  It will try to keep the current 'expansion',
but if that would result in a picture larger than the screen, it will use
the 'normal' size (defined in the description of the 'Normal' button).
.PP
The 'AutoCrop' button (or the 'A' key) will crop off any constant borders 
that exist in the picture.  It will crop to smallest rectangle that encloses
the 'interesting' section of the picture.
.SH "MULTIPLE FILES"
If, when you started \fIxv\fP, you specified more than one file name, you'll be
able to use the file-selection controls in the CONTROL BOX.
.PP
The CONTROL BOX will have a list of the filenames 
that you specified on the command line.  The
names will be shown without any common prefixes.  For example, if you started
\fIxv\fP with the command '\fIxv /pic/gif/*\fP', the filenames will be shown 
without the leading '/pic/gif/'.  The current filename will be shown 
in reverse video.
.PP
If there's more than a screenful of file names the scrollbar will be enabled.
.PP
You can scroll through the list a line at a time by using the up and down
arrow buttons in the scroll bar.  If you hold the button down, it will 
auto-repeat.  If you click inside the gray region of the scrollbar, but not
on the slider, the list will be scrolled up or down (depending on whether you
clicked above or below the slider) a page at a time.  If you click on the 
slider, you can drag it to another position and let go of it.
.PP
You can also scroll through the list by clicking on the list itself, (which
will move the reverse video 'bar') and dragging up or down.
.PP
In short, it behaves like a Macintosh.
.PP
You can display any picture file by double-clicking on its filename.  The
current picture will go away, and the new picture will be displayed,
if possible.
If \fIxv\fP was unable to load the selected picture, the previous picture will
be re-displayed.
.PP
If there are multiple files, and you aren't at the end of the list, the 'Next'
button will be enabled.  Clicking 'Next' (or pressing the RETURN or SPACEBAR 
keys) will close the current picture and bring up the next one.  This is the
normal way to view multiple images.
.PP
If there are multiple files, and you aren't at the beginning of the list,
the 'Previous' button will be enabled.  Clicking 'Prev' (or pressing the
BACKSPACE or DELETE keys) will close the current picture and bring up the
previous one.
.PP
It should be pointed out that all of these commands work whether or not the
CONTROL BOX is visible (though if it's not visible, you'll obviously have
to use the keyboard equivalents.)
.SH "QUITTING THE PROGRAM"
Pressing the 'Quit' button (or the 'q' key) will exit the program.
.PP
.SH "THE INFO BOX"
The INFO BOX displays several bits of information.  In addition to 
credits and a revision date, the INFO BOX displays information about the 
currently displayed picture.  It shows the current file name, the format of 
the current file, its size, and its resolution.  This information is available
early in the loading process, and is displayed as soon is it is known.  The
rest of the lines are filled in after the picture has been loaded.
.PP
The 'Cropping' line displays the coordinates of the current cropping 
rectangle.  Normally, this line says 'none', but if you draw a cropping
rectangle on the picture (see CROPPING, above) it will display the size
and position of the rectangle in Image Coordinates.  The first two numbers
are the width and height of the rectangle, respectively.
The second pair of numbers specifies where
the upper-left corner of the rectangle is, as an offset from the upper-left
corner of the entire image.
.PP
The 'Expansion' line shows the effects of any stretching that you may have
done to the picture.  The first pair of numbers represent the stretching as
a ratio of two scaling factors.  Normally, they will be '1x1', which indicates
that one data pixel maps to one screen pixel, in both x and y axes.  For
example, the values '2x3' would indicate that the image or sub-image
has been made twice as
wide as normal, and three times as high as normal.  The second pair of 
numbers, (the ones in parenthesis) simply display the current screen size of
the image.
.PP
The 'Colors' lines displays how successful the color allocation schemes have
been.  Normally, \fIxv\fP uses a three-pass color allocation algorithm.  
In the first pass, the program requests every color that the picture
requires to be displayed properly.  The results of this attempt are printed
on the first 'Colors' line.  If everything  worked out perfectly, this
line will say "Got all \fIx\fP desired colors.", and may 
append "(\fIy\fP unique)".
In this string, \fIx\fP is the number of colors that the picture required.
If the 'unique' string is appended, that means that some of the colors
were duplicates of one another, and the picture only REALLY needed (and 
was only allocated) \fIy\fP colors.
.PP
If \fIxv\fP wasn't able to get all the colors it wanted, it will run
the second-pass color allocation code.  In this pass, the program will
ask the display what colors it has available in its colormap,
dtermine which of those colors are 'close' to the desired colors, and try
to allocate those colors.
The program will print "Got \fIx\fP 'close' colors." if it performed the
second pass allocation.  This is so that the user will know that image 
displayed is not as well as it could possibly be.
.PP
Finally, if even that didn't work, \fIxv\fP will normally attempt to 'borrow'
colors from the colormap without actually allocating them.  These colors
are not owned by the program, and they can change without \fIxv\fP's knowledge.
If this third pass is executed, the program will 
print "'Borrowed' \fIx\fP colors."
.PP
It should be noted that the '\fB\-noglob\fP', '\fB\-perfect\fP', 
and '\fB\-rw\fP' options modify
the way color allocation is handled in \fIxv\fP, and will therefore modify
what will be displayed in the INFO BOX.  For example, if you 
specify '\fB\-noglob\fP', 
\fIxv\fP will never 'borrow' colors, so you'll never see a third-pass line.
.PP
Finally, the INFO BOX will display warning messages that occur while loading
the image.  In particular the message 'File appears truncated, winging it'
comes to mind, from the GIF image loading code.
.PP
.SH "THE GAMMA BOX"
The GAMMA BOX is used to control image brightness, contrast, and to get some
fairly bizarre effects.  The majority of this box is taken up by a window
that displays the current gamma correction curve.  This curve defines a 
mapping between the input values (0-255) along the \fIx\fP axis, and the
output values (0-255) along the \fIy\fP axis.  How these values are interpreted
depends on the setting of the 'HSV/RGB Mode' button.  (see below)
.PP
The gamma curve is defined by four 'control points', two of which are locked
at the left and right edges of the window.  These two points may only move
up and down.  The other two points may be moved freely around the window,
subject only to the constraint that they cannot be moved past one another
on the \fIx\fP axis.  The 'left' point must stay to the left of the 'right'
point.
.PP
The gamma curve can be adjusted in a variety of ways.  You can change the
curve directly by clicking on one of the control points and dragging it.
Also, you can indirectly adjust the curve by using 
the 'Brighter', 'Dimmer', 'Sharper', and 'Duller' buttons.
.PP
The 'Apply' button takes the current gamma curve, and applies it to the
ORIGINAL picture data, according to the setting of the 'HSV/RGB Mode' button,
and displays the results.  It's important to note that the gamma curve is
always applied to the original data.  It is not applied to the 
currently-displayed data.  Thus, if you draw a gamma curve that makes
pictures darker, and click 'Apply' several times, it will only (noticably)
do anything the first time.  It will NOT keep making the picture darker.
Also, it should be noted that the apply button
is very often unnecessary.  If you specified the '\fB\-rw\fP' option on the 
command line,
the gamma curve will be automatically applied every time it is 
changed.  (Keyboard equivalent: 'p')
.PP
The 'No Gamma' button shows the original picture with no gamma correction,
but does not affect the current gamma curve.  It just ignores it.  You can
use this command to do A/B comparisions between the original picture and
your 'improved' version.
.PP
The 'Linear' button sets the gamma curve to a straight line from 0,0 to 
255,255.  This has the effect of displaying the picture without any
apparent gamma correction, much like the 'No Gamma' command, however, this
command also resets the curve.  This command serves as an "Aaah!  I've 
screwed it up horribly!" fix.
.PP
The 'Default' button sets the gamma curve to its default setting.  Normally,
this is a straight line, exactly the same as the 'Linear' command.  However,
by specifying the '\fB\-GAMMA\fP' option on the command line, or by 
defining the 'xv.gamma' resource, it is possible to the the default
gamma correction to something else entirely.
.PP
The 'Spline' button is actually a two-state switch that displays its
current setting.  It controls how the four control points are connected.
By default, they are connected by a spline curve.  Unfortunately, some
gamma curves are hard to get (or impossible) in this mode.  Clicking
the 'Spline' button will toggle it to 'Lines'.  The control points will now
be connected by straight lines.  Clicking the button again will set it back 
to 'Spline'.
.PP
The 'Close' button hides the GAMMA BOX.  Use the 'Gamma' command (see
CONTROL BOX, above) to make it visible again.
.PP
The 'Brighter' button makes the picture brighter.  Unless you're running 
in '\fB\-rw\fP' mode, you'll have to press 'Apply' to see the effect.
.PP
The 'Dimmer' button makes the picture dimmer.
.PP
The 'Sharper' button increases the contrast of the picture.
.PP
The 'Duller' button decreases the contrast of the picture.
.PP
The 'HSV/RGB Mode' button is a two-state switch that displays its current
setting.  It affects HOW the gamma curve is used.  By default, it is 
in 'HSV Mode'.  In this mode, the colors of the picture are converted from
the RGB model (red, green, and blue) into the HSV model (hue, saturation, 
and value).  The gamma curve is applied to the 'value' (brightness) of the
HSV colors.  The (modified) HSV colors are converted back to RGB colors so
that they may be displayed.  In this mode, colors are made brighter or
dimmer, according to the curve, but their Hue and Saturation is not changed.
This is generally the more desirable way to apply gamma correction to color
pictures.
.PP
When the 'HSV/RGB Mode' button is in 'RGB Mode', the gamma curve is applied to
each of the RGB components (red, green, and blue) separately.  This can have
some interesting effects, particularly when you use a drastic gamma correction
curve.  For example, assume a gamma curve that is a straight line from 0,255 to
255,0 (top-left to bottom-right, instead of the 'normal' bottom-left 
to top-right).  In HSV Mode, this curve will merely take 'dark' colors and 
make them 'light', and vice-versa.  (i.e., dark blue <-> light blue).
The RGB Mode, on the other hand will COMPLEMENT the colors.  (blue <-> yellow,
red <-> cyan, and green <-> violet).  Both modes will do (black <-> white),
however.  The RGB Mode is mainly for amusement value.
.PP
It should be noted that when viewing greyscale pictures, it makes no difference
whether you are in HSV or RGB mode.  Both modes will behave exactly the same.
Also, note that when the '\fB\-rw\fP' option is specified, gamma correction 
is performed AFTER the reversal.
.PP
\fIxv\fP allows you to have four gamma 'presets'.  By default, they have
four vaguely useful curves.  You can 'load' them by clicking
on the '1', '2', '3', or '4' buttons, respectively.  You can 'write' them by
clicking 'Set', and clicking one of the numbered buttons.  The current gamma
correction curve will be 'stored' in the preset number you clicked, and
will remain there until overwritten, or until you exit the program.
.PP
Notes:  The Spline/Lines and HSV/RGB settings are NOT stored in the presets.
A weakness, admittedly.  You can specify your own 'default settings' for
the presets by setting the X resources 'xv.gamma1', 'xv.gamma2', etc.
.PP
The 'Undo' button undoes the last change to the gamma curve.  Currently, the
undo buffer is eight slots long, so you can undo up to the last eight 
changes.  There is no way to 'undo an undo', however.  As with presets, the
Spline/Lines and HSV/RGB settings are not saved, nor are they 
considered 'changes'.
.PP
At the top of the GAMMA BOX are six numbers that define the current gamma
correction curve.  The numbers are, in order, the y-coordinate of the first
control point, the x- and y-coordinates of the second and third control points,
and the y-coordinate of the fourth control point.  These numbers appear in
the same order that they would be specifed to the '\fB\-GAMMA\fP' command line
option, or the 'xv.gamma', 'xv.gamma[1-4]' X resources.
.PP
.SH "THE SAVE BOX"
When you issue the 'Save' command (by clicking the 'Save' button in the CONTROL
BOX (above), or typing 's' in any of the \fIxv\fP windows, the SAVE BOX will
appear, giving you an opportunity to write the current file to disk.  The file
will consist of the currently-visible portion of the picture.  Normally, this
would be the entire picture, but if you 'crop' first, and then save, it will
only save the cropped-to region.
If the picture has been rotated, the rotation will also be saved in the
file.  If a gamma correction curve has been applied to a picture, the picture
will be saved with the gamma correction.
.PP
Major Bummer:  As noted elsewhere, \fIxv\fP stores images internally as
8-bit colormapped images.  If you load a 24-bit color image, it is converted
to an 8-bit image IMMEDIATELY, and the 24-bit version is thrown away.  As such,
you do not REALLY want to use \fIxv\fP to modify (crop, rotate, etc.) 
24-bit images, as much of the information will be lost in the translation.
.PP
Saved images are not affected by the display that they were saved on.  
For example, if you displayed a full-color image on a 1-bit b/w display, it
would be dithered in black and white.  If you save the image, by default, it
will be saved as a full-color image.  All the data will still be there.
.PP
When you open up the SAVE BOX, it will display the contents of the current
directory in a scrollable list.  
Next to each file name will be an icon
representing its file type.  Subdirectories will be shown as 'file folders', 
for instance.  You can go 'down' the directory tree by 'Open'-ing a
subdirectory, either by clicking on its name and clicking the 'Open'
button, or by double clicking on the name.  (Note:  You can only 'Open' 
directories and symbolic links.  Other files are displayed merely as a
navigational aid.)
.PP
You can go 'up' the directory tree by clicking on the button at the very top
of the SAVE BOX.  A pop-up menu will appear, with the current directory name
at the top, and its parent directories listed below it.  Drag the mouse to any
directory in this list and let go.  You will switch to that directory.
.PP
Once you are in the correct directory, you can save the file by typing a
simple file name (no /'s) and clicking 'Save' or pressing return.  Ctrl-U
or Ctrl-K will clear the line.  By default, the file will be saved as a
full-color GIF file, in 'Normal Size'.  You can choose the format by clicking
on the buttons at the bottom of the window.  Note that some combinations are
not possible (for example, X11 Bitmaps can only be saved as 'B/W Dithered').
Also, the 'PBM (raw)' and 'PBM (ascii)' formats actually cover all PBM/PGM/PPM
formats.  The particular format is chosen according to the setting of 
the 'Colors' control.
.PP
The 'Cancel' button gets rid of the SAVE BOX.  You'll have to issue the 'Save'
command to make it visible again.
.PP
The 'Quit' button exits \fIxv\fP.  It is provided as a convenience, as you'll
often want to quit immediately after saving a file.
.PP
Note:  Since the SAVE BOX is expecting you to type a file name, you cannot
execute keyboard commands (see 'Shortcuts', below) while the keyboard 
focus is in this window (generally, whenever the mouse is in this window).
.PP
.SH "COMMAND LINE OPTIONS"
There are a Vast Multitude of options.  Note: only the first few 
unique characters of an option name are required.  For example, '\fB\-d\fP' 
is a legal abbreviation for '\fB\-display\fP', but you'd have to 
give '\fB\-nc\fP' as an abbreviation for '\fB\-ncols\fP', because 
there's another option that starts with the letter 'n'.
.PP
That said...
.SH "GENERAL OPTIONS"
.IP \fB\-help\fP 12
Print usage instructions, listing the current available command-line options.
Any unrecognized option will do this as well.  
.IP \fB\-display\fP 12
Specifies the display that \fIxv\fP should attempt to 
connect to.  If you don't specify a display, \fIxv\fP will use the 
environment variable $DISPLAY.
.IP \fB\-fg\fP 12
Sets the foreground color used by the windows.  (Resource name:  foreground.
Type: string)
.IP \fB\-bg\fP 12
Sets the background color used by the windows.  (Resource name:  background.
Type: string)
.IP \fB\-bw\fP 12
Sets the width of the border on the windows.  Your window
manager may choose to ignore this, however.  (Resource name:  borderWidth.
Type: integer)
.PP
.SH "WINDOW SIZING OPTIONS"
.IP \fB\-geometry\fP 12
Lets you specify the size and placement of the 'image' window.  It's most
useful when you only specify a position, and let \fIxv\fP choose the size.
If you specify a size as well, \fIxv\fP will create a window of that size,
unless '\fB\-fixed\fP' is specified.  (Resource name: geometry.  Type: string)
.IP \fB\-fixed\fP 12
Only used in conjunction with the '\fB\-geometry\fP'
option.  If you specify a window size with the '\fB\-geometry\fP' 
option, \fIxv\fP
will normally stretch the picture to exactly that size.  This is not
always desirable, as it may seriously distort the aspect ratio of the
picture.  Specifying the '\fB\-fixed\fP' option corrects this behavior.  When
you do this, \fIxv\fP will now use the geometry size as a MAXIMUM window
size.  It will, however, preserve the original aspect ratio of the
picture.  For example, if you give a rectangular geometry of '320x240', 
and you try to display a square picture of '256x256', the
window opened will actually be '240x240', which is the largest square
that still fits in the '320x240' rectangle that was specified. (resource 
name: fixed)
.IP \fB\-expand\fP 12
Lets you specify an initial expansion or compression 
factor for the picture.  It expects an integer value.  Values larger than 1
multiply the picture's dimensions by the given factor.  (ie, an expand factor
of '3' will make a 320x200 image display as 960x600).  Factors less than zero
are treated as reciprocals.  (ie, an expand factor of '-4' makes the picture
1/4th its normal size.)  '0' is not a valid expansion factor.  (resource
name: expand)
.IP \fB\-aspect\fP 12
Lets you set an initial aspect ratio, and also sets the
value used by the 'Aspect' control.  The aspect ratio of nearly every X 
display (and, in fact, any civilized graphics display) is 1:1.  What this 
means is that pixels appear to be 'square'.  A 100 pixel wide by 100 pixel high
box will appear on the screen as a square.  Unfortunately, this is not the
case with some screens, and many digitizers.  The '\fB\-aspect\fP' 
option lets you
stretch the picture so that the picture appears correctly on your display.
Unlike the other size-related options, this one doesn't care what the 
size of the overall picture is.  
It operates on a pixel-by-pixel basis, stretching each image pixel slightly,
in either width or height, depending on the ratio.
Aspect ratios greater than '1' make the picture
wider than normal.  Aspect ratios less than 1 make the picture taller than
normal.  (Useful aspect ratio:  A 512x480 image that was supposed to fill
a standard 4x3 video screen should be displayed with an aspect ratio 
of 5:4)  (Resource name:  aspect.  Type: string)
.PP
.SH "COLOR ALLOCATION OPTIONS"
.IP \fB\-ncols\fP 12
Sets the maximum number of colors that \fIxv\fP will
use.  Normally, this is set to 'as many as it can get'.  (ie, 2^(depth of
screen)) However, you can set this to smaller values for interesting effect.
Most notably, if you set it to '0', it will display the picture by dithering
with 'black' and 'white'.  (The actual colors used can be set by 
the '\fB\-black\fP' and '\fB\-white\fP' options, 
below.)  (Resource name: ncols.  Type: integer)
.IP \fB\-nglobal\fP 12
Adjusts the way the program behaves when it is unable to
get all the colors it requested.  Normally, it will search the display's
default colormap, and 'borrow' any colors it deems appropriate.  These
borrowed colors are, however, NOT owned by \fIxv\fP, and as such, can changed
without \fIxv\fP's permission, or knowledge.  If this happens, the displayed
picture will change, in a less-than-desirable direction.  If
you specify the '\fB\-nglobal\fP' option, \fIxv\fP will not 
use 'global' colors.  It
will only use colors that it successfully allocated, which makes it immune to
any color changes.  (Resource name: nglobal.  Type boolean)
.IP 
It should be noted that 'use global colors' is the default because color
changes aren't generally a problem if you are only using \fIxv\fP to display a
picture for a short time.  Color changes only really become a problem
if you use \fIxv\fP to display a picture that you will be keeping around for a
while, while you go and do some other work (such as using \fIxv\fP to display
a background).  In such cases you will want to specify '\fB\-nglobal\fP'.  
Note: using the '\fB\-ncols\fP' or '\fB\-root\fP' options automatically 
turn on '\fB\-nglobal\fP'.
.IP \fB\-rw\fP 12
Tells \fIxv\fP to use read/write color cells.  Normally,
\fIxv\fP allocates colors read-only, which allows it to share colors with
other programs.  If you use read/write color cells, no other program can use
the colors that \fIxv\fP is using, and vice-versa.  The only reason you'd do 
such a thing is that using read/write color cells allows 
the 'Apply' function in the Gamma window to operate many 
times faster.  (Resource name: rwColor.  Type: boolean)
.IP \fB\-perfect\fP 12
Makes \fIxv\fP try 'extra hard' to get all the colors it
wants.  In particular, when '\fB\-perfect\fP' is specified, \fIxv\fP 
will allocate and
install its own colormap if (and only if) it was unable to allocate all the
desired colors.  This option is not allowed in conjunction 
with the '\fB\-root\fP'
option.  (Resource name:  perfect.  Type boolean)
.IP \fB\-ninst\fP 12
Prevents \fIxv\fP from 'installing' its own colormap, when
the '\fB\-perfect\fP' option is in effect.  Instead of installing 
the colormap, it
will merely 'ask the window manager, nicely' to take care of it.  This is the
correct way to install a colormap (ie, ask the WM to do it), unfortunately, it
doesn't actually seem to work in many window managers, so the default behavior
is for \fIxv\fP to handle installation itself.  However, this has been seen to
annoy one window manager (dxwm), so this option is provided if your WM doesn't
like programs installing their own colormaps.  Note that this is ONLY relevant
if A) '\fB\-perfect\fP' has been specified and B) \fIxv\fP ran out of 
colors and
generated its own colormap.  (Resource name: ninstall.  Type: boolean)
.PP
.SH "24 BIT CONVERSION OPTIONS"
The following options only come into play if you are using \fIxv\fP to display
24-bit RGB data (PPM files, color PM files, and the output of \fIbggen\fP).
They have no effect whatsoever on how GIF pictures or 8-bit greyscale 
images are displayed.
.IP \fB\-slow24\fP 12
Specifies that the 'alternate' 24-bit to 8-bit conversion
algorithm is to be used by the program.  The default algorithm dithers the
picture using a fixed set of colors that roughly approximate all displayable
colors.  The '\fB\-slow24\fP' algorithm picks the 'best' colors on a 
per-image basis,
and dithers with those.  Advantages: The '\fB\-slow24\fP' 
algorithm often produces
better looking pictures.  Disadvantages: The '\fB\-slow24\fP' 
algorithm is about half
the speed of the default algorithm.  Since the colors are chosen on a
per-image basis, it can't be used to display multiple images, as each image
will almost certainly want a different set of 256 colors.  The default
algorithm, however, uses the same exact colors for all images, so it can
display many images simultaneously, without running out of colors.  Also, 
the '\fB\-slow24\fP' algorithm occasionally produces worse-looking 
pictures than the
default algorithm, particularly on displays with very few colors.  The default
algorithm produces nice, dependably 'okay' pictures.  (Resource name: slow24.
Type: boolean)
.IP \fB\-noqcheck\fP 12
Turns off a 'quick check' that is normally made.
Normally, before running either of the 24-bit to 8-bit conversion algorithms,
\fIxv\fP determines whether the picture to be displayed has more than 256
unique colors in it.  If the picture doesn't, it will treat the picture as an
8-bit colormapped image (ie, GIF), and won't run either of the conversion
algorithms.  Advantages: The pictures will be displayed 'perfectly', whereas
if they went through either of the conversion algorithms, they'd be dithered.
Disadvantages: Often uses a lot of colors, which limits the ability to view
multiple images at once.  (See the '\fB\-slow24\fP' option above for 
further info about color sharing.)  (Resource name: noqcheck.  Type: boolean)
.PP
.SH "ROOT WINDOW OPTIONS"
\fIxv\fP has the ability to display images on the root window of an X display,
rather than opening its own window (the default behavior).  When using the
root window, the program is somewhat limited, because the program cannot
receive input events (key press and mouse clicks) from the root window.  As
a result, you cannot track pixel values, or crop, nor can you use keyboard 
commands while the mouse is in the root window.
.IP \fB\-root\fP 12
Directs \fIxv\fP to display images in the root window,
instead of opening its own window.  Images will be displayed in the upper left
corner of the screen, and will be repeated as many times as necessary to fill
the entire screen.  (Resource name: <none>)
.IP \fB\-tile\fP 12
Makes \fIxv\fP shrink images so that they fit on the screen
an integer number of times (in both directions).  The default behavior will
generally chop off the bottom and right sides of the images along the bottom
and right sides of the screen.  Disadvantage:  will slightly change the
aspect ratios of the images.  (Resource name:  tile.  Type: boolean)
.IP \fB\-center\fP 12
Forces \fIxv\fP to center the image in the root window.  If the image is 
smaller than the root window, the area around it will be determined by the
settings of \fB-rpat\fP, \fB-rfg\fP, and \fB-rbg\fP.  (See below.)  (Resource
name: centerPic.  Type: boolean)
.IP \fB\-rpat\fP 12
Specifies the pattern that will be used to fill the rest of the root window,
when \fB\-center\fP is in effect.  Currently, there are three different 
fill patterns.  '\fB\-rpat 0\fP' (the default) is just a solid background
color.  '\fB\-rpat 1\fP' adds radial lines to the solid 
background.  '\fB\-rpat 2\fP' is a brick pattern.  (Resource name: rootPattern.
Type: integer)
.IP \fB\-rfg\fP 12
Sets the 'foreground' color used in the various \fB-rpat\fP 
patterns.  (Resource name: rootForeground.  Type: string)
.IP \fB\-rbg\fP 12
Sets the 'background' color used in the various \fB-rpat\fP 
patterns.  (Resource name: rootBackground.  Type: string)
.IP \fB\-max\fP 12
Makes \fIxv\fP automatically stretch the image to the full
size of the screen.  This is mostly useful when you want \fIxv\fP to display a
background.  While you could just as well specify the dimensions of your
display (ie, '\fB\-geom\fP 1152x900' for example), the \fB\-max\fP option is
display-independent.  If you suddenly decide to start working on a 1280x1024
display (ferinstance) the same command will still work.  Note: If you 
specify '\fB\-max\fP' when you AREN'T using '\fB\-root\fP', 
the behavior is slightly 
different.  The image will be made as large as possible while still preserving
the normal aspect ratio.  (Resource name: <none>)
.IP \fB\-quit\fP 12
Makes \fIxv\fP display the (first) specified file and exit, 
without any user intervention.  Since images displayed on the root window 
remain there until explicitly cleared, this is very useful for having \fIxv\fP 
display background images on the root window in some sort of start-up script.
Needless to say, this is only useful if you are 
using '\fB\-root\fP'.  (Resource name:  <none>)
.IP \fB\-clear\fP 12
Clears the root window of any extraneous \fIxv\fP images.
While there are other ways of clearing the root window of an X display, such
as 'xsetroot', you must use the '\fB\-clear\fP' option to 
free up the other resources
allocated by \fIxv\fP, in particular, the colormap entries.  Note: it is not
necessary to do an 'xv -clear' before displaying another picture in the root
window.  \fIxv\fP will detect that there's an old \fIxv\fP image in the root
window and automatically clear it out (and free the associated colors).
(Resource name: <none>)
.PP
.SH "WINDOW OPTIONS"
\fIxv\fP currently consists of four main windows, plus one window for the
actual image.  Of those four, three of them (the CONTROL BOX, the INFO BOX,
and the GAMMA BOX) may be automatically mapped and positioned when the program
starts.
.IP \fB\-cmap\fP 12
Maps the CONTROL BOX.  (Resource name:  ctrlMap.  Type: boolean)
.IP \fB\-cgeom\fP 12
Sets the initial geometry of the CONTROL BOX.  Note:  only
the position information is used.  The CONTROL BOX is of fixed 
size.  (Resource name:  ctrlGeometry.  Type: string)
.IP \fB\-imap\fP 12
Maps the INFO BOX.  (Resource name:  infoMap.  Type: boolean)
.IP \fB\-igeom\fP 12
Sets the initial geometry of the INFO BOX.  Note:  only
the position information is used.  The INFO BOX is of fixed 
size.  (Resource name:  infoGeometry.  Type: string)
.IP \fB\-gmap\fP 12
Maps the GAMMA BOX.  (Resource name: gammaMap.  Type: boolean)
.IP \fB\-ggeom\fP 12
Sets the initial geometry of the GAMMA BOX.  Note:  only
the position information is used.  The GAMMA BOX is of fixed
size.  (Resource name:  gammaGeometry.  Type: string)
.PP
.SH "MISCELLANEOUS OPTIONS"
.IP \fB\-rv\fP 12
Reverses the colors of the image, so that white becomes
black and black becomes white.  This has 'interesting' effects on color 
images, however.  (For instance, red (255,0,0) becomes 
cyan (0,255,255))  (Resource name: reverseVideo.  Type: boolean)

.IP \fB\-mono\fP 12
Forces the image to be displayed as a grayscale.  This is
most useful when you are using certain grayscale X displays.  While \fIxv\fP
attempts to determine if it's running on a grayscale display, many X displays
\fIlie\fP, and claim to be able to do color.  (This is often because they 
have color
graphics boards hooked up to b/w monitors.  The computer, of course, has no
way of knowing what type of monitor is attached.)  On these displays, if you
don't specify '\fB\-mono\fP', what you will see is a grayscale 
representation of one
of the RGB outputs of the system.  (For example, you'll see the 'red' output
on our grayscale Sun 3/60s.)  The '\fB\-mono\fP' option corrects this behavior.
(Resource name: mono.  Type: boolean)
.IP \fB\-white\fP 12
Specifies the 'white' color used when the picture
is b/w stippled. (When '\fB\-ncols\fP 0' has been 
specified.)  (Resource name: white.  Type: string)
.IP \fB\-black\fP 12
Specifies the 'black' color used when the picture is
b/w stippled.  (When '\fB\-ncols\fP 0' has been specified.)  Try something
like 'xv -ncols 0 -bl red -wh yellow <filename>' for some interesting, 
late-'60s-style psychodelia effects.  (Resource name:  black.  Type: string)
.IP \fB\-GAMMA\fP 12
Sets up the default gamma-correction curve.
It can be used for contrast and/or brighness control.  The curve 
defines a transformation between input pixel intensity values (from the
picture) and output pixel intensity values (which get displayed).  The
curve is specified by four points in the range 0,0 <-> 255,255.  The points
must be in strict left-to-right order.  The first point is fixed at x=0.  The
last point is fixed at x=255.  The parameters to the '\fB\-GAMMA\fP' 
option are,
in order, the y-value of the first point, the x and y values of the second
point, the x and y values of the third point, and the y value of the last
point.  (These are the same numbers that appear above the gamma correction
curve in the GAMMA BOX (see below)).  (Resource name:  gamma. Type:  six
integers)
.IP
You can also specify default values for the 4 gamma 'presets' in the GAMMA
BOX.  The format is the same as above, and the resource names 
are 'gamma1', 'gamma2', 'gamma3', and 'gamma4'.
.IP \fB\-autogamma\fP 12
Tells \fIxv\fP to apply the 'default' gamma correction
(set by the '\fB\-GAMMA\fP' option or the 'gamma' resource) to the image
automatically, before the image is ever displayed.  (Resource
name: autoGamma.  Type: boolean)
.IP \fB\-fish\fP 12
Turns on some animated fish that are displayed whenever
\fIxv\fP is loading or resizing an image.  Note: This option may cause 'X
Protocal Errors' on slower X displays.  Use at your own risk.  (Resource name:
fish.  Type: boolean)
.IP \fB\-wait\fP 12
Turns on a 'slide-show' feature.  Normally, if you specify
multiple input files, \fIxv\fP will display the first one, and wait for you to
give the 'Next' command (or whatever).  The '\fB\-wait\fP' 
option makes \fIxv\fP wait
the specified number of seconds, and then go on to the next picture, without
any user intervention.  The program still accepts commands, so it's possible
to 'abort' the current picture without waiting the full specified time by
using the 'Next' command.  (Resource name: <none>)
.PP
.IP \fB\-bfc\fP 12
Toggles the 'color freeing behavior'.  If you experience X Protocol Errors 
when applying gamma corrections, or when loading multiple images, try 
using this option.  Normally, this option turns on some workarounds for
broken X servers, but if \fIxv\fP was built with the workarounds ON by
default, this option will turn them OFF.  (Resource name:  
brokeFreeCols.  Type: boolean)

.SH SHORTCUTS
Commands and their keyboard equivalents:
.in +0.5i
.ta 3in
.nf
Next Picture:	<SPACE>, <RETURN>
.br
Previous Picture:	<BS>, <DEL>
.br
Quit XV:	'q'
.br
Open/Close Control Box:	'h', '?', Right Mouse Button
.br
Open/Close Info Box:	'i'
.br
Open/Close Gamma Box:	'g'
.br
Open Save Box:	's'
.br
Aspect:	'a'
.br
Turn Right:	't'
.br
Turn Left:	'T'
.br
4x3:	'4'
.br
Crop:	'c'
.br
Uncrop:	'u'
.br
AutoCrop:	'A'
.br
Normal:	'n'
.br
Max Size:	'm'
.br
Maxpect:	'M'
.br
Shrink 10%:	','
.br
Grow 10%:	'.'
.br
Half Size:	'<'
.br
Double Size:	'>'
.br
Apply Gamma:	'p'
.ta
.in -0.5i
.fi
.PP
.SH LIMITATIONS
\fIxv\fP will NOT work on displays that aren't 1-, 4-, 6-, 8-, 24-, or 32-bits
deep.  Luckily, that should still cover nearly every display out there.  It
may not work on certain 6- or 24-bit displays.
.PP
It also only displays the first image in GIF files that have multiple 
images in them.
.PP
As for PM pictures, this program only displays 1-plane PM_I pictures, or
1-, 3-, or 4-plane PM_C pictures.
.PP
.SH "PM FORMAT"
The PM format is a file format that we use at the GRASP Lab for our image-
processing work.  If you aren't at Penn, you are unlikely to ever run into 
a PM-format file, so don't worry about it.  Please ignore all references to PM.
.PP BUGS
The 4-, 6-, 24-, and 32-bit code has not been extensively 
tested.  (A 4-bit MicroVax GPX system, a 6-bit HP 9000/320, and a 
24-bit HP 9000/350, respectively.  The 32-bit code hasn't actually been 
tested at all.)  
You won't be able to do '\fB\-ncols\fP 0' on a 6-, 24-, or 32-bit display, 
not that you should want to.
.SH AUTHOR
John Bradley  -  bradley@cis.upenn.edu
.PP
GIF reading code based on gif2ras.c, by Patrick J. Naughton 
(naughton@wind.sun.com)
.PP
GIF writing code essentially unchanged from code written 
by Michael Maudlin (mlm@cs.cmu.edu).

