#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <time.h>

#ifdef COHERENT
#define srandom srand
#define random rand
#endif

#define Neighbors(func, x, y)   func(x-1,y-1);func(x,y-1);func(x+1,y-1);\
                                func(x-1,y  );            func(x+1,y  );\
                                func(x-1,y+1);func(x,y+1);func(x+1,y+1)


void fillBlanks();

#define AWIDTH  10
#define AHEIGHT 10

#define LIVE 1
#define DIE -1

#define MINE 9
#define MISSMARKED 10
#define BOOM 11
#define MARKED  0x20
#define COVERED 0x10
/*
    bit 5   : Marked
    bit 4   : Cover/uncovered
    bit 3-0 : number of mines in adjoining cells
*/
  
int minefield[50][20];
int numcells = 0;
int nummines = 10;
int numuncovered = 0;
int nummarked;

int done;
int score;
int pausetime = 0;
int interval;
int height;
int width;
int pauseflag = 0;

void ticktock()
{
}

delay(time)
    int time;
{
#ifndef COHERENT
    struct itimerval value,ovalue;

    signal(SIGALRM,ticktock);
    value.it_interval.tv_sec = time/1000;
    value.it_interval.tv_usec = (time %1000)*1000;
    value.it_value.tv_sec = time/1000;
    value.it_value.tv_usec = (time %1000)*1000;
    setitimer(ITIMER_REAL,&value,&ovalue);
    pause();
    value.it_interval.tv_sec = 0;
    value.it_interval.tv_usec = 0;
    value.it_value.tv_sec = 0;
    value.it_value.tv_usec = 0;
    setitimer(ITIMER_REAL,&value,&ovalue);
#endif
}


setdoneflag(i)
{
    done = i;
}

main(argc,argv)
    int argc;
    char **argv;
{

/*    openScores(); */

    height = 16;
    width = 30;
    parseOptions(argc,argv);
    extractOptions();
    nummines = 60;
    XStuff(argc,argv);

    srandom(getpid());

    while(1)
    {
        score = 0;
        nummarked = 0;
        numcells = height*width;
        numuncovered = 0;
        newscreen();
        startscore();
        draw_screen();
        done = 0;
        while(!done)
        {
            for(interval = 100;(interval > 0) && !done; interval--)
            {
                CheckforEvent();
                delay(10);
            }
            if(numuncovered)
            {
                score++;
            }
            else
            {
                startscore();
                pausetime = 0;
            }
            show_score();
        }
        if(numuncovered == (numcells - nummines))
        {
            shades();
        }
        else
        {
            unhappy();
            showallmines();
            score = 9999;
        }
#ifdef SCORE2
        newScore(score, numuncovered,numcells - nummines);
#else
        newScore(score);
#endif
        show_high_scores(0);
    }
}

time_t start_score;

startscore()
{
    time(&start_score);
}

getscore()
{
    int score;
    score = time(NULL) - start_score - pausetime;
    return score;
}

time_t start_pausetime;

paws()
{
    if(pauseflag == 0)
    {
        time(&start_pausetime);
    }
    else
    {
        pausetime += time(NULL) - start_pausetime;
    }
    pauseflag = pauseflag ^ 1;
    draw_screen();
}


shades()
{
}

unhappy()
{
}

getminesleft()
{
    return nummines - nummarked;
}


IsBlank(x,y) /* no neighboring mines */
{
    return (minefield[x][y]) ? 0 : 1;
}

IsMine(x,y)
{
    return (InArray(x,y) && (minefield[x][y] & 0xf) == MINE) ? 1 : 0;
}

IsMarked(x,y)
{
    return (InArray(x,y) && (minefield[x][y] & MARKED)) ? 1 : 0;
}

cntmines(x,y)
{
    return IsMine(x-1,y-1) + IsMine(x-1,y) + IsMine(x-1,y+1) +
        IsMine(x,y-1) + IsMine(x,y+1) +
        IsMine(x+1,y-1) + IsMine(x+1,y) + IsMine(x+1,y+1);
}

IsVisible(x,y)
{
    return (minefield[x][y] & COVERED) ? 0 : 1;
}

InArray(x,y)
{
    return ((x >= 0 && x < width) && (y >= 0 && y < height)) ? 1 : 0;
}

Number(x,y)
{
    return minefield[x][y] & 0xf;
}

MissmarkCell(x,y)
{
    minefield[x][y] = MISSMARKED;
}

MarkCell(x,y)
{
    if(InArray(x,y) && !IsVisible(x,y))
    {
        if(IsMarked(x,y))
        {
            minefield[x][y] &= ~MARKED;
            nummarked--;
        }
        else
        {
            minefield[x][y] |= MARKED;
            nummarked++;
        }
    }
    DrawCell(x,y);
}

BoomCell(x,y)
{
    minefield[x][y] = BOOM;
    DrawCell(x,y);
}

UncoverCell(x,y)
{
    minefield[x][y] &= 0xf;
    if(!IsMine(x,y))
    {    
        numuncovered++;
    }
}

WriteCell(x,y,val)
{
    minefield[x][y] = val;
}

ReadCell(x,y)
{
    return minefield[x][y];
}

newscreen()
{
    int i,j,k;
    int x,y;

    for(i=0; i < width; i++)
    {
        for(j=0; j < height; j++)
        {
            WriteCell(i,j,0);
        }
    }
    for(k=0; k < nummines; k++)
    {
        do
        {
            x = random() % width;
            y = random() % height;
        } while(IsMine(x,y));
        WriteCell(x,y,MINE + COVERED);
    }
    for(i=0; i < width; i++)
    {
        for(j=0; j < height; j++)
        {
            if(!IsMine(i,j))
            {
                WriteCell(i,j,COVERED + cntmines(i,j));
            }
        }
    }
}

showallmines()
{
    int x,y;

    for(x=0; x < width; x++)
    {
        for(y=0; y < height; y++)
        {
            if(!IsVisible(x,y))
            {
                if(!IsMine(x,y) && IsMarked(x,y))
                {
                    MissmarkCell(x,y);
                    DrawCell(x,y);
                }
                if(IsMine(x,y) && !IsMarked(x,y))
                {
                    UncoverCell(x,y);
                    DrawCell(x,y);
                }
            }
        }
    }
}


Highlight(x,y)
{
    if(!IsMarked(x,y) && !IsVisible(x,y))
    {
        DrawHighlight(x,y);
    }
}

unHighlight(x,y)
{
    if(!IsMarked(x,y) && !IsVisible(x,y))
    {
        DrawCell(x,y);
    }
}


void Show(x,y)
    int x,y;
{
    if(InArray(x,y) && !IsVisible(x,y) && !IsMarked(x,y))
    {
        if(IsMine(x,y))
        {
            BoomCell(x,y);
            DrawCell(x,y);
            setdoneflag(DIE);
        }
        else
        {
            UncoverCell(x,y);
            fillBlanks(x,y);
            DrawCell(x,y);
            if(numuncovered == numcells - nummines)
            {
                setdoneflag(LIVE);
            }
        }
    }
}

/* fill blanks starting at x, y */
void
fillBlanks( x, y )
int x,y;
{
    if (IsBlank (x, y)) {
	Neighbors (Show, x, y);
    }
}

/* highlight neighbors which are invisible (two button down) */
void
highlightInvisible(x,y)
int x, y;
{
    Highlight(x,y);
    Neighbors( Highlight, x, y);
}

unhighlightInvisible(x,y)
    int x, y;
{
    unHighlight(x,y);
    Neighbors( unHighlight, x, y);
}


int
foundMines(x,y)
int x,y;
{
    int     visibleMineCount;

    visibleMineCount = 0;

    Neighbors (visibleMineCount += IsMarked, x, y);

    return visibleMineCount;
}


/* fill numbers if all mines are already discovered (two button up) */
void
fillNumbers( x, y )
int x,y;
{
    if(IsVisible(x, y))
    {
	if (foundMines (x, y) == Number (x, y))
        {
	    Neighbors (Show, x, y);
        }
    }
    unhighlightInvisible(x,y);
}

