#include <stdio.h>
#ifndef COHERENT
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/file.h>
#include <pwd.h>
#include "xmines.h"

#define COMPLETEDsCORING
FILE *scoreFile=NULL;
unsigned numScores = 0;
#define HIGHsCORES 10
#define MUSTpLAYED 10
#define MAXnUMsCORES 1000

#define NAMEsIZE 50
#define NOTFOUND 1

int player;
int uid;
int geoeffnet=0;

#define LiveScore(i) ((float)scores[i].live/scores[i].played)
#define FracScore(i) (scores[i].fraction/scores[i].played)
#define TimeScore(i) (scores[i].time)

#define SCOREfILE "/usr/games/lib/xminescores"
#define Lives(u, s)  (u == s ? 1 : 0 )
#define Frac(u, s) ( (float)u / s )
/* scorefile: userid lived frac played lowest-time*/
#define SCOREfORMAT "%u %u %f %u %u\n"




#define newstr(s)        (char *)strcpy(malloc((unsigned)(strlen(s)+1)),s)



struct
{
    unsigned live;
    float fraction;
    unsigned played, time;
    int userid;
} scores[MAXnUMsCORES] = {{0,MAXsCORE, MAXsCORE, -1}};

struct
{
    float liveScore, fracScore;
    unsigned time;
    char *name;
} highScores[HIGHsCORES];

openScores()
{
  if (geoeffnet==0)
    {
      if ((scoreFile = fopen (SCOREfILE, "r+")) == NULL)
	{
        fprintf(stderr,"Error: can't open score file\n");
      }
    }
  geoeffnet ++;
}

void closeScores()
{
  if (geoeffnet == 1)  if (scoreFile) fclose(scoreFile);
  geoeffnet --;
}

readScores(uid, score, uncovered, spaces)
int uid, uncovered, spaces;
unsigned score;
{
    int     found;

    if (scoreFile == NULL)
	return !NOTFOUND;

    rewind (scoreFile);
    numScores = 0;
    found = NOTFOUND;

    while (!feof (scoreFile)) {
	if (fscanf (scoreFile, SCOREfORMAT,
		    &scores[numScores].userid,
		    &scores[numScores].live,
		    &scores[numScores].fraction,
		    &scores[numScores].played,
		    &scores[numScores].time) == 5) {
	    if (scores[numScores].userid == uid) {
		scores[numScores].played += 1;
		scores[numScores].live += Lives(uncovered, spaces);
		scores[numScores].fraction += Frac(uncovered, spaces);
                if (score < scores[numScores].time )
		    scores[numScores].time = score;
		found = !NOTFOUND;
                player = numScores;
	    }
	    numScores += 1;
	}
    }
    return found;
}


writeScores()
{
    int     i;

    openScores();
    if (scoreFile == NULL) return;

    rewind(scoreFile);		/* okay, so the file never gets shorter */
    for (i = 0; i < numScores; i++) {
        fprintf (scoreFile, SCOREfORMAT, 
	scores[i].userid, 
	scores[i].live, 
	scores[i].fraction, 
	scores[i].played,
	scores[i].time);
    }
    closeScores();
}

newScore(score, uncovered, spaces)
unsigned score;
int uncovered, spaces;
{
    int     i;

    openScores();
#ifndef COHERENT
    if (scoreFile != NULL)
	flock (scoreFile, LOCK_EX);
#endif
    uid = getuid ();

    if (readScores (uid, score, uncovered, spaces) == NOTFOUND) {
        /* first timer */
	scores[numScores].live = Lives(uncovered, spaces);
	scores[numScores].fraction = Frac(uncovered, spaces);
	scores[numScores].played = 1;
	scores[numScores].userid = getuid ();
        scores[numScores].time = score;
        player = numScores;
        numScores += 1;
    }

    writeScores ();
#ifndef COHERENT
    if (scoreFile != NULL)
	flock (scoreFile, LOCK_UN);
#endif
    closeScores();
    
}

#ifdef FRACSCORE
#define BETTER >
#define SCORE fracScore
#define SortScore(i) FracScore (i);
#elif defined( TIMESCORE )
#define BETTER <
#define SCORE time
#define SortScore(i) TimeScore (i);
#else                           /* LIVESCORE */
#define BETTER >
#define SCORE liveScore
#define SortScore(i) LiveScore (i);
#endif

findHighScores()
{
    int     i,
            j;

    float   thisScore;

    for (i = 0; i < HIGHsCORES; i++) {
	highScores[i].liveScore = 0;
	highScores[i].fracScore = 0;
	highScores[i].time = MAXsCORE;
	highScores[i].name = "";
    }

    for (i = 0; i < numScores; i++) {
	thisScore = SortScore (i);
	if ((scores[i].played >= MUSTpLAYED) &&
		(thisScore BETTER highScores[HIGHsCORES - 1].SCORE)) {
	    for (j = HIGHsCORES - 1; j >= 1; j--) {
		if (thisScore BETTER highScores[j - 1].SCORE) {
#ifdef BADcOMPILER		/* can't copy structures */
		    highScores[j].liveScore = highScores[j - 1].liveScore;
		    highScores[j].fracScore = highScores[j - 1].fracScore;
		    highScores[j].time = highScores[j - 1].time;
		    highScores[j].name = highScores[j - 1].name;
#else
		    highScores[j] = highScores[j - 1];
#endif
		}
		else {
		    break;
		}
	    }
	    highScores[j].liveScore = LiveScore (i);
	    highScores[j].fracScore = FracScore (i);
	    highScores[j].time = scores[i].time;
	    highScores[j].name = newstr (getpwuid (scores[i].userid) -> pw_name);
	}
    }
}


#define PRINTfORMAT  "%10s  %4.1f%%  %4.1f%% %5d"

print_scores()
{
    int     i;
    char    s[80];

    if (scoreFile == NULL) return;
    
    findHighScores ();

    sprintf (s, PRINTfORMAT, 
            getpwuid (scores[player].userid) -> pw_name,
            LiveScore (player)*100,
            FracScore (player)*100,
            scores[player].time);
    WriteScore (0, s);

    WriteScore(2,"       Top Scores");
    WriteScore(3,"   Name     %comp  %clear  Time");

    for (i = 0; i < HIGHsCORES; i++) {
	sprintf (s, PRINTfORMAT, 
                highScores[i].name,
	        highScores[i].liveScore*100, 
	        highScores[i].fracScore*100, 
	        highScores[i].time);
	WriteScore (i+5, s);
    }

}



