#ident "@(#)grasp.h	1.10 91/04/03 XGRASP"
/*-
 * grasp.h - random collection of defines and structures...
 *
 * Copyright (c) 1991 by Patrick J. Naughton
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Comments and additions should be sent to the author:
 *
 *                     Patrick J. Naughton
 *                     Sun Microsystems
 *                     2550 Garcia Ave, MS 10-20
 *                     Mountain View, CA 94043
 *                     (415) 336-1080
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/*
#ifdef COHERENT
typedef uchar_t		u_char;
typedef ushort_t	u_short;
typedef uint_t		u_int;
typedef ulong_t		u_long;
#endif
*/

extern char *pname;
extern int  imageloop;
extern int  showdirectory;
extern int  showtext;
extern int  printthecodes;
extern int  verbose;
extern int  imverbose;
extern Display *dsp;
extern Window win;
extern Visual *vis;
extern XVisualInfo vinfo;
extern int  screen;
extern int  planes;
extern GC   gc;
extern GC   gc1;
extern long white;
extern long black;
extern int  currentcolor;
extern Atom protocol_atom;
extern Atom kill_atom;
extern XRectangle window;
extern u_int GetByte();
extern u_int GetWord();
extern u_int GetLong();
extern Colormap CreateEGAcmap();
extern int  videomode;
extern int  spacegap;
extern int  chargap;
extern void lowerstr();
extern char *strdup();

#define NOTOKEN		0
#define BOX		1
#define BREAK		2
#define CALL		3
#define CFADE		4
#define CFREE		5
#define CGETBUF		6
#define CHGCOLOR	7
#define CIRCLE		8
#define CLEARSCR	9
#define CLOAD		10
#define CLOSEGL		11
#define COLOR		12
#define CYCLE		13
#define DATA		14
#define DATABEGIN	15
#define DATAEND		16
#define DATASKIP	17
#define DFREE		18
#define DLOAD		19
#define EDGE		20
#define ELSE		21
#define ENDLFLOAT	22
#define ENDIF		23
#define EXEC		24
#define EXIT		25
#define FFREE		26
#define FGAPS		27
#define FLOAD		28
#define FLOAT		29
#define FLY		30
#define FONT		31
#define FSTYLE		32
#define GETCOLOR	33
#define GETKEY		34
#define GOSUB		35
#define GOTO		36
#define IF		37
#define IFKEY		38
#define IFMEM		39
#define IFMOUSE		40
#define IFVIDEO		41
#define INT		42
#define LINE		43
#define LINK		44
#define LOCAL		45
#define LOOP		46
#define MARK		47
#define MERGE		48
#define MODE		49
#define MOUSE		50
#define MOVE		51
#define NOISE		52
#define NOTE		53
#define OFFSET		54
#define OPENGL		55
#define OUT		56
#define PALETTE		57
#define PAN		58
#define PFADE		59
#define PFREE		60
#define PGETBUF		61
#define PLOAD		62
#define PNEWBUF		63
#define POINT		64
#define POKE		65
#define POKEL		66
#define POKEW		67
#define POP		68
#define POSITION	69
#define PSAVE		70
#define PSETBU		71
#define PUTDFF		72
#define PUTUP		73
#define REC		74
#define RESETGL		75
#define RESETSCR	76
#define RETURN		77
#define REVPAGE		78
#define SEND		79
#define SET		80
#define SETCOLOR	81
#define SETPAGE		82
#define SETRGB		83
#define SETUPSCR	84
#define SPLIT		85
#define SPREAD		86
#define TEXT		87
#define TILE		88
#define TIMER		89
#define TRAN		90
#define VIDEO		91
#define WAITKEY		92
#define WHEN		93
#define WINDOW		94
#define FADE		95
#define WAIT		96
#define NTOKENS		WAIT+1
#define ARG		128
#define INTEGER		ARG+1
#define STRING		ARG+2
#define IMAGE		ARG+3
#define FONTTYPE	ARG+4
#define EXECTYPE	ARG+5
#define WILDTYPE	ARG+6


typedef struct {
    char       *name;
    int         type;
    int         w;
    int         h;
    int         d;
    int         xoff;
    int         yoff;
    Pixmap      pix;
    Colormap    cmap;
    int         cmaplen;
    XColor      colors[256];
}           ImageStruct;

typedef struct {
    Pixmap      pix;
    int         width;
    int         lbearing;
}           GlyphStruct;

typedef struct {
    char       *name;
    int         width;
    int         height;
    GlyphStruct glyphs[256];
}           FontStruct;

typedef struct {
    char        fname[14];
    long        offset;
}           FilenameStruct;

typedef struct {
    int         token;
    union {
	char       *s;
	int         i;
	ImageStruct *image;
	FontStruct *font;
	struct execStruct *exec;
    }           val;
}           ExecAtom;
#define MAXCODES 10240

typedef struct {
    char       *string;
    int         ipaddr;
}           LabelStruct;
#define MAXLABELS 512

typedef struct execStruct {
    char       *name;
    int         numcodes;
    ExecAtom    Code[MAXCODES];
    int         numlabels;
    LabelStruct label[MAXLABELS];
    int         currentdataptr;
    int         currentdataend;
    int         ip;
    char       *txt;
}           ExecStruct;

extern char *tokens[];

#define MAXIMAGES 256
extern ImageStruct *image[MAXIMAGES];
extern int  numimages;

#define MAXFONTS 16
extern FontStruct *font[MAXFONTS];
extern int  numfonts;

#define MAXEXECS 16
extern ExecStruct *exec[MAXEXECS];
extern int  numexecs;

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

/* EGA palette is 6 bit direct color, byte encoded
 * _________________________________
 * | x | x | r | g | b | R | G | B |
 * ---------------------------------
 * where r == "1 part red" and R == "2 parts red", and x's are ignored.
 * where the 0-3 part sequence is 0, 85, 170, 255.
 */
#define decodepal(pal, one, two) ((((pal)&(one))?85:0)+(((pal)&(two))?170:0))

extern u_short egapal[16][3];
extern int  cgapal[3][6];

#define EXT_PIC 0
#define EXT_PCX 1
#define EXT_GIF 2
#define EXT_PAL 3
#define EXT_CLP 4
#define EXT_SET 5
#define EXT_FNT 6
#define EXT_TXT 7

#define YFLIP(y) (picreg[0]->h-(1)-(y))
#define YFLIPIM(y,im) (YFLIP(y)-(im)->h)
