/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef COHERENT
#include <stdlib.h>
#endif

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#include "Clock.h"
#include <X11/Xaw/Mailbox.h>

#include "struct.h"
#include "config.h"

/*
 * Ein Typedef fuer die Menus
 */
typedef struct {
	char		*label;
	void  (*cb)();
} Menu_Glyph, *Menu_Glyph_Ptr;


/*
 * Global variables
 */

extern	Cursor	def_cursor;
extern	Cursor	file_cursor;

extern	Widget	toplevel;

extern	Folder_Glyph	*selc_fo;
extern	Dir_Glyph	*selc_g;
extern	Dimension	selc_f;
extern	Dir_Glyph	root;

extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs;
extern	Dimension	multi_ve;

extern	xfm_struct	defaults;

/*
 * Function Prototypes
 */
extern	void	init_move (char *from, char *to);
extern	void	init_delete (char *file);
extern	void	init_newdir (char *file);
extern	void	init_copy (char *from, char *to);
extern	void	init_setup (Dir_Glyph *dir, File_Glyph *file);
extern	void	init_exec (char *file, char *data);
extern	void	init_info (void);
extern	void	init_goto (void);
extern	void	init_root (void);
extern	void	initAbout (void);

void	makeMenu (Widget parent);

void	start_move (void);
void	start_copy (void);
void	start_delete (void);
void	start_exec (void);
void	start_quit (void);
void	start_newdir (void);
void	start_info (void);
void	start_about (void);
void	start_goto (void);
void	start_root (void);
extern	String	getPath(Dir_Glyph *dir);
char	*getString(void);
char	*getMulti(void);
extern	void	makeIconBar (Widget parent, Widget left, Boolean HIDE);


/*
 * Hier stehen die Menus
 */
Menu_Glyph	main_menu[] = {
	{"Execute ...",		start_exec},
	{"LINE",		NULL},
	{"Show Dir",		start_goto},
	{"Change Root",		start_root},
	{"LINE",		NULL},
	{"About",		start_about},
	{"Quit",		start_quit},
	{NULL,			NULL},
};

Menu_Glyph	setup_menu[] = {
	{"Associate Filetype",	NULL},
	{"LINE",		NULL},
	{"Configuration",	NULL},
	{NULL,			NULL},
};

String		menun[] = {"File"}; /*"Setup"}; */
Menu_Glyph_Ptr	menus[] = {main_menu}; /*,setup_menu};*/


/*
**	Function name : makeMenu
**
**	Description : erzeugt auf einem Parent eine Form, in der
**			das Controlmenu gesetzt wird.
**	Input : Widget	parent	- Zeiger auf das Parentwidget
**	Ouput : none
*/
void makeMenu (Widget parent)
{
	Widget	form;
	Widget	last, new;
	Arg	args[10];
	int	i;

	/*
	 * Erst die Widgetform erzeugen
	 */
	XtSetArg(args[0],XtNshowGrip, FALSE);
	form = XtCreateManagedWidget ("menu_form", formWidgetClass,
					parent, args, 1);

	last = NULL;
	for (i = 0; i < XtNumber(menun); i++) {
		char	*buf;
		char	*nbuf;
		int	j;
		Widget	menu;
		Widget	but;
		Menu_Glyph	*mm;

		/*
		 * Zunaechst einmal den Menubutton erzeugen
		 */
		if (!(buf = (char *) malloc (30)) ||
		    !(nbuf = (char *) malloc (30)))
			FATAL_ERROR ("makeMenu: Malloc failed\n");
		sprintf(buf,"%s_menu",menun[i]);
		sprintf(nbuf,"%s_button",menun[i]);

		XtSetArg(args[0],XtNfromHoriz, last);
		XtSetArg(args[1],XtNlabel, menun[i]);
		XtSetArg(args[2],XtNmenuName,buf);
		XtSetArg(args[3],XtNtop,XtChainTop);
		XtSetArg(args[4],XtNbottom,XtChainTop);
		XtSetArg(args[5],XtNright,XtChainLeft);
		XtSetArg(args[6],XtNleft,XtChainLeft);
		XtSetArg(args[7],XtNwidth,60);
		XtSetArg(args[8],XtNheight,32);
		new = XtCreateManagedWidget ("menu_but", menuButtonWidgetClass,
					     form, args, 9);

		/*
		 * Jetzt das Menu erzeugen
		 */
		menu = XtCreateManagedWidget (buf, simpleMenuWidgetClass,
						toplevel, args, 0);

		mm = (Menu_Glyph *) menus[i];
		/*
		 * Nun die Menuitems erzeugen
		 */
		for (j = 0; mm[j].label; j++) {
			if (strcmp(mm[j].label,"LINE")) {
				XtSetArg(args[0],XtNlabel,mm[j].label);
				but = XtCreateManagedWidget ("menu_item",
							    smeBSBObjectClass,
							    menu, args, 1);
				if (mm[j].cb)
					XtAddCallback (but, XtNcallback,
							(XtCallbackProc) mm[j].cb,
							NULL);
			}
			else {
				but = XtCreateManagedWidget ("menu_line",
							    smeLineObjectClass,
							    menu, args, 0);
			}
		}
		last = new;
	}
	makeIconBar(form,last,FALSE);
	XtVaCreateManagedWidget("clock",clockWidgetClass, form,
				XtNwidth, 34,
				XtNheight, 34,
				XtNleft, XawChainRight,
				XtNright, XawChainRight,
				XtNtop, XawChainTop,
				XtNbottom, XawChainBottom,
				XtNhorizDistance, (defaults.multi_window ? 360 : 860),
				XtNshapeWindow, FALSE,
				NULL);
}


/*********************************************************
 * name:	getString
 * description:	gibt den vollen Filenamen der selection zurueck
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
char	*getString(void)
{	char	*from = NULL;

	if (selc_g || (selc_fo && selc_f < 16000)) {
		if (selc_g)
			from = getPath(selc_g);
		else {
			char *got = getPath(selc_fo->dir);

			if (!(from = (char *) malloc (strlen(got) + 4 +
						      strlen (selc_fo->file[selc_f]->name))))
				FATAL_ERROR("start_delete: Malloc faileed\n");
			if (strcmp(got,"/"))
				sprintf(from,"%s/%s",got,selc_fo->file[selc_f]->name);
			else
				sprintf(from,"/%s",selc_fo->file[selc_f]->name);
			free(got);
		}
	}
	return(from);
}


/*********************************************************
 * name:	getMulti
 * description:	Auslesen des Mutliarrays
 * input:	none	
 * output:	char	*multi-string
 * author:	Ove Kalkan
 * date:	3.8.1993
 *********************************************************/
char	*getMulti(void)
{	char	*back = NULL;

/*	if (multi_fo && multi_vs < 16000 && multi_ve < 16000) {
		int	i;
		char	*got;
		got = getPath(multi_fo->dir);

		for (i = multi_vs; i <= multi_ve; i++) {
			if (!(back = (char *) realloc((void *) back, strlen(back) +
				strlen(got) + strlen(multi_fo->file[i]->name) + 4)))
				FATAL_ERROR("GetMulti: realloc failed.");
			if (strcmp(got,"/"))
				sprintf(back,"%s %s/%s\0",back,got,multi_fo->file[i]->name);
			else
				sprintf(back,"%s /%s\0",back,multi_fo->file[i]->name);
		}
		free(got);
	}
*/	return(back);
}

/*********************************************************
 * name:	start_move
 * description:	Ruft die init_move routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_move (void)
{
	char	*from = NULL;

	from = getString();
	init_move(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_copy
 * description:	Ruft die init_copy routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_copy (void)
{
	char	*from = NULL;

	from = getString();
	init_copy(from,NULL);
	free(from);
}


/*********************************************************
 * name:	start_delete
 * description:	Ruft die init_delete routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_delete (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getMulti();
	init_delete(from);
	free(from);
}


/*********************************************************
 * name:	start_newdir
 * description:	Ruft die init_newdir routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_newdir (void)
{
	char	*from = NULL;

	from = getString();
	if (!from)
		from = getPath (&root);
	init_newdir(from);
	free(from);
}



/*********************************************************
 * name:	start_exec
 * description:	Ruft die init_exec routine mit den
 *		richtigen Parametern auf. Wenn etwas mit
 *		einem single-select selectiert wurde, so
 *		wird der Filename als Argument uebergeben
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 ********************************************************/
void	start_exec (void)
{
	char	*from = NULL;

	from = getString();
	init_exec(from,NULL);
	if (from)	free(from);
}


/*********************************************************
 * name:	start_quit
 * description:	Ruft die init_quit
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.93
 *********************************************************/
void	start_quit (void)
{
	init_quit();
}

/*********************************************************
 * name:	start_about
 * description:	Ruft die initAbout routine
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.93
 *********************************************************/
void	start_about (void)
{
	initAbout();
}

/*********************************************************
 * name:	start_info
 * description:	ruft init_info auf
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	18.6.1993
 *********************************************************/
void	start_info(void)
{
	if (selc_g || (selc_f && selc_fo))
		init_info();
}

/*********************************************************
 * name:	start_goto
 * description:	displays the goto-requester
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_goto(void)
{
	init_goto ();
}


/*********************************************************
 * name:	start_root
 * description:	displays the change_root-dialog
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
void	start_root(void)
{
	init_root();
}
