# Program: xf
# Description: global routines (not xf specific)
#
# $Header: xfglobals.tcl[2.2] Mon Mar  8 01:57:16 1993 garfield@garfield frozen $

proc Alias {args} {# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}

proc Unalias {aliasName} {# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}

proc GetSelection {} {# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}

proc MenuPopupAdd {xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  set tk_popupPriv($xfMenu,button) $xfButton
  set tk_popupPriv($xfMenu,canvasTag) $xfCanvasTag
  if {"$xfModifier" != ""} {
    set tk_popupPriv($xfMenu,press) "$xfModifier-"
    set tk_popupPriv($xfMenu,motion) "$xfModifier-"
    set tk_popupPriv($xfMenu,release) "Any-"
  } {
    set tk_popupPriv($xfMenu,press) ""
    set tk_popupPriv($xfMenu,motion) ""
    set tk_popupPriv($xfMenu,release) ""
  }

  if {"$tk_popupPriv($xfMenu,canvasTag)" == ""} {
    bind $xfW "<$tk_popupPriv($xfMenu,press)ButtonPress-$tk_popupPriv($xfMenu,button)>" "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<$tk_popupPriv($xfMenu,release)ButtonRelease-$tk_popupPriv($xfMenu,button)>" "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $tk_popupPriv($xfMenu,canvasTag) "<$tk_popupPriv($xfMenu,press)ButtonPress-$tk_popupPriv($xfMenu,button)>" "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $tk_popupPriv($xfMenu,canvasTag) "<$tk_popupPriv($xfMenu,release)ButtonRelease-$tk_popupPriv($xfMenu,button)>" "MenuPopupRelease $xfMenu %W"
  }
}

proc MenuPopupPost {xfMenu xfX xfY} {# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {"$tk_popupPriv($xfMenu,focus)" == ""} {
      set tk_popupPriv($xfMenu,focus) [focus]
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    bind $xfMenu "<$tk_popupPriv($xfMenu,motion)B$tk_popupPriv($xfMenu,button)-Motion>" "MenuPopupMotion $xfMenu %W %X %Y"
    bind $xfMenu "<$tk_popupPriv($xfMenu,release)ButtonRelease-$tk_popupPriv($xfMenu,button)>" "MenuPopupRelease $xfMenu %W"
    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}

proc MenuPopupMotion {xfMenu xfW xfX xfY} {# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          bind [lindex $result 4] "<$tk_popupPriv($xfMenu,motion)B$tk_popupPriv($xfMenu,button)-Motion>" "MenuPopupMotion $xfMenu %W %X %Y"
          bind [lindex $result 4] "<$tk_popupPriv($xfMenu,release)ButtonRelease-$tk_popupPriv($xfMenu,button)>" "MenuPopupRelease $xfMenu %W"
        }
      }
    } {
      $xfW activate none
    }
  }
}

proc MenuPopupRelease {xfMenu xfW} {# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; $xfMenu unpost
    }
  }
  catch "$xfMenu unpost"
}

proc NoFunction args {# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########

}

proc SymbolicName {{xfName ""}} {# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}

proc SN {{xfName ""}} {# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}

# eof

