
/*
 * xanim_dl.c
 *
 * Copyright (C) 1990,1991,1992,1993,1994 by Mark Podlipec. 
 * All rights reserved.
 *
 * This software may be freely copied, modified and redistributed
 * without fee provided that this copyright notice is preserved 
 * intact on all copies and modified copies.
 * 
 * There is no warranty or other guarantee of fitness of this software.
 * It is provided solely "as is". The author(s) disclaim(s) all
 * responsibility and liability with respect to this software's usage
 * or its effect upon hardware or computer systems.
 *
 */

#include "xanim_dl.h"

XA_CHDR   *ACT_Get_CMAP();
XA_ACTION *ACT_Get_Action();
void  ACT_Setup_Mapped();
void  ACT_Add_CHDR_To_Action();
void  ACT_Setup_Loop();
LONG  UTIL_Get_LSB_Short();
ULONG UTIL_Get_LSB_Long();
void  UTIL_Sub_Image();

static ULONG dl_version;
static ULONG dl_format;
static ULONG dl_time;
static UBYTE dl_title[21];
static UBYTE dl_author[21];
static ULONG dl_num_of_screens;
static ULONG dl_num_of_images;
static ULONG dl_ims_per_screen;
static ULONG dl_num_of_frames;
static ULONG dl_frame_cnt;
static ULONG dl_loop_frame;
static XA_ACTION **dl_frame_lst;
static ULONG dl_imagex,dl_imagey,dl_imagec;

static ColorReg dl_cmap[DL_MAX_COLORS];

static XA_ACTION **dl_acts;
static XA_CHDR *dl_chdr;
static ULONG dl_image_cnt;

/*
 *
 */
LONG Is_DL_File(filename)
char *filename;
{
  FILE *fin;
  ULONG data0,data1;

  if ( (fin=fopen(filename,"r")) == 0) return(FALSE);
  data0 = fgetc(fin);
  data1 = fgetc(fin);
  fclose(fin);
  if (data0 == 0x01) return(TRUE);
  if (data0 == 0x02)
  {
    if ( (data1 >= 0x00) && (data1 <= 0x02) ) return(TRUE);
  }
  return(FALSE);
}

/*
 *
 */
void DL_Read_File(fname,anim_hdr)
XA_ANIM_HDR *anim_hdr;
char *fname;
{
  FILE *fin;
  LONG i,j,ret,tmp;
  XA_ACTION *act;
  UBYTE *pic;
  ULONG pic_size;
  XA_ACTION *prev_end_act;

  dl_chdr = 0;
  dl_acts = 0; 
  dl_ims_per_screen = 1;

  if ( (fin = fopen(fname,"r")) == 0)
  { 
    fprintf(stderr,"DL_Read_File: Can't open %s for reading.\n",fname); 
    TheEnd();
  }

  dl_version = fgetc(fin);  /* either 1 or 2 */

  switch(dl_version)
  {
    case DL_VERSION_1:
		dl_format = DL_FORM_MEDIUM;
		break;
    case DL_VERSION_2:
		dl_format = fgetc(fin);
		break;
    default:
		break;
  }

  switch(dl_format)
  {
    case DL_FORM_LARGE:
	dl_imagex = DL_LARGE_XSIZE;
	dl_imagey = DL_LARGE_YSIZE;
	dl_ims_per_screen = 1;
	break;
    case DL_FORM_MEDIUM:
	dl_imagex = DL_MEDIUM_XSIZE;
	dl_imagey = DL_MEDIUM_YSIZE;
	dl_ims_per_screen = 4;
	break;
    case DL_FORM_SMALL:
	dl_imagex = DL_SMALL_XSIZE;
	dl_imagey = DL_SMALL_YSIZE;
	dl_ims_per_screen = 16;
	break;
    default:
	fprintf(stderr,"DL_Read_File: unknown format %lx\n",dl_format);
	TheEnd();
	break;
  }

  dl_title[20] = 0;
  for(i=0; i<20; i++) 
  {
    tmp = fgetc(fin);
    dl_title[i] = (tmp)?(tmp ^ 0xff):tmp;
  }

  dl_author[0] = dl_author[20] = 0;
  if (dl_version == DL_VERSION_2)
  {
    for(i=0; i<20; i++)
    {
      tmp = fgetc(fin);
      dl_author[i] = (tmp)?(tmp ^ 0xff):tmp;
    }
  }

  dl_num_of_screens = fgetc(fin);
/*
  dl_num_of_images = dl_num_of_screens * (dl_format * 3 + 1);
*/
  dl_num_of_images = dl_num_of_screens * dl_ims_per_screen;

  if (dl_version == DL_VERSION_1)
     dl_num_of_frames = UTIL_Get_LSB_Short(fin);
  else
     dl_num_of_frames = UTIL_Get_LSB_Long(fin);

  if (xa_verbose == TRUE)
  {
    fprintf(stderr,"   Version %ld  Format %ld",dl_version,dl_format);
    fprintf(stderr," Images %ld  Frames %ld\n",
			dl_num_of_images, dl_num_of_frames );
    fprintf(stderr,"   Title = %s  Author = %s\n",dl_title,dl_author);
  }

  dl_imagec = DL_MAX_COLORS;
  for(i=0; i < DL_MAX_COLORS; i++)
  {
    dl_cmap[i].red   = fgetc(fin) & 0x3f;
    dl_cmap[i].green = fgetc(fin) & 0x3f;
    dl_cmap[i].blue  = fgetc(fin) & 0x3f;
  }
  dl_chdr = ACT_Get_CMAP(dl_cmap,DL_MAX_COLORS,0,DL_MAX_COLORS,0,6,6,6);
  
  pic_size = dl_imagex * dl_imagey;
  dl_time = XA_GET_TIME(100);

  dl_acts = (XA_ACTION **)malloc(dl_num_of_images * sizeof(XA_ACTION *));
  dl_image_cnt = 0;

  for(j = 0; j < dl_num_of_screens; j++)
  {
    switch(dl_format)
    {
      case DL_FORM_LARGE: /* large */
	pic = (UBYTE *) malloc( XA_PIC_SIZE(pic_size) );
	if (pic == 0) TheEnd1("DL: malloc failed.\n");
        ret = fread(pic, pic_size, 1, fin);
	if (ret != 1) TheEnd1("DL: read of image failed format 0");
	DEBUG_LEVEL2 fprintf(stderr,"Read large format image\n");
        act = ACT_Get_Action(anim_hdr);
	dl_acts[dl_image_cnt] = act;  dl_image_cnt++;
	ACT_Setup_Mapped(act,pic,dl_chdr,0,0,dl_imagex,dl_imagey,
		dl_imagex,dl_imagey,FALSE,0,TRUE,FALSE,FALSE);
	ACT_Add_CHDR_To_Action(act,dl_chdr);
	break;

      case DL_FORM_MEDIUM: /* medium */
      case DL_FORM_SMALL: /* medium */
	{
	  ULONG x,y;
	  UBYTE *t_pic;

	  tmp = DL_LARGE_XSIZE * DL_LARGE_YSIZE;
	  pic = (UBYTE *) malloc( tmp );
	  if (pic == 0) TheEnd1("DL: malloc failed.\n");
          ret = fread(pic, tmp , 1, fin);
	  if (ret != 1) TheEnd1("DL: read of image failed format 1");
	  DEBUG_LEVEL2 fprintf(stderr,"Read small/medium image\n");

          for(y = 0; y < DL_LARGE_YSIZE; y += dl_imagey)
            for(x = 0; x < DL_LARGE_XSIZE; x += dl_imagex)
	    {
	      t_pic = (UBYTE *) malloc( XA_PIC_SIZE(pic_size) );
	      if (t_pic == 0) TheEnd1("DL: malloc failed.\n");
	      UTIL_Sub_Image(t_pic,pic,dl_imagex,dl_imagey, x, y,(DL_LARGE_XSIZE),1);
	      act = ACT_Get_Action(anim_hdr);
	      dl_acts[dl_image_cnt] = act;  dl_image_cnt++;
	      ACT_Setup_Mapped(act,t_pic,dl_chdr, 0,0,dl_imagex,dl_imagey,
			dl_imagex,dl_imagey,FALSE,0,TRUE,FALSE,FALSE);
	      ACT_Add_CHDR_To_Action(act,dl_chdr);
	    }
	}
	break;
   }
 }

 dl_frame_lst = (XA_ACTION **)malloc( dl_num_of_frames * sizeof(XA_ACTION *) );
 if (dl_frame_lst == 0) TheEnd1("DL_Read_File: malloc failed");

 prev_end_act = 0;
 dl_loop_frame = 0;
 switch(dl_version)
 {
   case DL_VERSION_1:
	dl_frame_cnt = 0;
	for(i=0; i < dl_num_of_frames; i++)
	{
	  register ULONG tmp;
	  tmp = fgetc(fin);
	  tmp = (tmp % 10) - 1 + ((tmp / 10) - 1) * 4;
	  dl_frame_lst[dl_frame_cnt] = dl_acts[tmp]; 
	  dl_frame_cnt++;
	}
	break;
   case DL_VERSION_2:
	{
	  DEBUG_LEVEL2 fprintf(stderr," DL reading frame lst: ");
	  dl_frame_cnt = 0;
	  i = 0;
	  while(i < dl_num_of_frames)
	  {
	    register ULONG tmp;
	    tmp  =  fgetc(fin); tmp |=  ( fgetc(fin) << 8); i++;
	    DEBUG_LEVEL2 fprintf(stderr,"\t<%ld %lx>",i,tmp);

	    if (tmp & 0x8000)
	    {
	      switch(tmp)
	      {
		case 0xffff:
		  {
		    ULONG cnt;
		    XA_ACTION *begin_act,*end_act;
		    ACT_END_LP_HDR *end_lp;

		    cnt  =  fgetc(fin); cnt |=  ( fgetc(fin) << 8); i++;
		    DEBUG_LEVEL2 fprintf(stderr,"begin loop %ld",cnt);
		    begin_act = ACT_Get_Action(anim_hdr,0);
		    end_act = ACT_Get_Action(anim_hdr,0);
	            dl_frame_lst[dl_frame_cnt] = begin_act;
	            dl_frame_cnt++;
		    ACT_Setup_Loop(begin_act,end_act,cnt,dl_frame_cnt,
				0);
		    end_lp = (ACT_END_LP_HDR *)end_act->data;
		    end_lp->prev_end_act = prev_end_act;
		    prev_end_act = end_act;  /* nest loops */
		  }
		  break;
		case 0xfffe:
		  {
		    ACT_END_LP_HDR *end_lp;
		    end_lp = (ACT_END_LP_HDR *)prev_end_act->data;
		    if (dl_frame_cnt > 0)
			*end_lp->end_frame = dl_frame_cnt - 1;
		    else *end_lp->end_frame = 0;

	            dl_frame_lst[dl_frame_cnt] = prev_end_act;
	            dl_frame_cnt++;
			/* unnest loops */
		    prev_end_act = end_lp->prev_end_act;
		    DEBUG_LEVEL2 fprintf(stderr,"end loop ");
		  }
		  break;
		case 0xfffd:
			tmp  =  fgetc(fin); tmp |=  ( fgetc(fin) << 8); i++;
			DEBUG_LEVEL2 fprintf(stderr,"key press %lx\n",tmp);
			break;
		default:
			fprintf(stderr,"unknown code %lx\n",tmp);
			break;
		}
	    }
	    else
	    {
	      if (tmp < dl_image_cnt)
	      {
	        dl_frame_lst[dl_frame_cnt] = dl_acts[tmp];
	        dl_frame_cnt++;
	      }
	      else
	      {
		fprintf(stderr,"   unknown code - ignored. %lx\n",tmp);
	      }
	    }
	  }
	  DEBUG_LEVEL2 fprintf(stderr,"\n");
	  if (dl_loop_frame >= dl_frame_cnt) dl_loop_frame = 0;
	}
	break;
  }
  anim_hdr->frame_lst = 
	(XA_FRAME *)malloc(sizeof(XA_FRAME) * (dl_frame_cnt + 1) ); 
  if (anim_hdr->frame_lst == NULL)
      TheEnd1("DL_ANIM: couldn't malloc for frame_lst\0");

  for(i=0; i < dl_frame_cnt; i++) 
  {
    anim_hdr->frame_lst[i].act  = dl_frame_lst[i];
    if (   (dl_frame_lst[i]->type == ACT_BEG_LP)
        || (dl_frame_lst[i]->type == ACT_END_LP) )
		    anim_hdr->frame_lst[i].time = 0;
    else anim_hdr->frame_lst[i].time = dl_time;
  }
  anim_hdr->frame_lst[dl_frame_cnt].time = 0;
  anim_hdr->frame_lst[dl_frame_cnt].act  = 0;
  anim_hdr->loop_frame = dl_loop_frame;
  anim_hdr->last_frame = dl_frame_cnt-1;
  anim_hdr->imagex = dl_imagex;
  anim_hdr->imagey = dl_imagey;
  anim_hdr->imagec = dl_imagec;
  anim_hdr->imaged = 8; /* nop */

  FREE(dl_frame_lst,0x5000); dl_frame_lst=0;
  FREE(dl_acts,0x5001); dl_acts=0;
}

