
/*
 * xanim_avi.h
 *
 * Copyright (C) 1993,1994 by Mark Podlipec. 
 * All rights reserved.
 *
 * This software may be freely copied, modified and redistributed
 * without fee provided that this copyright notice is preserved 
 * intact on all copies and modified copies.
 * 
 * There is no warranty or other guarantee of fitness of this software.
 * It is provided solely "as is". The author(s) disclaim(s) all
 * responsibility and liability with respect to this software's usage
 * or its effect upon hardware or computer systems.
 *
 */

#include "xanim.h"

#define RIFF_RIFF 0x52494646
#define RIFF_LIST 0x4C495354
#define RIFF_avih 0x61766968
#define RIFF_strd 0x73747264
#define RIFF_strh 0x73747268
#define RIFF_strf 0x73747266
#define RIFF_vedt 0x76656474
#define RIFF_JUNK 0x4A554E4B
#define RIFF_00dc 0x30306463
#define RIFF_00db 0x30306462
#define RIFF_00xx 0x30307878
#define RIFF_01wb 0x30317762
#define RIFF_idx1 0x69647831
#define RIFF_CRAM 0x4352414D
/* the BI_RGB compression code for uncompressed bitmaps */
#define RIFF_RGB  0x00000000
 
#define RIFF_AVI  0x41564920
#define RIFF_hdrl 0x6864726C
#define RIFF_strl 0x7374726C
#define RIFF_DISP 0x44495350
#define RIFF_ISBJ 0x4953424a

/* fcc Types */
#define RIFF_vids 0x76696473
#define RIFF_auds 0x61756473
 
/* fcc handlers */
#define RIFF_RLE  0x524C4432
#define RIFF_msvc 0x6D737663

typedef struct
{
  ULONG ckid;
  ULONG flags;
  ULONG chunk_offset;   /* position of chunk rel to movi list include 8b hdr*/
  ULONG chunk_size;     /* length of chunk excluding 8 bytes for RIFF hdr */
} AVI_INDEX_ENTRY;

/* Flags for AVI_INDEX_ENTRY */
#define AVIIF_LIST          0x00000001L
#define AVIIF_TWOCC         0x00000002L
        /* keyframe doesn't need previous info to be decompressed */
#define AVIIF_KEYFRAME      0x00000010L
        /* this chunk needs the frames following it to be used */
#define AVIIF_FIRSTPART     0x00000020L
        /* this chunk needs the frames before it to be used */
#define AVIIF_LASTPART      0x00000040L
#define AVIIF_MIDPART       (AVIIF_LASTPART|AVIIF_FIRSTPART)
        /* this chunk doesn't affect timing ie palette change */
#define AVIIF_NOTIME        0x00000100L
#define AVIIF_COMPUSE       0x0FFF0000L
 
typedef struct
{
  ULONG us_frame;       /* MicroSecPerFrame - timing between frames */
  ULONG max_bps;        /* MaxBytesPerSec - approx bps system must handle */
  ULONG pad_gran;       /* */
  ULONG flags;          /* Flags */
  ULONG tot_frames;     /* TotalFrames */
  ULONG init_frames;    /* InitialFrames - initial frame before interleaving */
  ULONG streams;        /* Streams */
  ULONG sug_bsize;      /* SuggestedBufferSize */
  ULONG width;          /* Width */
  ULONG height;         /* Height */
  ULONG scale;          /* Scale */
  ULONG rate;           /* Rate */
  ULONG start;          /* Start */
  ULONG length;         /* Length */
} AVI_HDR;
 
/* AVI_HDR Flags */
        /* had idx1 chunk */
#define AVIF_HASINDEX           0x00000010
        /* must use idx1 chunk to determine order */
#define AVIF_MUSTUSEINDEX       0x00000020
        /* AVI file is interleaved */
#define AVIF_ISINTERLEAVED      0x00000100
        /* specially allocated used for capturing real time video */
#define AVIF_WASCAPTUREFILE     0x00010000
        /* contains copyrighted data */
#define AVIF_COPYRIGHTED        0x00020000
 
 
typedef struct
{
  ULONG fcc_type;       /* fccType  {vids} */
  ULONG fcc_handler;    /* fccHandler {msvc,RLE} */
  ULONG flags;          /* Flags */
  ULONG priority;       /* Priority*/
  ULONG init_frames;    /* InitialFrames */
  ULONG scale;          /* Scale */
  ULONG rate;           /* Rate */
  ULONG start;          /* Start */
  ULONG length;         /* Length In units above...*/
  ULONG sug_bsize;      /* SuggestedBufferSize */
  ULONG quality;        /* Quality */
  ULONG samp_size;      /* SampleSize */
} AVI_STREAM_HDR;
/* AVI_STREAM_HDR Flags */
#define AVISF_DISABLED                  0x00000001
#define AVISF_VIDEO_PALCHANGES          0x00010000
 
 
typedef struct /* BitMapInfoHeader */
{
  ULONG size;           /* Size */
  ULONG width;          /* Width */
  ULONG height;         /* Height */
  ULONG planes;         /* short Planes */
  ULONG bit_cnt;        /* short BitCount */
  ULONG compression;    /* Compression {1} */
  ULONG image_size;     /* SizeImage */
  ULONG xpels_meter;    /* XPelsPerMeter */
  ULONG ypels_meter;    /* XPelsPerMeter */
  ULONG num_colors;     /* ClrUsed */
  ULONG imp_colors;     /* ClrImportant */
} VIDS_HDR;
 

typedef struct AVI_FRAME_STRUCT
{
  ULONG time;
  XA_ACTION *act;
  struct AVI_FRAME_STRUCT *next;
} AVI_FRAME;

