.TH TETRIS 6 "19 Jan 1993, V2.1" "Univ of Arizona"
.SH NAME
GENERIC TETRIS \- Yet Another Tetris Game on X
.SH SYNOPSIS
.B tetris
[-s] [-l <start level>] [-p <prefilled lines>] [-showNext] [-beep]
[-display <display>] [-geometry <geometry>] [-iconGeometry <geometry>]
[-{background | bg} <color>] [-{foreground | fg} <color>] [-bigFont
<font>] [-tinyFont <font>] [-u <name>] [-xrm <resource specification>]
.SH DESCRIPTION
.LP
One of the motivations of this tetris program is simplicity. It does
not have many fancy features but the blocks are big enough so player
can feel comfortable.
.LP
The program lists the top 15 players at the end, each player may has at
most three scores. With the option \fB\-s\fP, it shows all the players
and scores.
.LP
Key "\fBj\fP" moves the block left, "\fBl\fP" moves right,
"\fBk\fP" rotates. Left-handed people may want to use "\fBs\fP",
"\fBd\fP", "\fBf\fP" respectively. Or maybe someone wants to try the
arrow keys...  The space bar drops a block quickly. Use "\fBCTRL-L\fP"
key combination to redraw \- in case the program messes somthing up.
.LP
As usual, "\fB+\fP" and "\fB\-\fP" speed up or lower down the speed. Note
that you don't need to press the "\fISHIFT\fP" key \- "\fB=\fP" and
"\fB_\fP" also work. The "\fBb\fP" key toggles "beep", and "\fBn\fP"
toggles "show next".
.LP
If you press "\fBp\fP", the game will be paused, and the window
will be iconified \- just in case your boss suddenly appears at your
door ;o). When the tetris window loses its focus, it also goes to
"paused" mode except it doesn't iconify itself.
.LP
To get high scores, don't use "show next" mode, try starting at a
higher level and try to let "tetris" eat more than one line at a time.
.SH OPTIONS
.PP
.TP 8
.B \-s
This option lets the program only list all the recorded scores then exit.
.TP 8
.B \-u \fIname\fP
This option sets alternative player name.
.TP 8
.B \-l \fIlevel\fP
This option starts the program at the specified level (resource name
"\fIstartLevel\fP").
.TP 8
.B \-p \fIlines\fP
This option indicates that the program should start with some of the lines
being randomly filled (resource name "\fIpreFilledLines\fP").
.TP 8
.B \-showNext
This option tells the program start in "show next" mode (resource name
"\fIshowNext\fP").
.TP 8
.B \-beep
This option turns the sound on (resource name "\fIbeep\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the tetris window (resource
name "\fIgeometry\fP").
.TP 8
.B \-iconGeometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the position of the icon (resource name "\fIiconGeometry\fP").
.TP 8
.B \-{background | bg} \fIcolor\fP
This option specifies the background of the tetris window (resource name
"\fIbackground\fP").
.TP 8
.B \-{foreground | fg} \fIcolor\fP
This option specifies the foreground of the tetris window (resource name
"\fIforeground\fP").
.TP 8
.B \-bigFont \fIfont\fP
This option sets the font used in drawing titles and important messages
(resource name "\fIbigFont\fP").
.TP 8
.B \-tinyFont \fIfont\fP
This option sets the font used in drawing status information
(resource name "\fItinyFont\fP").
.TP 8
.B \-xrm <\fIresource specification\fP>
Another method of specifying preferences.
.PP
.SH "SEE ALSO"
.LP
X(1), xtetris(1), xmris(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1992-93, Qiang Alex Zhao, University of Arizona.
.SH "BUG REPORTS AND PROGRAM UPDATES"
.LP
Send bugs (or their reports, or fixes) to the author (note: my first
name is NOT spelled as "Quiang"):
.RS
Qiang Alex Zhao,	<\fIazhao@cs.arizona.edu\fP>
.br
Computer Science Department
.br
University of Arizona
.br
Tucson, AZ 85721
.RE
.LP
The most updated source could be found on \fIexport.lcs.mit.edu\fP under
\fI/contrib\fP.
.SH ACKNOWLEDGEMENTS
.LP
Thanks go to people who helped me in improving the program.
