.\"	@(#) zoo.1 2.44 88/08/25 16:05:30 */
.\"
.\" For formatting with nroff:
.\"   tbl zoo.1 | nroff -man | col
.\" It should be possible to use troff instead of nroff but I haven't
.\" confirmed this.  R.D.
.\"
.TH ZOO 1 "Aug 25, 1988"
.de sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.SH NAME
.PP
zoo \- manipulate archives of files in compressed form
.SH SYNOPSIS
.PP
.B zoo 
.RB { acfDeghlLPTuUvVx }[ aAcCdEfgImMnNoOpPqSu1:/.@n+\-= ]
archive [file] ...
.sp 0
.B zoo \-command 
archive [file] ...
.sp 0
.B zoo h
.SH DESCRIPTION
.PP
.I Zoo
is used to create and maintain collections of files in compressed form.
It uses a Lempel-Ziv compression algorithm that gives space savings
in the range of 20% to 80% depending on the type of file data.
.I Zoo
can store and selectively extract
multiple generations of the same file.  Data can be recovered
from damaged archives by skipping the damaged portion
and locating undamaged data with the help of
.I fiz(1).
.PP
This documentation is for version 2.01.  Changes from previous
versions are described in the section labelled
.BR CHANGES .
.PP
The command
.I zoo 
.B h
gives summary of commands.
.PP
.I Zoo 
will not add an archive to itself, nor add the
archive's backup (with 
.B .bak 
extension to the filename) to the archive.
.PP
.I Zoo 
has two types of commands:  Expert commands, which consist of one command 
letter followed by zero or more modifier characters, and Novice commands, 
which consist of a hyphen (`\-') followed by a command word that may
be abbreviated.  Expert commands are case-sensitive but Novice commands
are not.
.PP
When 
.I zoo
adds a file to an existing archive, the default action is to maintain 
one generation of each file in an archive and 
to mark any older generation as deleted.  A limit on the number
of generations to save can be specified by the user for
an entire archive, or for each file individually, or both.
.I
Zoo
deletes a stored copy of an added file if necessary to prevent 
the number of stored generations from exceeding the user-specified limit.
.PP
Deleted files may be later undeleted.
Archives may be packed to recover space occupied by deleted files.
.PP
All commands assume that the archive name ends with the characters
.B .zoo
unless a different extension is supplied.  
.PP
.B Novice commands
.PP
Novice commands may be abbreviated to a hyphen followed by at least
one command character.  Each Novice command works in two stages. 
First, the command does its intended work.  Then, if the result was
that one or more files were deleted in the specified archive, the
archive is packed.  If packing occurs, the original unpacked archive
is always left behind with an extension of
.BR .bak .
.PP
No Novice command ever stores the directory prefix of a file.
.PP
The Novice commands are as follows.
.PP
.B \-add
.br
Adds the specified files to the archive.
.PP
.B \-freshen
.br
Adds a specified file to the archive if and only if an older file by
the same name already exists in the archive.
.PP
.B \-delete
.br
Deletes the specified files from the archive.
.PP
.B \-update
.br
Adds a specified file to the archive either:  if an older file by
the same name already exists in the archive or:  if a file by the
same name does not already exist in the archive.
.PP
.B \-extract
.br
Extracts the specified files from the archive.  If no file is specified
all files are extracted.
.PP
.B \-move
.br
Equivalent to 
.B \-add
except that source files are deleted after addition.
.PP
.B \-print
.br
Equivalent to 
.B \-extract
except that extracted data are sent to standard output.
.PP
.B \-list
.br
Gives information about the specified archived files including any
attached comments.  If no files are
specified all files are listed.  Deleted files are not listed.
.PP
.B \-test
.br
Equivalent to
.B \-extract
except that the extracted data are not saved but any errors encountered
are reported.
.PP
.B \-comment
.br
Allows the user to add or update comments attached to archived files.
When prompted, the user may:  type a carriage return to skip the file,
leaving any
current comment unchanged;  or type a (possibly null) comment of up
to 65,535 characters terminated 
by
.B /end
(case-insensitive) on
a separate line;  or type the end-of-file character (normally control D)
to skip all remaining files. 
.PP
.B \-delete
.br
Deletes the specified files.
.PP
.ne 15
.nf
The correspondence between Novice and Expert commands is as follows.
.sp 1
Novice						 Equivalent
Command		Description			 Expert Command
===============================================================
\-add		add files to archive		 aP:
\-extract	extract files from archive	 x
\-move		move files to archive		 aMP:
\-test		test archive integrity		 xNd
\-print		extract files to standard output xp
\-delete		delete files from archive	 DP
\-list		list archive contents		 VC
\-update		add new or newer files		 aunP:
\-freshen	by add newer files		 auP:
\-comment	add comments to files		 c
.fi
.PP
.sh "Expert commands"
The general format of expert commands is:
.PP
.I zoo
.RB { acDeghlLPTuUvVx }[ aAcCdEfImMnNoOpPqSu1:/.@n+\-= ]
archive [file] ...
.PP
The characters enclosed within {} are commands.  Choose any one of
these.  The characters enclosed within [] just to the right of the {}
are modifiers and zero or more of these may immediately follow the
command character.  All combinations of command and modifier characters
may not be valid.
.PP
Files are added to an archive with the command:
.PP
.I zoo 
.RB { au }[ cfIMnPqu:+\- ]
archive [file] ...
.PP
Command characters are:
.PP
.B a
.br
Add each specified file to archive.  Any already-archived copy of 
the file is deleted if this is necessary to avoid exceeding the
user-specified limit on the number of generations of the
file to maintain in the archive.
.PP
.B u
.br
Do an update of the archive.  A specified file is added to the
archive only if a copy of it is already in the archive and the copy
being added is newer than the copy already in the archive.  
.PP
The following modifiers are specific to these commands.
.PP
.B M
.br
Move files to archive.  This makes 
.I zoo 
delete (unlink) the original files after they have been added to the
archive.  Files are deleted after addition of all files to the archive is
complete and after any requested packing of the archive has been done,
and only if 
.I zoo 
detected no errors.
.PP
.B n
.br
Add new files only.  A specified file is added only if it isn't
already in the archive.
.PP
.B P
.br
Pack archive after files have been added.  
.PP
.B u
.br
Applied to the
.B a
command, this modifier makes it behave identically to the
.B u
command.
.sp 1
The combination of the 
.B n
modifier with the
.B u
modifier or 
.B u
command causes addition of a file to the archive either 
if the file is not already in the archive, 
.I or 
if the file is already in the archive but the archived
copy is older than the copy being added.
.PP
.B :
.br
Do not store directory names.  In the absence of this modifier
.I zoo
stores the full pathname of each archived file.
.PP
.B I
.br
Read filenames to be archived from standard input.  
.I Zoo 
will read
its standard input and assume that each line of text contains a
filename.  Under AmigaDOS and the **IX family, the entire line is used.
Under MS-DOS and VAX/VMS,
.I zoo
assumes that the filename is terminated by a blank, tab,
or newline; thus it is permissible for the line of text to
contain more than one field separated by white space, and only the
first field will be used.
.sp 1
Under the **IX family of operating systems, 
.I zoo
can be used as follows in a pipeline:
.IP "" 10
find . \-print | 
.I zoo
aI sources
.IP "" 5
.sp 1
If the
.B I
modifier is specified, no filenames may be supplied on the command
line itself.
.PP
.BR + , \-
.br
These modifiers take effect only if the
.B a
command results in the creation of a new archive.
.B +
causes any newly-created archive to have
generations enabled.
.B \-
is provided for symmetry and causes any newly-created
archive to have generations disabled;  this is also the
default if neither
.B +
nor
.B \-
is specified.
.PP
Files are extracted from an archive with the command:
.sp 1
.I zoo 
.RB { ex }[ dNoOpqS./@ ]
archive [file] ...
.PP
The 
.B e 
and 
.B x 
commands are synonymous.  If no file was specified, all files are
extracted from the archive.
.PP
The following modifiers are specific to the e and x commands:
.PP
.B N
.br
Do not save extracted data but report any errors encountered.  
.PP
.B O
.br
Overwrite files.  Normally, if a file being extracted would 
overwrite an already-existing file of the same name, 
.I zoo 
asks you if
you really want to overwrite it.  You may answer the question with
`y', which means yes, overwrite; or `n', which means no, don't
overwrite; or `a', which means assume the answer is `y' for this
and all subsequent files.  The 
.B O 
modifier makes 
.I zoo
assume that files may always be overwritten.  Neither
answering the question affirmatively nor using
.B O
alone will cause read-only files to be overwritten.
.sp 1
On **IX systems, however, doubling this modifier as
.B OO
will force
.I zoo
to unconditionally overwrite any read-protected files 
with extracted files if it can do so.  
.sp 1
The 
.B O, N, 
and 
.B p 
modifiers are mutually exclusive.
.PP
.B S
.br
Supersede newer files on disk with older extracted
files.
Unless this modifier is used,
.I zoo
will not overwrite a newer existing file with an
older extracted file.
.PP
.B o    
.br
This is equivalent to the 
.B O 
modifier if and only if it
is given at least twice.  It is otherwise ignored.
.PP
.B p    
.br
Pipe extracted data to standard output.  Error messages are piped to 
standard output as well.  However, if a bad CRC is detected, an error
message is sent both to standard error and to standard output.
.PP
.B /
.br
Extract to original pathname.  Any needed directories must already
exist.  In the absence of this modifier all files are extracted into
the current directory.  If this modifier is doubled as
.BR // ,
required directories need not exist and are created if necessary.
.PP
The management of multiple generations of archived files
is done with the commands:
.sp 1
.B zoo 
\fBgl\fR[\fR\fBAq\fR]{\fR\fB+\-=\fR}\fR\fBnumber
.B archive files ..
.sp 0
.B zoo 
\fBgc\fR[\fR\fBq\fR]{\fR\fB+\-=\fR}\fR\fBnumber
.B archive files ..
.sp 0
.B zoo 
.BR gA [ q ] "\- archive"
.sp 0
.B zoo 
.BR gA [ q ] "+ archive"
.sp 1
The first form,
.BR gl ,
adjusts the generation limit of selected files by the specified
value.  If the form
.B "=n"
is used, where n is a decimal number, this sets the generation
limit to the
specified value.  If
.B +
or
.B \-
are used in placed of 
.B =
the effect is to increment or decrement the generation limit
by the specified value.  For example, the command
.IP "" 5
.B "zoo gl=5 xyz :"
.IP "" 0
sets the generation limit of each file in the archive
.B xyz.zoo
to a value of 5.  The command
.IP "" 5
.B "zoo gl\-3 xyz :"
.IP "" 0
decrements the generation limit of each file in the archive
to 3 less than it currently is.
.sp 1
If the
.B A
modifier is used, the archive-wide generation limit is
adjusted instead.
.sp 1
The number of generations of a file maintained in an archive
is limited by the file generation
limit, or the archive generation limit, whichever is lower.
As a special case, a generation limit of 0 stands for
no limit.  Thus the default file generation limit of
0 and archive generation limit of 1 limits the number
of generations of each file in a newly-created archive to one.
.sp 1
The generation limit specified should be in the range
0 through 15;  any higher numbers are interpreted modulo
16.
.PP
The second form of the command, using
.BR gc ,
adjusts the generation count of selected files.  Each file
has a generation count of 1 when it is first added to
an archive.  Each time a file by the same name is added
again to an archive, it receives a generation count
that is one higher than the highest generation count
of the archived copy of the file.  The permissible 
range of generation counts is 1 through 65535.
If repeated manipulations
of an archive result in files having very high generation
counts, they may be set back to lower numbers with the
.B gc
command.  The syntax of the command is analogous to
the syntax of the 
.B gl
command, except that the 
.B A
modifier is not applicable to the
.B gc
command.
.PP
The third form,
.BR "gA\-" ,
disables generations in an archive.  Generations are
off when an archive is first created, but may be enabled
with the fourth form of the command,
.BR "gA+" .
When generations are disabled in an archive,
.I zoo
will not display generation numbers in archive listings
or maintain multiple generations.  Generations can
be re-enabled at any time, though manipulation
of an archive with repeated interspersed 
.B "gA\-"
and 
.B "gA+"
commands may result in an archive whose
behavior is not easily understandable.
.PP
Archived files are listed with the command:
.sp 1
.I zoo
.RB { lLvV }[ aAcCdfgmqvV@/1+\- ] 
.RB archive[ .zoo ]
[file] ...
.PP
.B l
.br
Information presented includes the date and time of each file, its
original and current (compressed) sizes, and the percentage
size decrease due to compression (labelled CF or compression factor).
If a file was added to the archive in a different timezone,
the difference between timezones is shown in hours as a signed
number.  As an example, if the difference is listed as +3, this
means that the file was added to the archive in a timezone
that is 3 hours west of the current timezone.  The file time
listed is, however, always the original timestamp of the
archived file, as observed by the user who archived the file,
expressed as that user's local time.  (Timezone information
is stored and displayed only if the underlying operating
system knows about timezones.)
.sp 1
If no filename is supplied all files are listed except deleted files.
.sp 1
.I Zoo
selects which generation(s) of a file to list according to
the following algorithm.
.sp 1
If no filename is supplied, only the latest generation of
each file is listed.  If any filenames are specified,
and a generation is specified for an argument, only
the requested generation is listed.  If a filename
is specified ending with the generation character
(`:' or `;'), all generations of that file
are listed.  Thus a filename argument of the form
.B zoo.c
will cause only the latest generation of
.I zoo.c
to be listed;  an argument of the form
.B "zoo.c:4"
will cause generation 4 of
.I zoo.c 
to be listed;  and an argument of the form
.B "zoo.c:"
or
.B "zoo.c:*"
will cause all generations of
.I zoo.c
to be listed.
.PP
.B L
.br
This is similar to the
.B l
command except that all supplied arguments must be archives and all
non-deleted generations of all files in each archive appear in
the listing.
.sp 1
On **IX systems, on which the shell expands arguments, if multiple
archives are to be listed, the
.B L
command must be used.  On other systems (VAX/VMS, AmigaDOS,
MSDOS) on which wildcard expansion is done internally by
.I zoo,
wildcards may be used in the archive name, and a multiple
archive listing obtained, using the
.B l
command.
.PP
.B v
.br
This causes any comment attached to the archive to
be listed in addition to the other information.
.PP
.B V
.br
This causes any comment attached to the archive and also any
comment attached to each file to be listed.
.sp 1
Both the
.B V
and
.B v
command characters can also be used as modifiers to
the
.B l
and
.B L
commands.
.PP
In addition to the general modifiers described later, the following 
modifiers can be applied to the archive list commands.
.PP
.B a
.br
This gives a single-line format containing both each filename and the
name of the archive, sorted by archive name.  It is especially useful
with the
.B L
command, since the result can be further sorted on any field to give a
master listing of the entire contents of a set of archives.
.PP
.B A
.br
This causes any comment attached to the archive to be listed.
.PP
.B g
.br
This modifier causes file generation information to
be listed about the archive.  For each file listed, the
user-specified generation limit, if any, is listed.  For
example, `3g' for a file means that the user wants no more
than three generations of the file to be kept.  In archives
created by older versions of
.I zoo,
the listing will show `\-g',
meaning that no generation information is kept and multiple
generations of the file are not being maintained.
.sp 1
In addition to the generation information for each file,
the archive-wide generation limit, if any, is shown
at the end of the listing.  If generations have been
disabled by the user, this is so indicated, for example:
.IP "" 10
Archive generation limit is 3 (generations off).
.IP "" 5
For more information about generations see the
description of the
.B g
command.
.PP
.B m
.br
This modifier is currently applicable to **IX systems only.
It causes the mode bits (file protection code) of each
file to be listed as a three-digit octal number.  Currently 
.I zoo
preserves only the lowest nine mode bits.  Their meanings
are as described in the **IX documentation for the
.I chmod(1)
command.
.PP
.B C
.br
This modifier causes the stored cyclic redundancy code (CRC) 
for each archived file to be shown as a four-digit hexadecimal 
number.
.PP
.B 1
.br
This forces one filename to be listed per line.  It is most useful
in combination with the
.B f
modifier.
.B /
.br
This forces any directory name to be always listed, even in
fast columnized listings that do not normally include any
directory names.
.PP
.BR + , \-
.br
The
.B \-
modifier causes trailing generation numbers to be
omitted from filenames.
The
.B +
modifier causes the trailing generation numbers to be
shown, which is also the default if neither
.B \-
nor 
.B +
is specified.
.PP
Files may be deleted and undeleted from an archive with the following
commands:
.sp 1
.I zoo
.RB { DU }[ Pq1 ]
archive file ...
.PP
The 
.B D
command deletes the specified files and the 
.B U
command undeletes the specified files.  The
.B 1
modifier (the digit one, not the letter ell) forces deletion or undeletion
of at most one file.  If multiple instances of the same file exist
in an archive, use of the
.B 1
modifier may allow selective extraction of one of these.
.PP
Comments may be added to an archive with the command:
.sp 1
.I zoo
.BR c [ A ]
archive
.PP
Without the modifier
.BR A ,
this behaves identically to the
.B \-comment
command.  With the modifier
.BR A ,
the command serves to add or update the comment attached
to the archive as a whole.  This comment may be listed with
the
.B lA, LA, v, and V
commands.  Applying the
.B cA
command to an archive that was created with an older version
of
.I zoo
will result in an error message requesting that the user
first pack the archive with the
.B P
command.  This reorganizes the archive and creates space
for the archive comment.
.PP
The timestamp of an archive may be adjusted with the command:
.sp 1
.I zoo
.BR T [ q ]
archive
.PP
.I Zoo 
normally attempts to maintain the timestamp of an archive to reflect
the age of the newest file stored in it.  Should the timestamp ever be
incorrect it can be fixed with the
.B T
command.
.PP
An archive may be packed with the command:
.sp 1
.I zoo
.BR P [ EPq ]
archive
.PP
If the backup copy of the archive already exists, 
.I zoo
will refuse to
pack the archive unless the
.B P
modifier is also given.  The
.B E
modifier causes 
.I zoo
not to save a backup copy of the original archive
after packing.  A unique temporary file in the current directory
is used to initially hold the packed archive.  This file will be
left behind if packing is interrupted or if for some reason this
file cannot be renamed to the name of the original archive when
packing is complete.
.PP
Packing removes any garbage data appended to an archive because of
Xmodem file transfer and also recovers any wasted space
remaining in an archive that has been frequently updated
or in which comments were replaced.  Packing also updates
the format of any archive that was created by an older 
version of
.I zoo
so that newer features (e.g. archive-wide generation limit,
archive comment) become fully available.
.PP
.I Zoo
can act as a pure compression or uncompression filter,
reading from standard input and writing to standard output.
This is achieved with the command:
.sp 1
.I zoo
.BR f { cu }
.PP
where
.B c
specifies compression and
.B u
specifies uncompression.  A CRC value is used to check the
integrity of the data.  The compressed data stream has
no internal archive structure and contains multiple
files only if the input data stream was already structured,
as might be obtained, for example, from
.I tar
or
.I cpio.
.PP
 Modem transfers can be speeded up with these commands:
.IP "" 10
.I zoo
.B fc
< file |
.I sz ...
.I rz |
.I zoo
.B fu
> file
.IP "" 5
.PP
.sh "General modifiers"
.PP
The following modifiers are applicable to several commands:
.PP
.B c
.br
Applied to the
.B a
and
.B u
commands, this causes the user to be prompted 
for a comment for each file added to the archive.  If the file
being added has replaced, or is a newer generation of,
a file already in the archive, any comment
attached to that file is shown to the user and becomes
attached to the newly-added file unless the user changes it.
Possible user responses are as described for the
.B \-comment
command.  Applied to the archive list command
.BR l ,
the 
.B c
modifier causes the listing of any comments attached to archived files.
.PP
.BR \ .
.br
In conjunction with
.B /
or
.B //
this modifier causes any extracted pathname beginning with `/' to be
interpreted relative to the current directory, resulting in 
the possible creation of a subtree rooted at the current directory.
In conjunction with the command
.B P
the
.B .
modifier causes the packed archive to be created in the current
directory.  This is intended to allow users with limited disk
space but multiple disk drives to pack large archives.
.PP
.B d
.br
Most commands that act on an archive act only on files that are
not deleted.  The
.B d
modifier makes commands act on both normal and deleted files.  If
doubled as
.BR dd ,
this modifier forces selection only of deleted files. 
.PP
.B f
.br
Applied to the
.B a
and
.B u
commands, the
.B f
modifier causes fast archiving by adding files without compression.
Applied to
.B l
it causes a fast listing of files in a multicolumn format.
.PP
.B q
.br
Be quiet.  Normally 
.I zoo
lists the name of each file and what action it is performing.  The
.B q
modifier suppresses this.  When files are being extracted to standard
output, the
.B q
modifier suppresses the header preceding each file.  When archive
contents are being listed, this modifier suppresses any header
and trailer.  When a fast columnized listing is being obtained,
this modifier causes all output to be combined into a single set
of filenames for all archives being listed.
.sp 1
When doubled as
.BR qq ,
this modifier suppresses WARNING messages, and when tripled as
.BR qqq ,
ERROR messages are suppressed too.  FATAL error messages
are never suppressed.
.PP
.sh "Recovering data from damaged archives"
The
.B @
modifier allows the user to specify the exact position in
an archive where
.I zoo
should extract a file from, allowing damaged portions
of an archive to be skipped.
This modifier must be immediately followed by a decimal
integer without intervening spaces, and possibly by
a comma and another decimal integer, giving a command of
the form
.B l@m
or
.B l@m,n
(to list archive contents)
or
.B x@m
or
.B x@m,n
(to extract files from an archive).  Listing or extraction
begin at position 
.B m
in the archive.
The value of
.B m
must be the position within the archive of an
undamaged directory entry.  This position is usually obtained from
.I fiz(1)
version 2.0 or later.
.sp 1
If damage to the archive has shortened or lengthened it, all
positions within the archive may be changed by some constant amount.
To compensate for this, the value of
.B n
may be specified.  This value is also usually obtained from
.I fiz(1).
It should be the position in the archive of the file data
corresponding to the directory entry that has been specified
with 
.BR m .
Thus if the command
.B x@456,575
is given, it will cause the first 456 bytes of the archive to
be skipped and extraction to begin at offset 456;  in addition,
.I zoo
will attempt to extract the file data from position 575 in the archive
instead of the value that is found in the directory entry
read from the archive.
For example, here is some of the output of 
.I fiz
when it acts on a damaged 
.I zoo
archive:
.sp 1
.nf
****************
    2526: DIR  [changes] ==>   95
    2587: DATA
****************
    3909: DIR  [copyrite] ==> 1478
    3970: DATA
    4769: DATA
****************
.fi
.sp 1
In such output, 
.B DIR
indicates where 
.I fiz
found a directory entry in the archive, and
.B DATA
indicates where 
.I fiz
found file data in the archive.  Filenames located by
.I fiz
are enclosed in square brackets, and the notation
"==>   95" indicates that the directory entry found by
.I fiz
at position 2526 has a file data pointer to
position 95.  (This is clearly wrong,
since file data always occur in an archive 
.I after
their directory entry.)  In actuality,
.I fiz
found file data at positions 2587, 3970, and
4769.  Since 
.I fiz
found only two directory entries, and each directory entry
corresponds to one
file, one of the file data positions is an artifact.
.PP
.sp 1
In this case, commands to try giving to 
.I zoo
might be
.B x@2526,2587
(extract beginning at position 2526, and get file data
from position 2587),
.B x@3090,3970
(extract at 3090, get data from 3970)
and
.B x@3909,4769
(extract at 3909, get data from 4769).  Once a correctly-matched
directory entry/file data pair is found,
.I zoo
will in most cases synchronize with and correctly extract all files
subsequently found in the archive.  Trial and error should allow
all undamaged files to be extracted.
Also note that self-extracting archives created using
.I sez
(the Self-Extracting
.I Zoo
utility for MS-DOS), which are normally executed on an MS-DOS
system for extraction, can
be extracted on non-MSDOS systems using 
.I "zoo's"
damaged-archive recovery method using the
.B @
modifier.
.PP
.sh "Wildcard handling"
Under the **IX family of operating systems, 
the shell normally expands wildcards to a list of matching files.  Wildcards 
that are meant to match files within an archive must therefore
be escaped or quoted.  When selecting files to be added to an archive,
wildcard conventions are as defined for the shell.  When selecting
files from within an archive, wildcard handling is done by
.I zoo
as described below.
.PP
Under MS-DOS and AmigaDOS, quoting of wildcards is not needed.
All wildcard expansion of filenames is done by
.I zoo,
and wildcards inside directory names are expanded only
when listing or extracting files but not when adding them.
.PP
The wildcard syntax interpreted by 
.I zoo
is limited to the following characters.
.PP
.B *
.br
Matches any sequence of zero or more characters.
.PP
.B \?
.br
Matches any single character.
.sp 1
Arbitrary combinations of 
.B *
and 
.B ?
are allowed.
.PP
.B /
.br
If a supplied pattern contains a slash anywhere in it, then the
slash separating any directory prefix from the filename must be
matched explicitly.  If a supplied pattern contains
no slashes, the match is selective only on the filename.
.PP
.B c\-c
.br
Two characters separated by a hyphen specify a character range.  All
filenames beginning with those characters will match.  The character
range is meaningful only by itself or preceded by a directory name.
It is not specially interpreted if it is part of a filename.
.PP
.B ": and ;"
.br
These characters are used to separate a filename from a generation
number and are used when selecting specific generations
of archived files.  If no generation character is used, the
filename specified matches only the latest generation of the
file.  If the generation character is specified,
the filename and the generation are matched independently by
.I "zoo's"
wildcard mechanism.  If no generation is
specified following the
.B ":"
or
.B ";"
character, all generations of that file will match.  As
a special case, a generation number of
.B 0
matches only the latest generation of a file, while
.B ^0
matches all generations of a file except the
latest one.  If no
filename is specified preceding the generation character,
all filenames will match.  As a corollary, the generation
character by itself matches all generations of all files.
.PP
MS-DOS users should note that 
.I zoo 
does not treat the dot as
a special character, and it does not ignore characters following
an asterisk.  Thus 
.B * 
matches all filenames;
.B *.* 
matches
filenames containing a dot;
.B *_* 
matches filenames
containing an underscore;  and 
.B *z 
matches all filenames
that end with the character 
.BR z ,
whether or not they contain
a dot.
.PP
.sh "Usage hints"
The Novice command set in
.I zoo
is meant to provide an interface with functionality and
format that will be familiar to users of other similar
archive utilities.  In keeping with this objective,
the Novice commands do not maintain or use any subdirectory
information or allow the use of
.I "zoo's"
ability to maintain multiple generations of files.
For this reason, users should switch to exclusively
using the Expert commands as soon as possible.
.PP
Although the Expert command set is quite large, it should
be noted that in almost every case, all legal modifiers
for a command are fully orthogonal.  This means that the
user can select any combination of modifiers, and when they
act together, they will have the intuitively obvious effect.
Thus the user need only memorize what each modifier does,
and then can combine them as needed without much further thought.
.PP
For example, consider the 
.B a
command which is used to add files to an archive.  By itself,
it simply adds the specified files.  To cause only already-archived
files to be updated if their disk copies have been modified,
it is only necessary to add the
.B u
modifier, making the command
.BR au .
To cause only new files (i.e., files not already in
the archive) to be added, the
.B n
modifier is used to create the command
.BR an .
To cause 
.I both
already-archived files to be updated and new files
to be added, the
.B u
and
.B n
modifiers can be used together, giving the command
.BR aun .
Since the order of modifiers is not significant, the
command could also be
.BR anu .
.PP
Further, the
.B c
modifier can be used to cause
.I zoo
to prompt the user for a comment to attach to
each file added.  And the
.B f
modifier can cause fast addition (addition without
compression).  It should be obvious then that the
command
.B auncf
will cause
.I zoo
to update already-archived files, add new files,
prompt the user for comments, and do the addition
of files without any compression.  Furthermore,
if the user wishes to move files to the archive,
i.e., delete the disk copy of each file after it
is added to the archive, it is only necessary to add
the
.B M
modifier to the command, so it becomes
.BR auncfM .
And if the user also wishes to cause the archive
to be packed as part of the command, thus recovering
space from any files that are replaced, the command
can be modified to
.B auncfMP
by adding the
.B P
modifier that causes packing.
.PP
Similarly, the archive listing commands can be built up
by combining modifiers.  The basic command to list the
contents of an archive is
.BR l .
If the user wants a fast columnized listing, the
.B f 
modifier can be added to give the
.B lf
command.  Since this listing will have a header giving
the archive name and a trailer summarizing interesting
information about the archive, such as the number
of deleted files, the user may wish to "quieten" the
listing by suppressing these;  the relevant modifier
is
.BR q ,
which when added to the command gives
.BR lfq .
If the user wishes to see the **IX mode (file protection)
bits, and also information about multiple generations,
the modifiers
.B m
(show mode bits) and
.B g
(show generation information) can be added, giving the
command
.BR lfqmg .
If the user also wishes to see an attached archive
comment, the modifier
.B A
(for archive) will serve.  Thus the command
.B lfqmgA
will give a fast columnized listing of the archive,
suppressing any header and trailer, showing mode bits
and generation information, and showing any comment
attached to the archive as a whole.  If in addition
individual comments attached to files are also needed,
simply append the
.B c
modifier to the command, making it
.BR lfqmgAc .
The above command will not show any deleted files, 
however;  to see them, use the
.B d
modifier, making the command
.B lfqmgAcd
(or double it as in
.B lfqmgAcdd
if 
.I only 
the deleted files are to be listed).  And if the user
also wishes to see the CRC value for each file being listed,
the modifier
.B C
will do this, as in the command
.BR lfqmgAcdC ,
which gives a fast columnized listing of all files, including
deleted files, showing any archive comment and file comments,
and file protection codes and generation information, as
well as the CRC value of each file.
.PP
Note that the above command
.B lfqmgAcdC
could also be abbreviated to
.B VfqmgdC
because the command
.B V
is shorthand for
.B lcA 
(archive listing with all comments shown).
Similarly the command
.B v
is shorthand for
.BR lA
(archive listing with archive comment shown).  Both
.B V
and 
.B v
can be used as modifiers to any of the other archive
listing commands.
.PP
.sh "Generations"
By default,
.I zoo
assumes that only the latest generation of a specified file
is needed.  If generations other than the latest one
need to be selected, this may be done by specifying them
in the filename.  For example, the name
.B stdio.h
would normally refer to the latest generation of
the file
.I stdio.h
stored in a 
.I zoo
archive.  To get an archive listing showing all
generations of
.I stdio.h 
in the archive, the specification
.B stdio.h:*
could be used (enclosed in single quotes if necessary
to protect the wildcard character
.B *
from the shell).  Also,
.B stdio.h:0
selects only the latest generation of
.I stdio.h,
while
.B stdio.h:^0
selects all generations except the latest one.  The 
.B :
character here separates the filename from the generation
number, and the character
.B *
is a wildcard that matches all possible generations.
For convenience, the generation itself may be left
out, so that the name
.B stdio.h:
(with the
.B :
but without a generation number or a wildcard) matches
all generations exactly as
.B stdio.h:*
does.
.PP
If a generation is specified but no filename is present,
as in
.BR :5 ,
.BR :* ,
or just
.BR : ,
all filenames of the specified generation will be selected.
Thus
.B :5
selects generation 5 of each file, and
.B :*
and
.B :
select all generations of all files.
.PP
It is important to note that
.I "zoo's"
idea of the latest generation of a file is not based
upon searching the entire archive.  Instead, whenever
.I zoo
adds a file to an archive, it is marked
as being the latest generation.  Thus, if
the latest generation of a file is deleted, then
.I no
generation of that file is considered the latest any
more.  This can be surprising to the user.  For
example, if an archive already contains the file
.I stdio.h:5
and a new copy is added, appearing in the archive
listing as
.I stdio.h:6,
and then
.I stdio.h:6
is deleted, the remaining copy
.I stdio.h:5
will no longer be considered to be the latest generation,
and the file
.I stdio.h:5,
even if undeleted, will no longer appear in an archive listing
unless generation 5 (or every generation) is specifically requested.
This behavior will likely be improved in future releases of
.I zoo.
.SH FILES
.PP
xXXXXXX \- temporary file used during packing
.sp 0
.RB archive_name. bak
\- backup of archive
.SH "SEE ALSO"
.PP
compress(1), fiz(1)
.SH BUGS
.PP
When files are being added to an archive on a non-MS-DOS system, it
is possible for
.I zoo
to fail to detect a full disk and hence create an invalid archive.
This bug will be fixed in a future release.
.PP
Files with generation counts that wrap around from 65535 to 1
are not currently handled correctly.  If a file's generation
count reaches a value close to 65535, it should be manually
set back down to a low number.  This may be easily done
with a command such as
.BR gc\-65000 ,
which subtracts 65000 from the generation count of each
specified file.  This problem will be fixed in a
future release.
.PP
Although
.I zoo
on **IX systems preserves the lowest nine mode bits of
regular files, it does not currently do the same for directories.
.PP
Currently
.I "zoo's"
handling of the characters
.B :
and 
.B ;
in filenames is not robust, because it interprets these
to separate a filename from a generation number.  A
quoting mechanism will eventually be implemented.
.PP
Standard input cannot be archived nor can a created archive be sent
to standard output.  Spurious error messages may appear if the 
filename of an archive is too long.
.PP
Since
.I zoo
never archives any file with the same name as the archive or its
backup (regardless of any path prefixes), care should be taken 
to make sure that a file to be archived does not coincidentally have 
the same name as the archive it is being added to.
It usually suffices 
to make sure that no file being archived is itself a 
.I zoo
archive.  (Previous versions of
.I zoo
sometimes tried to add an
archive to itself. This bug now seems to be fixed.)
.PP
Only regular files are archived; devices and empty directories are not.
Support for archiving empty directories and for preserving directory
attributes is planned for the near future.
.PP
Early versions of MS-DOS have a bug that prevents "." from referring
to the root directory;  this leads to anomalous results if the
extraction of paths beginning with a dot is attempted.
.PP
VAX/VMS destroys case information unless arguments are enclosed
in double quotes.  For this reason if a command given to
.I zoo
on a VAX/VMS system includes any uppercase characters, it must be 
enclosed in double quotes.  Under VAX/VMS,
.I zoo
does not currently restore file timestamps;  this will be fixed
as soon as I figure out RMS extended attribute blocks, or DEC supplies
a utime() function, whichever occurs first.  Other VMS bugs, related to
file structures, can often be overcome by using the program 
.I bilf.c
that is supplied with
.I zoo.
.PP
It is not currently possible to create a
.I zoo
archive containing all
.I zoo
archives that do not contain themselves.
.SH DIAGNOSTICS
.PP
Error messages are intended to be self-explanatory and are divided into
three categories.  WARNINGS are intended to inform the user of an
unusual situation, such as a CRC error during extraction, or
.BR \-freshen ing
of an archive containing a file newer than one specified on
the command line.  ERRORS are fatal to one file, but execution
continues with the next file if any.  FATAL errors cause execution to
be aborted.  The occurrence of any of these causes an exit status of
1.  Normal termination without any errors gives an exit status of 0.
(Under VAX/VMS, however, to avoid an annoying message,
.I zoo
always exits with an error code of 1.)
.SH COMPATIBILITY
.PP
All versions of
.I zoo
on all systems are required to create archives that can
be extracted and listed with all versions of 
.I zoo
on all systems, regardless of filename and
directory syntax or archive structure;  furthermore,
any version of 
.I zoo
must be able to fully manipulate all archives
created by all lower-numbered versions of
.I zoo
on all systems.  So far as I can tell, this
upward compatiblity (all manipulations) and downward
compatiblity (ability to extract and list)
is maintained by
.I zoo
version 2.0.
You are forbidden, with the force of
copyright law, to create from the
.I zoo
source code any derivative work
that violates this compatibility goal,
whether knowingly or through negligence.
If any violation of this
compatibility goal is observed i.e.,
if you are able to use an implementation of
.I zoo
to create an archive
that some implementation of
.I zoo
on any system cannot extract this should be
considered a serious problem and reported to me.
.SH CHANGES
.PP
Here is a list of changes occurring from version 1.50 to
version 2.01.  In parentheses is given the version in which each
change occurred.
.sp 1
\-
(1.71) New modifiers to the list commands permit
optional suppression of header and trailer information, 
inclusion of directory names in columnized listings, and 
fast one-column listings.
.sp 1
\-
(1.71) Timezones are handled.
.sp 1
\-
(1.71) A bug was fixed that had made it impossible to
individually update comments for a file whose name did
not correspond to MS-DOS format.
.sp 1
\-
(1.71) A change was made that now permits use of the
shared library on the **IX PC.
.sp 1
\-
(1.71) VAX/VMS is now supported reasonably well.
.sp 1
\-
(2.00) A comment may now be attached to the archive itself.
.sp 1
\-
(2.00) The \fBOO\fR option allows
forced overwriting of read-only files.
.sp 1
\-
(2.00) \fIZoo\fR will no longer extract a file if a 
newer copy already exists on disk;  the
.B S
option will override this.
.sp 1
\-
(2.00) File attributes are preserved for **IX systems.
.sp 1
\-
(2.00) Multiple generations of the same file are supported.
.sp 1
\-
(2.00) \fIZoo\fR will now act as a compression or
decompression filter on a stream of data and will
use a CRC value to check the integrity of a
data stream that is uncompressed.
.sp 1
\-
(2.00) A bug was fixed that caused removal of a directory link
if files were moved to an archive by the superuser
on a **IX system.
.sp 1
\-
(2.00) The data recovery modifier
.B @
was greatly enhanced.  Self-extracting archives created for MS-DOS
systems can now be extracted by 
.I zoo
on any system with help from 
.I fiz(1).
.sp 1
\-
(2.01)
A bug was fixed that had caused the first generation of a file
to sometimes unexpectedly show up in archive listings.
.sp 1
\-
(2.01) A bug was fixed that had caused the MS-DOS version
to silently skip files that could not be extracted because
of insufficient disk space.
.sp 1
\-
(2.01) A bug was fixed that had sometimes made it impossible to
selectively extract a file by specifying its name, even 
though all files could be extracted from the archive
by not specifying any filenames.  This occurred when
a file had been archived on a longer-filename system
(e.g. AmigaDOS) and extraction was attempted on a
shorter-filename system (e.g. MS-DOS).
.sp 1
\-
(2.01) A change was made that will make zoo preserve the mode
(file protection) of a zoo archive when it is packed.
This is effective only if zoo is compiled to preserve
and restore file attributes.  Currently this is so
only for **IX systems.
.sp 1
\-
(2.01) 
A bug was fixed that had caused an update of an archive to
not always add all newer files.
.sp 1
\-
(2.01) Blanks around equal signs in commands given to "make"
were removed from the mk* scripts for better compatiblity
with more **IX implementations including Sun's.
.SH "FUTURE DIRECTIONS"
.PP
A revised version of 
.I zoo
is in the works that will be able to write newly-created archives
to standard output, and will also automatically perform end-of-line 
conversion for text files moved between dissimilar systems.
It will be upward and downward compatible with existing versions of 
.I zoo.
.SH ACKNOWLEDGEMENTS
.PP
The 
.I zoo
archiver was initially developed using Microsoft C 3.0
on a PC clone manufactured
by Toshiba of Japan and almost sold by Xerox.  Availability
of the following systems was helpful in achieving portability:
Paul Homchick's Compaq running Microport System V/AT;  The 
Eskimo BBS somewhere in Oregon running Xenix/68000; Greg Laskin's
system 'gryphon' which is an Intel 310 running Xenix/286;  Ball 
State University's AT&T 3B2/300, UNIX PC, and VAX-11/785 (4.3BSD)
systems.  In addition J. Brian Waters provided feedback to
help me make the code compilable on his Amiga using
Manx/Aztec C.  More recently, actual development, as
opposed to portability testing, has been done exclusively
on my own AT from PC's Limited running Microport System V/AT.
The executable version 2.0 for MS-DOS is currently
compiled with Borland's Turbo C 1.0.
.PP
Special thanks are due to:
.PP
J. Brian Waters <uunet!bsu-cs!jbwaters>, who has worked
diligently to port
.I zoo
to AmigaDOS, created Amiga-specific code,
and continues keeping it updated.
.PP
Paul Homchick <rutgers!cgh!paul>, who provided numerous detailed
reports about some nasty bugs.
.PP
Bill Davidsen <steinmetz!crdos1!davidsen>, who fixed
.I "zoo's"
handling of daylight savings time, provided changes to make this
manual format correctly with
.I troff,
and provided many useful bug reports and suggestions.
.PP
Mark Alexander <amdahl!drivax!alexande>, who provided me with some bug
fixes, and also some portability modifications and
speed optimizations
that are due to be incorporated into the next release.
.SH AUTHOR
.PP
Rahul Dhesi
