.\" @(#) fiz.1 1.2 88/01/31 23:22:04
.\"
.\" For formatting with nroff:
.\"   nroff -man fiz.1
.\"
.TH FIZ 1 "Jan 31, 1988"
.SH NAME
.PP
fiz \- analyze damaged zoo archive for data revovery
.SH SYNOPSIS
.PP
.I fiz
.RB archive[ .zoo ]
.SH DESCRIPTION
.PP
.I Fiz
is used to analyze damaged
.I zoo
archives and locate directory entries and file data in them.
The current version of 
.I fiz
is 2.0 and it is meant to be used in conjunction with
.I zoo
version 2.0.
.I Fiz
makes no assumptions about archive structure.  Instead, it simply
searches the entire subject archive for tag values
that mark the locations of directory entries and file data.
In a 
.I zoo
archive, a
.I directory entry
contains information about a stored file such as its name, whether 
compressed or not, and its timestamp.  The
.I file data
are the actual data for the archived file, and may be
either the original data, or the result of compressing the file.
.PP
For each directory entry found,
.I fiz
prints where in the archive it is located, the directory path and
filename(s) found in it, whether the directory entry appears
to be corrupted (indicated by [*CRC Error*]), and the value of
the pointer to the file data that is found in the directory entry.
For each block of file data found in the archive,
.I fiz
prints where in the archive the block begins.  In the case of
an undamaged archive, the pointer to file data found in
a directory entry will correspond to where
.I fiz
actually locates the data.  Here is some sample output from 
.I fiz:
.PP
.nf
****************
    2526: DIR  [changes] ==>   95
    2587: DATA
****************
    3909: DIR  [copyrite] ==> 1478
    3970: DATA
    4769: DATA
****************
.fi
.sp 1
In such output, 
.B DIR
indicates where 
.I fiz
found a directory entry in the archive, and
.B DATA
indicates where 
.I fiz
found file data in the archive.  Filenames located by
.I fiz
are enclosed in square brackets, and the notation
"==>   95" indicates that the directory entry found by
.I fiz
at position 2526 has a file data pointer to
position 95.  In actuality,
.I fiz
found file data at positions 2587, 3970, and
4769.  Since 
.I fiz
found only two directory entries, and each directory entry corresponds
to one file, one of the file data positions is an artifact.
.PP
Once the locations of directory entries and file data are found, the
.B @
modifier to
.I "zoo's"
archive list and extract commands can be used and
the archive contents selectively listed or extracted,
skipping the damaged portion.  This is further described
in the documentation for
.I zoo(1).
.PP
In the above case, commands to try giving to 
.I zoo
might be
.B x@2526,2587
(extract beginning at position 2526, and get file data
from position 2587),
.B x@3090,3970
(extract at 3090, get data from 3970)
and
.B x@3909,4769
(extract at 3909, get data from 4769).  Once a correctly-matched
directory entry/file data pair is found,
.I zoo
will in most cases synchronize with and correctly extract all files
subsequently found in the archive.  Trial and error should allow
all undamaged files to be extracted.
Also note that self-extracting archives created using
.I sez
(the Self-Extracting
.I Zoo
utility for MS-DOS), which are normally executed on an MS-DOS
system for extraction, can
be extracted on non-MSDOS systems in a similar way.
.PP
.SH "SEE ALSO"
.PP
zoo(1)
.SH BUGS
.PP
Random byte patterns can occasionally be incorrectly recognized
as tag values.  This occurs very rarely, however, and trial
and error will usually permit all undamaged data to be
extracted.
.SH DIAGNOSTICS
.PP
.I Fiz
always exits with a status code of 0.
.SH "FUTURE DIRECTIONS"
.PP
Automation of data recovery from a damaged archive is potentially
achievable.  However, since damaged archives occur only rarely,
.I fiz
as it currently stands is unlikely to change much in the
near future.
.SH AUTHOR
.PP
Rahul Dhesi
