/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Initialisierungen			*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include "ad.h"

extern	void	exit();

static	struct	termio	term,oterm;	/* Terminaldaten */

/****************************************************************/
/*	Initialisierungen					*/
/****************************************************************/

void	ad_init()
{
	int 	i,ch;
	int 	pfd[2];

	lex();				/* Strings einlesen 	*/

	if(startcmd[0]!=(char)0)
		system(startcmd);	/* Startkommando ausf.	*/

	/**** Unterbrecher starten			****/

	if(pipe(pfd)== -1)	/* Pipe erzeugen	*/
	{			/* Fehler ?	*/
		ad_error("");
		ad_deinit();
		exit(1);
	}

	if((break_pid=fork())== -1)	/* Fehler ?	*/
	{
		ad_error("");
		ad_deinit();
		exit(1);
	}

	if(break_pid==0)	/* Sohn ?	*/
	{
		close(1);	/* Standardausgabe schliessen	*/
		dup(pfd[1]);	/* neue Standardausgabe		*/
		close(pfd[0]);	/* Pipes schliessen		*/
		close(pfd[1]);
		execlp("./chbrk","./chbrk",(char *)0);	/* starten	*/
		ad_error("");
		ad_deinit();
		exit(1);
	}
	else			/* Vater ?	*/
	{
		close(0);	/* Standardeingabe schliessen	*/
		dup(pfd[0]);	/* neue Standardeingabe		*/
		close(pfd[0]);	/* Pipes schliessen		*/
		close(pfd[1]);
	}

	/**** Ende Unterbrecher starten			****/

	initscr();			/* Curses ein		*/
	curses=1;

	if(ioctl(1,TCGETA,&oterm)== -1)	/* termio retten */
	{
		ad_error("");
		ad_deinit();
		exit(1);
	}

	if(ioctl(1,TCGETA,&term)== -1)	/* termio holen */
	{
		ad_error("");
		ad_deinit();
		exit(1);
	}

	term.c_cc[VEOF]=1;		/* veraendern */
	term.c_cc[VEOL]=1;
	term.c_lflag &= ~(ICANON | ECHO);

	if(ioctl(1,TCSETA,&term))
	{
		ad_error("");
		ad_deinit();
		exit(1);
	}

	ad_startint();		/* Interrupt starten	*/
}

/****************************************************************/
/*	Deinitialisierungen					*/
/****************************************************************/

void	ad_deinit()
{
	if(break_pid!= -1)		/* Unterbrecher laeuft ?*/
		kill(break_pid,SIGTERM);/* beenden		*/

	if(lock==1)			/* Lock erworben ?	*/
		ad_unlock();		/* freigeben		*/

	if(curses==1)			/* Curses an ?		*/
	{
		char	s[STRLEN];

		ioctl(1,TCSETA,&oterm);	/* termio herstellen 	*/
		endwin();		/* Curses aus		*/

		if(stdname[0]!='\0' && !ende && UEBUNG())
		{
			ad_lock();
			sprintf(s,"save %s",stdname);
			schach(s,ptr);		/* Speichern		*/
			ad_unlock();
		}

		if(stdname[0]!='\0' && !ende && TURNCOM())
		{
			schach("info",ptr);	/* Info holen	*/

			if(atoi(ptr[1]) != old_moves)
			{		/* veraendert ?		*/
				ad_lock();
				sprintf(s,"save %s",stdname);
				schach(s,ptr);	/* Speichern	*/
				ad_unlock();
			}
		}
	}

	fflush(stdout);			/* Buffer leeren	*/
	fflush(stdin);

	chdir(cwd);			/* Directory herstellen	*/
}

/****************************************************************/
/*	Neustart						*/
/****************************************************************/

void	ad_new()
{
	static	int	first=1;

	if(first)	/* Laden der Bib. einmal anzeigen	*/
	{
		ad_msg(load_lib);
		first=0;
	}

	schach("init",ptr);		/* Initialsieren 	*/
	if(ptr[0][0]=='?')		/* Fehler ?		*/
	{
		ad_error("");
		ad_deinit();
		exit(1);
	}
	schach("stufe 2",ptr);		/* Stufe einstellen	*/

	if(UEBUNG())			/* Uebungsspiel ?	*/
	{
		char	str[STRLEN];

		sprintf(str,"stufe %d",atoi(tr_lv)-1);
		schach(str,ptr);	/* Level einstellen	*/

		wei=0;			/* 0=Spieler		*/
		sch=1;			/* 1=Computer		*/
	}

	if(TURNIER())			/* Turnierspiel		*/
	{
		char	str[STRLEN];

		sprintf(str,"stufe %d",atoi(to_lv)-1);
		schach(str,ptr);	/* Level einstellen	*/
	}

	ende=0;				/* 1:Matt oder Patt	*/

	ad_brett();		/* Brett aufbauen	*/

	schach("info",ptr);	/* Info holen		*/
	modus = atoi(ptr[9]);	/* merken		*/
	farbe = ptr[0][0];
	level = atoi(ptr[6]);


	ad_menu();		/* Menue ausgeben	*/

	move(23,79);		/* Cursor weg		*/
}

/****************************************************************/
/*	Partie loeschen						*/
/****************************************************************/

void	ad_remove()
{
	char	str[STRLEN*2];

	if(stdname[0]=='\0')	/* Kein Name definiert ?	*/
		return;

	sprintf(str,"%s/%s.ch",WORKDIR,stdname);
	unlink(str);

	sprintf(str,"%s/%s.lock",WORKDIR,stdname);
	unlink(str);
}
