/* $Id: xferentry.c,v 3.3 1991/09/01 14:02:55 piggy Rel $
 * Process /usr/spool/uucp.Admin/xferstat: read each line, parse it and
 * return the values in it.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	GetXferEntry( struct xferentry * entry);
 *      Returns EOF at the end, ERROR if it is not able to open the file,
 *      OK in all the other cases.
 *
 */

#include    <stdio.h>
#include    <string.h>
#include    "hdbstat.h"
#include    <time.h>

#ifdef HDB_ERR_FACT
float ERRFACT = 2.5;
#endif

int
GetXferEntry (entry)
     struct xferentry *entry;

{
  char line[256], datebuffer[20];
  static FILE *xfer_fp = (FILE *) NULL;
  extern int atoi ();
  extern double atof ();
  time_t timestamp;

  if (xfer_fp == NULL)
    {
      char xfername[LPNMAX];

      sprintf (xfername, "%s/%s", PrefixPath, XFER_NAME);
      if ((xfer_fp = fopen (xfername, "r")) == (FILE *) NULL)
	{
	  perror ("GetXferEntry(fopen)");
	  return (ERROR);
	}
    }

  if (fgets (line, 256, xfer_fp) == NULL)
    {
      fclose (xfer_fp);
      return (EOF);
    }

  strcpy (entry->System, strtok (line, "!"));
  strcpy (entry->User, strtok (NULL, " "));
  entry->Month = atoi (strtok (NULL, " MS(/"));
  entry->Day = atoi (strtok (NULL, "-"));
  entry->Hour = atoi (strtok (NULL, ":"));
  entry->Min = atoi (strtok (NULL, ":"));
  entry->Sec = atoi (strtok (NULL, ")"));
  sprintf(datebuffer, "%d/%d-%d:%d:%d", entry->Month, entry->Day, entry->Hour,
          entry->Min, entry->Sec);
  timestamp = get_date(datebuffer);
  entry->DayOfWeek = localtime(&timestamp)->tm_wday;
  (void) strtok (NULL, "[");
  strcpy (entry->PortName, strtok (NULL, "]"));
  if (strcmp ("<-", strtok (NULL, " ")))
    entry->Direction = 'S';
  else
    entry->Direction = 'R';
  entry->Bytes = atof (strtok (NULL, " "));

#ifdef HDB_ERR_FACT
  entry->Time = (float) atof (strtok (NULL, " /")) / ERRFACT;
#else
  entry->Time = (float) atof (strtok (NULL, " /"));
#endif
  return OK;
}
