/* $Id: procxfer.c,v 3.3 1991/09/01 14:02:41 piggy Rel $
 * Eat /usr/spool/uucp/.Admin/xferstats and update the systems tables.
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	ProcXferstats()
 *	Return OK, or ERROR if something went wrong.
 *
 */

#include    <stdio.h>
#include    "hdbstat.h"

int
ProcXferstats ()
{
  struct xferentry xfe;
  int xfer_status;
  int LineNumber = 0;

  if (VerboseOutput)
    fputs ("\nProcessing xferstats:\n", stderr);

  while ((xfer_status = GetXferEntry (&xfe)) == OK)
    {
      sysrep_t *sr;
      dailyrep_t *dr;
      portact_t *pa;

      if (JustSomeSystem)
        {
          if ((sr = CheckSystemEsist (xfe.System)) == (sysrep_t *) NULL)
            continue;
        }
      else
        sr = InsertSys (xfe.System);

      dr = InsertDay (xfe.Month, xfe.Day);
      pa = InsertPort (xfe.PortName);
      
      if (VerboseOutput && (++LineNumber % 50) == 0)
	fprintf (stderr, "\r%6d", LineNumber);

      pa->Activity[xfe.Hour * 3 + (xfe.Min / 20)] += xfe.Bytes;
      if (!sr->Killed)
	{
	  sr->PhoneCost[GetPhonePrice (xfe.DayOfWeek, xfe.Hour, xfe.Min)] +=
	    xfe.Time;
	  if (xfe.Month == sr->History.LastMonthProcessed)
	    sr->History.MonthlyActivity[xfe.Month - 1] += xfe.Bytes;
	  else
	    {
	      sr->History.MonthlyActivity[xfe.Month - 1] = xfe.Bytes;
	      sr->History.LastMonthProcessed = xfe.Month;
	    }
	  if (xfe.Direction == 'S')
	    {
	      userrep_t *ur = InsertUser (xfe.User);

	      sr->TimeOut += xfe.Time;
	      sr->BytesOut += xfe.Bytes;
	      sr->FilesOut++;
	      dr->BytesOut += xfe.Bytes;
	      dr->TimeOut += xfe.Time;
	      dr->FilesOut++;
	      if (!ur->Killed)
		{
		  ur->FilesOut++;
		  ur->BytesOut += xfe.Bytes;
		  ur->TimeOut += xfe.Time;
		}
	    }
	  else
	    {
	      sr->TimeIn += xfe.Time;
	      sr->BytesIn += xfe.Bytes;
	      sr->FilesIn++;
	      dr->TimeIn += xfe.Time;
	      dr->BytesIn += xfe.Bytes;
	      dr->FilesIn++;
	    }
	}
    }
  if (VerboseOutput)
    fprintf (stderr, "\r%6d\n", LineNumber);
  return (xfer_status == EOF ? OK : ERROR);
}
