/* $Id: procuux.c,v 3.3 1991/09/01 14:02:37 piggy Rel $
 * Read and process /usr/spool/uucp/.Log/uux/*
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	ProcUux()
 *	Process uux log and update commands trees.
 *
 */

#include    <stdio.h>
#include    <string.h>
#include    "hdbstat.h"

#if defined(DIRENT)
#include <dirent.h>
typedef struct dirent DIRECT;
#else
#if defined (NDIR)
#include    <sys/ndir.h>
typedef struct direct DIRECT;
#else
error:"You need the directory package!"
#endif
#endif

#define	DNULL	(DIRECT *)NULL

int
ProcUux ()
{
  DIR *dirfp;
  DIRECT *direntry;
  char dirname[LPNMAX];

  if (DoCommandReport)
    {
      sprintf (dirname, "%s/%s", PrefixPath, UUX_DIR);
      if ((dirfp = opendir (dirname)) == (DIR *) NULL)
	{
	  perror("ProcUux(opendir)");
	  return (ERROR);
	}

      if (VerboseOutput)
	fputs("\nProcessing uux logs:", stderr);

      while ((direntry = readdir (dirfp)) != DNULL)
	{
	  FILE *UuxFp;
	  char PathName[LPNMAX];
	  char System[15];
	  static void ProcUuxEntry PROTO( (FILE *, char *) );

	  if (*direntry->d_name == '.')
	    continue;
#if defined(DIRENT)
	  sprintf (System, "%s", direntry->d_name);
#else
	  sprintf (System, "%.*s", direntry->d_namlen, direntry->d_name);
#endif

          if (JustSomeSystem &&
              (CheckSystemEsist(System) == (sysrep_t *) NULL))
            continue;

	  sprintf (PathName, "%s/%s/%s", PrefixPath, UUX_DIR, System);
	  if ((UuxFp = fopen (PathName, "r")) == (FILE *) NULL)
	    {
              perror("ProcUux(fopen)");
	      return ERROR;
	    }

	  ProcUuxEntry (UuxFp, System);
	  fclose (UuxFp);
	}
    }
  return OK;
}

static void
ProcUuxEntry (fp, sys)
     FILE *fp;
     char *sys;
{
  char line[256];
  sysrep_t *sr = InsertSys (sys);	/* {2} */
  int LineNumber = 0;

  if (!sr->Killed)
    {
      if (VerboseOutput)
	fprintf(stderr, "\n%s:\n", sys);
      while (fgets (line, 256, fp) != NULL)
	{
	  commrep_t *cr;
	  userrep_t *ur;
	  dailyrep_t *dr;
	  char *User;
	  int Month, Day, atoi ();
	  char commandline[128];
	  char *argument, *command;

          if (VerboseOutput && (++LineNumber % 50) == 0)
	    fprintf(stderr, "\r%6d", LineNumber);

	  User = strtok (line, " ");
	  ur = InsertUser (User);
	  (void) strtok (NULL, "(");
	  Month = atoi (strtok (NULL, "/"));
	  Day = atoi (strtok (NULL, "-"));
	  dr = InsertDay ((short) Month, (short) Day);
	  (void) strtok (NULL, "(");
	  sprintf (commandline, "(%s) %s ", sys,
		   (command = strtok (NULL, " ")));
	  argument = strtok (NULL, ")\n");
	  if (argument != NULL)
	    strcat (commandline, argument);
	  if (!ur->Killed)
	    {
	      cr = InsertComm (&ur->Commands, commandline);
	      cr->Number++;
	    }
	  cr = InsertComm (&dr->Commands, commandline);
	  cr->Number++;
	  sprintf (commandline, "%s ", command);
	  if (argument != NULL)
	    strcat (commandline, argument);
	  cr = InsertComm (&sr->Commands, commandline);
	  cr->Number++;
	}
      if (VerboseOutput)
	fprintf(stderr, "\r%6d\n", LineNumber);
    }
}
