/* $Id: procuucp.c,v 3.3 1991/09/01 14:02:30 piggy Rel $
 * Read and process /usr/spool/uucp/.Log/uucp/*
 *
 *   Copyright (C) 1991  Lele Gaifax (piggy@idea.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * SYNOPSIS:
 * int	ProcUucp()
 *	Process uucp log and update commands trees.
 *
 */

#include    <stdio.h>
#include    <string.h>
#include    "hdbstat.h"

#if defined(DIRENT)
#include <dirent.h>
typedef struct dirent DIRECT;
#else
#if defined(NDIR)
#include    <sys/ndir.h>
typedef struct direct DIRECT;
#else
error:"You need the directory package!"
#endif
#endif

#define	DNULL	(DIRECT *)NULL

int 
ProcUucp ()
{
  DIR *dirfp;
  DIRECT *direntry;
  char dirname[LPNMAX];

  sprintf (dirname, "%s/%s", PrefixPath, UUCP_DIR);
  if ((dirfp = opendir (dirname)) == (DIR *) NULL)
    { 
      perror("ProcUucp(opendir)");
      return (ERROR);
    }

  if (VerboseOutput)
    fputs("\nProcessing uucp logs:", stderr);

  while ((direntry = readdir (dirfp)) != DNULL)
    {
      FILE *UucpFp;
      char PathName[LPNMAX];
      char System[15];
      static void ProcUucpEntry PROTO( (FILE *, char *) );
      
      if (*direntry->d_name == '.')
	continue;
#if defined(DIRENT)
      sprintf (System, "%s", direntry->d_name);
#else
      sprintf (System, "%.*s", direntry->d_namlen, direntry->d_name);
#endif

      if (JustSomeSystem &&
          (CheckSystemEsist(System) == (sysrep_t *) NULL))
        continue;

      sprintf (PathName, "%s/%s/%s", PrefixPath, UUCP_DIR, System);
      if ((UucpFp = fopen (PathName, "r")) == (FILE *) NULL)
	{
	  perror("ProcUucp(fopen)");
	  return ERROR;
	}

      ProcUucpEntry (UucpFp, System);
      fclose (UucpFp);
    }
  return OK;
}

static void 
ProcUucpEntry (fp, sys)
     FILE *fp;
     char *sys;
{
  char line[256];
  sysrep_t *sr = InsertSys (sys);
  int LineNumber = 0;

  if (!sr->Killed)
    {
      if (VerboseOutput)
        fprintf(stderr, "%s:\n", sys);
      while (fgets (line, 256, fp) != NULL)
	{
	  commrep_t *cr;
	  userrep_t *ur;
	  char *User;
	  char commandline[128];
	  char *file1, *file2;

          if (VerboseOutput && (++LineNumber % 50) == 0)
	    fprintf(stderr, "\r%6d", LineNumber);
	  User = strtok (line, " ");
	  ur = InsertUser (User);
	  (void) strtok (NULL, ")");
	  (void) strtok (NULL, "(");
	  file1 = strtok (NULL, " ");
	  (void) strtok (NULL, " ");
	  file2 = strtok (NULL, ")");
	  sprintf (commandline, "uucp %s %s", file1, file2);
	  if (!ur->Killed)
	    {
	      cr = InsertComm (&ur->Commands, commandline);
	      cr->Number++;
	    }
	  cr = InsertComm (&sr->Commands, commandline);
	  cr->Number++;
	}
      if (VerboseOutput)
        fprintf(stderr, "\r%6d\n", LineNumber);
    }
}
