/*
 *	TERMIOS support functions for System V.3
 *	This functions should go into libc.a
 *
 *	Udo Munk (udo@umunk.GUN.de)
 */

#include <stdio.h>
#include <termio.h>
#include <string.h>

struct termio __tty__;

/*
 *	get tty line speed
 */
__get_tty_speed__(tty)
struct termio *tty;
{
	return(tty->c_cflag & CBAUD);
}

/*
 *	set tty line speed
 */
__set_tty_speed__(tty, speed)
struct termio *tty;
int speed;
{
	if (speed == B0 || speed == B50 || speed == B75 ||
	    speed == B110 || speed == B134 || speed == B150 ||
	    speed == B200 || speed == B300 || speed == B600 ||
	    speed == B1200 || speed == B1800 || speed == B2400 ||
	    speed == B4800 || speed == B9600 || speed == B19200 ||
	    speed == B38400) {
		tty->c_cflag = (tty->c_cflag & ~CBAUD) | speed;
		return(0);
	} else
		return(-1);
}

/*
 *	POSIX.1 ctermid function
 */
char *ctermid(str)
char *str;
{
	static char ctermid_name[15];

	if (str == NULL)
		str = &ctermid_name[0];
	return(strcpy(str, "/dev/tty"));
}
