/*
 *	Example program for TERMIOS, taken from the book
 *	Advanced Programming in the UNIX Environment
 *	but modified for System V.3
 *
 *	Udo Munk (udo@umunk.GUN.de)
 */

#include	<signal.h>
#include	<stdio.h>
#include	"termios.h"

#define	MAX_PASS_LEN	8	/* max # of chars for user to enter */

char *getpass(prompt)
const char *prompt;
{
	static char	buf[MAX_PASS_LEN + 1];
	char		*ptr;
	struct termios	term, termsave;
	FILE		*fp;
	int		c;

	/* open terminal */
	if ( (fp = fopen("/dev/tty", "r+")) == NULL)
		return(NULL);

	setbuf(fp, NULL);

	/* block signals */
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
#ifdef SIGTSTP
	signal(SIGTSTP, SIG_IGN);
#endif

	/* get current tty state and save it for later */
	tcgetattr(fileno(fp), &termsave);
	term = termsave;

	/* echo off, so that password don't become visible */
	term.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL);
	tcsetattr(fileno(fp), TCSAFLUSH, &term);

	/* write the prompt to the terminal */
	fputs(prompt, fp);

	/* now read password from user */
	ptr = buf;
	while ( (c = getc(fp)) != EOF && c != '\n') {
		if (ptr < &buf[MAX_PASS_LEN])
			*ptr++ = c;
	}

	/* terminate buffer and write a newline */
	*ptr = 0;
	putc('\n', fp);

	/* restore tty state */
	tcsetattr(fileno(fp), TCSAFLUSH, &termsave);

	/* restore signals */
	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
#ifdef SIGTSTP
	signal(SIGTSTP, SIG_DFL);
#endif

	/* close the terminal */
	fclose(fp);

	return(buf);
}

void main()
{
	printf("You entered <%s>\n", getpass("Enter Password: "));
}
