/*
 *	This is very simple server for testing the socket library.
 *	5/29/92 Udo Munk
 */
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MY_PORT 30000
#define TRUE 1

extern int errno;

main()
{
	int			sd, nsd, err;
	struct sockaddr_in	server;
	char			buf[20];
	char			*term = "**EXIT**";

	/* clear our address */
	bzero((char *)&server, sizeof(server));
	
	/* create socket */
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) <= 0) {
		err = errno;
		fprintf(stderr, "server: can't create socket\n");
		fprintf(stderr, "server: errno = %d\n", err);
		exit(1);
	}

	server.sin_family = AF_INET;
	server.sin_addr.s_addr = htonl(INADDR_ANY);
	server.sin_port = htons(MY_PORT);
  
  	/* bind the socket */
	if ((bind(sd, (struct sockaddr *)&server, sizeof(server))) != 0) {
		err = errno;
		fprintf(stderr, "server: can't bind socket\n");
		fprintf(stderr, "server: errno = %d\n", err);
		close(sd);
		exit(1);
	}
  
  	/* listen on the socket */
	if ((listen(sd, 1)) != 0) {
		err = errno;
		fprintf(stderr, "server: can't listen on socket\n");
		fprintf(stderr, "server: errno = %d\n", err);
		close(sd);
		exit(1);
	}

	/* accept connections on the socket */
	if ((nsd = accept(sd, (struct sockaddr*)0, (int *)0)) == -1) {
		err = errno;
		fprintf(stderr, "server: can't accept connection\n");
		fprintf(stderr, "server: errno = %d\n", err);
		close(sd);
		exit(1);
	}

	/* echo every message back to client, exit on terminate string */
	while (TRUE) {
		bzero(&buf[0], sizeof(buf));
		read(nsd, &buf[0], sizeof(buf));

		if (!strncmp(buf, term, strlen(term)))
			break;
		write(nsd, &buf[0], sizeof(buf));
	}
	fprintf(stdout, "server: terminate string received\n");

	/* close sockets */
	close(nsd);
	close(sd);
	exit(0);
}
