/*
 *	This is very simple client for testing the socket library.
 *	First run the server in the background, before you run this client!
 *	5/29/92 Udo Munk
 */
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MY_PORT 30000

extern int errno;

main()
{
	int			sd, err;
	struct sockaddr_in	client;
	char			buf[20];
	char			*msg = "hello world";
	char			*term = "**EXIT**";

	/* clear our address */
	bzero((char *)&client, sizeof(client));
	
	/* create socket */
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) <= 0) {
		err = errno;
		fprintf(stderr, "client: can't create socket\n");
		fprintf(stderr, "client: errno = %d\n", err);
		exit(1);
	}

	client.sin_family = AF_INET;
	client.sin_addr.s_addr = htonl(INADDR_ANY);
	client.sin_port = htons(MY_PORT);
  
	/* connect to the socket */
	if (connect(sd, (struct sockaddr*)&client, sizeof(client))) {
		err = errno;
		fprintf(stderr, "client: can't connect socket\n");
		fprintf(stderr, "client: errno = %d\n", err);
		close(sd);
		exit(1);
	}
	/* send "hello world" to server */
	fprintf(stdout, "client: send to server: <%s>\n", msg);
	write(sd, msg, strlen(msg));
	
	/* now receive from server */
	read(sd, &buf[0], sizeof(buf));
	fprintf(stdout, "client: answer from server: <%s>\n", buf);
	
	/* send termination string to server */
	fprintf(stdout, "client: send terminate string to server\n");
	write(sd, term, strlen(term));
	
	/* close socket */
	close(sd);
	exit(0);
}
