#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sgtty.h>
#include <errno.h>
#include <fcntl.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

int
soioctl(fildes, request, arg)
int fildes, request, *arg;
{
	register struct socket *so;
	struct stat sbuf;

	if ((so = GETSOCKET(fildes)) == NULL)
		return -1;
	switch (request) {
	case FIOSNBIO:
		if (*arg) {
			if (so->so_fd != -1)
				fcntl(so->so_fd, F_SETFL,
				      fcntl(so->so_fd, F_GETFL, 0) | O_NDELAY);
			if (so->so_rfd != -1)

				fcntl(so->so_rfd, F_SETFL,
				      fcntl(so->so_rfd, F_GETFL, 0) | O_NDELAY);
			so->so_state |= SS_NBIO;
		} else {
			if (so->so_fd != -1)
				fcntl(so->so_fd, F_SETFL,
				      fcntl(so->so_fd, F_GETFL, 0) & ~O_NDELAY);
			if (so->so_rfd != -1)
				fcntl(so->so_rfd, F_SETFL,
				      fcntl(so->so_rfd, F_GETFL, 0) & ~O_NDELAY);
			so->so_state &= ~SS_NBIO;
		}
		break;
		
#ifdef FIOASYNC
	case FIOASYNC:
		if (*arg)
			so->so_state |= SS_ASYNC;
		else
			so->so_state &= ~SS_ASYNC;
		return (0);
#endif

	case FIONREAD:
		if (fstat(so->so_rfd, &sbuf) == -1)
			return -1;
		*arg = sbuf.st_size;
		return (0);

	default:
		errno = EOPNOTSUPP;
		return -1;
	}
	return 0;
}
