#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

/*
 * Most socket options are no-ops
 * but we set them anyway, so that a getsockopt can
 * read them back.
 */
int
setsockopt(s, level, name, val, valsize)
int s, level, name, valsize;
char *val;
{
	struct socket *so;

	if ((so = GETSOCKET(s)) == NULL)
		return -1;
	if (level != SOL_SOCKET) {
		errno = ENOPROTOOPT;
		return -1;
	}
	switch (name) {
	case SO_LINGER:
	case SO_DEBUG:
	case SO_KEEPALIVE:
	case SO_DONTROUTE:
	case SO_USELOOPBACK:
	case SO_BROADCAST:
	case SO_REUSEADDR:
	case SO_OOBINLINE:
		if (*val)
			so->so_options |= name;
		else
			so->so_options &= ~name;
		break;
		
	case SO_SNDBUF:
	case SO_RCVBUF:
	case SO_SNDLOWAT:
	case SO_RCVLOWAT:
	case SO_SNDTIMEO:
	case SO_RCVTIMEO:
		break;

	default:
		errno = ENOPROTOOPT;
		break;
	}
	return 0;
}
