#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <memory.h>
#include <fcntl.h>
#include <errno.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

extern char *strdup();
static int seq = 1;

int
connect(s, name, namelen)
int s, namelen;
struct sockaddr *name;
{
	register struct socket *so;
	int pid, cc, old_umask;
	char rname[15], wname[15], trname[20], twname[20];
	int rfd, wfd;
	struct socket_packet msg;
	char *path;
	int pfd, sofd;

	if ((so = GETSOCKET(s)) == NULL)
		return -1;
	if (so->so_options & SO_ACCEPTCONN) {
		errno = EOPNOTSUPP;
		return -1;
	}
	/*
	 * Can connect only once, otherwise, try to disconnect first.
	 * This allows user to disconnect by connecting to, e.g.,
	 * a null address.
	 */
	if (so->so_state & SS_ISCONNECTED) {
		if (_sodisconnect(so) < 0) {
			errno = EISCONN;
			return -1;
		}
	}

	/*
	 * Now find socket to connect to, 
	 */
	path = _socketname(name);
	if (path == NULL) {
		errno = EOPNOTSUPP;
		return -1;
	}
	if ((pfd = open(path, O_RDWR)) == -1)
		return -1;
/*	fcntl(rfd, F_SETFD, O_WRONLY); */ /* Huh ????? */

	/*
	 * Check if other side is listening
	 */
	if (_checksolock(pfd, SO_ACCEPTCONN) == -1) {
		errno = ENOTCONN;
		close(pfd);
		return -1;
	}

	/*
	 * Other side is listening. Set up the socket
	 * data channels.
	 */
	pid = getpid();
	sprintf(rname, "SR.%d.%d", pid, ++seq);
	sprintf(trname, "/tmp/%s", rname);
	sprintf(wname, "SW.%d.%d", pid, seq);
	sprintf(twname, "/tmp/%s", wname);
	old_umask = umask(0);
	if (mknod(trname, S_IFIFO|0777, 0) == -1 ||
	    mknod(twname, S_IFIFO|0777, 0) == -1) {
		umask(old_umask);
		goto bad3;
	}
	umask(old_umask);
	if ((rfd = open(trname, O_RDWR)) == -1)
		goto bad2;
	fcntl(rfd, F_SETFD, O_RDONLY);
	if ((wfd = open(twname, O_RDWR)) == -1)
		goto bad1;
	fcntl(wfd, F_SETFD, O_WRONLY);
	/*
	 * Now send a message telling that we want to connect
	 */
	msg.scm_magic = SOCKET_MAGIC;
	msg.scm_msg = MSG_CONNECT;
	msg.scm_type = so->so_type;
	strcpy(msg.scm_rname, rname);
	strcpy(msg.scm_wname, wname);
	strcpy((char *)&msg.scm_addr.un.sun_path[0], so->so_name);
	cc = write(pfd, (char *)&msg, sizeof(msg));
	if (cc == -1)
		goto bad;
	if (cc != sizeof(msg)) {
		errno = EPIPE; goto bad;
	}

	/*
	 * Message sent. Now we have to receive a message
	 * on our socket pipe, to finalize the handshake.
	 */
	cc = read(so->so_fd, (char *)&msg, sizeof(msg));
	if (cc == -1)
		goto bad;
	if (cc != sizeof(msg) || msg.scm_magic != SOCKET_MAGIC) {
		errno = EIO;
		goto bad;
	}
	if (msg.scm_msg != MSG_CONNECT_OK) {
		errno = ECONNREFUSED;
		goto bad;
	}
	if (so->so_type != msg.scm_type) {
		errno = EPROTOTYPE;
		goto bad;
	}

	/*
	 * Juggle around the file descriptors so that the socket
	 * fd refers to the read pipe.
	 */
	sofd = dup(so->so_fd);
	if (sofd == -1)
		goto bad;
	rfd = dup2(rfd, so->so_fd);
	if (rfd == -1) {
		close(sofd);
		goto bad;
	}
	so->so_conn = (struct sockaddr *)malloc(SOCKADDRLEN(&msg.scm_addr.sa));
	memcpy((char *)so->so_conn, (char *)&msg.scm_addr, SOCKADDRLEN(&msg.scm_addr.sa));
	so->so_state |= SS_ISCONNECTED;
	so->so_rname = strdup(rname);
	so->so_wname = strdup(wname);
	so->so_rfd = rfd;
	so->so_wfd = wfd;
	so->so_pfd = pfd;
	so->so_fd = sofd;
	return 0;

bad:	close(wfd); 
bad1:	close(rfd);
bad2:	unlink(trname); unlink(twname);
bad3:	close(pfd);
	so->so_rfd = so->so_wfd = so->so_pfd = -1;
	return -1;
}
