#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <memory.h>
#include <errno.h>
#include "socket.h"
#include "in.h"
#include "un.h"
#include "socketvar.h"

extern char *malloc(), *strdup();
static int doconnect();
static struct socket_packet msg;

int
accept(s, name, anamelen)
int s, *anamelen;
struct sockaddr *name;
{
	register struct socket *so;
	int cc, fd, e;

	if ((so = GETSOCKET(s)) == NULL)
		return -1;
	if ((so->so_options & SO_ACCEPTCONN) == 0) {
		errno = EINVAL;
		return -1;
	}
	/*
	 * Read a packet from the pipe
	 */
	cc = read(so->so_fd, (char *)&msg, sizeof(msg));
	if (cc == 0 && so->so_state & SS_NBIO) {
		errno = EWOULDBLOCK;
		return -1;
	}
	if (cc == -1)
		return -1;
	if (msg.scm_magic != SOCKET_MAGIC) {
		/* Garbage block. Do nothing */
		errno = EIO;
		return -1;
	}

	/*
	 * Dispatch on packet type
	 */
	switch (msg.scm_msg) {
	case MSG_CONNECT:
		if ((fd = doconnect(so)) != -1) {
			so = GETSOCKET(fd);
			if (anamelen)
				*anamelen = SOCKADDRLEN(so->so_conn);
			if (name)
				memcpy((char *)name, (char *)so->so_conn, *anamelen);
			return fd;
		}
	case MSG_DISCONNECT:
		e = _sodisconnect2(so);
		errno = ECONNABORTED;
		return -1;

	default:
		errno = EOPNOTSUPP;
		return -1;
	}
}

	
static int
doconnect(so)
register struct socket *so;
{
	register struct socket *so2;
	int rfd, wfd, sofd, pfd;
	char twname[20], trname[20];
	int peersotype;
	int cc;

	/*
	 * Open up our side of the socket files.
	 * Note that read and write sides are swapped.
	 *
	 */
	sprintf(twname, "/tmp/%s", msg.scm_wname);
	if ((rfd = open(twname, O_RDWR)) == -1)
		return -1;
	fcntl(rfd, F_SETFD, O_RDONLY);
	sprintf(trname, "/tmp/%s", msg.scm_rname);
	if ((wfd = open(trname, O_RDWR)) == -1) {
		close(rfd);
		return -1;
	}
	fcntl(wfd, F_SETFD, O_WRONLY);
	if ((pfd = open(msg.scm_addr.un.sun_path, O_RDWR)) == -1) {
		close(rfd); close(wfd);
		return -1;
	}

	/*
	 * Connection established. Pass back
	 * our message.
	 */
	msg.scm_magic = SOCKET_MAGIC;
	peersotype = msg.scm_type;
	msg.scm_type = so->so_type;
	msg.scm_msg = peersotype == so->so_type ? MSG_CONNECT_OK : MSG_FAIL;
	memcpy((char *)&msg.scm_addr, (char *)so->so_addr, SOCKADDRLEN(so->so_addr));
	cc = write(pfd, (char *)&msg, sizeof msg);
	if (cc == -1)
		goto bad;
	if (cc != sizeof msg) {
		errno = EIO;
		goto bad;
	}
	if (peersotype != so->so_type) {
		errno = EPROTOTYPE;
		goto bad;
	}

	if ((sofd = socket(so->so_domain, so->so_type, so->so_protocol)) == -1)
		goto bad;
	/*
	 * Juggle around the file descriptors so that the socket
	 * fd refers to the read pipe.
	 */
	so2 = GETSOCKET(sofd);
	sofd = dup(so->so_fd);
	if (sofd == -1) {
		soclose(sofd);
		goto bad;
	}
	rfd = dup2(rfd, so2->so_fd);
	if (rfd == -1) {
		close(sofd);
		soclose(sofd);
		goto bad;
	}
	so2->so_fd = sofd;
	so2->so_rfd = rfd;
	so2->so_wfd = wfd;
	so2->so_pfd = pfd;
	so2->so_addr = NULL;
	so2->so_conn = (struct sockaddr *)malloc(SOCKADDRLEN(so->so_addr));
	memcpy((char *)so2->so_conn, (char *)&msg.scm_addr, SOCKADDRLEN(so->so_addr));
	so2->so_rname = strdup(msg.scm_wname);
	so2->so_wname = strdup(msg.scm_rname);
	so2->so_state |= SS_ISCONNECTED;
	return rfd;

bad:
	close(rfd); close(wfd); close(pfd);
	unlink(trname); unlink (twname);
	return -1;
}
