.TH RCSCLEAN L "October 30, 1989" "Purdue University"
.SH NAME
rcsclean \- clean up working files
.SH SYNOPSIS
\fBrcsclean\fR [ \fB-r\fIrev\fR ] [ \fB-q\fIrev\fR ] file...
.SH DESCRIPTION
.I Rcsclean
removes working files that were checked out and never modified.
For each file given, \fIrcsclean\fR
compares the working file and a revision in the corresponding
RCS file. If it finds no difference, it removes the working file, and,
if the revision was locked by the caller, unlocks the revision.
.PP
A file name ending in ',v' is an RCS file name, otherwise a
working file name. \fIRcsclean\fR derives the working file name from the RCS
file name and vice versa, as explained in
.IR co (L).
Pairs consisting
of both an RCS and a working file name may also be specified.
.PP
\fIRev\fR specifies with which revision the working file is compared.
If \fIrev\fR is omitted, \fIrcsclean\fR compares the working file with
the latest revision
on the default branch (normally the highest branch on the trunk).
The option \fB-q\fR suppresses diagnostics.
.PP
\fIRcsclean\fR is useful for "clean" targets in Makefiles.
Note that
.IR rcsdiff (L)
prints out the differences.
Also,
.IR ci (L)
normally asks whether to check in a file
if it was not changed.
.SH EXAMPLES
.nf
The command

	rcsclean *.c *.h

.fi
removes all working files ending in ".c" or ".h" that were not changed
since their checkout.
.SH DIAGNOSTICS
The exit status is 0 if there were no differences
during the last comparison or if the last working file did not exist,
1 if there were differences, and 2 if there were errors.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.3 $
; Release Date:
.VL $Date: 89/10/30 17:36:41 $
\&.
.sp 0
Copyright \(co 1982, 1988, 1989 by Walter F. Tichy.
.SH SEE ALSO
co(L), ci(L), ident(L), rcs(L), rcsdiff(L), rcsintro(L), rcsmerge(L),
rlog(L), rcsfile(L).
