/* MAIN.C - PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 
 *
 *		Author: Herbert R. Alcorn  --  mwcbbs:  Alcorn!herb
 *
 *		Herb's List Program.  Usable on any(?) terminal, but works best on a PC
 *		keyboard with the keypad keys; however, ALL of the keypad keys are
 *		repeated on the alpha keyboard!  For some reason(?) the top and bottom
 *		lines don't show in standout mode on my Wyse-50!  Ideas for this 
 *		program were freely researched(!) from several sources: Mark Quarles'
 *		Coherent List program, the keyboard driver for the Micro Emacs editor,
 *		some old DOS programs of mine, Vernon D. Buerg's MS-DOS List utility, 
 *		and wherever else good ideas come from.  When the recursive Directory
 *		Display subsystem was added, I did not yield to the urge to show the ..
 *		parent directory (and thereby allow recursion both down and back) to
 *		avoid getting lost in the weeds - and run out of stack space!
 *		I like to keep this lister (named l) on my ram disk, for fast access.
 *
 *		Intended improvements: allow programs bigger than malloc-able memory
 *		to be listed by slicing; add ???; ad-nauseam!
 *		
 *		I'll put this back on the BBS if I ever get this stuff done. 
 *		Please notify me by e-mail thru the mwcbbs if you find bugs, there's
 *		gotta be a few left.  I will leave as an exercise for the user the 
 *		problem of adapting this lister to exotic terminals!
 *
 *		I freely contribute this program, all or any part, to the public domain
 *		for any use whatsoever.  Author, Herbert R. Alcorn
 *
 *		Compile with:  make
 *							cp pclist /fast/bin/l  (or whatever)
 *
 *		Compile w/ -DHDB option to activate the buffer debugging scheme.
 *
 *		Ver.	Date		Modifications:
 *		2.0.3	5/20/91	Added Segmented buffer system to Display File.
 *		2.0.4	5/22/91	Added Recursive Directory Display subsystem.  Try:
 *							list /   (you can browse the entire file system!)
 *		2.0.5	5/23/91	Added x or X for Quick exit from nested directories or
 *							command line multiple file display.
 *		2.0.5	5/24/91	Allow left (& right) shifts of 10 char's at a time
 *							to see lines longer than 80 char's (were just chopped!)
 *							(If the arrow keys seem backwards to you, interchange 
 *							the two lines commented 'Shift Left' and 'Shift Right'
 *							in the procedure disp_file (). )
 *		2.0.6	5/25/91	Added the find (search) and Find (Search) capability.
 *							Use s or f for case-sensitive, S or F for case-
 *							insensitive, and a or A for search again (like before).
 *		2.0.7	5/27/91	Added the Help facility (z, Z or ?) and fixed ability
 *							to display Manual pages (needed 0x08 in detab ()).
 *							Broke pclist into several files w/ pclist.h for ease,
 *							added Makefile.
 */

#include "pclist.h"

#ifdef HDB
FILE *dbf;
#endif

WINDOW *swin;							/* Global Subwindow, for text */
WINDOW *fwin;							/* Global Subwindow, for find */
WINDOW *hwin;							/* Global Subwindow, for help */
L_INDX *l_ndx;							/* Global line headers			*/
int buf_blk_no;						/* Global Buffer Block Index	*/
char *buf_list[BLOCK_NO];			/* Global Buffer Block List	*/
char *buf, *buf_p;					/* Global buffer pointers		*/
char *buf_end;							/* Global Buffer End Pointer	*/
long int buf_size;					/* Global Buffer Available		*/
int waste_buf;							/* Keep track of Wasted buf space */

FILE *fp, *dfp;						/* Global file, directory ptr's	 */
int end_of_file;						/* Global end-of-file Indicator   */
int early_end;							/* Global File-wont-fit Indicator */
int last_line;							/* Global Last line No (so far)   */
int exit_switch = 0;					/* Global Leave Quickly, properly */
int have_pat_sw = 0;					/* For Again, I got a pattern!	 */
int H_L_line_no = 0;					/* For Find, "THE" line (0 = none) */
int tab_size = 8;						/* Set it as you like it, see main */

char pattern[Pat_len+1];	/* Buf for Find Pattern			*/
char header[81] = " ";		/* Header - Once per file		*/
char *file_trailer =					/* Trailer - For sale or rent	*/
		"<Enter, N>xt-pg <B>k-pg <H>ome <E>nd <U>p <D>own <L>eft <R>ight "
		" <Q>uit <X>it ? ";			/* DON'T CHANGE THE LENGTH OF THIS !!! */
char *dir_trailer =					/* Trailer - Ditto, Dir Screen */
		"<Enter> <N>xt-pg <B>k-pg <H>ome <E>nd <U>p <D>own <L>eft <R>ight"
		" <Q>uit <X>it ? ";			/* DON'T CHANGE THE LENGTH OF THIS !!! */
		
char *exit_msg = NULL;				/* Global exit error message		 */
char *exec_err_msg_1 = 
		"****> Can't Display an Object, Execution or Archive Module! <****";
char *exec_err_msg_2 = "****> Can't Open That Input file! <****";
char *exec_err_msg_3 = "****> Can't Open That Directory! <****";

/* LEAVE --		Clean up and exit.
 */
void leave (exit_code, name)
int exit_code;
char *name;
{
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, "Leave\n");
	fclose (dbf);
#endif
	echo (); nl (); noraw (); crmode ();
	delwin (swin);						/* Get rid of Sub Window */
	endwin ();							/* Turn off Curses		 */
	free_buf ();						/* Free Buffer System Memory */
	if (fp != NULL)
		fclose (fp);					/* Close it for him, he knoweth not */
	if (exit_msg != NULL)			/* Write Error Msg, If any */
		if (name == NULL)
			fprintf (stderr, exit_msg);
		else
			fprintf (stderr, exit_msg, name);
#ifdef HDB
	dbf = fopen ("list-db", "a");
	fprintf (dbf, exit_msg);
	fprintf (dbf, "PCLIST: Leaving!\n");
	fclose (dbf);
#endif
	exit (exit_code);
}

/* DISP_FILE --	Display a file.  Mostly manage the translated input
 *						keystrokes, letting disp_file_scr () do all the work.
 */
void disp_file (name)
char *name;
{
	int c, l, old_l, f_shift;
	
	if ((fp = fopen (name, "r")) == NULL)  {
		cls (0, NULL);			/* Handle the Can't Open That File problem! */
		mvwaddstr (swin, 12, 20, exec_err_msg_2);
		wrefresh (swin);
		getakey ();
		return;
	}

	init_buf (LINE_MAX);			/* Start up the segmented Buffer System */
	reset_hdrs (name, "File:", file_trailer);	/* Set up the hdr & Trlr */

	end_of_file = early_end = f_shift = 0;
	last_line = 1;
	l = 1;
	old_l = 2;
	do {
		if (l != old_l)			/* Eliminate flicker for a do-nothing key */
			if (disp_file_scr (l, fp, f_shift))  {
				free_buf ();		/* Handle Non-Displayable File! */
				fclose (fp);
				getakey ();
				return;
			}
		old_l = l;

		switch ((c = getakey ()))  {
			case (10): case (13): case ('n'): case ('N'): case (P_PGDN):
				if ((l += Text_lines) >= last_line - Text_lines)
					if ((l = last_line - Text_lines - 1) < 1)
						l = 1;
				break;
			case ('b'): case ('B'): case (P_PGUP):
				if ((l -= Text_lines) < 1)
					l = 1;
				break;
			case ('u'): case ('U'): case (P_UP):
				if (--l < 1)
					l = 1;
				break;
			case ('d'): case ('D'): case (' '): case (P_DOWN):
				if (++l >= last_line - 1)
					l = last_line - 2;
				break;
			case ('l'): case ('L'): case (P_LEFT):  /* Shift left */
				if (f_shift - 10 >= 0)
					f_shift -= 10, old_l++;
				break;
			case ('r'): case ('R'): case (P_RIGHT): /* Shift right */
				if (f_shift + 10 < MAX_SHIFT)
					f_shift += 10, old_l++;
				break;
			case ('h'): case ('H'): case (P_HOME):
				l = 1;
				break;
			case ('e'): case ('E'): case (P_END):
				if ((l = last_line - Text_lines - 1) < 1)
					l = 1;
				break;				/* Maybe we have even read the whole file? */
			case ('f'): case ('s'):			/* Case-Sensitive search (find)   */
				l = do_find (l, 1, 1);			/* Sensitive, Need new Pattern */
				old_l = 0;
				break;
			case ('F'): case ('S'):			/* Case-Insensitive search (find) */
				l = do_find (l, 0, 1);			/* Insensitive, Need new Pattern */
				old_l = 0;
				break;
			case ('a'): case ('A'):			/* Repeat search (find)  */
				l = do_find (l, 1, 0);			/* Sensitive, Don't force Pattern? */
				old_l = 0;
				break;
			case ('z'): case ('Z'):	case ('?'):	/* Show File Help Screen */
				help_scr (1);
				old_l = 0;
				break;
			case ('q'): case ('Q'):			/* Adios, for now */
				c = 'q';
				break;
			case ('x'): case ('X'):			/* Use x for Quick, Total Exit */
				exit_switch = 1;
				c = 'q';
				break;
			default:				/* If we get here, I didn't want it anyway! */
				break;
		}  /* of switch (c) */
	} while (c != 'q');
	free_buf ();
	fclose (fp);
	fp = NULL;
}

/* DISP_DIR --	Display a Directory's Contents, mostly manage the translated
 *					input keystrokes, letting disp_dir_scr () do all the work.
 */
void disp_dir (dir_nm, no)
char *dir_nm;
int no;
{
	char *buf, *wd, *getwd (), cwd[128], dir_name[128];
	struct AE **array;
	int c, nt, nd, nf, H_L_item, tpb, tpe;

	wd = getwd ();					/* if we ever go back to the caller */
	strcpy (cwd, wd);				/* get a copy that we can mess with it */

	if (*dir_nm == '/')
		strcpy (dir_name, dir_nm);		/* (S)he specified a root path */
	else  {
		strcpy (dir_name, cwd);
		if (strcmp (dir_nm, "."))  {	/* Take the cheap way out! */
			strcat (dir_name, "/");
			strcat (dir_name, dir_nm);
		}
	}

	no += 4;							/* for slack in allocations */
	if ((buf = malloc (no * (DIRSIZ + 5))) == NULL)  {  /* and room for size */
		exit_msg = "Can't allocate Memory for disp_dir Buffer!\n";
		leave (1, NULL);
	}
	if ((array = (struct AE **) calloc (no, sizeof (char *))) == NULL)  {
		exit_msg = "Can't allocate Memory for disp_dir Name Array!\n";
		leave (1, NULL);
	}

	nt = nd = nf = 0;
	chdir (dir_name);
	if (read_dir_file (dir_name, array, buf, &nt, &nd, &nf))  {
		chdir (cwd);
		free (buf);			/* Handle the Can't Open the Dir. problem! */
		free (array);
		return;
	}
	chdir (cwd);

	reset_hdrs (dir_name, " Dir:", dir_trailer);	/* Set up the hdr & Trlr */
	H_L_item = tpb = 0;						/* Zero Hi-Lite & Page Beginning	 */
	do  {
		tpe = (tpb + 65 >= nt) ? nt-1 : tpb + 65;		  /* Set the page end  */
		disp_dir_scr (array, tpb, H_L_item, nt, nd);   /* do the real work! */

		switch ((c = getakey ()))  {
			case (10): case (13):			/* Select via Enter */
				if (nt == 0)
					break;
				chdir (dir_name);					/* Change to dir. displayed */
				if (H_L_item < nd)				/* If Directory, Recur! */
					disp_dir (array[H_L_item]->name,
						(int) (array[H_L_item]->size / sizeof (struct direct)));
				else
					disp_file (array[H_L_item]->name); /* Let'em Look! */
				chdir (cwd);						/* Back to our original dir. */
				cls (0, NULL);
				reset_hdrs (dir_name, " Dir:", dir_trailer);
				if (exit_switch)					/* If (S)he wants out quick */
					c = 'q';
				break;
			case ('u'): case ('U'): case (P_UP):
				if (--H_L_item < tpb)						/* if a prev. line */
					H_L_item = tpb;
				break;
			case ('d'): case ('D'): case (' '): case (P_DOWN):
				if (++H_L_item > tpe)						/* if another line */
					H_L_item = tpe;
				break;
			case ('l'): case ('L'): case (P_LEFT):
				if (H_L_item-Text_lines >= tpb)			/* if a prev. column */
					H_L_item -= Text_lines;
				break;
			case ('r'): case ('R'): case (P_RIGHT):
				if (H_L_item + Text_lines <= tpe)		/* if a next column */
					H_L_item += Text_lines;
				break;
			case ('n'): case ('N'): case (P_PGDN):
				if  (tpb + 66 < nt)							/* if another page? */
					H_L_item = tpb += 66;
				break;
			case ('b'): case ('B'): case (P_PGUP):
				if  (tpb - 66 >= 0)							/* if a prev page? */
					H_L_item = tpb -= 66;
				break;
			case ('h'): case ('H'): case (P_HOME):		/* go Home */
				H_L_item = tpb;
				break;
			case ('e'): case ('E'): case (P_END):		/* go to end */
				H_L_item = tpe;
				break;
			case ('z'): case ('Z'):	case ('?'):			/* Show Dir. Help Screen */
				help_scr (0);
				break;
			case ('q'): case ('Q'):							/* go away */
				c = 'q';
				break;
			case ('x'): case ('X'):		/* Use x for Quick, Total Exit */
				exit_switch = 1;
				c = 'q';
				break;
			default:				/* If we get here, I didn't want it anyway! */
				break;
		}  /* of switch (c) */
	} while (c != 'q');
	free (buf);
	free (array);
}

/*	MAIN  --  The beginning of it all, remember the main!
 */
int main (argc, argv)
int argc; char **argv;
{	
	char *env;
	struct stat sb;

#ifdef HDB
	dbf = fopen ("list-db", "w");
	fprintf (dbf, "PCLIST: Main\n");
	fclose (dbf);
#endif
	
	if (argc < 2)  {
		puts ("\nFile and Directory Listing Utility V2.0.7"
					 " -- by: H. R. Alcorn.\n");
		puts ("Usage: pclist  file ...");
		puts ("   z, Z or ? gets you a Help Screen\n");
		exit (1);
	}

			/* Get user's TABSIZ	from his Environment (if there). */
	if ((env = (char *) getenv ("TABSIZ")) != NULL)
		tab_size = atoi (env);

	initscr ();										/* Allow Curses to work    */
	swin = subwin (stdscr, Bot_text_line+1, 80, 0, 0);	/* Define Text Window */
	fwin = subwin (stdscr, 6, 60, 10, 9);					/* Define Find Window */
	hwin = subwin (stdscr, Bot_text_line+1, 80, 0, 0);	/* Define Help Window */
	echo (); nl (); raw (); crmode ();		/* Raw, so addstr() works! */

	while (--argc && !exit_switch)  {	/* Trip thru command line args */
		if (stat (*++argv, &sb))  {
			exit_msg = "Error, Can't Find '%s'!\n";
			leave (1, *argv);
		}
		if ((sb.st_mode & S_IFMT) == S_IFREG)  {	/* Let him do the work! */
			disp_file (*argv);
			continue;
		}
		if ((sb.st_mode & S_IFMT) == S_IFDIR)  {	/* Let's look at Directory */
			disp_dir (*argv, (int) (sb.st_size / sizeof (struct direct)));
			continue;
		}
		exit_msg = "PCLIST: Can't Classify File '%s'!\n";
		leave (1, *argv);
	}	/* of while (--argc) */

	cls (0, " ");									/* Clean up the screen		*/
	leave (0, NULL);								/* And split.					*/
}
