/* HELP.C -- PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

#include "pclist.h"

char *file_help[24] = {
	"             PCLIST - Ver. 2.0.7   File List Help",
	" ",
	" Keys                      Definition or Use",
	" -----------------------   -------------------------------------------",
	" Enter, n, N, PgDn         display Next page of file (if any).",
	" b, B, PgUp                display prev. page (Back) (if any).",
	" u, U, Up-arrow            move display Up one line.",
	" d, D, Dn-arrow, space     move display Down one line.",
	" l, L, Left-arrow          show text to Left of current display.",
	" r, R, Right-arrow         show text to Right of current display.",
	" h, H, Home                show first (Home) page of text.",
	" e, E, End                 show last (End) page of text.",
	" ",
	" f, s                      start a case sensitive Find (Show).",
	" F, S                      start a case insensitive Find (Show).",
	" a, A                      repeat the previous search (Again).",
	" ",
	" z, Z, ?                   display Help - This is it!",
	" ",
	" q, Q                      Quit, return to the previous display.",
	" x, X                      eXit immediately.",
	" ",
	" ",
	""
	};

char *dir_help[24] = {
	"           PCLIST - Ver. 2.0.7   Directory List Help",
	" ",
	" Keys                      Definition or Use",
	" -----------------------   -------------------------------------------",
	" Enter                     select hi-lit entry for display.",
	" u, U, Up-arrow            move hi-lite Up one line.",
	" d, D, Dn-arrow, space     move hi-lite Down one line.",
	" l, L, Left-arrow          move hi-lite to previous column.",
	" r, R, Right-arrow         move hi-lite to following column.",
	" n, N, PgDn                display Next page of directory (if any).",
	" b, B, PgUp                display prev. page of directory (if any).",
	" h, H, Home                show first (Home) page of text.",
	" e, E, End                 show last (End) page of text.",
	" ",
	" z, Z, ?                   display Help - This is it!",
	" ",
	" q, Q                      Quit, return to the previous display.",
	" x, X                      eXit immediately.",
	" ",
	" ",
	" ",
	" ",
	" ",
	""
};

/* HELP_SCR  --	Display the specified (file or dir) Help Screen.
 */
void help_scr (sw)
int sw;
{
	char **help;
	int i;

	help = (sw) ? file_help : dir_help;
	wclear (hwin);
	wmove (hwin, Hdr_line, 0);
	wstandout (hwin);
	waddstr (hwin, help[0]);
	wstandend (hwin);
	for (i = Top_text_line; i <= Text_lines; i++)
		mvwaddstr (hwin, i, 2, help[i]);
	wmove (hwin, 0, 79);
	wrefresh (hwin);
	(void) getakey ();
	wclear (hwin);
	wrefresh (swin);
	return;
}
