/* FIND.C -- PCLIST: A fast, keypad driven listing utility.  Version 2.0.7 */

#include "pclist.h"

/* PROCESS_PATTERN --	Process the User's raw pattern; a do-nothing for
 *								Case-Sensitive mode, else build a Case-Insensitive
 *								search pattern.
 */
void process_pattern (in, out, s_sw)
char *in, *out;
int s_sw;			/* 1 == case-sensitive, 0 == insensitive clod */
{
	char *end;
	
	if (s_sw)
		strcpy (out, in);			/* Sensitive, the easy one! */
	else  {
		for (end = out + Pat_len; *in && out < end; in++)  {
			if (isalpha (*in))  {
				*out++ = '[';
				*out++ = *in;
				*out++ = (isupper (*in)) ? tolower (*in) : toupper (*in);
				*out++ = ']';
			} else
				*out++ = *in;
		}
		*out++ = '\0';
	}
	have_pat_sw = 1;
	return;
}

/* GET_FIND_PATTERN --	Do the Find-Window stuff and input our user's
 *								raw pattern, use process_pattern () to refine it.
 */
void get_find_pattern (pat, sens_sw)
char *pat;
int sens_sw;
{
	char pat_buf[Pat_len + 1];
	
	wclear (fwin);
	box (fwin, '|', '=');
	mvwaddstr (fwin, 1, 17, (sens_sw) ?
					"  Case Sensitive Search " :
					" Case Insensitive Search" );
	mvwaddstr (fwin, 2, 14, "Enter Pattern, end with <Enter>");
	wstandout (fwin);
	mvwaddstr (fwin, 4, 3,
					"                                                      ");
	wstandend (fwin);
	wmove (fwin, 4, 4);
	wrefresh (fwin);
	echo (); crmode (); noraw ();
	wgetstr (fwin, pat_buf);
	noecho (); raw ();
	wclear (fwin);
	process_pattern (pat_buf, pat, sens_sw);
	wrefresh (swin);
	return;
}

/* DO_FIND --	Acquire a Pattern (if req'd), search for the next line that
 *					matches the pattern, Set H_L_line_no and l, then let
 *					disp_file () do all of the hard work.
 */
int do_find (line, sens_sw, get_pat_sw)
 int line, sens_sw, get_pat_sw;
 {
	int i;
	
	if (get_pat_sw || (!get_pat_sw && !have_pat_sw)) /* Do we need one? */
		get_find_pattern (pattern, sens_sw);
	
	for (i = line+1; i < last_line; i++)
		if (pnmatch (l_ndx[i].bufp, pattern, 1))  {
			return (H_L_line_no = i);
		}
	H_L_line_no = 0;
	return line;
 }
