#include <stdio.h>

#include "bool.h"

#include "short.h"

static char termcap_area[400];
static int lines;
static char *cm,*ce,*cd,*al,*dl,*so,*se;
int sg;

int outchar();
int screen_lines;
bool dirty;

full_window ()
{
  extern W_oy,W_dy;
  W_oy = 1;
  W_dy = screen_lines;
}

gotoxy(x,y) int x,y;
{
  tputs (tgoto(cm,x-1,y-1),1,outchar);
}

clreol()
{
  tputs(ce,1,outchar);
}

insLine()
{
  if (al) tputs(al,1,outchar); else dirty=TRUE;
}

DelLine()
{
  if (dl) tputs(dl,1,outchar); else dirty=TRUE;
}

ClrFullScr()
{
  tputs(cd,1,outchar);
}

standout()
{
  if (so) tputs(so,1,outchar);
}

standend()
{
  if (se) tputs(se,1,outchar);
}

outchar(ch) char ch;
{
  putchar(ch);
}

complain(msg,cap) char *msg, *cap;
{
  printf("No %s (%s) capability for this terminal - aborted.\n",msg,cap);
  exit(1);
}

get_terminal_capability()
{
  char bp[1024];
  char *terminal;
  char *getenv();
  char *pointer;
  extern int W_dx;

  if ((terminal=getenv("TERM"))==NULL)
  {
    printf("Environment variable TERM not set.\n");
    return (1);
  }
  switch (tgetent(bp,terminal))
  {
    case -1: printf("Cannot open termcap.\n"); return (1); break;
    case 0: printf("Cannot find %s in termcap.\n",terminal); return (1); break;
  }

  screen_lines = tgetnum("li");
  W_dx = tgetnum("co");

  pointer = termcap_area;
  if ((cm=tgetstr("cm",&pointer))==NULL) complain("cursor motion","cm");
  if ((ce=tgetstr("ce",&pointer))==NULL) complain("clear to end of line","ce");
  if ((cd=tgetstr("cd",&pointer))==NULL) complain("clear to end of display","cd");
  al=tgetstr("al",&pointer);
  dl=tgetstr("dl",&pointer);
  so=tgetstr("so",&pointer);
  se=tgetstr("se",&pointer);
  sg=tgetnum("sg"); if (sg == -1) sg=0;
  return (0);
}
