/*{{{  #includes*/
#include <ctype.h>
#include <stdio.h>

#include "bool.h"

#include "keys.h"
#include "rcformat.h"
#include "keybind.h"
#include "scanner.h"
/*}}}  */

char nullc='\0';
char *op_def_name = &nullc;
TOKEN *m_def;

/*{{{  create a jump-command*/
TOKEN *generate_jmp(j,ad,dest) TOKEN j, *ad, *dest;
{
  if (j!=M_JMP && j!=M_JMP_TRUE && j!=M_JMP_FALSE && j!=M_CALL) {
    fprintf(stderr,"wrong jump-command CRASH\n");
    return(NULL);
  }
  *ad++ = j;
  *ad= dest-(ad+1);
  return(ad+1);
}
/*}}}  */
/*{{{  parse a keycode sequence*/
bool parse_keysequence(cod,pro) char *cod,*pro;
{
  char *c=cod;
  char *p=pro;
  tokens token;

  /*{{{  check (*/
  if (get_token(TRUE)!=BEGIN) {
    fprintf(stderr,"keysequence starts not with ( in line %d.\n",line_no);
    return(TRUE);
  }
  /*}}}  */
  /*{{{  read 'til )*/
  do {
    token=get_token(TRUE);
    switch (token) {
      /*{{{  CHAR-handling*/
      case CHAR:
        *c++=tk_char;
        /*{{{  generate protocol of this binding*/
        if (tk_char==127)      {*p++='C';*p++='-';*p++='?';}
        else if (tk_char>=' ') *p++=tk_char;
        else                   {*p++='C';*p++='-';*p++=tk_char+'A'-1;}
        *p++=' ';
        /*}}}  */
        break;
      /*}}}  */
      /*{{{  META-handling*/
      case META:
        *c++=27;
        *p++='M';*p++='-';
        break;
      /*}}}  */
      /*{{{  ALIAS-handling*/
      case DOLLAR: {
        char *s=tk_alias->code;
        char *n=tk_alias->key_name;
      
        while (*s) *c++ = *s++;
        while (*n) *p++ = *n++;
        *p++=' ';
        break;
      }
      /*}}}  */
      case END: break;
      /*{{{  default=error*/
      default: {
        fprintf(stderr,"incorrect keycode in line %d.\n",line_no);
        return(TRUE);
      }
      /*}}}  */
    }
  }
  while (token!=END);
  /*}}}  */
  *c = *p='\0';
  return(FALSE);
}
/*}}}  */
/*{{{  put variable-adress*/
TOKEN *put_var(buff) TOKEN *buff;
{
  tokens token=get_token(FALSE);

  switch (token) {
    case NAME:
      *buff++ = int_no;
      creat_var(tk_string);
      break;
    case VARIABLE:
      *buff++ = tk_var->no;
      break;
    default:
      fprintf(stderr,"missing variable in %d.\n",line_no);
      return(NULL);
  }
  return(buff);
}
/*}}}  */
/*{{{  parse a condition*/
TOKEN *parse_cond(buff) TOKEN *buff;
{
  tokens tk;

  switch(tk=get_token(FALSE)) {
    /*{{{  single tests*/
    case TEST_FILED:
      *buff++ = M_FILED_FOLD;
      break;
    case TEST_FOLD_LINE:
      *buff++ = M_CLOSED_FOLD;
      break;
    case TEST_BEGIN_FOLD:
      *buff++ = M_BEGIN_FOLD_COMMENT;
      break;
    case TEST_END_FOLD:
      *buff++ = M_END_FOLD_COMMENT;
      break;
    case TEST_TEXT:
      *buff++ = M_TEXTLINE;
      break;
    case TEST_TOP:
      *buff++ = M_TOP_OF_FOLD;
      break;
    case TEST_BOTTOM:
      *buff++ = M_BOT_OF_FOLD;
      break;
    case TEST_BEGIN_LINE:
      *buff++ = M_BEGIN_OF_LINE;
      break;
    case TEST_END_LINE:
      *buff++ = M_END_OF_LINE;
      break;
    /*}}}  */
    /*{{{  test-behind-counter*/
    case TEST_BEHIND_COUNTER:
      *buff++ = M_BEHIND_COUNTER_X_POS;
      if ((buff=put_var(buff))==NULL) return(NULL);
      break;
    /*}}}  */
    /*{{{  counter_null*/
    case COUNTER_NULL:
      *buff++ = M_NULL_COUNTER;
      if ((buff=put_var(buff))==NULL) return(NULL);
      break;
    /*}}}  */
    /*{{{  counter_positiv*/
    case C_POSITIV:
      *buff++ = M_POSITIV_COUNTER;
      if ((buff=put_var(buff))==NULL) return(NULL);
      break;
    /*}}}  */
    /*{{{  test_char x*/
    case TEST_CHAR:
      *buff++ = M_TEST_CHAR;
      if (get_token(TRUE)!=CHAR) {
        fprintf(stderr,"test_char waits for its char in %d.\n",line_no);
        return(NULL);
      }
      *buff++ = tk_char;
      break;
    /*}}}  */
    /*{{{  not condition*/
    case NOT:
      if (get_token(FALSE)!=BEGIN) {
        fprintf(stderr,"not misses ( in %d.\n",line_no);
        return(NULL);
      }
      if ((buff=parse_cond(buff))==NULL) return(NULL);
      *buff++ = M_NOT;
      if (get_token(FALSE)!=END) {
        fprintf(stderr,"NOT ends not with ) in %d.\n",line_no);
        return(NULL);
      }
      break;
    /*}}}  */
    /*{{{  and(c1,c2)*/
    case AND: {
      TOKEN *first_jmp;
    
      if (get_token(FALSE)!=BEGIN) {
        fprintf(stderr,"and misses ( in %d.\n",line_no);
        return(NULL);
      }
      if ((first_jmp=parse_cond(buff))==NULL) return(NULL);
      if ((buff=generate_jmp(M_JMP_FALSE,first_jmp,first_jmp))==NULL) return(NULL);
      if (get_token(FALSE)!=COMMA) {
        fprintf(stderr,"missing , for and in %d.\n",line_no);
        return(NULL);
      }
      if ((buff=parse_cond(buff))==NULL) return(NULL);
      if (generate_jmp(M_JMP_FALSE,first_jmp,buff)==NULL) return(NULL);
      if (get_token(FALSE)!=END) {
        fprintf(stderr,"and ends not with ) in %d.\n",line_no);
        return(NULL);
      }
      break;
    }
    /*}}}  */
    /*{{{  or(c1,c2)*/
    case OR: {
      TOKEN *first_jmp;
    
      if (get_token(FALSE)!=BEGIN) {
        fprintf(stderr,"or misses ( in %d.\n",line_no);
        return(NULL);
      }
      if ((first_jmp=parse_cond(buff))==NULL) return(NULL);
      if ((buff=generate_jmp(M_JMP_TRUE,first_jmp,first_jmp))==NULL) return(NULL);
      if (get_token(FALSE)!=COMMA) {
        fprintf(stderr,"missing , for and in %d.\n",line_no);
        return(NULL);
      }
      if ((buff=parse_cond(buff))==NULL) return(NULL);
      if (generate_jmp(M_JMP_TRUE,first_jmp,buff)==NULL) return(NULL);
      if (get_token(FALSE)!=END) {
        fprintf(stderr,"or ends not with ) in %d.\n",line_no);
        return(NULL);
      }
      break;
    }
    /*}}}  */
    default:
      fprintf(stderr,"incorrect test in line %d.\n",line_no);
      return(NULL);
  }
  return(buff);
}
/*}}}  */
/*{{{  parse a macro*/
TOKEN *parse_macro(buff) TOKEN *buff;
{
  tokens token;

  /*{{{  leading (?*/
  if (get_token(FALSE)!=BEGIN) {
    fprintf(stderr,"macro starts not with ( in line %d.\n",line_no);
    return(NULL);
  }
  /*}}}  */
  do {
    token=get_token(FALSE);
    switch (token) {
      /*{{{  repeat*/
      case REPEAT: {
        int count;
        TOKEN *new;
      
        if (get_token(FALSE)==NAME) {
          count=atoi(tk_string);
          if (count>0) {
            if (new=parse_macro(buff)) {
              count=(count-1)*(new-buff);
              while (count--) *new++ = *buff++;
              buff=new;
              break;
            }
          }
        }
        fprintf(stderr,"wrong repeat format in line %d.\n",line_no);
        return(NULL);
      }
      /*}}}  */
      /*{{{  while*/
      case WHILE: {
        TOKEN *whilestart,*jmpad;
      
        if ((jmpad=parse_cond(whilestart=buff))==NULL) return(NULL);
        if ((buff=generate_jmp(M_JMP_FALSE,jmpad,jmpad))==NULL) return(NULL);
        if ((buff=parse_macro(buff))==NULL) return(NULL);
        if ((buff=generate_jmp(M_JMP,buff,whilestart))==NULL) return(NULL);
        if (generate_jmp(M_JMP_FALSE,jmpad,buff)==NULL) return(NULL);
        break;
      }
      /*}}}  */
      /*{{{  do*/
      case DO: {
        TOKEN *dostart=buff;
      
        if ((buff=parse_macro(buff))==NULL) return(NULL);
        if (get_token(FALSE)!=WHILE) {
          fprintf(stderr,"expected while in %d.\n",line_no);
          return(NULL);
        }
        if ((buff=parse_cond(buff))==NULL) return(NULL);
        if ((buff=generate_jmp(M_JMP_TRUE,buff,dostart))==NULL) return(NULL);
        break;
      }
      /*}}}  */
      /*{{{  case*/
      case CASE: {
        TOKEN *condptr,*defaultjmp,*startcase=buff;
      
        /*{{{  create: jmp cases ; jmp end ; cases:*/
        if ((defaultjmp=generate_jmp(M_JMP,startcase,buff))==NULL) return(NULL);
        if ((buff=generate_jmp(M_JMP,defaultjmp,buff))==NULL) return(NULL);
        if (generate_jmp(M_JMP,startcase,buff)==NULL) return(NULL);
        /*}}}  */
        token=get_token(FALSE);
        do {
          switch (token) {
            /*{{{  BEGIN -> cond macro*/
            case BEGIN: {
              if ((condptr=parse_cond(buff))==NULL) return(NULL);
              if ((buff=generate_jmp(M_JMP_FALSE,condptr,condptr))==NULL)
                return(NULL);
              if ((buff=parse_macro(buff))==NULL) return(NULL);
              if ((buff=generate_jmp(M_JMP,buff,defaultjmp))==NULL)
                return(NULL);
              if (generate_jmp(M_JMP_FALSE,condptr,buff)==NULL)
                return(NULL);
              if (get_token(FALSE)!=END) {
                fprintf(stderr,"expected ) for case-entry in %d.\n",line_no);
                return(NULL);
              }
              token=get_token(FALSE);
            }
            /*}}}  */
            case ESAC:
              break;
            default:
              fprintf(stderr,"esac or ( expexcted in %d.\n",line_no);
              return(NULL);
          }
        } while (token!=ESAC);
        if (generate_jmp(M_JMP,defaultjmp,buff)==NULL) return(NULL);
        break;
      }
      /*}}}  */
      /*{{{  if*/
      case IF: {
        TOKEN *jmpadr,*endtrue;
      
        if ((jmpadr=parse_cond(buff))==NULL) return(NULL);
        if ((buff=generate_jmp(M_JMP_FALSE,jmpadr,jmpadr))==NULL) return(NULL);
        if ((endtrue=parse_macro(buff))==NULL) return(NULL);
        token=get_token(FALSE);
        switch (token) {
          /*{{{  if else fi*/
          case ELSE:
            if ((buff=generate_jmp(M_JMP,endtrue,endtrue))==NULL) return(NULL);
            if (generate_jmp(M_JMP_FALSE,jmpadr,buff)==NULL) return(NULL);
            if ((buff=parse_macro(buff))==NULL) return(NULL);
            if (generate_jmp(M_JMP,endtrue,buff)==NULL) return(NULL);
            if (get_token(FALSE)!=FI) {
              fprintf(stderr,"if then else without fi in %d.\n",line_no);
              return(NULL);
            }
            break;
          /*}}}  */
          /*{{{  if fi*/
          case FI:
            if (generate_jmp(M_JMP_FALSE,jmpadr,endtrue)==NULL) return(NULL);
            buff=endtrue;
            break;
          /*}}}  */
          default:
            fprintf(stderr,"fi or else expected in %d.\n",line_no);
            return(NULL);
        }
        break;
      
      
      }
      /*}}}  */
      /*{{{  add_/set_counter*/
      case ADD_COUNTER:
      case SET_COUNTER:
        if (token==SET_COUNTER) *buff++ = M_SET_COUNTER;
        else *buff++ = M_ADD_COUNTER;
        if ((buff=put_var(buff))==NULL) return(NULL);
        if (get_token(FALSE)!=NAME) {
          fprintf(stderr,"incorrect add/set_counter in %d.\n",line_no);
          return(NULL);
        }
        *buff++ = atoi(tk_string);
        break;
      /*}}}  */
      /*{{{  sum_counter*/
      case SUM_COUNTER:
        *buff++ = M_SUM_COUNTER;
        if ((buff=put_var(buff))==NULL) return(NULL);
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  inv_counter*/
      case INV_COUNTER:
        *buff++ = M_INV_COUNTER;
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  message-exit/exit*/
      case MES_EXIT:
      case EXIT: {
        TOKEN *x=tk_macro;
      
         *buff++ = M_EXIT;
         if (token==MES_EXIT) {
           /*{{{  move string*/
           if (get_token(FALSE)!=MACRO) {
             fprintf(stderr,"exit-description expected in %d.\n",line_no);
             return(NULL);
           }
           while (*x) *buff++ = *x++;
           /*}}}  */
         }
         *buff++ = M_END_MACRO;
         break;
      }
      /*}}}  */
      /*{{{  store_x*/
      case STORE_X:
        *buff++ = M_POS_TO_COUNTER;
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  store_y*/
      case STORE_Y:
        *buff++ = M_STORE_LINE_NO;
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  goto_y*/
      case GOTO_Y:
        *buff++ = M_GO_LINE;
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  goto_x*/
      case GOTO_X:
        if (get_token(FALSE)!=NAME) {
          fprintf(stderr,"incorrect goto_x adress in %d.\n",line_no);
          return(NULL);
        }
        *buff++ = M_GO_X_POS;
        *buff++ = atoi(tk_string);
        break;
      /*}}}  */
      /*{{{  goto_counter*/
      case GOTO_COUNTER:
        *buff++ = M_GO_COUNTER_X_POS;
        if ((buff=put_var(buff))==NULL) return(NULL);
        break;
      /*}}}  */
      /*{{{  opcode*/
      case OPCODE:
        *buff++=tk_key->num;
        break;
      /*}}}  */
      /*{{{  macrostring*/
      case MACRO: {
        int *x=tk_macro;
      
        while (*x) {
          *buff++ = *x++;
        }
        break;
      }
      /*}}}  */
      /*{{{  previosly defined operation*/
      case OPERATION: {
        TOKEN *x=tk_operation->ops;
        int lg=tk_operation->length;
      
        while (lg--) *buff++ = *x++;
        break;
      }
      /*}}}  */
      case END: break;
      /*{{{  rekursiv on my one*/
      case NAME:
        if (!strcmp(op_def_name,tk_string)) {
          buff=generate_jmp(M_CALL,buff,m_def);
          break;
        }
      /*}}}  */
      /*{{{  default=error*/
      default:
        fprintf(stderr,"no valid macro-string in line %d.\n",line_no);
        return(NULL);
      /*}}}  */
    }
  }
  while (token!=END);
  return(buff);
}
/*}}}  */

/*{{{  parse the file*/
bool process_file()
{
  /*{{{  variables*/
  tokens token;
  char code[alias_lg];
  char prot[alias_lg];
  char name[name_lg];
  TOKEN tokenlist[macro_lg];
  TOKEN *tl_ptr;
  int macro_pos=MAX_MACRO;
  bool named=FALSE;
  /*}}}  */

  int_no=0;
  token=get_token(FALSE);
  do {
    switch (token) {
      case ENDFILE: break;
      case BEGIN: {
        token=get_token(FALSE);
        switch (token) {
          /*{{{  alias command*/
          case KEYALIAS: {
            /*{{{  name given?*/
            if (get_token(FALSE)!=NAME) {
              fprintf(stderr,"expected name for alias in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            strcpy(name,tk_string);
            if (parse_keysequence(code,prot)) return(TRUE);
            creat_alias(name,code);
            /*{{{  incorrect commandend?*/
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"alias ends not with ) in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            break;
          }
          /*}}}  */
          /*{{{  keybind command*/
          case KEYDEF: {
            TOKEN t;
            char *n;
          
            /*{{{  opcode given?*/
            token=get_token(FALSE);
            /*{{{  if opcode*/
            if (token==OPCODE) {
              t=tk_key->num;
              n=tk_key->name;
            /*}}}  */
            /*{{{  if operation*/
            } else if (token==OPERATION) {
              if (tk_operation->place==0) {
                fprintf(stderr,"defmac cannot be bound in %d.\n",line_no);
                return(TRUE);
              }
              t=O_EXE_MACRO+tk_operation->place;
              n=tk_operation->op_name;
            /*}}}  */
            /*{{{  else error*/
            } else {
              fprintf(stderr,"no valid origamicommand in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            /*}}}  */
            if (parse_keysequence(code,prot)) return(TRUE);
            /*{{{  incorrect end of command?*/
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"keybind ends not with ) in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            write_key_rc(t,code);
            write_bind(n,prot);
            break;
          }
          /*}}}  */
          /*{{{  forward-declaration*/
          case FORWARD: {
            /*{{{  check if name given*/
            if (get_token(FALSE)!=NAME) {
              fprintf(stderr,"define a new operation has no name in line %d.\n"
                            ,line_no);
              return(TRUE);
            }
            /*}}}  */
            strcpy(name,tk_string);
            tokenlist[0]=O_EXE_MACRO+macro_pos;
            tokenlist[1]=M_END_MACRO;
            creat_op(name,FALSE,1,tokenlist,macro_pos--);
            /*{{{  incorrect end of command?*/
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"defop ends not with ) in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            break;
          }
          /*}}}  */
          /*{{{  define a new operation*/
          case DEFOP: {
            /*{{{  check if name given*/
            if (get_token(FALSE)!=NAME) {
              fprintf(stderr,"define a new operation has no name in line %d.\n"
                            ,line_no);
              return(TRUE);
            }
            /*}}}  */
            strcpy(name,tk_string);
            /*{{{  prepare M_CALL-information*/
            op_def_name=name;
            m_def=tokenlist;
            /*}}}  */
            if ((tl_ptr=parse_macro(tokenlist))==NULL) return(TRUE);
            /*{{{  reset M_CALL-information*/
            op_def_name = &nullc;
            m_def=NULL;
            /*}}}  */
            creat_op(name,TRUE,tl_ptr-tokenlist,tokenlist,0);
            /*{{{  incorrect end of command?*/
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"defop ends not with ) in line %d.\n",line_no);
              return(TRUE);
            }
            /*}}}  */
            break;
          }
          /*}}}  */
          /*{{{  macro commands*/
          case DEFMACRO:
          case INITMACRO: {
            bool def=(token==DEFMACRO);
            readtags tag=(token==DEFMACRO) ? RC_DEFMACRO : RC_INITMACRO;
            int po;
          
            if ((token=get_token(FALSE))==NAME) {
              /*{{{  declaration & definition*/
              /*{{{  no macros available*/
              if (!macro_pos) {
                fprintf(stderr,"no further macros available in line %d.\n",
                        line_no);
                return(TRUE);
              }
              /*}}}  */
              po = macro_pos--;
              strcpy(name,tk_string);
              op_def_name=name;
              m_def=tokenlist;
              /*}}}  */
            } else if (token==OPERATION) {
              /*{{{  definition*/
              if (tk_operation->defined) {
                fprintf(stderr,"duplicate definition in %d.\n",line_no);
                return(NULL);
              }
              strcpy(name,tk_operation->op_name);
              tk_operation->defined=TRUE;
              po = *(tk_operation->ops)-O_EXE_MACRO;
              op_def_name=name;
              /*}}}  */
            } else {
              fprintf(stderr,"no valid macro name in line %d.\n",line_no);
              return(TRUE);
            }
            if ((tl_ptr=parse_macro(tokenlist))==NULL) return(TRUE);
            write_macro_rc(tag,po,tl_ptr-tokenlist,tokenlist);
            if (token!=OPERATION) {
              /*{{{  macro as operation storing*/
              if (def) {
                tokenlist[0]=O_EXE_MACRO+po;
                tokenlist[1]=0;
                creat_op(name,TRUE,1,tokenlist,po);
              } else
                creat_op(name,TRUE,tl_ptr-tokenlist,tokenlist,po);
              m_def=NULL;
              op_def_name = &nullc;
              /*}}}  */
            }
            /*{{{  incorrect end of command?*/
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"macrodefinition ends not with ) in line %d.\n",
                      line_no);
              return(TRUE);
            }
            /*}}}  */
            break;
          }
          /*}}}  */
          /*{{{  define the name of this binding*/
          case BINDNAME: {
            if (named) {
              fprintf(stderr,"multiple named keybinding in line %d.\n",line_no);
              return(TRUE);
            }
            named=TRUE;
            if (get_token(FALSE)!=NAME) {
              fprintf(stderr,"waiting for keybindname in line %d.\n");
              return(TRUE);
            }
            write_name_rc(tk_string);
            if (get_token(FALSE)!=END) {
              fprintf(stderr,"waiting for ) in line %d.\n");
              return(TRUE);
            }
            break;
          }
          /*}}}  */
          default:
            fprintf(stderr,"incorrect commandline in %d.\n",line_no);
            return(TRUE);
        }
        break;
      }
      default:
        fprintf(stderr,"incorrect keybind-command in line %d.\n",line_no);
        return(TRUE);
    }
  }
  while ((token=get_token(FALSE))!=ENDFILE);
  /*{{{  check forward-declarations*/
  { OP **act=new_op;
  
    while (*act!=NULL) {
      if (!(*act)->defined) {
        fprintf(stderr,"declared and not defined macro %s.\n",(*act)->op_name);
        return(TRUE);
      }
      act++;
    }
  }
  /*}}}  */
  return(FALSE);
}
/*}}}  */
