/* oriedt.c - Origami editor routines */

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include "bool.h"

#include "short.h"

#include "globals.h"
#define ORIEDT_G
#include "origami.h"
#include "macros.h"

#ifdef STD_C
int first_char(char *s)
#else
int first_char(s)
char *s;
#endif /* STD_C */
{
  bool completed;
  int i, l;

  l = strlen(s);
  i = 0;
  completed = FALSE;
  while (i < l && !completed) {
    i++;
    completed = (s[i - 1] != ' ');
  }
  if (completed)
    return i;
  else
    return (l + 1);
}

#ifdef STD_C
int last_char(char *s)
#else
int last_char(s)
char *s;
#endif /* STD_C */
{
  int i;

  i = strlen(s);
  while (s[i - 1] == ' ' && i > 0)
    i--;
  return i;
}

#ifdef STD_C
void trailing_spaces(char *s)
#else
void trailing_spaces(s)
char *s;
#endif /* STD_C */
{
  bool completed;

  completed = FALSE;
  do {
    if (*s != '\0') {
      if (s[strlen(s) - 1] == ' ')
	s[strlen(s) - 1] = '\0';
      else
	completed = TRUE;
    }
    else
      completed = TRUE;
  } while (!completed);
}

#ifdef STD_C
void join_links(element *p,element *q)
#else
void join_links(p, q)
element *p, *q;
#endif /* STD_C */
{
  p->next = q;
  q->prec = p;
  if (filed_or_fold(p))
    p->other_end->next = q;
}

#ifdef STD_C
void move_on(element **p)
#else
void move_on(p)
element **p;
#endif /* STD_C */
{
  if ((*p)->foldline == START_FOLD)
    *p = (*p)->fold;
  else
    *p = (*p)->next;
}

#ifdef STD_C
int insert_indent_of(element *p)
#else
int insert_indent_of(p)
element *p;
#endif /* STD_C */
{
  if (p->foldline == START_OPEN_FOLD)
    return (p->UU.U1.indent - p->UU.U1.fold_indent);
  else
    return (p->UU.U1.indent);
}

#ifdef STD_C
void close_fold_at(element *ptr)
#else
void close_fold_at(ptr)
element *ptr;
#endif /* STD_C */
{
  element *p;
  int i;

  p = ptr;
  if (p->foldline == START_OPEN_FOLD) {
    p->foldline = START_FOLD;
    p->fold = p->next;
    p->next = p->other_end->next;
    p->next->prec = p;
  }
  i = p->UU.U1.fold_indent;
  p->UU.U1.indent -= i;
  i += p->UU.U1.indent;
  p = p->fold;
  while (p->foldline != END_FOLD) {
    if (p->foldline == START_OPEN_FOLD)
      close_fold_at(p);
    p->UU.U1.indent -= i;
    p = p->next;
  }
  p->UU.U1.indent -= i;
}

#ifdef STD_C
int lines_within(element *p)
#else
int lines_within(p)
element *p;
#endif /* STD_C */
{
  element *q;
  int l;

  if (p->foldline != START_FOLD) {
    l = 1;
    return l;
  }
  l = 0;
  q = p;
  while (q != p->next) {
    l++;
    move_on(&q);
  }
  return l;
}

/* It is a really difficult task, to determine the available storage in
   UNIX.  I assume, that a typical source code has 30 characters per line,
   which is true for most of my programs.  Origami is stable enough, to
   die proper, if there is suddenly no more memory.  Anyway, never user
   too big files ...
*/
#ifdef STD_C
bool available(unsigned int lines)
#else
bool available(lines)
unsigned int lines;
#endif /* STD_C */
{
  char *p;
  
  p=malloc(30*lines);
  if (p==NULL) return FALSE;
  free(p); return TRUE;
#if (0)
  bool a;
  int l;

  l = dispose_size + maxavail() / line_size - lines - 2;   /* safety */
  a = (l >= 0);
  if (l >= 200) return a;
  if (a) {
    message("Running out of memory ");
    printf("%d lines left", l);
  }
  else {
    message("Not enough memory to create lines. Need ");
    printf("%d but only have %d lines left", lines, l + lines);
  }
  return a;
#endif
}

#ifdef STD_C
void proc_undispose(element **p)
#else
void proc_undispose(p)
element **p;
#endif /* STD_C */
{
  /* try harder to get back deleted line */
  
  if (dispose_head == dispose_tail) {
    *p = NULL;
    return;
  }
  *p = dispose_tail;
  dispose_size -= lines_within(*p);
  dispose_tail = (*p)->prec;
}

#ifdef STD_C
void proc_new(element **p)
#else
void proc_new(p)
element **p;
#endif /* STD_C */
{
  element *q;

  if (dispose_head != dispose_tail) {
    *p = dispose_head->next;
    if (filed_or_fold(*p)) {
      q = (*p)->other_end;
      (*p)->foldline = NOT_FOLD;
      q->foldline = NOT_FOLD;
      if (dispose_tail == *p)
	dispose_tail = q;
      (*p)->next = (*p)->fold;
    }
    if (dispose_tail == *p)
      dispose_tail = dispose_head;
    else
      join_links(dispose_head, (*p)->next);
    dispose_size--;
    if ((*p)->strng) free((*p)->strng);
  }
  else
    *p = (element *) malloc(sizeof(element));
  **p = *null_item_ptr;
  (*p)->strng=malloc(1); *((*p)->strng)='\0';
}

#ifdef STD_C
void proc_to_edit_pos(void)
#else
void proc_to_edit_pos()
#endif /* STD_C */
{
  element *WITH;

  WITH = current;
  pre_edit_pos = WITH->UU.U1.indent;
  first_edit_pos = pre_edit_pos + 1;
  if (filed_or_fold(current)) {
    pre_edit_pos = first_edit_pos + WITH->UU.U1.fold_indent;
    first_edit_pos = pre_edit_pos + MARKER_LEN;
  }
  if (WITH->foldline == START_OPEN_FOLD || WITH->foldline == START_ENTER_FOLD) {
    pre_edit_pos = 0;
    first_edit_pos += MARKER_LEN;
  }
  if (WITH->foldline == END_FOLD || WITH->foldline == START_ENTER_FILED) {
    pre_edit_pos = 0;
    first_edit_pos = 255;
  }
}

#ifdef STD_C
void proc_from_edit_pos(void)
#else
void proc_from_edit_pos()
#endif /* STD_C */
{
  element *WITH;

  WITH = current;
  if (filed_or_fold(current))
    WITH->UU.U1.fold_indent =
      strpos2(current_dsp_line, "...", 1) - WITH->UU.U1.indent - 1;
}

#ifdef STD_C
void copyin(char *line,element *p,bool full)
#else
void copyin(line, p, full) char *line; element *p; bool full;
#endif
{
	char            fold_str[17];
	int             ind;
	char            STR1[MAX_FIELD_SIZE + 1];
	char            STR2[174];
	int		null_line=0;

	ind = p->UU.U1.indent;
	copy_parts_to_line(p, line);
	if (p->foldline == END_FOLD)
		*line = '\0';
	if (full)
		trailing_spaces(line);
	if (p->foldline != NOT_FOLD) {
		if (filed_or_fold(p)) {
		    if (fold_out) {
		        strcpy(fold_str,"");
		    } else {
			if (full && (p->foldline != START_FILED || p->UU.U1.fold_type != 1)) {
			    strcpy(fold_str, fold_open_str);
			} else { strcpy(fold_str, "..."); }
			if (p->foldline == START_FILED)
				strcat(fold_str, "F ");
			else
				strcat(fold_str, "  ");
		    }
		    ind += p->UU.U1.fold_indent;
		}
		if (dialect >= 0) {
			switch (p->foldline) {
			case START_OPEN_FOLD:
			case START_ENTER_FOLD:
				if (!fold_out) sprintf(fold_str, "%s  ", fold_open_str);
				break;
			case START_ENTER_FILED:
				if (!fold_out) sprintf(fold_str, "%sF ", fold_open_str);
				break;
			case END_FOLD:
				if (!fold_out) {
				    strcpy(fold_str, "}}}");
				} else {
				    null_line++;
				}
				break;
			}
			if (full)
				pad_(fold_str, ' ', 5);
			else
				pad_(fold_str, '\0', 5);
			if (full)
				strinsert(dialect_start[dialect], fold_str, 1);
		} else
			*fold_str = '\0';
	} else
		*fold_str = '\0';
	sprintf(STR2, "%s%s", spaces(STR1, ind), fold_str);
	strinsert(STR2, line, 1);
	if (p->foldline != NOT_FOLD && full  && dialect >= 0)
		strcat(line, dialect_end[dialect]);
	if (null_line) *line=0;
}

#ifdef STD_C
void copyout(char *line,element *p)
#else
void copyout(line, p)
char *line;
element *p;
#endif /* STD_C */
{
  int i;
  element *WITH;
  char STR1[MAX_FIELD_SIZE + 1];

  WITH = p;
  if (WITH->foldline == NOT_FOLD)
    i = WITH->UU.U1.indent;
  else
    i = WITH->UU.U1.indent + MARKER_LEN;
  if (filed_or_fold(p))
    i += WITH->UU.U1.fold_indent;
  copy_line_to_parts(copy_to_end(STR1, line, i + 1), &p);
}
