/* fieldedt.c - Field editor source file */

#include <ctype.h>
#include <string.h>
#include <stdio.h>

#include "bool.h"

#include "short.h"

#include "globals.h"
#define FIELDEDT_G
#include "origami.h"
#include "macros.h"

#define change_edit_pos(by)     (first_edit_pos += (by), pre_edit_pos += (by))

#define are_we_past_end(LINK)   \
                        if (*(LINK)->field_pos > strlen((LINK)->field_str) + 1)\
                           pad_((LINK)->field_str, ' ', *(LINK)->field_pos - 1);


/*{{{  restore cursor*/
#ifdef STD_C
PRIVATE void restore_cursor(LOC_field *LINK)
#else
PRIVATE void restore_cursor(LINK)
LOC_field *LINK;
#endif /* STD_C */
{
  LINK->sect = (*LINK->field_pos - 1) / LEN + 1;
  if (LINK->sect <= 2)
    gotoxy((int)(START + (*LINK->field_pos - 1) % LEN), dsp_fields[LINK->sect - 1]);
  else
    gotoxy(START + LEN, OVERFLOW_LINE);
  /* p2c: edtline.pas, line 357:
   * Note: Using % for possibly-negative arguments [317]
   */
}
/*}}}  */
/*{{{  refresh_field*/
#ifdef STD_C
PRIVATE void refresh_field(int froms,int tos,LOC_field *LINK)
#else
PRIVATE void refresh_field(froms, tos, LINK)
int froms, tos;
LOC_field *LINK;
#endif /* STD_C */
{
  char f_str[MAX_FIELD_SIZE + 1];
  int sect, left_pos, right_pos;
  char STR1[256];

  if (froms < 1) froms = 1;
  if (tos > LINK->full_len) tos = LINK->full_len;   /* len*2 */
  if (tos < froms) return;
  strcpy(f_str, LINK->field_str);
  if (tos > strlen(f_str)) pad_(f_str, ' ', tos);
  for (sect = 1; sect <= 2; sect++) {
    if (froms <= sect * LEN && tos > (sect - 1) * LEN) {
      if (froms > (sect - 1) * LEN) left_pos = froms;
      else left_pos = (sect - 1) * LEN + 1;
      if (tos <= sect * LEN) right_pos = tos;
      else right_pos = sect * LEN;
      gotoxy((int)(START + (left_pos - 1) % LEN), dsp_fields[sect - 1]);
      /* p2c: edtline.pas, line 380:
       * Note: Using % for possibly-negative arguments [317]
       */
      fputs(strsub(STR1, f_str, left_pos, right_pos - left_pos + 1), stdout);
    }
  }
}
/*}}}  */
/*{{{  move_cursor*/
#ifdef STD_C
PRIVATE void move_cursor(int dist,LOC_field *LINK)
#else
PRIVATE void move_cursor(dist, LINK)
int dist;
LOC_field *LINK;
#endif /* STD_C */
{
  if (*LINK->field_pos + dist <= 0 || *LINK->field_pos + dist > LINK->full_len + 1)
    return;
  *LINK->field_pos += dist;
  if (*LINK->field_pos > strlen(LINK->field_str) + 1)
    strcat(LINK->field_str, " ");
  if (*LINK->field_pos == strlen(LINK->field_str)) {
    if (LINK->field_str[strlen(LINK->field_str) - 1] == ' ')
      LINK->field_str[strlen(LINK->field_str) - 1] = '\0';
  }
}
/*}}}  */
/*{{{  insert_*/
#ifdef STD_C
PRIVATE void insert_(char ch,LOC_field *LINK)
#else
PRIVATE void insert_(ch, LINK)
char ch;
LOC_field *LINK;
#endif /* STD_C */
{
  char STR1[MAX_FIELD_SIZE + 1];
  char STR3[256];

  if (*LINK->field_pos > LINK->full_len)
    return;
  if ((*LINK->field_pos > pre_edit_pos || ch != ' ' ||
       *LINK->field_pos <= LINK->ind) && *LINK->field_pos < first_edit_pos)
    return;
  if (strlen(LINK->field_str) == LINK->full_len) {
    LINK->field_str[LINK->full_len - 1] = '\0';
  }
  if (*LINK->field_pos==1)
  {
    STR3[0]=ch;
    strcpy(&STR3[1],LINK->field_str);
  }
  else sprintf(STR3, "%.*s%c%s", *LINK->field_pos - 1, LINK->field_str, ch,
          copy_to_end(STR1, LINK->field_str, *LINK->field_pos));
  strcpy(LINK->field_str, STR3);
  if (*LINK->field_pos <= pre_edit_pos) change_edit_pos(1);
  (*LINK->field_pos)++;
  refresh_field(*LINK->field_pos - 1, strlen(LINK->field_str), LINK);
}
/*}}}  */
/*{{{  case_word*/
#ifdef STD_C
PRIVATE void case_word(LOC_field *LINK; int mode)
#else
PRIVATE void case_word(LINK, mode) LOC_field *LINK; int mode;
#endif
{
  int pos;
  char *run;

  if (*LINK->field_pos > strlen(LINK->field_str)) return;
  pos = *LINK->field_pos;
  run = &LINK->field_str[*LINK->field_pos-1];
  while (isalpha(*run))
  {
    switch (mode)
    {
      case 0: *run=toupper(*run); mode=1; break;

      case 1: *run=tolower(*run); break;

      case 2: *run=toupper(*run); break;
    }
    (*LINK->field_pos)++;
    run++;
  }
  refresh_field(pos, strlen(LINK->field_str), LINK);
}
/*}}}  */
/*{{{  delete__*/
#ifdef STD_C
PRIVATE void delete__(LOC_field *LINK)
#else
PRIVATE void delete__(LINK)
LOC_field *LINK;
#endif /* STD_C */
{
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[256];


  if (*LINK->field_pos <= LINK->ind + 1) {
    LINK->field_key = FALSE;
    return;
  }
  if (*LINK->field_pos <= first_edit_pos && *LINK->field_pos > pre_edit_pos)
    return;
 deleted_ch = LINK->field_str[*LINK->field_pos - 2];
  if (*LINK->field_pos-2==0) strcpy(STR3,&LINK->field_str[1]);
  else
  sprintf(STR3, "%.*s%s",
          *LINK->field_pos - 2, LINK->field_str,
          copy_to_end(STR2, LINK->field_str, *LINK->field_pos));
  strcpy(LINK->field_str, STR3);
  if (*LINK->field_pos <= pre_edit_pos)
    change_edit_pos(-1);
  (*LINK->field_pos)--;
  refresh_field(*LINK->field_pos, (int)(strlen(LINK->field_str) + 1), LINK);
}
/*}}}  */
/*{{{  delete_under*/
#ifdef STD_C
PRIVATE void delete_under(LOC_field *LINK)
#else
PRIVATE void delete_under(LINK)
LOC_field *LINK;
#endif /* STD_C */
{
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[256];

  if (*LINK->field_pos > LINK->full_len || *LINK->field_pos <= LINK->ind)
    return;
  if (*LINK->field_pos < first_edit_pos && *LINK->field_pos >= pre_edit_pos)
    return;
  deleted_ch = LINK->field_str[*LINK->field_pos - 1];
  if (*LINK->field_pos-1==0) strcpy(STR3,&LINK->field_str[1]);
  else
 sprintf(STR3, "%.*s%s",
          *LINK->field_pos - 1, LINK->field_str,
          copy_to_end(STR2, LINK->field_str, *LINK->field_pos + 1));
  strcpy(LINK->field_str, STR3);
  if (strlen(LINK->field_str) < *LINK->field_pos)
    strcat(LINK->field_str, " ");
  if (*LINK->field_pos < pre_edit_pos)
    change_edit_pos(-1);
  refresh_field(*LINK->field_pos, (int)(strlen(LINK->field_str) + 1), LINK);
}
/*}}}  */
/*{{{  char_type*/
#ifdef STD_C
PRIVATE uchar char_type(char ch)
#else
PRIVATE uchar char_type(ch)
char ch;
#endif /* STD_C */
{
  if (ch != ' ') {
    if (isdigit(ch) || isalpha(ch))
      return 1;
    else
      return 2;
  } else
    return 0;
}
/*}}}  */
/*{{{  symbol_start*/
#ifdef STD_C
PRIVATE bool symbol_start(LOC_field *LINK)
#else
PRIVATE bool symbol_start(LINK)
LOC_field *LINK;
#endif /* STD_C */
{
  bool b;

  b = (*LINK->field_pos > 1 && *LINK->field_pos <= strlen(LINK->field_str));
  if (b) {
    if (LINK->field_str[*LINK->field_pos - 1] == ' ')
      return FALSE;
    else
      return (char_type(LINK->field_str[*LINK->field_pos - 2]) !=
              char_type(LINK->field_str[*LINK->field_pos - 1]));
  }
  else
    return TRUE;
}
/*}}}  */
/*{{{  field_edit*/
#ifdef STD_C
TOKEN field_edit(bool *keypad,int *field_pos_,char *field_str_)
#else
TOKEN field_edit(keypad, field_pos_, field_str_)
bool *keypad;
int *field_pos_;
char *field_str_;
#endif /* STD_C */
{
  /*{{{  declarations*/
  LOC_field V;
  TOKEN Result, ch;
  int temp, tempf;
  char STR1[256];
  char STR2[256];
  element *WITH;
  char STR3[MAX_FIELD_SIZE + 1];
  char STR4[MAX_FIELD_SIZE + 1];
  /*}}}  */

  V.field_pos = field_pos_;
  V.field_str = field_str_;
  V.ind = current->UU.U1.indent;
  V.full_len = LEN * 2;
  trailing_spaces(V.field_str);
  if (strlen(V.field_str) < V.ind) {
    V.field_str[V.ind] = '\0';
    /* p2c: edtline.pas, line 476:
     * Note: Modification of string length may translate incorrectly [146]
     */
  }
  if (strlen(V.field_str) > V.full_len) {
    V.field_str[V.full_len] = '\0';
    /* p2c: edtline.pas, line 477:
     * Note: Modification of string length may translate incorrectly [146]
     */
  }
  if (*V.field_pos <= V.ind) *V.field_pos = V.ind + 1;
  are_we_past_end(&V);   /* full_len */
  refresh_field(LEN, strlen(V.field_str), &V);
  do {
    V.field_key = FALSE;
    do {
      restore_cursor(&V);
      ch = edit_key(keypad);
    } while (!valid_key(keypad, &ch));
    V.field_key = valid_field_key(keypad, &ch);
    if (V.field_key) {
      no_message();
      if (*keypad) {
        switch (ch) {   /*if and case*/
          /*{{{  M_BEGIN_OF_LINE*/
          case M_BEGIN_OF_LINE: {
            int po=1;
            char *t=V.field_str;
          
            while (*t && *t==' ') {t++;po++;}
            macro_tag=(po>=*V.field_pos);
            break;
          }
          /*}}}  */
          /*{{{  M_TOP_OF_FOLD*/
          case M_TOP_OF_FOLD:
            macro_tag=(current==head->next);
            break;
          /*}}}  */
          /*{{{  M_BOT_OF_FOLD*/
          case M_BOT_OF_FOLD:
            macro_tag=(current==tail);
            break;
          /*}}}  */
          /*{{{  M_TEST_CHAR*/
          case M_TEST_CHAR: {
            char c=get_arg();
          
            if (V.field_str[*(V.field_pos)-1]=='\0') macro_tag=(c==' ');
            else macro_tag=(V.field_str[*(V.field_pos)-1]==c);
            break;
          }
          /*}}}  */
          /*{{{  M_END_OF_LINE*/
          case M_END_OF_LINE: {
            char *c = &V.field_str[*(V.field_pos)-1];
          
            macro_tag=TRUE;
            while (*c) {
              if (*c++!=' ') { macro_tag=FALSE; break;}
            }
            break;
          }
          /*}}}  */
          /*{{{  M_GOTO..*/
          case M_GO_X_POS:
          case M_GO_COUNTER_X_POS: {
            int diff;

            if (ch==M_GO_X_POS)
              diff=get_arg() -*V.field_pos;
            else
              diff=macro_int[get_arg()] - *V.field_pos;
            if (diff>0) {
              while (diff-- > 0) move_cursor(1, &V);
            } else {
              while (diff++ < 0) move_cursor(-1, &V);
            }
            break;
          }
          /*}}}  */
          /*{{{  M_BEHIND_COUNTER_X_POS*/
          case M_BEHIND_COUNTER_X_POS:
            macro_tag = *V.field_pos>macro_int[get_arg()];
            break;
          /*}}}  */
          /*{{{  M_POS_TO_COUNTER*/
          case M_POS_TO_COUNTER:
            macro_int[get_arg()]= *V.field_pos;
            break;
          /*}}}  */
          /*{{{  O_UNDEL_CHAR*/
          case O_UNDEL_CHAR:
            insert_(deleted_ch, &V);
            break;
          /*}}}  */
          /*{{{  O_START_OF_LINE*/
          case O_START_OF_LINE:
            *V.field_pos = V.ind + 1;
            trailing_spaces(V.field_str);
            are_we_past_end(&V);
            if (*V.field_pos < strlen(V.field_str)) {
              while (V.field_str[*V.field_pos - 1] == ' ')
                (*V.field_pos)++;
            }
            break;
          /*}}}  */
          /*{{{  O_END_OF_LINE*/
          case O_END_OF_LINE:  /*eol*/
            trailing_spaces(V.field_str);
            *V.field_pos = strlen(V.field_str) + 1;
            if (*V.field_pos <= V.ind) {
              *V.field_pos = V.ind + 1;
              are_we_past_end(&V);
            }
            break;
          /*}}}  */
          /*{{{  O_WORD_RIGHT*/
          case O_WORD_RIGHT:   /*word right*/
            if (*V.field_pos < last_char(V.field_str)) {
              do {
                move_cursor(1, &V);
              } while (!symbol_start(&V));
            }
            else move_cursor(1, &V);
            break;
          /*}}}  */
          /*{{{  O_WORD_LEFT*/
          case O_WORD_LEFT:   /*word left*/
            if (*V.field_pos > first_char(V.field_str)) {
              do {
                move_cursor(-1, &V);
              } while (!(symbol_start(&V) && *V.field_pos <= strlen(V.field_str)));
            }
            else {
              *V.field_pos = V.ind + 1;
              are_we_past_end(&V);
            }
            break;
          /*}}}  */
          /*{{{  O_DELTO_EOL*/
          case O_DELTO_EOL:
            if (*V.field_pos >= first_edit_pos) {
              temp = strlen(V.field_str);
              if (*V.field_pos == 1)
              *V.field_str='\0';
              else
              sprintf(V.field_str, "%.*s",
                      *V.field_pos - 1, strcpy(STR2, V.field_str));
              refresh_field(*V.field_pos, temp, &V);
            }
            break;
          /*}}}  */
          /*{{{  O_LEFT*/
          case O_LEFT:
            move_cursor(-1, &V);
            break;
          /*}}}  */
          /*{{{  O_RIGHT*/
          case O_RIGHT:
            move_cursor(1, &V);
            break;
          /*}}}  */
          /*{{{  O_DEL_CHAR_R*/
          case O_DEL_CHAR_R:
            delete_under(&V);
            break;
          /*}}}  */
          /*{{{  O_BROWSE*/
          case O_BROWSE:
            browse_mode = !browse_mode;
            title();
            break;
          /*}}}  */
          /*{{{  O_DELETE*/
          case O_DELETE:
            delete__(&V);
            break;
          /*}}}  */
          /*{{{  O_RETURN*/
          case O_RETURN:   /* cr */
            if (available(1)) {
              tempf = first_char(V.field_str);
              temp = strlen(V.field_str);
              if (!select_on) {   /* makefold */
                WITH = current;
                if (current != tail || *V.field_pos == 1) {
                  if (!entered(current) || current != head->next ||
                      *V.field_pos > temp) {
                    if (WITH->foldline == NOT_FOLD || *V.field_pos <= tempf ||
                        *V.field_pos > temp) {
                      split_line = (*V.field_pos > tempf);
                      proc_new(&part_line);
                      part_line->UU.U1.indent = V.ind;
                      if (split_line) {
                        copy_line_to_parts(copy_to_end(STR3, V.field_str,
                                                       *V.field_pos),
                                           &part_line);
                        sprintf(V.field_str, "%.*s",
                                *V.field_pos - 1, strcpy(STR2, V.field_str));
                        refresh_field(*V.field_pos, temp, &V);
                      }
                      *V.field_pos = first_char(V.field_str);
                      sprintf(STR1, "%s%s",
                              spaces(STR3, *V.field_pos - V.ind - 1),
                              line_of(STR4, part_line));
                      copy_line_to_parts(STR1, &part_line);
                      V.field_key = FALSE;
                    }
                  }
                }
              }
            }
            break;
          /*}}}  */
          /*{{{  O_TRANSPOSE_CHARACTERS*/
          case O_TRANSPOSE_CHARACTERS:
            if (*V.field_pos==1) break;
            move_cursor(-1, &V);
            delete_under(&V);
            move_cursor(1, &V);
            insert_(deleted_ch, &V);
            break;
          /*}}}  */
          /*{{{  O_CAPITALIZE_WORD*/
          case O_CAPITALIZE_WORD:
            case_word(&V, 0);
            break;
          /*}}}  */
          /*{{{  O_LOWERCASE_WORD*/
          case O_LOWERCASE_WORD:
            case_word(&V, 1);
            break;
          /*}}}  */
          /*{{{  O_UPPERCAE_WORD*/
          case O_UPPERCASE_WORD:
            case_word(&V, 2);
            break;
          /*}}}  */
        }
      }
      if (!*keypad) insert_(ch, &V);
    }
  } while (V.field_key != FALSE);
  Result = ch;
  trailing_spaces(V.field_str);
  if (strlen(V.field_str) <= LEN) return Result;
  gotoxy(LEN, dsp_fields[0]);
  fputc(END_OF_LINE, stdout);
  gotoxy(START, OVERFLOW_LINE);
  clreol();
  return Result;
}
/*}}}  */
