/*
 * newjunk written by Michael A. Meiszl (mam@mamnix.hamm.sub.org)
 */

#include "newjunk.h"

#define MAXITEMS 5000	/* if anybody cares for space lower it, but wouldn't
			   it be better if you spend some bucks on rams ???
			*/

char *files[MAXITEMS];	/* Array for filenames,
			   junk sometimes gets pretty big
			*/

char *groups[MAXITEMS]; /* Array for groups out of active file
			   Currently I have 1154 groups online :-(((
			*/

int maxfiles=0,maxgroups=0; /* Upper bounds of arrays */

int debug=0;		/*  Debug level. Currently only 9 does something
			    special. Everything above 0 shows program
			    progress
			*/

int scriptflag=0;	/*  Incremented by every group that is newly
			    installed. If a file argv[0].sh exists in
			    the BIN directory it is executed if any
			    group is created.
			*/

#ifdef HAVE_GETOPT
extern char *optarg;
#endif
/*
 * PANIC
 *		Aborts program because of too low array configuration
 * Return:	Never (I hope)
 */

void panic(what)
char *what;
{
fprintf(stderr,"Sysop! You have more than %d %s in your JUNK directory!\n",
MAXITEMS,what);
fprintf(stderr,"Either you cleanup by hand or recompile newjunk with a higher MAXITEMS value!\n");
fprintf(stderr,"NEWJUNK: I give up!\n");
exit(2);
}

/*
 * USAGE
 *		a nice little routine which only tells the user about his
 *		stupidity :-)
 */
void usage()
{
	printf("Usage: newjunk [-t] [-d NUM]\n");
	printf("		-t = testmode (show only, do nothing)\n");
	printf("		-d = debug level (9=testmode)\n");
	exit(0);
}
/*
 * READIN
 *		reads the junk directory and copies filenames into the
 *		files[] array.
 * Return:	0 if successful, -1 if open failiure
 */
int readin()
{
	char l[255];
	DIR *D;
	struct direct *dir;

	if (D=opendir(JUNKDIR,"r")) {
		while (dir=readdir(D)) {
			if (*dir->d_name=='.') continue;
			files[maxfiles++]=strdup(dir->d_name);
			if (maxfiles>=MAXITEMS) panic("files");
		}
		closedir(D);
		return 0;
	}
	return -1;
}

/*
 * READACTIVE
 *		reads the active file in and copies the groupnames to
 *		the array groups[]
 * Returns:	0 if successful, -1 can't read active file
 */
int readactive()
{
	FILE *F;
	char l[255],*s;

	if (!(F=fopen(ACTIVE,"r"))) return -1;
	while (fgets(l,255,F)) {
		for (s=l;*s && *s!=' ' && *s!='\t';s++);
		*s=(char) 0;
		groups[maxgroups++]=strdup(l);
		if (maxgroups>=MAXITEMS) panic("groups");
		}
	fclose(F);
	return 0;
}

/*
 * ADDGROUP
 *		adds a new group to the array groups[] and calls INEWS to
 *		create this group.
 * Returns:	NOTHING or panics if array overflow
 */
addgroup(which)
char *which;
{
	char l[255];
	FILE *P;

	if (maxgroups>=MAXITEMS) panic ("groups");

	groups[maxgroups++]=strdup(which);

/*
 * build system() command line
 */
	strcpy (l,INEWS);
#ifdef DISTRIBUTION
	strcat (l," -d ");
	strcat (l,DISTRIBUTION);
#endif

#ifdef	COHERENT
#	ifdef	WNEWS
		strcat (l," -n control ");
		strcat (l," -f Newjunk ");
		strcat (l," -t \"Newgroup ");
		strcat (l,which); strcat(l,"\"");
		strcat (l," -c \"newgroup ");
#	else
		strcat (l," -C ");
#	endif
#else
	strcat (l," -C ");
#endif

	strcat (l,which);

#ifdef	COHERENT
#	ifdef	WNEWS
	strcat(l,"\"");
#	endif
#endif

	strcat (l," < ");
	strcat (l,BINDIR);
	strcat (l,"/");
	strcat (l,"newjunk.msg");

	if (debug) fprintf(stderr,"Executing:<%s>\n",l);

/*
 * Execute command line with a read pipe
 * So we can get rid of inews output and keep pretty calm during crontab work
 * Why bother the sysop? He will get mail from the news system soon...
 */
	if (debug<9)
		if (P=popen(l,"r")) {
			while(fgets(l,255,P)) {
				if(debug) printf("INEWS:%s",l);
				}
			pclose(P);
/*
 * Increment flag, so that MAIN can decide if it should start the script
 */
			scriptflag+=1;
			return 0;
			}
		else 
			{
			perror("Can't Pipe to INEWS");
			exit(1);
			}
	else {
		fprintf(stderr,"no exec! just testing!\n");
		scriptflag+=1; /* fake it */
	      }
	return 0;
}

/*
 * LOOKUP
 *		searches the groups[] array for a given group
 *		It is a poor linear scan, but who cares???
 *		qsorting and bsearching maybe thousends of times faster,
 *		but are not that portable as this routine
 * Returns:	0 if group has been added, -1 if group already exists
 */
lookup(what)
char *what;
{
	register int i,len;
	register char *s;

/*
 * the stupid line parsing routine occasionally creates NULL strings, so
 * we eliminate them here
 */
	if (!strlen(what)) return -1;

	if (debug) fprintf (stderr,"searching for %s:",what);
/*
 * first we scan for the whole group name
 */
	for (i=0;i<maxgroups;i++)
		if (!strcmp(groups[i],what)) {
			if (debug) fprintf (stderr," already there\n");
			return -1;
			}
/*
 * Now, let's take a closer look to the net
 * If the first part of the group does not exist, don't add this group, it
 * may be a crossposting only.
 * SYSOP NOTE: Since this program will never create a new net, you have to 
 * take care about that by yourself. If you don't bother, define NETCREATION
 * in the header file...
 */
	if (debug) fprintf (stderr," not there! checking net ");
	s=strchr(what,'.');
	if (!s) {
		if (debug) fprintf (stderr,": No TOP level allowed!\n");
		return -1; /* This would be a top-top level.
			      I don't believe that...
			   */
		}

#ifndef NETCREATION
	*s=(char) 0;
	len=strlen(what);
	if (debug) fprintf(stderr,"%s:",what);
	*s=(char) '.'; /* in case we forget it later ... */
	for (i=0;i<maxgroups;i++)
		if (!strncmp(groups[i],what,len)) {
		 	if (debug) fprintf(stderr," ok, found %s\n",groups[i]);
			break;
			}
	if (i>=maxgroups) {
		if (debug) fprintf(stderr," new net, not allowed\n");
		return -1;
		}
#endif
/*
 * otherwise do your job...
 */
	if (debug) fprintf(stderr,"Installing new group %s\n",what);
	addgroup(what);
	return 0;
}

/*
 * SCAN_MESSAGE
 *		reads the message specified as name and searches for the
 *		"Newsgroups:" line. This line is broken up and fed into lookup.
 * Returns:	0 if ok, -1 if message is unreadable
 */
scan_message(name)
char *name;
{
	char l[255],*s,*t;
	FILE *F;

	sprintf(l,"%s/%s",JUNKDIR,name);
	if (!(F=fopen(l,"r"))) return -1;
	while (fgets(l,255,F)) {
		s=strrchr(l,'\n');
		if (s) *s=(char) 0;
		if (!strlen(l)) {
		if (debug) fprintf(stderr,"%s: no Newsgroups line!\n",name);
			break; /* End of Header */
			}
		if (!strncmp(l,"Newsgroups: ",12)) {
			s=l+12;
/*
 * Pardon me this GOTO. It much more effective as strtok would be.
 */
redo:
			t=s;
			while (*t && *t!=' ' && *t!='\t' && *t!=',') t++;
			if (*t) {
				*t++=(char) 0;
				lookup(s);
			while (*t && (*t==' ' || *t=='\t' || *t==',')) t++;
				s=t;
				goto redo;
				}
			if (s) lookup(s);
			break;
			}
		}
	fclose(F);
	return 0;
}


/*
 * MAIN
 *	nothing to worry about, it just calles the reading routines and 
 *	calls SCAN_MESSAGE for every entry of the files[] array
 *
 * Returns:	I hope so :-)
 */
main(argc,argv)
int argc;
char *argv[];
{
	int i;
	char script[255];

	debug=0;


#ifdef HAVE_GETOPT

	while ((i=getopt(argc,argv,"td:v:x:"))!=EOF) {
		switch (i) {
			case 'd':
			case 'v':
			case 'x':	debug=atoi(optarg); break;
			case 't':	debug=9; break;
			default :	usage();
			}
		}
#else
	if (argc>1) debug=atoi(argv[1]); /* stupid, but reliable :-) */
#endif

	
/*
 * 	build filename for script
 */
	sprintf(script,"%s/%s.sh",BINDIR,argv[0]);

	if (debug) fprintf (stderr,"Reading JUNK directory: ");
	if (readin()) {
		perror("readin");
		exit(1);
		}
	if (debug) fprintf (stderr,"%d files found\n",maxfiles);
	if (debug) fprintf (stderr,"Reading ACTIVE file: ");
	if (readactive()) {
		perror("readactive");
		exit(1);
		}
	if (debug) fprintf (stderr,"%d groups found\n",maxgroups);
	for (i=0;i<maxfiles;i++) {
		if (debug) fprintf(stderr,"Scanning message %s\n",files[i]);
		scan_message(files[i]);
		}
	if (debug) fprintf(stderr,"%s: installed %d new group%s\n",
			argv[0],scriptflag,
			scriptflag>1?"s":"");
	if (scriptflag) {
		if (debug) fprintf(stderr,"%s: ready to start %s\n",
			argv[0],script);
		if (!access(script,1)) {
			if (debug!=9) i=system(script); else i=-1;
			if (debug) fprintf(stderr,"%s: exit status %d\n",
				argv[0],i);
			}
		}
	exit(0);
}

