/* mtalk - general info for both daemon and client.
 *
 * Copyright (c) 1991, Matthew Kimmel.  Permission granted for unlimited
 * non-commercial use and distribution.
 */

/* Number of users that can use mtalk at one time. */
#define MAX_USERS	3

/* Maximum length of a user's message--must be smaller then the maximum
   size of a msg queue message.  In the tradition of MUDs, I have it set
   to 256 bytes.  Newline never included. */
#define MAX_MESSAGE	256

/* Where the executables are located--used with ftok(). */
#define DAEMON_PATH	"/usr/local/etc/mtalkd"
#define CLIENT_PATH	"/usr/local/bin/mtalk"

/* Message types that can be sent to the daemon */
#define M_USRIN		1L	/* User logging in. */
#define M_USRMSG	2L	/* A public message from a user */
#define M_USRCMD	3L	/* A command from a user */

/* Message types that can be received by the client */
#define M_DMNTEXT	4L	/* Text to be displayed to user */
#define M_DMNFULL	5L	/* Too many users; user cannot join mtalk */

/* User commands that can be sent to the server as type M_USRCMD */
#define U_WHISPER	0	/* Whisper to a specific user */
#define U_WHO		1	/* Who's on? */
#define U_EXIT		2	/* Exit mtalk */

/* Structure passed with M_USRIN type */
struct usrin {
  int uid;	/* This user's uid */
  };

/* Structure passed with M_USRMSG type */
struct usrmsg {
  int uid;	/* User's uid */
  char text[MAX_MESSAGE];	 /* Text of message */
  };

/* Structure passed with M_USRCMD type */
struct usrcmd {
  int uid;	/* User's uid */
  int cmd;	/* Which command is being sent */
  char user[31];	/* Which user it concerns */
  char text[MAX_MESSAGE];	/* Text that accompanies the command */
  };

/* Note: type M_DMNTEXT is just straight text, and type M_DMNFULL has
   no parameters. */

/* This is a "generic message" structure.  It is used to receive messages
   before their types (and thus formats) are known. */
struct genmsg {
  long msgtype;
  char contents[1024]; /* Just to be safe */
  };

