/* key_t ftok(filename,c) - Create a unique IPC key based on a filename
 *                          and an 8-bit number.
 *
 * This function takes as parameters a pointer to an ascii string
 * containing the pathname of a file, and an integer.  It then returns
 * a (hopefully) unique IPC key.  The key is a 32-bit integer, and is
 * constructed as follows: the lower 8 bits are the low 8 bits of c.
 * The next 8 bits are the low 8 bits of the device descriptor of the
 * device the file is located on.  The upper 16 bits are the inode
 * of the file.
 *
 * This code copyright (c) Matt Kimmel 1991.  Permission granted for
 * unrestricted use in non-commercial products.
 */
#include <sys/ipc.h>
#include <sys/stat.h>

key_t ftok(filename,c)
char *filename;
int c;
{
  struct stat fs;
  union {
    key_t key;
    struct {
      char c;
      char dev;
      int inode;
      } info;
    } keyval;

  /* First attempt to stat the file */
  if(stat(filename,&fs) == -1) {
    perror("ftok");
    exit(1); /* Best to exit if this happens, or we may have a major IPC collision... */
    }

  keyval.info.c = (char)c;
  keyval.info.dev = (char)fs.st_dev;
  keyval.info.inode = (int)fs.st_ino;
  return(keyval.key);
}

