/* screen.c */
/* maybe */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#include "miles.h"

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/**********************************/
/* external procedure definitions */
/**********************************/

extern format();
extern place_string();
extern initialize_card_set();
extern deal_card();
extern remove_card();
extern message();
extern write_screen();
extern clear_screen();

/*********************************/
/* external variable definitions */
/*********************************/

extern int hand[2][15];         /* current status of players */
extern int change[2][15];       /* parallel structure of booleans */
extern int deck[20];            /* shufled deck of cards */
extern int cards_played[20];    /* set of cards already played */
extern char *card_names[40];    /* array of pointers to pointers to text */
extern int discard;             /* card being discarded */
extern int extension;           /* boolean for extension */
extern int delayed_action;      /* boolean for delayed action game */
extern int whose_turn;          /* you, me, or -1 if game done */
extern int play;                /* play=TRUE, discard=FALSE, drawn=-1 */
extern char *screen;            /* screen buffer */
extern int card_number;         /* card to play */
extern int debug;               /* flag for debug output */

extern char *T_dealing_cards;

/**********************************************************************/
/*                                                                    */
/*              UTILITIES TO PUT GAME INFORMATION ON THE SCREEN       */
/*                                                                    */
/**********************************************************************/

/***********************************************/
/* writes hand and score information to screen */
/***********************************************/
display_hand(who)
int who;
{
int temp;
int i;
/********** put up score **********/
if (change[who][miles])
    format(hand[who][miles],miles_loc + (who * 40));
/********** put up 200 count **********/
if (change[who][cnt_200])
    switch (hand[who][cnt_200]) {
         case 0: {
              place_string(card_names[safe_trip],cnt_200_loc + who_loc,20);
              break;
              }
         case 1: {
              place_string(card_names[one_200],cnt_200_loc + who_loc,20);
              break;
              }
         case 2: {
              place_string(card_names[two_200],cnt_200_loc + who_loc,20);
              break;
              }
         }
/********** put up safeties **********/
if (change[who][safety]) {
    temp = 0;
    if (hand[who][safety] & 0x1) {
         place_string(card_names[extra_tank],temp + safety_loc + who_loc,20);
         if (hand[who][coups] & 0x1)
              place_string(card_names[coup_fourre],
                           temp + safety_loc + who_loc + 16,12);
         else
              place_string(card_names[blank_line],
                           temp + safety_loc + who_loc + 16,12);
         temp++;
         }
    if (hand[who][safety] & 0x2) {
         place_string(card_names[puncture_proof],temp + safety_loc + who_loc,20);
         if (hand[who][coups] & 0x2)
              place_string(card_names[coup_fourre],
                           temp + safety_loc + who_loc + 16,12);
         else
              place_string(card_names[blank_line],
                           temp + safety_loc + who_loc + 16,12);
         temp++;
         }
    if (hand[who][safety] & 0x4) {
         place_string(card_names[driving_ace],temp + safety_loc + who_loc,20);
         if (hand[who][coups] & 0x4)
              place_string(card_names[coup_fourre],
                           temp + safety_loc + who_loc + 16,12);
         else
              place_string(card_names[blank_line],
                           temp + safety_loc + who_loc + 16,12);
         temp++;
         }
    if (hand[who][safety] & 0x8) {
         place_string(card_names[right_of_way],temp + safety_loc + who_loc,20);
         if (hand[who][coups] & 0x8)
              place_string(card_names[coup_fourre],
                           temp + safety_loc + who_loc + 16,12);
         else
              place_string(card_names[blank_line],
                           temp + safety_loc + who_loc + 16,12);
         temp++;
         }
    }
/********** put up limit **********/
if (change[who][limit])
    place_string(card_names[hand[who][limit]],limit_loc + who_loc,20);
/********** put up battle **********/
if (change[who][battle])
    place_string(card_names[hand[who][battle]],battle_loc + who_loc,20);
/********** put up hand **********/
temp = 0;
if (who == you || debug)        /* <=========================== debug */
    for (i=0; i<7; i++) {
         if (change[who][i])
              place_string(card_names[hand[who][i]],
                           temp + hand_loc + who_loc,20); /* place card name */
         temp++;
         }
else                            /* <=========================== debug */
    for (i=0; i<7; i++) {
         if (change[who][i])
              place_string(card_names[0],
                           temp + hand_loc + who_loc,20); /* blank out cards */
         temp++;
         }                      /* <=========================== debug */
/********** put up discard and card count **********/
place_string(card_names[discard],discard_loc,20);
format(deck[0],cards_left_loc);
write_screen();
for (i=0; i<15; i++)
    change[who][i] = FALSE;
}

/***********************************************/
/* shows which card and how it is to be played */
/* -2 for direction means clear play           */
/***********************************************/
display_pick(direction)
int direction;
{
char *string;
place_string(card_names[blank_line],card_number + hand_loc - 10,10);
if (direction == -2) {
    write_screen();
    return;
    }
card_number += direction;
if (card_number < 0)            /* this allows wrapping of the pointer */
    card_number = 6;
if (card_number > 6)
    card_number = 0;
if (play == TRUE)
    string = card_names[Play];
if (play == FALSE)
    string = card_names[Discard];
if (play == -1) {
    string = card_names[Drawn];
    play = TRUE;
    };
place_string(string,card_number + hand_loc - 10,10);
write_screen();
}

/**********************************/
/* debug routine to show the deck */
/**********************************/
display_deck()  /* <=========================================== debug */
{
int temp;
int i;
temp = 0;
for (i=5; i<20; i++) {
    format(cards_played[i],temp + safety_loc + 64);
    temp++;
    }
write_screen();
}

/***********************************/
/* initializes the screen for play */
/***********************************/
initialize_game ()
{
int i;
message(T_dealing_cards,TRUE);
/* initilaize the variables */
initialize_card_set(&cards_played[0]);
initialize_card_set(&deck[0]);
for (i=0; i<15; i++) {
    change[you][i] = TRUE;
    change[me][i] = TRUE;
    }
hand[you][miles]= hand[me][miles]= 0;
hand[you][cnt_200] = hand[me][cnt_200] = 0;
hand[you][safety] = hand[me][safety] = 0x0;
hand[you][limit] = hand[me][limit] = end_of_limit;
hand[you][battle] = hand[me][battle] = stop;
hand[you][coups] = hand[me][coups] = 0;
discard = 0;
extension = FALSE;
delayed_action = FALSE;
whose_turn = you;               /* you move first */
for (i=0; i<6; i++) {
    hand[you][i] = deal_card();
    hand[me][i] = deal_card();
    remove_card(&cards_played[0],hand[me][i]);  /* mark cards me seen */
    }
hand[you][6] = hand[me][6] = 0;
/* initilaize the screen */
refresh_screen(FALSE);
}

/*************************/
/* refresh entire screen */
/*************************/
refresh_screen(score_too)
int score_too;
{
int i;
clear_screen(start_loc);
place_string(card_names[YOUR_STATUS],start_loc + 10,16);
place_string(card_names[MY_STATUS],start_loc + 50,16);
place_string(card_names[Miles],miles_loc - 10,16);
place_string(card_names[Miles],miles_loc + 30,16);
place_string(card_names[Hand],-1 + hand_loc - 10,16);
place_string(card_names[Last_Discard],discard_loc - 20,16);
place_string(card_names[Cards_Left],discard_loc + 20,16);
for (i=0; i<15; i++) {
    change[you][i] = TRUE;
    change[me][i] = TRUE;
    }
display_hand(you);
display_hand(me);
if (score_too)
    tabulate_score(FALSE);
}

/**********************************************************************/
/*                                                                    */
/*              UTILITIES TO COMPUTE THE SCORE FOR THIS GAME          */
/*                                                                    */
/**********************************************************************/

/***************************************/
/* counts the number of bits on in lsb */
/***************************************/
count_bits(value)
int value;
{
int count;
int i;
count = 0;
for (i=0; i<4; i++) {
    if (value & 1)
         count++;
    value >>= 1;
    }
return(count);
}

/************************************/
/* tabulate the score for this game */
/************************************/
compute_score(who,keepers)
int who;
int keepers;
{
int other_guy;
int the_score;
int trip_complete;
int count;
int temp;
other_guy = who ? you : me;
the_score = 0;
place_string(card_names[Scoring],result_loc + who_loc - 20,16);
format(hand[who][miles],result_loc + who_loc - 10);
place_string(card_names[S_miles],result_loc + who_loc,20);
temp = 1;
the_score += hand[who][miles];
count = count_bits(hand[who][safety]);
if (count > 0) {
    format(count,temp + result_loc + who_loc - 10);
    place_string(card_names[S_safety],temp + result_loc + who_loc,20);
    temp++;
    the_score += count * 100;
    }
if (count == 4) {
    place_string(card_names[S_4_safeties],temp + result_loc + who_loc,20);
    temp++;
    the_score += 300;
    }
count = count_bits(hand[who][coups]);
if (count > 0) {
    format(count,temp + result_loc + who_loc - 10);
    place_string(card_names[S_coup_fourre],temp + result_loc + who_loc,20);
    temp++;
    the_score += count * 300;
    }
if (trip_complete = hand[who][miles] == (extension ? 1000 : 700)) {
    place_string(card_names[S_trip_complete],temp + result_loc + who_loc,20);
    temp++;
    the_score += 400;
    }
if (trip_complete && deck[0] == 0) {
    place_string(card_names[S_delayed_action],temp + result_loc + who_loc,20);
    temp++;
    the_score += 300;
    }
if (trip_complete && hand[who][cnt_200] == 0) {
    place_string(card_names[S_safe_trip],temp + result_loc + who_loc,20);
    temp++;
    the_score += 300;
    }
if (trip_complete && extension - 1 == who) {
    place_string(card_names[S_extension],temp + result_loc + who_loc,20);
    temp++;
    the_score += 200;
    }
if (trip_complete && hand[other_guy][miles] == 0) {
    place_string(card_names[S_shut_out],temp + result_loc + who_loc,20);
    temp++;
    the_score += 500;
    }
place_string(card_names[Hand],score_loc + who_loc,16);
format(the_score,score_loc + who_loc + 10);
place_string(card_names[Game],score_loc + who_loc + 20,16);
if (keepers)
    hand[who][score] += the_score;
format(hand[who][score],score_loc + who_loc + 30);
}

/***********************************************/
/* figures out this games score for you and me */
/***********************************************/
tabulate_score(keepers)
int keepers;
{
/* clear lower part of screen */
clear_screen(result_loc);
compute_score(you,keepers);
compute_score(me,keepers);
write_screen();
}

/*********** end of program **********/
