/* main.c */
/* maybe */

/**********************************************************************/
/*                                                                    */
/*           MM   MM  IIIIIII  L        L        EEEEEEE              */
/*           M M M M     I     L        L        E                    */
/*           M  M  M     I     L        L        EEEE                 */
/*           M     M     I     L        L        E                    */
/*           M     M  IIIIIII  LLLLLLL  LLLLLLL  EEEEEEE              */
/*                                                                    */
/*      BBBBBB    OOOOO   RRRRRR   NN    N  EEEEEEE   SSSSSS          */
/*      B     B  O     O  R     R  N N   N  E        S                */
/*      BBBBBB   O     O  RRRRRR   N  N  N  EEEEE     SSSSS           */
/*      B     B  O     O  R    R   N   N N  E              S          */
/*      BBBBBB    OOOOO   R     R  N    NN  EEEEEEE  SSSSSS           */
/*                                                                    */
/*                                                                    */
/* Creation: Edmond Dujardin                                          */
/*           (c) 1962 Parker Brothers, Inc.                           */
/*                                                                    */
/* Written by: Brett K. Carver                                        */
/*             Hewlett-Packard, 1983.                                 */
/*                                                                    */
/* Copyright: (c) Brett K. Carver, Hewlett-Packard, 1986.             */
/*                                                                    */
/**********************************************************************/

#ifndef COHERENT
#include <curses.h>
#else
#include <ncurses.h>
#endif
#include "miles.h"

/**********************************************************************/
/*                                                                    */
/*              CONSTANTS AND VARIABLES                               */
/*                                                                    */
/**********************************************************************/

/**********************************/
/* external procedure definitions */
/**********************************/

extern initialize_io();
extern display_banner();
extern cleanup_io();
extern deal_card();
extern display_hand();
extern display_pick();
extern display_deck();          /* <=========================== debug */
extern wait_for_move();
extern valid_move();
extern remove_card();
extern play_card();
extern compute_play_weight();
extern compute_discard_weight();
extern format();
extern initialize_game();
extern any_cards_left();
extern another_match();
extern another_question();
extern extension_question();
extern tabulate_score();
extern init_random();
extern random();
extern message ();
extern write_screen();

/*********************************/
/* external variable definitions */
/*********************************/

extern int deck[20];            /* shufled deck of cards */
extern int hand[2][15];         /* current status of players */
extern int change[2][15];       /* parallel structure of booleans */
extern int cards_played[20];    /* set of cards already played */
extern int extension;           /* boolean for extension */
extern int whose_turn;          /* you, me, or -1 if game done */
extern int play;                /* play=TRUE, discard=FALSE, drawn=-1 */
extern int card_number;         /* card to play */
extern int debug;               /* flag for debug output */
extern char *screen;

extern char *T_shuffling_cards;
extern char *T_make_play;
extern char *T_you_won;
extern char *T_me_won;
extern char *T_endgame;

/**********************************************************************/
/*                                                                    */
/*              UTILITIES TO PLAY YOU AND ME TURNS                    */
/*                                                                    */
/**********************************************************************/

/*********************/
/* you play one card */
/*********************/
you_play_turn()
{
card_number = 6;
if (hand[you][card_number] = deal_card())
    play = -1;
else
    play = TRUE;
change[you][card_number] = TRUE;
display_hand(you);
display_pick(0);
if (debug) display_deck();         /* <=========================== debug */
while (TRUE) {
    wait_for_move();
    if (valid_move(you,card_number,play,TRUE)) {
         remove_card(&cards_played[0],hand[you][card_number]);
         if (play_card(you,card_number,play))
              return(you);
         else
              return(me);
         }
    display_pick(0);
    }
}

/********************/
/* me play one card */
/********************/
me_play_turn()
{
int me_card;
int me_play;
int me_weight;
int weight;
int i;
hand[me][6] = deal_card();
if (debug)			/* <=========================== debug */
    for (i=0; i<7; i++)		/* <=========================== debug */
         change[me][i] = TRUE;	/* <=========================== debug */
remove_card(&cards_played[0],hand[me][6]);
if (debug) display_hand(me);    /* <=========================== debug */
if (debug) display_deck();      /* <=========================== debug */
me_card = 0;
me_play = TRUE;
me_weight = -1;
for (i=0; i<7; i++) {
    weight = 0;                 /* <=========================== debug */
    if (valid_move(me,i,TRUE,TRUE))
         if ((weight = compute_play_weight(i)) > me_weight) {
              me_weight = weight;
              me_card = i;
              me_play = TRUE;
              }
    if (debug)                  /* <=========================== debug */
         format(weight,i + hand_loc + 20);
    weight = 0;                 /* <=========================== debug */
    if (valid_move(me,i,FALSE,TRUE))
         if ((weight = compute_discard_weight(i)) > me_weight) {
              me_weight = weight;
              me_card = i;
              me_play = FALSE;
              }
    if (debug)                  /* <=========================== debug */
         format(weight,i + hand_loc + 30);
    }
if (debug) write_screen();      /* <=========================== debug */
if (debug) sleep(2);            /* <=========================== debug */
if (play_card(me,me_card,me_play))
    return(me);
else
    return(you);
}

/****************************/
/* check for useable cards */
/****************************/
int useable_card(who,play)
int who;
int play;
{
int i;
for (i=0; i<7; i++)
    if (valid_move(who,i,play,FALSE))
         return(TRUE);
return(FALSE);
}

/**********************************************************************/
/*                                                                    */
/*              MAIN PROGRAM                                          */
/*                                                                    */
/**********************************************************************/

/****************/
/* main program */
/****************/
main ()
{
initialize_io();
display_banner();
message(T_shuffling_cards,TRUE);
init_random();
while (TRUE) {
    hand[you][score] = hand[me][score] = 0;         /* set scores to 0 */
    while (hand[you][score] < 10000 && hand[me][score] < 10000) {
         initialize_game();
         while (whose_turn != -1) {
              switch (whose_turn) {
                   case you : {
                       if (deck[0] == 0)              /* no cards left to draw*/
                             if ( ! useable_card(you,FALSE)) {  /* or to play */
                                  whose_turn = me;
                                  break;
                                  }
                        message(T_make_play,TRUE);
                        whose_turn = you_play_turn();
                        display_hand(you);
                        display_hand(me);
                        if (extension) {
                             if (hand[you][miles] == 1000)
                                  whose_turn = -1;
                             }
                        else
                             if (hand[you][miles] == 700)
                                  if (!(extension = extension_question()))
                                       whose_turn = -1;
                        break;
                        }
                   case me : {
                        if (deck[0] == 0)             /* no cards left to draw*/
                             if ( ! useable_card(me,FALSE)) {   /* or to play */
                                  whose_turn = you;
                                  break;
                                  }
                        whose_turn = me_play_turn();
                        display_hand(you);
                        display_hand(me);
                        if (extension) {
                             if (hand[me][miles] == 1000)
                                  whose_turn = -1;
                             }
                        else
                             if (hand[me][miles] == 700) {
                                  if (hand[you][miles] == 0 ||
                                      (deck[0] - 25 - (random() % 10)) < 0)
                                       extension = FALSE;
                                  else
                                       extension = 2;
                                  if (!extension)
                                       whose_turn = -1;
                                  }
                        break;
                        }
                   }
              if (whose_turn != -1 && deck[0] == 0)  /* no cards left to draw */
                   if ( ! useable_card(you,TRUE) && ! useable_card(me,TRUE)) {
                        message(T_endgame,FALSE);
                        refresh();
                        getch();
                        whose_turn = -1;
                        }
              }
         tabulate_score(TRUE);
         if (hand[you][score] < 10000 && hand[me][score] < 10000)
              if (!another_question())
                   break;
         }
    if (hand[you][score] > hand[me][score])
        message(T_you_won,FALSE);
    else
        message(T_me_won,FALSE);
    sleep(2);
    if (!another_match())
         break;
    }
cleanup_io();
exit(0);
}

/*********** end of program **********/
