#ifndef _MGR_BLITLIB_H
#define _MGR_BLITLIB_H

#include "bitmap.h"
#include "window.h"

/*
 * The macro "GET Most Significant Bits" defines how the bits in each
 * word map from memory to pixels on the display.  The top left most
 * pixel on the display comes from either the *high* order or *low* order
 * bit of the first frame buffer word.  Use "<<" in the first case, ">>"
 * in the second.
 * 
 * The macro "GET Least Significant Bits" does the inverse of GETMSB
 */

#define GETMSB(word,shift)	\
	(word << shift)					/* get most significant bits in word */
#define GETLSB(word,shift) \
	(word >> shift)					/* get least significant bits in word */

/* these probably won't need changing */

#define MSB		(~GETLSB((DATA)~0,1))	/* most sig bit set */
#define LSB		(~GETMSB((DATA)~0,1))	/* least sig bit set */

/*
 * bitmap data has 2 formats, an internal format and an external format.
 * (Sometimes the formats are the same).  The external format is native
 * 68020 SUN/3, DATA aligned 1=black, 0=white.  The internal format is
 * whatever the frame buffer is.  If DOFLIP is set, data is converted
 * from external to internal format the first time it is used.  Bitmap
 * data is recognized as being in external format if the _FLIP flag is
 * set in the type field.  The installation routine flip() does the
 * conversion.
 */

/* need to flip bytes */

#define DOFLIP (MSB==1)

/* Function declarations */

/* convert memory data in external format to internal format */
BITMAP *bit_load(int w, int h, unsigned char d, int size, unsigned char *src);
/* allocate memory for bitmap */
BITMAP *bit_alloc(int wide, int high, DATA *data, unsigned char depth);
/* do bit blt operation */
void bit_blit(BITMAP *dst, int dx, int dy, int width, int height, int func, BITMAP *src, int sx, int sy);
/* create sub bitmap */
BITMAP *bit_create(BITMAP *map, int x, int y, int wide, int high);
/* free allocated memory for bitmap */
void bit_destroy(BITMAP *map);
/* draw a line in a bitmap */
void bit_line(BITMAP *dst, int x0, int y0, int x1, int y1, int func);
/* find out if a dot in a bitmap is set */
int bit_on(BITMAP *bp, int x, int y);
/* open frame buffer bitmap */
BITMAP *bit_open(char *name);
/* set dot in bitmap */
int bit_point(BITMAP *map, int dx, int dy, int func);
/* return bitmap data size for entire bitmap (NOT parts of it!) */
int bit_size(int wide, int high, unsigned char depth);
/* switch to grafics mode */
void bit_grafscreen(void);
/* switch to text mode */
void bit_textscreen(void);
/* init frame buffer *once*, *not* for use by programmer */
DATA *bit_initscreen(char *name, int *width, int *height, unsigned char *depth);
/* fast vertical scroll */
void fast_scroll(BITMAP *map, int x, int y, int wide, int high, int delta);
/* set timestamp for bitblit logging */
int timestamp(void);

#endif
/*{{{}}}*/
