dnl{{{}}}
dnl{{{  m4 rules
changequote([,])dnl
define([check],[ifdef([$1],[define([$1],[changequote({,})]{$[]1}[changequote([,])])],[define([$1],)])dnl])dnl
dnl}}}
dnl{{{  checks
check([coherent])
check([linux])
check([vga])
check([hgc])
check([svga1])
check([svga2])
check([sunos])
check([movie])
check([hpux])
check([gropbm])
check([texmgr])
dnl}}}
dnl{{{  portable definitions
[VERSION=	0.57]

[INCLUDEDIR=	]WHEREHOME[/include]
[BINDIR=	]WHEREHOME[/bin$(ARCHITECTURE)]
[SHBINDIR=	]WHEREHOME[/bin]
[FONTDIR=	]WHEREHOME[/font]
[HFONTDIR=	]WHEREHOME[/hfont]
[ICONDIR=	]WHEREHOME[/icon]
[LIBDIR=	]WHEREHOME[/lib$(ARCHITECTURE)]
[MANDIR=	]WHEREHOME[/man]

[DEFAULT_FONT=	$(FONTDIR)/ser7x12L]
[EXAMPLES=	]EXAMPLES
movie([MOVIECLIENTS=play_data])
gropbm([GROPBM=	gropbm])
gropbm([GROFFFONTDIR=	]WHEREGROFFFONT)
texmgr([TEXMGR=	texmgr])
texmgr([FONTDESC=]WHEREFONTDESC)
dnl}}}
dnl{{{  linux
linux([
LEX=		flex
CC=		gcc
FLAGS=		-Wall -O2 -I$(INCLUDEDIR) ]movie([-DMOVIE])[

AWK=		gawk
ROFF=		groff
ROFFDEVICE=	-Tascii
ROFFONLY=	-Z
TBL=		tbl

MOUSE_DEV=	/dev/mouse
MGRFLAGS=	-DWHO -DVI -DBUCKEY -DKILL -DCUT -DALIGN -DMOUSE=]MOUSE[ -DTERMNAME=\"mgr-linux\"
BITBLIT=	linux

SERVER=		mgr
SERVER_PERM=	4755
SET_CONSOLE_PERM=	4755
]
dnl{{{  hercules flags
hgc([
SCREEN=		hgc
SCREEN_DEV=	720x348
])
dnl}}}
dnl{{{  vga flags
vga([
SCREEN=		vga
SCREEN_DEV=	640x480
])
dnl}}}
)
dnl}}}
dnl{{{  coherent
coherent([
SHELL=		/usr/bin/ksh
LEX=		flex
CC=		gcc
EMULIB=		libcoh
LIBEMU=		$(LIBDIR)/libcoh.a
FLAGS=		-O2 -I$(INCLUDEDIR) -I$(INCLUDEDIR)/coherent ]movie([-DMOVIE])[

AWK=		gawk
ROFF=		groff
ROFFDEVICE=	-Tascii
ROFFONLY=	-Z
TBL=		tbl

MOUSE_DEV=	/dev/mouse
MGRFLAGS=	-DVI -DBUCKEY -DKILL -DCUT -DALIGN -DMOUSE=]MOUSE[ -DTERMNAME=\"mgr\" -DRDWR_FD
BITBLIT=	coherent

SERVER=		mgr
SERVER_PERM=	755
SET_CONSOLE_PERM=	755
]
dnl{{{  hercules flags
hgc([
SCREEN=		hgc
SCREEN_DEV=	720x348
])
dnl}}}
dnl{{{  vga flags
vga([
SCREEN=		vga
SCREEN_DEV=	640x480
])
dnl}}}
dnl{{{  svga1 flags
svga1([
SCREEN=		vga
SCREEN_DEV=	800x600
])
dnl}}}
dnl{{{  svga2 flags
svga2([
SCREEN=		vga
SCREEN_DEV=	1024x768
])
dnl}}}
)
dnl}}}
dnl{{{  sunos
sunos([
LEX=		lex
LEXLIB=		-ll
CC=		gcc
FLAGS=		-Wall -O -I$(INCLUDEDIR) -I$(INCLUDEDIR)/sun -D_POSIX_PATH_MAX=255]movie([ -DMOVIE])[
CPP=		/usr/lib/cpp

AWK=		awk
ROFF=		nroff
ROFFDEVICE=
ROFFONLY=
TBL=		tbl

MOUSE_DEV=	/dev/mouse
MGRFLAGS=	-DVI -DBUCKEY -DKBD -DKILL -DCUT -DALIGN -DMOUSE=1 -DTERMNAME=\"mgr\"

BITBLIT=	sunmono
BLITLIBFLAGS=	-DUNROLL
BLITLIBOPT=	0

SCREEN=		sun
SCREEN_DEV=	/dev/fb

SERVER=		mgr
SERVER_PERM=	755
SET_CONSOLE_PERM=	755
])
dnl}}}
dnl{{{  hp-ux
hpux([
LEX=		lex
LEXLIB=		-ll
CC=		gcc
FLAGS=		-Wall -O -I$(INCLUDEDIR) -Dsrandom=srand -Drandom=rand]movie([-DMOVIE])[
CPP=		/lib/cpp

AWK=		awk
ROFF=		nroff
TBL=		tbl

SERVER=
BITBLIT=
])
dnl}}}
